# ကူညီသူစာကြည့်တိုက်

[![License: MIT](https://img.shields.io/badge/License-MIT-yellow.svg)](LICENSE) [![PyPI](https://img.shields.io/pypi/v/pyhelper-tools-jbhm?style=for-the-badge&label=PyPI&color=blue)](https://pypi.org/project/pyhelper-tools-jbhm/)

## 🌍ရရှိနိုင်သည့်ဘာသာစကားများ

Pyheler Build-in-said-said-in ** 131 ဘာသာသို့ပြန်သွားသည်။

[![en](https://img.shields.io/badge/lang-en-red.svg)](readme/README.md) [![es](https://img.shields.io/badge/lang-es-yellow.svg)](readme/README.es.md) [![fr](https://img.shields.io/badge/lang-fr-blue.svg)](readme/README.fr.md) [![ru](https://img.shields.io/badge/lang-ru-purple.svg)](readme/README.ru.md) [![ru](https://img.shields.io/badge/lang-ru-purple.svg)](readme/README.ru.md) [![ru](https://img.shields.io/badge/lang-ru-purple.svg)](readme/README.ru.md)164_ [![it](https://img.shields.io/badge/lang-it-lightgrey.svg)](readme/README.it.md)16_162_ [![sv](https://img.shields.io/badge/lang-sv-blue.svg)](readme/README.sv.md) [![sv](https://img.shields.io/badge/lang-sv-blue.svg)](readme/README.sv.md)  
[![ja](https://img.shields.io/badge/lang-ja-red.svg)](readme/README.ja.md) [![ar](https://img.shields.io/badge/lang-ar-brown.svg)](readme/README.ar.md) [![af](https://img.shields.io/badge/lang-af-orange.svg)](readme/README.af.md) π_151[![bm](https://img.shields.io/badge/lang-bm-darkgreen.svg)](readme/README.bm.md) [![hy](https://img.shields.io/badge/lang-hy-red.svg)](readme/README.hy.md)1151_ [![ay](https://img.shields.io/badge/lang-ay-brown.svg)](readme/README.ay.md) [![bm](https://img.shields.io/badge/lang-bm-darkgreen.svg)](readme/README.bm.md) [![bm](https://img.shields.io/badge/lang-bm-darkgreen.svg)](readme/README.bm.md) [![bm](https://img.shields.io/badge/lang-bm-darkgreen.svg)](readme/README.bm.md)  
[![eu](https://img.shields.io/badge/lang-eu-pink.svg)](readme/README.eu.md) [![be](https://img.shields.io/badge/lang-be-darkblue.svg)](readme/README.be.md) [![bn](https://img.shields.io/badge/lang-bn-teal.svg)](readme/README.bn.md) [![bs](https://img.shields.io/badge/lang-bs-purple.svg)](readme/README.bm.md) [![bs](https://img.shields.io/badge/lang-bs-purple.svg)](readme/README.bm.md) [![bg](https://img.shields.io/badge/lang-bg-green.svg)](readme/README.bg.md)144_ [![ceb](https://img.shields.io/badge/lang-ceb-blue.svg)](readme/README.ceb.md)1144_ [![ceb](https://img.shields.io/badge/lang-ceb-blue.svg)](readme/README.ceb.md) [![co](https://img.shields.io/badge/lang-co-green.svg)](readme/README.co.md)  
[![hr](https://img.shields.io/badge/lang-hr-blue.svg)](readme/README.hr.md) [![cs](https://img.shields.io/badge/lang-cs-red.svg)](readme/README.cs.md) [![da](https://img.shields.io/badge/lang-da-purple.svg)](readme/README.da.md) [![dv](https://img.shields.io/badge/lang-dv-orange.svg)](readme/README.dv.md) π_136[![eo](https://img.shields.io/badge/lang-eo-green.svg)](readme/README.eo.md) [![et](https://img.shields.io/badge/lang-et-blue.svg)](readme/README.et.md)1134_ [![tl](https://img.shields.io/badge/lang-tl-purple.svg)](readme/README.tl.md) [![tl](https://img.shields.io/badge/lang-tl-purple.svg)](readme/README.tl.md)  
[![fi](https://img.shields.io/badge/lang-fi-blue.svg)](readme/README.fi.md) [![fy](https://img.shields.io/badge/lang-fy-orange.svg)](readme/README.fy.md) [![gl](https://img.shields.io/badge/lang-gl-green.svg)](readme/README.gl.md) π_1221π_1226_ [![gn](https://img.shields.io/badge/lang-gn-purple.svg)](readme/README.gn.md)122_ [![ht](https://img.shields.io/badge/lang-ht-green.svg)](readme/README.ht.md)111[![haw](https://img.shields.io/badge/lang-haw-red.svg)](readme/README.haw.md) [![haw](https://img.shields.io/badge/lang-haw-red.svg)](readme/README.haw.md)  
[![iw](https://img.shields.io/badge/lang-iw-purple.svg)](readme/README.iw.md) [![hi](https://img.shields.io/badge/lang-hi-orange.svg)](readme/README.hi.md) [![hmn](https://img.shields.io/badge/lang-hmn-green.svg)](readme/README.hmn.md) π_1116_ [![ig](https://img.shields.io/badge/lang-ig-purple.svg)](readme/README.ig.md)114_ [![id](https://img.shields.io/badge/lang-id-green.svg)](readme/README.id.md)1114[![jw](https://img.shields.io/badge/lang-jw-red.svg)](readme/README.jw.md)111_ [![jw](https://img.shields.io/badge/lang-jw-red.svg)](readme/README.jw.md) [![jw](https://img.shields.io/badge/lang-jw-red.svg)](readme/README.jw.md)  
[![kn](https://img.shields.io/badge/lang-kn-purple.svg)](readme/README.kn.md) [![kk](https://img.shields.io/badge/lang-kk-orange.svg)](readme/README.kk.md) [![km](https://img.shields.io/badge/lang-km-green.svg)](readme/README.km.md) [![km](https://img.shields.io/badge/lang-km-green.svg)](readme/README.km.md) [![gom](https://img.shields.io/badge/lang-gom-red.svg)](readme/README.gom.md) [![gom](https://img.shields.io/badge/lang-gom-red.svg)](readme/README.gom.md) [![kri](https://img.shields.io/badge/lang-kri-orange.svg)](readme/README.kri.md) [![kri](https://img.shields.io/badge/lang-kri-orange.svg)](readme/README.kri.md) [![ky](https://img.shields.io/badge/lang-ky-red.svg)](readme/README.ky.md) [![ky](https://img.shields.io/badge/lang-ky-red.svg)](readme/README.ky.md)  
[![lo](https://img.shields.io/badge/lang-lo-purple.svg)](readme/README.lo.md) [![la](https://img.shields.io/badge/lang-la-orange.svg)](readme/README.la.md) [![lv](https://img.shields.io/badge/lang-lv-green.svg)](readme/README.lv.md) [![ln](https://img.shields.io/badge/lang-ln-blue.svg)](readme/README.ln.md) [![lt](https://img.shields.io/badge/lang-lt-red.svg)](readme/README.lt.md) π_93[![lb](https://img.shields.io/badge/lang-lb-orange.svg)](readme/README.lb.md) [![mk](https://img.shields.io/badge/lang-mk-green.svg)](readme/README.mk.md)94_ [![mk](https://img.shields.io/badge/lang-mk-green.svg)](readme/README.mk.md) [![mg](https://img.shields.io/badge/lang-mg-red.svg)](readme/README.mg.md)  
[![ms](https://img.shields.io/badge/lang-ms-purple.svg)](readme/README.ms.md) [![ml](https://img.shields.io/badge/lang-ml-orange.svg)](readme/README.ml.md) [![mt](https://img.shields.io/badge/lang-mt-green.svg)](readme/README.mt.md) [![mr](https://img.shields.io/badge/lang-mr-red.svg)](readme/README.mr.md) [![mr](https://img.shields.io/badge/lang-mr-red.svg)](readme/README.mr.md) [![lus](https://img.shields.io/badge/lang-lus-purple.svg)](readme/README.lus.md)8_8_8_ [![my](https://img.shields.io/badge/lang-my-green.svg)](readme/README.my.md)8_8__ [![my](https://img.shields.io/badge/lang-my-green.svg)](readme/README.my.md) [![ne](https://img.shields.io/badge/lang-ne-blue.svg)](readme/README.ne.md) [![my](https://img.shields.io/badge/lang-my-green.svg)](readme/README.my.md)8_80_  
[![om](https://img.shields.io/badge/lang-om-orange.svg)](readme/README.om.md) [![ps](https://img.shields.io/badge/lang-ps-green.svg)](readme/README.ps.md) [![fa](https://img.shields.io/badge/lang-fa-blue.svg)](readme/README.fa.md) [![qu](https://img.shields.io/badge/lang-qu-red.svg)](readme/README.qu.md) [![ro](https://img.shields.io/badge/lang-ro-purple.svg)](readme/README.ro.md) [![sm](https://img.shields.io/badge/lang-sm-orange.svg)](readme/README.sm.md) [![sa](https://img.shields.io/badge/lang-sa-green.svg)](readme/README.sa.md) [![st](https://img.shields.io/badge/lang-st-purple.svg)](readme/README.st.md)73_ [![st](https://img.shields.io/badge/lang-st-purple.svg)](readme/README.st.md)7_71_  
[![sd](https://img.shields.io/badge/lang-sd-green.svg)](readme/README.sd.md) [![si](https://img.shields.io/badge/lang-si-blue.svg)](readme/README.si.md) [![sk](https://img.shields.io/badge/lang-sk-red.svg)](readme/README.sk.md) π_65[![so](https://img.shields.io/badge/lang-so-orange.svg)](readme/README.so.md) [![su](https://img.shields.io/badge/lang-su-green.svg)](readme/README.su.md) [![sw](https://img.shields.io/badge/lang-sw-blue.svg)](readme/README.sw.md) [![tg](https://img.shields.io/badge/lang-tg-red.svg)](readme/README.tg.md) [![ta](https://img.shields.io/badge/lang-ta-purple.svg)](readme/README.ta.md) [![tg](https://img.shields.io/badge/lang-tg-red.svg)](readme/README.tg.md) [![ta](https://img.shields.io/badge/lang-ta-purple.svg)](readme/README.ta.md) [![tt](https://img.shields.io/badge/lang-tt-orange.svg)](readme/README.tt.md) [![ta](https://img.shields.io/badge/lang-ta-purple.svg)](readme/README.ta.md)  
[![th](https://img.shields.io/badge/lang-th-blue.svg)](readme/README.th.md) [![ti](https://img.shields.io/badge/lang-ti-red.svg)](readme/README.ti.md) MIT MIT MIT MIT MIT5_5[![ug](https://img.shields.io/badge/lang-ug-purple.svg)](readme/README.ug.md) [![ur](https://img.shields.io/badge/lang-ur-red.svg)](readme/README.ur.md) [![ug](https://img.shields.io/badge/lang-ug-purple.svg)](readme/README.ug.md) [![uz](https://img.shields.io/badge/lang-uz-orange.svg)](readme/README.uz.md)  
[![xh](https://img.shields.io/badge/lang-xh-red.svg)](readme/README.xh.md) [![yi](https://img.shields.io/badge/lang-yi-purple.svg)](readme/README.yi.md) [![yo](https://img.shields.io/badge/lang-yo-orange.svg)](readme/README.yo.md) [![zu](https://img.shields.io/badge/lang-zu-green.svg)](readme/README.zu.md)

---


## 🚀 installation

Pypi မှ install:

```bash
pip install pyhelper-tools-jbhm
```

---

## 📖ခြုံငုံသုံးသပ်ချက်

** Pyhelper ** သည်စွယ်စုံလုံးပါ 0 င်သည်။ ** ဒေတာခွဲခြမ်းစိတ်ဖြာခြင်း,  
၎င်းသည်ပညာရေး, သုတေသနနှင့်ပရော်ဖက်ရှင်နယ်ပရောဂျက်များတွင်ချောမွေ့စွာပေါင်းစပ်ထားပြီး,

အဓိကအားသာချက်များ:
- 🧮 built-in ** စာရင်းအင်းနှင့်သင်္ချာအသုံးအဆောင်များ ** 
- 📊လွယ်ကူစွာအသုံးချနိုင်သော ** ဒေတာမြင်ကွင်းကိုထုပ်သည်။ ** 
- 🗂 handy ** ဖိုင်ကိုင်တွယ်ခြင်းနှင့်ရှာဖွေခြင်း ** 
- 🔍 ** syntax validation ** Pythonဖိုင်များအတွက် **
- 🌍 ** ** Multi-Language Multi-Language Support ** ဘာသာတရားများအသုံးပြုရန်
- 🚀 ** အစာရှောင်ခြင်းရှေ့ပြေးပုံစံ ** နှင့် ** ပညာရေး ** 

---

## ✨အဓိကအင်္ဂါရပ်များ

### 📊အချက်အလက်မြင်ကွင်း
- ဘားဇယား: အလျားလိုက်နှင့်ဒေါင်လိုက်(`hbar`, `vbar`)  
- ဖြန့်ဖြူးခြင်းမြေ - histograms (`histo`), box plots (`boxplot`), kde plots (`kdeplot`)  
- နှိုင်းယှဉ်မြေကွက် - တယော, Swarm, ချွတ်ကွက်ကွက်  
- ဆက်နွယ်မှုခွဲခြမ်းစိတ်ဖြာခြင်း - အပူစောင်(`heatmap`), ကြဲ 135_, (`scatter`)  
- အဆင့်မြင့်မြင်ကွင်းများ: ကွက်ကွက်ကွင်းကွင်းများ, ပူးတွဲကွက်များ, ဆုတ်ယုတ်ကျဆင်းမှု  
- ဒေတာဇယားများ - format ချထားသောဇယား splates (`table`)  

### statistical ခွဲခြမ်းစိတ်ဖြာခြင်း
- ** ဗဟိုစိတ်သဘောထား ** : ဆိုလိုသည်မှာ(`get_media`), ပျမ်းမျှ(`get_median`), mode (`get_moda`)  
- ** displayer ** : Range (`get_rank`), Variance (`get_var`), စံသွေဖည်(`get_desv`)  
- ** ခွဲခြမ်းစိတ်ဖြာခြင်း ** : ကွဲပြားမှုအစီရင်ခံစာများ(`disp`), IQR တွက်ချက်မှုများ, ပုံမှန်,  
- ** outlier detection ** : iQR နှင့် Z-ရမှတ်နည်းလမ်းများ  

### ဖိုင်စီမံခန့်ခွဲမှု
- `call()` (auto-detect CSV, JSON, XML, etc.)ဖြင့်စမတ်ရှာဖွေတွေ့ရှိမှု  
- အမျိုးအစား Multi-format တုပ Support (CSV, JSON, XML, PDF, spatial data)  
- sql ဒေတာဘေ့စ်စီမံခန့်ခွဲမှု`DataBase` Class နှင့်အတူ  
- ကူးပြောင်းခြင်းအသုံးအဆောင်များ(`convert_file`)  

### 🛠️ developer tools များ
- syplid system (`Switch`, `AsyncSwitch`)  
- syntax စစ်ဆေးခြင်း(`check_syntax`, `PythonFileChecker`)  
- ကြွယ်ဝသောအမှားအယွင်းများ(multi-language)  
- ဘက်ပေါင်းစုံအကူအညီစနစ်(`help`)  

### 🌍 International
- 100+ built-in ဘာသာပြန်ချက်များ  
- စိတ်ကြိုက်ဘာသာပြန်ထားသောဘာသာပြန်များ  
- Runtime ဘာသာစကား switching (`set_language() `)  
- Automatic English fallback  

---

## Dependencies (handled automatically):

- pandas, numpy (data manipulation)

- matplotlib, seaborn (visualization)

- scikit-learn (statistics)

- sqlalchemy (database)

- geopandas (spatial data)

---

## 🔧 Usage Examples

### Set language 

**support for up to 131 languages** 
```python
from helper import set_language

set_language("en")  # English
set_language("es")  # Spanish
set_language("fr")  # French
set_language("de")  # German
set_language("ru")  # Russian
set_language("tr")  # Turkish
set_language("zh")  # Chinese
set_language("it")  # Italian
set_language("pt")  # Portuguese
set_language("sv")  # Swedish
set_language("ja")  # Japanese
set_language("ar")  # Arabic
...
`133_


### အခြေခံစာရင်းအင်းများ
```python
import helper as hp

data = [1, 2, 2, 3, 4, 5]

print(hp.get_media(data))   # Mean
print(hp.get_median(data))  # Median
print(hp.get_moda(data))    # Mode
```

### visualization
```python
import helper as hp

df = hp.pd.DataFrame({"values": [5, 3, 7, 2, 9]})
hp.histo(df, "values", bins=5, title="Sample Histogram")
```

### ဖိုင်ကိုင်တွယ်ပုံ
```python
from helper import call

data = call(name="my_data", type="csv")  # Finds and loads a CSV file automatically
```

### စိတ်ကြိုက်ဘာသာပြန်ထားသောဘာသာပြန်များ
```python
from helper import load_user_translations

# Load custom translations from lang.json
load_user_translations("custom/lang.json")
```

### syntax validation
```python
from helper import run

run("./path/to/my_script.py")
#Show gui pop up with results
```

---

## 📂စီမံကိန်းတည်ဆောက်ပုံ

```
helper/
├── core.py
├── __init__.py
├── lang/
│   ├── en.json
│   ├── es.json
│   └── ... (100+ files)
└── submodules/
    ├── graph.py
    ├── statics.py
    ├── utils.py
    ├── caller.py
    ├── checker.py
    ├── manager.py
    ├── pyswitch.py
    ├── shared.py
    └── DBManager.py
```

---

## 📜_6_

ဤစီမံကိန်းကို ** MIT π_4 _ ** အောက်တွင်လိုင်စင်ချထားသည်။  
အသေးစိတ်အတွက်[LICENSE](LICENSE)ဖိုင်ကိုကြည့်ပါ။

---

## 🔮လမ်းပြမြေပုံ

- အပို visualization အမျိုးအစားများ

- တိုးချဲ့ထားသောဒေတာဘေ့စ်အထောက်အပံ့(NoSQL, graph databases)

- စက်သင်ယူမှုပေါင်းစည်းမှု

- ဝက်ဘ်အခြေပြု interface

- Plugin စနစ်

---

⚡_1_1_နှင့်အတူ ** pyhelper နှင့်အတူ witharkfloy ** ၏ supergarch ရန်အဆင်သင့်ရှိရန်အဆင်သင့်ရှိပါသည်။ ယနေ့စတင်လေ့လာပါ။