# സഹായിയുടെ ലൈബ്രറി

[![License: MIT](https://img.shields.io/badge/License-MIT-yellow.svg)](LICENSE) [![PyPI](https://img.shields.io/pypi/v/pyhelper-tools-jbhm?style=for-the-badge&label=PyPI&color=blue)](https://pypi.org/project/pyhelper-tools-jbhm/)

## 🌍 ലഭ്യമായ ഭാഷകൾ

ഉൾപ്പെടെ ** 131 ഭാഷകൾ ** എന്നതിനായി പൈ അൾട്ട്-ഇൻ വിവർത്തനങ്ങൾ പൈഹെൽപ്പർ വാഗ്ദാനം ചെയ്യുന്നു:

[![en](https://img.shields.io/badge/lang-en-red.svg)](readme/README.md) [![es](https://img.shields.io/badge/lang-es-yellow.svg)](readme/README.es.md) [![fr](https://img.shields.io/badge/lang-fr-blue.svg)](readme/README.fr.md) (`set_language() [![tr](https://img.shields.io/badge/lang-tr-orange.svg)](readme/README.tr.md) [![zh](https://img.shields.io/badge/lang-zh-black.svg)](readme/README.zh.md) [![pt](https://img.shields.io/badge/lang-pt-brightgreen.svg)](readme/README.pt.md) [![sv](https://img.shields.io/badge/lang-sv-blue.svg)](readme/README.sv.md) [![sv](https://img.shields.io/badge/lang-sv-blue.svg)](readme/README.sv.md)  
[![ja](https://img.shields.io/badge/lang-ja-red.svg)](readme/README.ja.md) [![ar](https://img.shields.io/badge/lang-ar-brown.svg)](readme/README.ar.md) [![af](https://img.shields.io/badge/lang-af-orange.svg)](readme/README.af.md) [![sq](https://img.shields.io/badge/lang-sq-blue.svg)](readme/README.sq.md) [![am](https://img.shields.io/badge/lang-am-green.svg)](readme/README.am.md) [![ay](https://img.shields.io/badge/lang-ay-brown.svg)](readme/README.ay.md) [![az](https://img.shields.io/badge/lang-az-lightblue.svg)](readme/README.az.md) [![bm](https://img.shields.io/badge/lang-bm-darkgreen.svg)](readme/README.bm.md) [![bm](https://img.shields.io/badge/lang-bm-darkgreen.svg)](readme/README.bm.md)  
[![eu](https://img.shields.io/badge/lang-eu-pink.svg)](readme/README.eu.md) [![be](https://img.shields.io/badge/lang-be-darkblue.svg)](readme/README.be.md) [![bn](https://img.shields.io/badge/lang-bn-teal.svg)](readme/README.bn.md) [![bho](https://img.shields.io/badge/lang-bho-orange.svg)](readme/README.bho.md) [![ca](https://img.shields.io/badge/lang-ca-yellow.svg)](readme/README.ca.md) [![ceb](https://img.shields.io/badge/lang-ceb-blue.svg)](readme/README.ceb.md) [![ny](https://img.shields.io/badge/lang-ny-red.svg)](readme/README.ny.md) [![co](https://img.shields.io/badge/lang-co-green.svg)](readme/README.co.md) [![co](https://img.shields.io/badge/lang-co-green.svg)](readme/README.co.md)  
[![hr](https://img.shields.io/badge/lang-hr-blue.svg)](readme/README.hr.md) [![cs](https://img.shields.io/badge/lang-cs-red.svg)](readme/README.cs.md) [![da](https://img.shields.io/badge/lang-da-purple.svg)](readme/README.da.md) `` [![nl](https://img.shields.io/badge/lang-nl-orange.svg)](readme/README.nl.md) [![et](https://img.shields.io/badge/lang-et-blue.svg)](readme/README.et.md) [![ee](https://img.shields.io/badge/lang-ee-red.svg)](readme/README.ee.md) [![tl](https://img.shields.io/badge/lang-tl-purple.svg)](readme/README.tl.md) [![tl](https://img.shields.io/badge/lang-tl-purple.svg)](readme/README.tl.md)  
π_1330_ [![fy](https://img.shields.io/badge/lang-fy-orange.svg)](readme/README.fy.md) [![gl](https://img.shields.io/badge/lang-gl-green.svg)](readme/README.gl.md) [![ka](https://img.shields.io/badge/lang-ka-red.svg)](readme/README.ka.md) [![el](https://img.shields.io/badge/lang-el-blue.svg)](readme/README.el.md) [![ht](https://img.shields.io/badge/lang-ht-green.svg)](readme/README.ht.md) [![ha](https://img.shields.io/badge/lang-ha-blue.svg)](readme/README.ha.md) [![haw](https://img.shields.io/badge/lang-haw-red.svg)](readme/README.haw.md)  
[![iw](https://img.shields.io/badge/lang-iw-purple.svg)](readme/README.iw.md) [![hi](https://img.shields.io/badge/lang-hi-orange.svg)](readme/README.hi.md) (multi-language) [![hu](https://img.shields.io/badge/lang-hu-blue.svg)](readme/README.hu.md) [![is](https://img.shields.io/badge/lang-is-red.svg)](readme/README.is.md) π_1115_ [![id](https://img.shields.io/badge/lang-id-green.svg)](readme/README.id.md) [![jw](https://img.shields.io/badge/lang-jw-red.svg)](readme/README.jw.md)  
[![kn](https://img.shields.io/badge/lang-kn-purple.svg)](readme/README.kn.md) [![kk](https://img.shields.io/badge/lang-kk-orange.svg)](readme/README.kk.md) [![km](https://img.shields.io/badge/lang-km-green.svg)](readme/README.km.md) [![rw](https://img.shields.io/badge/lang-rw-blue.svg)](readme/README.rw.md) [![gom](https://img.shields.io/badge/lang-gom-red.svg)](readme/README.gom.md) [![ku](https://img.shields.io/badge/lang-ku-green.svg)](readme/README.ku.md) [![ckb](https://img.shields.io/badge/lang-ckb-blue.svg)](readme/README.ckb.md) [![ky](https://img.shields.io/badge/lang-ky-red.svg)](readme/README.ky.md)  
[![lo](https://img.shields.io/badge/lang-lo-purple.svg)](readme/README.lo.md) [![la](https://img.shields.io/badge/lang-la-orange.svg)](readme/README.la.md) [![lv](https://img.shields.io/badge/lang-lv-green.svg)](readme/README.lv.md) [![ln](https://img.shields.io/badge/lang-ln-blue.svg)](readme/README.ln.md) [![lt](https://img.shields.io/badge/lang-lt-red.svg)](readme/README.lt.md) [![mk](https://img.shields.io/badge/lang-mk-green.svg)](readme/README.mk.md) [![mai](https://img.shields.io/badge/lang-mai-blue.svg)](readme/README.mai.md) [![mg](https://img.shields.io/badge/lang-mg-red.svg)](readme/README.mg.md)___  
[![ms](https://img.shields.io/badge/lang-ms-purple.svg)](readme/README.ms.md) [![ml](https://img.shields.io/badge/lang-ml-orange.svg)](readme/README.ml.md) [![mt](https://img.shields.io/badge/lang-mt-green.svg)](readme/README.mt.md) [![mi](https://img.shields.io/badge/lang-mi-blue.svg)](readme/README.mi.md) [![mr](https://img.shields.io/badge/lang-mr-red.svg)](readme/README.mr.md) [![my](https://img.shields.io/badge/lang-my-green.svg)](readme/README.my.md) [![ne](https://img.shields.io/badge/lang-ne-blue.svg)](readme/README.ne.md) [![no](https://img.shields.io/badge/lang-no-red.svg)](readme/README.no.md) [![or](https://img.shields.io/badge/lang-or-purple.svg)](readme/README.or.md)  
[![om](https://img.shields.io/badge/lang-om-orange.svg)](readme/README.om.md) [![ps](https://img.shields.io/badge/lang-ps-green.svg)](readme/README.ps.md) [![fa](https://img.shields.io/badge/lang-fa-blue.svg)](readme/README.fa.md) [![qu](https://img.shields.io/badge/lang-qu-red.svg)](readme/README.qu.md) [![ro](https://img.shields.io/badge/lang-ro-purple.svg)](readme/README.ro.md) [![gd](https://img.shields.io/badge/lang-gd-blue.svg)](readme/README.gd.md) [![nso](https://img.shields.io/badge/lang-nso-red.svg)](readme/README.nso.md) [![st](https://img.shields.io/badge/lang-st-purple.svg)](readme/README.st.md) [![sn](https://img.shields.io/badge/lang-sn-orange.svg)](readme/README.sn.md)  
[![sd](https://img.shields.io/badge/lang-sd-green.svg)](readme/README.sd.md) [![si](https://img.shields.io/badge/lang-si-blue.svg)](readme/README.si.md) [![sk](https://img.shields.io/badge/lang-sk-red.svg)](readme/README.sk.md) [![sl](https://img.shields.io/badge/lang-sl-purple.svg)](readme/README.sl.md) [![so](https://img.shields.io/badge/lang-so-orange.svg)](readme/README.so.md) [![tg](https://img.shields.io/badge/lang-tg-red.svg)](readme/README.tg.md) [![ta](https://img.shields.io/badge/lang-ta-purple.svg)](readme/README.ta.md) [![tt](https://img.shields.io/badge/lang-tt-orange.svg)](readme/README.tt.md) [![te](https://img.shields.io/badge/lang-te-green.svg)](readme/README.te.md)  
[![th](https://img.shields.io/badge/lang-th-blue.svg)](readme/README.th.md) [![ti](https://img.shields.io/badge/lang-ti-red.svg)](readme/README.ti.md) [![ts](https://img.shields.io/badge/lang-ts-purple.svg)](readme/README.ts.md) [![tk](https://img.shields.io/badge/lang-tk-orange.svg)](readme/README.tk.md) [![ak](https://img.shields.io/badge/lang-ak-green.svg)](readme/README.ak.md) [![ug](https://img.shields.io/badge/lang-ug-purple.svg)](readme/README.ug.md) [![uz](https://img.shields.io/badge/lang-uz-orange.svg)](readme/README.uz.md) [![vi](https://img.shields.io/badge/lang-vi-green.svg)](readme/README.vi.md) [![cy](https://img.shields.io/badge/lang-cy-blue.svg)](readme/README.cy.md)  
[![xh](https://img.shields.io/badge/lang-xh-red.svg)](readme/README.xh.md) [![yi](https://img.shields.io/badge/lang-yi-purple.svg)](readme/README.yi.md) [![yo](https://img.shields.io/badge/lang-yo-orange.svg)](readme/README.yo.md) [![zu](https://img.shields.io/badge/lang-zu-green.svg)](readme/README.zu.md)

---


## 🚀 ഇൻസ്റ്റാളേഷൻ

PYPI- ൽ നിന്ന് ഇൻസ്റ്റാൾ ചെയ്യുക:

```bash
pip install pyhelper-tools-jbhm
```

---

## 📖 അവലോകനം

** Pyhelpe ** ** ഡാറ്റ വിശകലനം, ദൃശ്യപരത, സ്റ്റാറ്റിസ്റ്റിക്കൽ പ്രവർത്തനങ്ങൾ, യൂട്ടിലിറ്റി വർക്ക്ഫ്ലോവ് എന്നിവ രൂപകൽപ്പന ചെയ്ത ഒരു വൈവിധ്യമാർന്ന Python ടൂൾകിറ്റ് ആണ് ** .  
ഇത് തടസ്സമില്ലാതെ അക്കാദമിക്, ഗവേഷണ, പ്രൊഫഷണൽ പ്രോജക്റ്റുകളിലേക്ക് സമന്വയിപ്പിക്കുന്നു, ഇത് ബോയിലർ ടെംപ്ലേറ്റ് കോഡിനേക്കാൾ ഉൾക്കാഴ്ചകളിൽ ശ്രദ്ധ കേന്ദ്രീകരിക്കാൻ നിങ്ങളെ അനുവദിക്കുന്നു.

പ്രധാന പ്രയോജനങ്ങൾ:
- 🧮 ബിൽറ്റ്-ഇൻ ** സ്ഥിതിവിവരക്കണക്കുകളും കണക്ക് യൂട്ടിലിറ്റികളും ** 
- 📊 ഉപയോഗിക്കാൻ എളുപ്പത്തിൽ ** ഡാറ്റ വിഷ്വലൈസേഷൻ റാപ്പറുകൾ ** 
- 🗂 ഹാൻഡി ** ഫയൽ കൈകാര്യം ചെയ്യൽ, തിരയൽ ** 
- 🔍 ** Python ഫയലുകൾക്കായി വാക്യഘടന മൂല്യനിർണ്ണയം ** 
- 🌍 ** ഒന്നിലധികം ഭാഷാ പിന്തുണ ** റെഡി-ടു-ഉപയോഗ വിവർത്തനങ്ങൾ
- at ** ഫാസ്റ്റ് പ്രോട്ടോടൈപ്പിംഗിനായി ഒപ്റ്റിമൈസ് ചെയ്തു ** , ** വിദ്യാഭ്യാസം ** 

---

## ✨ പ്രധാന സവിശേഷതകൾ

### 📊 ഡാറ്റ വിഷ്വലൈസേഷൻ
- ബാർ ചാർട്ടുകൾ: തിരശ്ചീനവും ലംബവുമായ (`hbar`, `vbar`)  
- വിതരണ പ്ലോട്ടുകൾ: ഹിസ്റ്റോഗ്രാമുകൾ (`histo`), ബോക്സ് പ്ലോട്ടുകൾ (`boxplot`), കെഡിഇ പ്ലോട്ടുകൾ (`kdeplot`)  
- താരതമ്യ പ്ലോട്ടുകൾ: വയലിൻ, കൂട്ടം, സ്ട്രിപ്പ് പ്ലോട്ടുകൾ  
- പരസ്പരബന്ധം വിശകലനം: ഹീറ്റാമോപ്പുകൾ (`heatmap`), സ്കേറ്റർ പ്ലോട്ടുകൾ (`scatter`)  
- വിപുലമായ ദൃശ്യവൽക്കരണങ്ങൾ: ജോഡി പ്ലോട്ടുകൾ, ജോയിന്റ് പ്ലോട്ടുകൾ, റിഗ്രഷൻ പ്ലോട്ടുകൾ  
- ഡാറ്റ പട്ടികകൾ: ഫോർമാറ്റുചെയ്ത പട്ടിക പ്രദർശിപ്പിക്കുന്നു (`table`)  

### 📈 സ്റ്റാറ്റിസ്റ്റിക്കൽ വിശകലനം
- ** കേന്ദ്ര പ്രവണത ** : അർത്ഥമാക്കുന്നത് (`get_media`), മീഡിയൻ (`get_median`), മോഡ് (`get_moda`)  
- ** വിതരണം ** : ശ്രേണി (`get_rank`), വേരിയൻസ് (`get_var`), സ്റ്റാൻഡേർഡ് ഡീവിയേഷൻ (`get_desv`)  
- ** വിശകലനം ** : വിതരണ റിപ്പോർട്ടുകൾ (`disp`), ഐക്ആർ കണക്കുകൂട്ടലുകൾ, സാധാരണവൽക്കരണം, സോപാധിക പരിവർത്തനങ്ങൾ  
- ** li ട്ട്ലിയർ കണ്ടെത്തൽ ** : ഐക്ആർ, ഇസഡ് സ്കോർ രീതികൾ  

### 🗂️ ഫയൽ മാനേജുമെന്റ്
- `call()` (auto-detect CSV, JSON, XML, etc.) ഉള്ള സ്മാർട്ട് കണ്ടെത്തൽ  
- മൾട്ടി ഫോർമാറ്റ് പിന്തുണ (CSV, JSON, XML, PDF, spatial data)  
- `DataBase` ക്ലാസ് ഉള്ള SQL ഡാറ്റാബേസ് മാനേജുമെന്റ്  
- പരിവർത്തന യൂട്ടിലിറ്റി (`convert_file`)  

### 🛠️ ഡവലപ്പർ ഉപകരണങ്ങൾ
- സ്വിച്ച് സിസ്റ്റം (`Switch`, `AsyncSwitch`)  
- വാക്യഘടന പരിശോധന (`check_syntax`, `PythonFileChecker`)  
- സമ്പന്നമായ പിശക് റിപ്പോർട്ടിംഗ് (multi-language)  
- സംയോജിത സഹായ സംവിധാനം (`help`)  

### 🌍 അന്താരാഷ്ട്രവൽക്കരണം
- 100+ അന്തർനിർമ്മിത വിവർത്തനങ്ങൾ  
- ഇഷ്ടാനുസൃത വിവർത്തനങ്ങൾ ലോഡുചെയ്യുക  
- റൺടൈം ലാംഗ്വേജ് സ്വിച്ചിംഗ് (`set_language() `)  
- Automatic English fallback  

---

## Dependencies (handled automatically):

- pandas, numpy (data manipulation)

- matplotlib, seaborn (visualization)

- scikit-learn (statistics)

- sqlalchemy (database)

- geopandas (spatial data)

---

## 🔧 Usage Examples

### Set language 

**support for up to 131 languages** 
``_14_ ``


### അടിസ്ഥാന സ്ഥിതിവിവരക്കണക്കുകൾ
```python
import helper as hp

data = [1, 2, 2, 3, 4, 5]

print(hp.get_media(data))   # Mean
print(hp.get_median(data))  # Median
print(hp.get_moda(data))    # Mode
```

### ദൃശ്യവൽക്കരണം
```python
import helper as hp

df = hp.pd.DataFrame({"values": [5, 3, 7, 2, 9]})
hp.histo(df, "values", bins=5, title="Sample Histogram")
```

### ഫയൽ കൈകാര്യം ചെയ്യൽ
```python
from helper import call

data = call(name="my_data", type="csv")  # Finds and loads a CSV file automatically
```

### ഇഷ്ടാനുസൃത വിവർത്തനങ്ങൾ
```python
from helper import load_user_translations

# Load custom translations from lang.json
load_user_translations("custom/lang.json")
```

### വാക്യഘടന മൂല്യനിർണ്ണയം
```python
from helper import run

run("./path/to/my_script.py")
#Show gui pop up with results
```

---

## 📂 പ്രോജക്റ്റ് ഘടന

```
helper/
├── core.py
├── __init__.py
├── lang/
│   ├── en.json
│   ├── es.json
│   └── ... (100+ files)
└── submodules/
    ├── graph.py
    ├── statics.py
    ├── utils.py
    ├── caller.py
    ├── checker.py
    ├── manager.py
    ├── pyswitch.py
    ├── shared.py
    └── DBManager.py
```

---

## 📜 License

ഈ പ്രോജക്റ്റ് ** MIT π_4 _ ** കീഴിലാണ് ലൈസൻസ് ചെയ്തിരിക്കുന്നത്.  
വിശദാംശങ്ങൾക്ക് [LICENSE](LICENSE) ഫയൽ കാണുക.

---

## 🔮 റോഡ്മാപ്പ്

- അധിക വിഷ്വലൈസേഷൻ തരങ്ങൾ

- വിപുലീകൃത ഡാറ്റാബേസ് പിന്തുണ (NoSQL, graph databases)

- മെഷീൻ പഠന സംയോജനം

- വെബ് അധിഷ്ഠിത ഇന്റർഫേസ്

- പ്ലഗിൻ സിസ്റ്റം

---

Age ** പൈഹെൽപറുമായി നിങ്ങളുടെ Python വർക്ക്ഫ്ലോട്ടുകൾ സൂപ്പർചാർപ്പിക്കാൻ തയ്യാറാണോ ** ? ഇന്ന് പര്യവേക്ഷണം ആരംഭിക്കുക!