# ຫ້ອງສະຫມຸດຜູ້ຊ່ວຍ

[![License: MIT](https://img.shields.io/badge/License-MIT-yellow.svg)](LICENSE) [![PyPI](https://img.shields.io/pypi/v/pyhelper-tools-jbhm?style=for-the-badge&label=PyPI&color=blue)](https://pypi.org/project/pyhelper-tools-jbhm/)

## 🌍ພາສາທີ່ມີຢູ່

Pyhelper ສະເຫນີການແປທີ່ໄດ້ສ້າງຂຶ້ນມາຈົນເຖິງ ** 131 ພາສາ ** ລວມທັງ:

[![en](https://img.shields.io/badge/lang-en-red.svg)](readme/README.md) [![es](https://img.shields.io/badge/lang-es-yellow.svg)](readme/README.es.md) [![fr](https://img.shields.io/badge/lang-fr-blue.svg)](readme/README.fr.md) [![de](https://img.shields.io/badge/lang-de-green.svg)](readme/README.de.md) [![ru](https://img.shields.io/badge/lang-ru-purple.svg)](readme/README.ru.md) [![zh](https://img.shields.io/badge/lang-zh-black.svg)](readme/README.zh.md) [![zh](https://img.shields.io/badge/lang-zh-black.svg)](readme/README.zh.md) [![it](https://img.shields.io/badge/lang-it-lightgrey.svg)](readme/README.it.md) [![it](https://img.shields.io/badge/lang-it-lightgrey.svg)](readme/README.it.md) [![it](https://img.shields.io/badge/lang-it-lightgrey.svg)](readme/README.it.md) [![pt](https://img.shields.io/badge/lang-pt-brightgreen.svg)](readme/README.pt.md) [![pt](https://img.shields.io/badge/lang-pt-brightgreen.svg)](readme/README.pt.md) [![sv](https://img.shields.io/badge/lang-sv-blue.svg)](readme/README.sv.md)  
[![ja](https://img.shields.io/badge/lang-ja-red.svg)](readme/README.ja.md) [![ar](https://img.shields.io/badge/lang-ar-brown.svg)](readme/README.ar.md)1559[![af](https://img.shields.io/badge/lang-af-orange.svg)](readme/README.af.md) [![sq](https://img.shields.io/badge/lang-sq-blue.svg)](readme/README.sq.md) [![hy](https://img.shields.io/badge/lang-hy-red.svg)](readme/README.hy.md) [![as](https://img.shields.io/badge/lang-as-purple.svg)](readme/README.as.md) π_1534_ π_1532_ [![az](https://img.shields.io/badge/lang-az-lightblue.svg)](readme/README.az.md) [![az](https://img.shields.io/badge/lang-az-lightblue.svg)](readme/README.az.md)  
[![eu](https://img.shields.io/badge/lang-eu-pink.svg)](readme/README.eu.md) [![be](https://img.shields.io/badge/lang-be-darkblue.svg)](readme/README.be.md) [![bn](https://img.shields.io/badge/lang-bn-teal.svg)](readme/README.bn.md) [![bs](https://img.shields.io/badge/lang-bs-purple.svg)](readme/README.bm.md) [![ca](https://img.shields.io/badge/lang-ca-yellow.svg)](readme/README.ca.md) [![ca](https://img.shields.io/badge/lang-ca-yellow.svg)](readme/README.ca.md) [![ceb](https://img.shields.io/badge/lang-ceb-blue.svg)](readme/README.ceb.md) [![ny](https://img.shields.io/badge/lang-ny-red.svg)](readme/README.ny.md) [![co](https://img.shields.io/badge/lang-co-green.svg)](readme/README.co.md) [![co](https://img.shields.io/badge/lang-co-green.svg)](readme/README.co.md) [![co](https://img.shields.io/badge/lang-co-green.svg)](readme/README.co.md) [![co](https://img.shields.io/badge/lang-co-green.svg)](readme/README.co.md)  
[![hr](https://img.shields.io/badge/lang-hr-blue.svg)](readme/README.hr.md) [![cs](https://img.shields.io/badge/lang-cs-red.svg)](readme/README.cs.md) [![da](https://img.shields.io/badge/lang-da-purple.svg)](readme/README.da.md) [![dv](https://img.shields.io/badge/lang-dv-orange.svg)](readme/README.dv.md) [![nl](https://img.shields.io/badge/lang-nl-orange.svg)](readme/README.nl.md) [![nl](https://img.shields.io/badge/lang-nl-orange.svg)](readme/README.nl.md) π_1334π_1334[![et](https://img.shields.io/badge/lang-et-blue.svg)](readme/README.et.md) [![et](https://img.shields.io/badge/lang-et-blue.svg)](readme/README.et.md) [![et](https://img.shields.io/badge/lang-et-blue.svg)](readme/README.et.md) π_133. [![ee](https://img.shields.io/badge/lang-ee-red.svg)](readme/README.ee.md) [![ee](https://img.shields.io/badge/lang-ee-red.svg)](readme/README.ee.md)  
[![fi](https://img.shields.io/badge/lang-fi-blue.svg)](readme/README.fi.md) [![fy](https://img.shields.io/badge/lang-fy-orange.svg)](readme/README.fy.md) [![gl](https://img.shields.io/badge/lang-gl-green.svg)](readme/README.gl.md) [![ka](https://img.shields.io/badge/lang-ka-red.svg)](readme/README.ka.md) [![gn](https://img.shields.io/badge/lang-gn-purple.svg)](readme/README.gn.md) [![gn](https://img.shields.io/badge/lang-gn-purple.svg)](readme/README.gn.md) [![ht](https://img.shields.io/badge/lang-ht-green.svg)](readme/README.ht.md) [![ha](https://img.shields.io/badge/lang-ha-blue.svg)](readme/README.ha.md) [![ha](https://img.shields.io/badge/lang-ha-blue.svg)](readme/README.ha.md) [![haw](https://img.shields.io/badge/lang-haw-red.svg)](readme/README.haw.md) [![haw](https://img.shields.io/badge/lang-haw-red.svg)](readme/README.haw.md) [![haw](https://img.shields.io/badge/lang-haw-red.svg)](readme/README.haw.md) [![haw](https://img.shields.io/badge/lang-haw-red.svg)](readme/README.haw.md)  
[![iw](https://img.shields.io/badge/lang-iw-purple.svg)](readme/README.iw.md) [![hi](https://img.shields.io/badge/lang-hi-orange.svg)](readme/README.hi.md) [![hmn](https://img.shields.io/badge/lang-hmn-green.svg)](readme/README.hmn.md) [![hu](https://img.shields.io/badge/lang-hu-blue.svg)](readme/README.hu.md) [![is](https://img.shields.io/badge/lang-is-red.svg)](readme/README.is.md) [![ig](https://img.shields.io/badge/lang-ig-purple.svg)](readme/README.ig.md) [![ilo](https://img.shields.io/badge/lang-ilo-orange.svg)](readme/README.ilo.md) [![ilo](https://img.shields.io/badge/lang-ilo-orange.svg)](readme/README.ilo.md) π_113. π_113. π_113. π_113. π112_ [![ga](https://img.shields.io/badge/lang-ga-blue.svg)](readme/README.ga.md) [![ga](https://img.shields.io/badge/lang-ga-blue.svg)](readme/README.ga.md)  
[![kn](https://img.shields.io/badge/lang-kn-purple.svg)](readme/README.kn.md) [![kk](https://img.shields.io/badge/lang-kk-orange.svg)](readme/README.kk.md) [![km](https://img.shields.io/badge/lang-km-green.svg)](readme/README.km.md) [![rw](https://img.shields.io/badge/lang-rw-blue.svg)](readme/README.rw.md) [![ko](https://img.shields.io/badge/lang-ko-purple.svg)](readme/README.ko.md) [![ko](https://img.shields.io/badge/lang-ko-purple.svg)](readme/README.ko.md) [![kri](https://img.shields.io/badge/lang-kri-orange.svg)](readme/README.kri.md) π_103. π_103. [![ckb](https://img.shields.io/badge/lang-ckb-blue.svg)](readme/README.ckb.md) [![ckb](https://img.shields.io/badge/lang-ckb-blue.svg)](readme/README.ckb.md) [![ckb](https://img.shields.io/badge/lang-ckb-blue.svg)](readme/README.ckb.md) [![ky](https://img.shields.io/badge/lang-ky-red.svg)](readme/README.ky.md)  
[![lo](https://img.shields.io/badge/lang-lo-purple.svg)](readme/README.lo.md) [![la](https://img.shields.io/badge/lang-la-orange.svg)](readme/README.la.md) [![lv](https://img.shields.io/badge/lang-lv-green.svg)](readme/README.lv.md) [![lt](https://img.shields.io/badge/lang-lt-red.svg)](readme/README.lt.md) [![lt](https://img.shields.io/badge/lang-lt-red.svg)](readme/README.lt.md) [![lg](https://img.shields.io/badge/lang-lg-purple.svg)](readme/README.lg.md) [![lb](https://img.shields.io/badge/lang-lb-orange.svg)](readme/README.lb.md) [![mk](https://img.shields.io/badge/lang-mk-green.svg)](readme/README.mk.md) [![mk](https://img.shields.io/badge/lang-mk-green.svg)](readme/README.mk.md) [![mai](https://img.shields.io/badge/lang-mai-blue.svg)](readme/README.mai.md) [![mg](https://img.shields.io/badge/lang-mg-red.svg)](readme/README.mg.md) [![mg](https://img.shields.io/badge/lang-mg-red.svg)](readme/README.mg.md)  
[![ms](https://img.shields.io/badge/lang-ms-purple.svg)](readme/README.ms.md) [![ml](https://img.shields.io/badge/lang-ml-orange.svg)](readme/README.ml.md) [![mt](https://img.shields.io/badge/lang-mt-green.svg)](readme/README.mt.md) [![mr](https://img.shields.io/badge/lang-mr-red.svg)](readme/README.mr.md) [![lus](https://img.shields.io/badge/lang-lus-purple.svg)](readme/README.lus.md) [![mn](https://img.shields.io/badge/lang-mn-orange.svg)](readme/README.mn.md) [![my](https://img.shields.io/badge/lang-my-green.svg)](readme/README.my.md) [![ne](https://img.shields.io/badge/lang-ne-blue.svg)](readme/README.ne.md) [![ne](https://img.shields.io/badge/lang-ne-blue.svg)](readme/README.ne.md) [![no](https://img.shields.io/badge/lang-no-red.svg)](readme/README.no.md) [![or](https://img.shields.io/badge/lang-or-purple.svg)](readme/README.or.md)  
[![om](https://img.shields.io/badge/lang-om-orange.svg)](readme/README.om.md) [![ps](https://img.shields.io/badge/lang-ps-green.svg)](readme/README.ps.md) [![fa](https://img.shields.io/badge/lang-fa-blue.svg)](readme/README.fa.md) [![ro](https://img.shields.io/badge/lang-ro-purple.svg)](readme/README.ro.md) [![sm](https://img.shields.io/badge/lang-sm-orange.svg)](readme/README.sm.md) [![gd](https://img.shields.io/badge/lang-gd-blue.svg)](readme/README.gd.md) [![gd](https://img.shields.io/badge/lang-gd-blue.svg)](readme/README.gd.md) [![nso](https://img.shields.io/badge/lang-nso-red.svg)](readme/README.nso.md) [![nso](https://img.shields.io/badge/lang-nso-red.svg)](readme/README.nso.md) [![nso](https://img.shields.io/badge/lang-nso-red.svg)](readme/README.nso.md) [![st](https://img.shields.io/badge/lang-st-purple.svg)](readme/README.st.md) [![st](https://img.shields.io/badge/lang-st-purple.svg)](readme/README.st.md) [![sn](https://img.shields.io/badge/lang-sn-orange.svg)](readme/README.sn.md)  
[![sd](https://img.shields.io/badge/lang-sd-green.svg)](readme/README.sd.md) [![si](https://img.shields.io/badge/lang-si-blue.svg)](readme/README.si.md) [![sk](https://img.shields.io/badge/lang-sk-red.svg)](readme/README.sk.md) [![sl](https://img.shields.io/badge/lang-sl-purple.svg)](readme/README.sl.md) [![so](https://img.shields.io/badge/lang-so-orange.svg)](readme/README.so.md) [![su](https://img.shields.io/badge/lang-su-green.svg)](readme/README.su.md) [![sw](https://img.shields.io/badge/lang-sw-blue.svg)](readme/README.sw.md) [![sw](https://img.shields.io/badge/lang-sw-blue.svg)](readme/README.sw.md) [![ta](https://img.shields.io/badge/lang-ta-purple.svg)](readme/README.ta.md) [![ta](https://img.shields.io/badge/lang-ta-purple.svg)](readme/README.ta.md) [![tg](https://img.shields.io/badge/lang-tg-red.svg)](readme/README.tg.md) π_60. [![ta](https://img.shields.io/badge/lang-ta-purple.svg)](readme/README.ta.md) [![ug](https://img.shields.io/badge/lang-ug-purple.svg)](readme/README.ug.md) [![tt](https://img.shields.io/badge/lang-tt-orange.svg)](readme/README.tt.md) [![tt](https://img.shields.io/badge/lang-tt-orange.svg)](readme/README.tt.md) [![tt](https://img.shields.io/badge/lang-tt-orange.svg)](readme/README.tt.md) [![te](https://img.shields.io/badge/lang-te-green.svg)](readme/README.te.md) [![tt](https://img.shields.io/badge/lang-tt-orange.svg)](readme/README.tt.md)  
[![th](https://img.shields.io/badge/lang-th-blue.svg)](readme/README.th.md) [![ti](https://img.shields.io/badge/lang-ti-red.svg)](readme/README.ti.md) [![ts](https://img.shields.io/badge/lang-ts-purple.svg)](readme/README.ts.md) [![tk](https://img.shields.io/badge/lang-tk-orange.svg)](readme/README.tk.md) [![uk](https://img.shields.io/badge/lang-uk-blue.svg)](readme/README.uk.md) [![ur](https://img.shields.io/badge/lang-ur-red.svg)](readme/README.ur.md) [![ur](https://img.shields.io/badge/lang-ur-red.svg)](readme/README.ur.md) Python [![uz](https://img.shields.io/badge/lang-uz-orange.svg)](readme/README.uz.md) [![uz](https://img.shields.io/badge/lang-uz-orange.svg)](readme/README.uz.md) [![vi](https://img.shields.io/badge/lang-vi-green.svg)](readme/README.vi.md) [![vi](https://img.shields.io/badge/lang-vi-green.svg)](readme/README.vi.md)  
[![xh](https://img.shields.io/badge/lang-xh-red.svg)](readme/README.xh.md) [![yi](https://img.shields.io/badge/lang-yi-purple.svg)](readme/README.yi.md) [![yo](https://img.shields.io/badge/lang-yo-orange.svg)](readme/README.yo.md) [![zu](https://img.shields.io/badge/lang-zu-green.svg)](readme/README.zu.md)

---


## 🚀ການຕິດຕັ້ງ

ຕິດຕັ້ງຈາກ PYPI:

```bash
pip install pyhelper-tools-jbhm
```

---

## 📖ພາບລວມ

** pyhelper ** ແມ່ນເຄື່ອງມື __41_ ທີ່ຖືກອອກແບບມາເພື່ອງ່າຍດາຍ ** ການວິເຄາະຂໍ້ມູນ, ການເບິ່ງເຫັນ, ການເຮັດວຽກສະຖິຕິ,.  
ມັນປະສົມປະສານເຂົ້າໄປໃນໂຄງການຄົ້ນຄ້ວາວິຊາການ, ແລະໂຄງການວິຊາຊີບ, ໃຫ້ທ່ານສຸມໃສ່ຄວາມເຂົ້າໃຈຫຼາຍກວ່າລະຫັດ boilerplate.

ຂໍ້ໄດ້ປຽບທີ່ສໍາຄັນ:
- 🧮ທີ່ສ້າງຂຶ້ນ ** ສະຖິຕິແລະເຄື່ອງໃຊ້ເລກຄະນິດສາດ ** 
- 📊ງ່າຍທີ່ຈະໃຊ້ ** ຫໍ່ຂອງຂໍ້ມູນການສະແດງຂໍ້ມູນ ** 
- 🗂ການຈັດການເອກະສານທີ່ມີປະສິດຕິພາບ ** ແລະການຄົ້ນຫາ ** 
- 🔍 ** ຄວາມຖືກຕ້ອງຂອງ Syntax ** ສໍາລັບPythonໄຟລ໌
- 🌍 ** ສະຫນັບສະຫນູນພາສາຫຼາຍພາສາ ** ກັບການແປທີ່ພ້ອມທີ່ຈະໃຊ້
- 🚀ທີ່ດີທີ່ສຸດສໍາລັບ ** ແບບໄວທີ່ສຸດ ** ແລະ ** ການສຶກສາ ** 

---

## ✨ຄຸນລັກສະນະທີ່ສໍາຄັນ

### 📊ການເບິ່ງເຫັນຂໍ້ມູນ
- ຕາຕະລາງແຖບ: ແນວນອນ & ແນວຕັ້ງ(`hbar`, `vbar`)  
- ແຜນການແຈກຢາຍ: histograms (`histo`), ປ່ອງທີ່ຢູ່ໃນປ່ອງ(`boxplot`), SLTS KDE (`kdeplot`)  
- ແຜນການປຽບທຽບ: PLOTS ປຽບທຽບ: ໄວໂອລິນ, swarm, ລອກແຜນດິນ  
- ການວິເຄາະທີ່ກ່ຽວຂ້ອງ: HEENMAPS (`heatmap`), ກະເປົາກະແຈກກະຈາຍ(`scatter`)  
- ສາຍຕາທີ່ກ້າວຫນ້າ: ແຜນການຄູ່, ດິນຕອນຮ່ວມ, ຜູ້ສິ້ນສຸດ, ແຜນການ  
- ຕາຕະລາງຂໍ້ມູນ: ຕາຕະລາງທີ່ມີຮູບແບບສະແດງ(`table`)  

### 📈ການວິເຄາະສະຖິຕິ
- ** ແນວພັນກາງ ** : ຫມາຍຄວາມວ່າ(`get_media`), ປານກາງ(`get_median`), mode (`get_moda`)  
- ** ການກະທໍາຄວາມຈິງ ** : ຊ່ວງ(`get_rank`), Variance (`get_var`), deviation ມາດຕະຖານ(`get_desv`)  
- ** ການວິເຄາະ ** : ບົດລາຍງານການກະແຈກກະຈາຍ(`disp`), ການຄິດໄລ່ IQR, ການເປັນປົກກະຕິ, ການຫັນປ່ຽນເງື່ອນໄຂ, ການຫັນປ່ຽນເງື່ອນໄຂ  
- ** ການກວດສອບພາຍໃນ ** : ວິທີການ IQR ແລະ Z-Scets  

### 🗂️ການຄຸ້ມຄອງເອກະສານ
- ສະຫຼາດ Discovery ກັບ`call()` (auto-detect CSV, JSON, XML, etc.)  
- ການສະຫນັບສະຫນູນຫຼາຍຮູບແບບ(CSV, JSON, XML, PDF, spatial data)  
- ການຄຸ້ມຄອງຖານຂໍ້ມູນ SQL ກັບຫ້ອງຮຽນ`DataBase`  
- ເຄື່ອງໃຊ້ແປງການແປງ(`convert_file`)  

### 🛠️ເຄື່ອງກໍາຈັດນັກພັດທະນາ
- ປ່ຽນລະບົບ(`Switch`, `AsyncSwitch`)  
- ການກວດສອບ syntax (`check_syntax`, `PythonFileChecker`)  
- ການລາຍງານຄວາມຜິດພາດທີ່ອຸດົມສົມບູນ(multi-language)  
- ລະບົບການຊ່ວຍເຫຼືອແບບປະສົມປະສານ(`help`)  

###🌍🌍🌍ationInization
- ການແປພາສາທີ່ຕິດຕັ້ງ 100+  
- ການໂຫຼດຄໍາແປພາສາ  
- ການປ່ຽນພາສາ Runtime (`set_language() `)  
- Automatic English fallback  

---

## Dependencies (handled automatically):

- pandas, numpy (data manipulation)

- matplotlib, seaborn (visualization)

- scikit-learn (statistics)

- sqlalchemy (database)

- geopandas (spatial data)

---

## 🔧 Usage Examples

### Set language 

**support for up to 131 languages** 
```python
from helper import set_language

set_language("en")  # English
set_language("es")  # Spanish
set_language("fr")  # French
set_language("de")  # German
set_language("ru")  # Russian
set_language("tr")  # Turkish
set_language("zh")  # Chinese
set_language("it")  # Italian
set_language("pt")  # Portuguese
set_language("sv")  # Swedish
set_language("ja")  # Japanese
set_language("ar")  # Arabic
...
```


### ສະຖິຕິພື້ນຖານ
```python
import helper as hp

data = [1, 2, 2, 3, 4, 5]

print(hp.get_media(data))   # Mean
print(hp.get_median(data))  # Median
print(hp.get_moda(data))    # Mode
```

### ການເບິ່ງເຫັນ
```python
import helper as hp

df = hp.pd.DataFrame({"values": [5, 3, 7, 2, 9]})
hp.histo(df, "values", bins=5, title="Sample Histogram")
```

### ການຈັດການເອກະສານ
```python
from helper import call

data = call(name="my_data", type="csv")  # Finds and loads a CSV file automatically
```

### ການແປພາສາຕາມປະເພນີ
```python
from helper import load_user_translations

# Load custom translations from lang.json
load_user_translations("custom/lang.json")
```

### ການກວດສອບ SYNTAX
```python
from helper import run

run("./path/to/my_script.py")
#Show gui pop up with results
```

---

## 📂ໂຄງສ້າງໂຄງການ

```
helper/
├── core.py
├── __init__.py
├── lang/
│   ├── en.json
│   ├── es.json
│   └── ... (100+ files)
└── submodules/
    ├── graph.py
    ├── statics.py
    ├── utils.py
    ├── caller.py
    ├── checker.py
    ├── manager.py
    ├── pyswitch.py
    ├── shared.py
    └── DBManager.py
```

---

## 📜License

ໂຄງການນີ້ໄດ້ຮັບອະນຸຍາດພາຍໃຕ້ການ ** MIT π_4 _ ** .  
ເບິ່ງເອກະສານ[LICENSE](LICENSE)ສໍາລັບລາຍລະອຽດ.

---

## 🔮 STAILLMAP

- ປະເພດການເບິ່ງເຫັນເພີ່ມເຕີມ

- ການສະຫນັບສະຫນູນຖານຂໍ້ມູນທີ່ຂະຫຍາຍ(NoSQL, graph databases)

- ການເຊື່ອມໂຍງການຮຽນຮູ້ເຄື່ອງ

- ການໂຕ້ຕອບທີ່ອີງໃສ່ເວບໄຊທ໌

- ລະບົບປັສມາດ

---

⚡ກຽມພ້ອມທີ່ຈະ superforming Pythonຂອງທ່ານເຮັດວຽກກັບ ** Pyhelper ** ? ເລີ່ມສໍາຫຼວດມື້ນີ້!