# Жардамчы китепкана

[![License: MIT](https://img.shields.io/badge/License-MIT-yellow.svg)](LICENSE) [![PyPI](https://img.shields.io/pypi/v/pyhelper-tools-jbhm?style=for-the-badge&label=PyPI&color=blue)](https://pypi.org/project/pyhelper-tools-jbhm/)

## Коллегиялык тилдер

Pyhelper ** 131 тилге чейин ** тилиндеги котормолор ** ** тилине которулган **

[![en](https://img.shields.io/badge/lang-en-red.svg)](readme/README.md) [![es](https://img.shields.io/badge/lang-es-yellow.svg)](readme/README.es.md)1168_1167_ [![ru](https://img.shields.io/badge/lang-ru-purple.svg)](readme/README.ru.md) [![tr](https://img.shields.io/badge/lang-tr-orange.svg)](readme/README.tr.md) (`set_language()116_163_ [![pt](https://img.shields.io/badge/lang-pt-brightgreen.svg)](readme/README.pt.md) [![sv](https://img.shields.io/badge/lang-sv-blue.svg)](readme/README.sv.md)  
[![ja](https://img.shields.io/badge/lang-ja-red.svg)](readme/README.ja.md)158_158_158_156_155_156_155_156_155_156_155_153_ [![ay](https://img.shields.io/badge/lang-ay-brown.svg)](readme/README.ay.md)152_ [![bm](https://img.shields.io/badge/lang-bm-darkgreen.svg)](readme/README.bm.md)  
[![eu](https://img.shields.io/badge/lang-eu-pink.svg)](readme/README.eu.md) [![be](https://img.shields.io/badge/lang-be-darkblue.svg)](readme/README.be.md) [![bn](https://img.shields.io/badge/lang-bn-teal.svg)](readme/README.bn.md)147_ [![bs](https://img.shields.io/badge/lang-bs-purple.svg)](readme/README.bm.md) [![bg](https://img.shields.io/badge/lang-bg-green.svg)](readme/README.bg.md) [![ca](https://img.shields.io/badge/lang-ca-yellow.svg)](readme/README.ca.md) [![ceb](https://img.shields.io/badge/lang-ceb-blue.svg)](readme/README.ceb.md) [![ny](https://img.shields.io/badge/lang-ny-red.svg)](readme/README.ny.md) [![co](https://img.shields.io/badge/lang-co-green.svg)](readme/README.co.md)  
[![hr](https://img.shields.io/badge/lang-hr-blue.svg)](readme/README.hr.md)138_138_138_137_135_136_ [![nl](https://img.shields.io/badge/lang-nl-orange.svg)](readme/README.nl.md) [![eo](https://img.shields.io/badge/lang-eo-green.svg)](readme/README.eo.md) [![et](https://img.shields.io/badge/lang-et-blue.svg)](readme/README.et.md) [![ee](https://img.shields.io/badge/lang-ee-red.svg)](readme/README.ee.md) [![tl](https://img.shields.io/badge/lang-tl-purple.svg)](readme/README.tl.md)  
[![fi](https://img.shields.io/badge/lang-fi-blue.svg)](readme/README.fi.md) [![fy](https://img.shields.io/badge/lang-fy-orange.svg)](readme/README.fy.md) [![gl](https://img.shields.io/badge/lang-gl-green.svg)](readme/README.gl.md) [![ka](https://img.shields.io/badge/lang-ka-red.svg)](readme/README.ka.md)112_126_ [![gn](https://img.shields.io/badge/lang-gn-purple.svg)](readme/README.gn.md) [![gu](https://img.shields.io/badge/lang-gu-orange.svg)](readme/README.gu.md) [![gu](https://img.shields.io/badge/lang-gu-orange.svg)](readme/README.gu.md) [![ht](https://img.shields.io/badge/lang-ht-green.svg)](readme/README.ht.md) [![ha](https://img.shields.io/badge/lang-ha-blue.svg)](readme/README.ha.md) [![haw](https://img.shields.io/badge/lang-haw-red.svg)](readme/README.haw.md)  
[![iw](https://img.shields.io/badge/lang-iw-purple.svg)](readme/README.iw.md) [![hi](https://img.shields.io/badge/lang-hi-orange.svg)](readme/README.hi.md)118_ [![hu](https://img.shields.io/badge/lang-hu-blue.svg)](readme/README.hu.md)117_117_116_ [![ig](https://img.shields.io/badge/lang-ig-purple.svg)](readme/README.ig.md) [![ilo](https://img.shields.io/badge/lang-ilo-orange.svg)](readme/README.ilo.md) [![id](https://img.shields.io/badge/lang-id-green.svg)](readme/README.id.md)113_ [![ga](https://img.shields.io/badge/lang-ga-blue.svg)](readme/README.ga.md) [![jw](https://img.shields.io/badge/lang-jw-red.svg)](readme/README.jw.md)  
[![kn](https://img.shields.io/badge/lang-kn-purple.svg)](readme/README.kn.md) [![kk](https://img.shields.io/badge/lang-kk-orange.svg)](readme/README.kk.md) [![km](https://img.shields.io/badge/lang-km-green.svg)](readme/README.km.md)107_ [![gom](https://img.shields.io/badge/lang-gom-red.svg)](readme/README.gom.md) [![ko](https://img.shields.io/badge/lang-ko-purple.svg)](readme/README.ko.md) [![kri](https://img.shields.io/badge/lang-kri-orange.svg)](readme/README.kri.md) [![ku](https://img.shields.io/badge/lang-ku-green.svg)](readme/README.ku.md) [![ckb](https://img.shields.io/badge/lang-ckb-blue.svg)](readme/README.ckb.md) [![ky](https://img.shields.io/badge/lang-ky-red.svg)](readme/README.ky.md)  
[![lo](https://img.shields.io/badge/lang-lo-purple.svg)](readme/README.lo.md) [![la](https://img.shields.io/badge/lang-la-orange.svg)](readme/README.la.md) [![lv](https://img.shields.io/badge/lang-lv-green.svg)](readme/README.lv.md) [![ln](https://img.shields.io/badge/lang-ln-blue.svg)](readme/README.ln.md) [![lt](https://img.shields.io/badge/lang-lt-red.svg)](readme/README.lt.md) [![lg](https://img.shields.io/badge/lang-lg-purple.svg)](readme/README.lg.md) [![lb](https://img.shields.io/badge/lang-lb-orange.svg)](readme/README.lb.md) [![mk](https://img.shields.io/badge/lang-mk-green.svg)](readme/README.mk.md) [![mai](https://img.shields.io/badge/lang-mai-blue.svg)](readme/README.mai.md) [![mg](https://img.shields.io/badge/lang-mg-red.svg)](readme/README.mg.md)  
[![ms](https://img.shields.io/badge/lang-ms-purple.svg)](readme/README.ms.md) [![ml](https://img.shields.io/badge/lang-ml-orange.svg)](readme/README.ml.md)88_88_8_85_85_85_85_ [![mn](https://img.shields.io/badge/lang-mn-orange.svg)](readme/README.mn.md) [![my](https://img.shields.io/badge/lang-my-green.svg)](readme/README.my.md) [![ne](https://img.shields.io/badge/lang-ne-blue.svg)](readme/README.ne.md) [![no](https://img.shields.io/badge/lang-no-red.svg)](readme/README.no.md) [![or](https://img.shields.io/badge/lang-or-purple.svg)](readme/README.or.md)  
[![om](https://img.shields.io/badge/lang-om-orange.svg)](readme/README.om.md) [![ps](https://img.shields.io/badge/lang-ps-green.svg)](readme/README.ps.md)7_77_ [![qu](https://img.shields.io/badge/lang-qu-red.svg)](readme/README.qu.md) [![ro](https://img.shields.io/badge/lang-ro-purple.svg)](readme/README.ro.md) [![sm](https://img.shields.io/badge/lang-sm-orange.svg)](readme/README.sm.md) [![sm](https://img.shields.io/badge/lang-sm-orange.svg)](readme/README.sm.md) [![gd](https://img.shields.io/badge/lang-gd-blue.svg)](readme/README.gd.md) [![gd](https://img.shields.io/badge/lang-gd-blue.svg)](readme/README.gd.md) [![nso](https://img.shields.io/badge/lang-nso-red.svg)](readme/README.nso.md) [![st](https://img.shields.io/badge/lang-st-purple.svg)](readme/README.st.md) [![sn](https://img.shields.io/badge/lang-sn-orange.svg)](readme/README.sn.md)  
[![sd](https://img.shields.io/badge/lang-sd-green.svg)](readme/README.sd.md)67_67_66_6_64_64_63_ [![sw](https://img.shields.io/badge/lang-sw-blue.svg)](readme/README.sw.md) [![tg](https://img.shields.io/badge/lang-tg-red.svg)](readme/README.tg.md) [![ta](https://img.shields.io/badge/lang-ta-purple.svg)](readme/README.ta.md) [![tt](https://img.shields.io/badge/lang-tt-orange.svg)](readme/README.tt.md) [![te](https://img.shields.io/badge/lang-te-green.svg)](readme/README.te.md)  
[![th](https://img.shields.io/badge/lang-th-blue.svg)](readme/README.th.md)56_56_55_55_55_53_52_52_4_5_50_50_50_50_48_4_48_ [![cy](https://img.shields.io/badge/lang-cy-blue.svg)](readme/README.cy.md)  
[![xh](https://img.shields.io/badge/lang-xh-red.svg)](readme/README.xh.md)44 [![yo](https://img.shields.io/badge/lang-yo-orange.svg)](readme/README.yo.md) [![zu](https://img.shields.io/badge/lang-zu-green.svg)](readme/README.zu.md)

---


## орнотуу

Pypi орнотуу:

```bash
pip install pyhelper-tools-jbhm
```

---

## 📖 Сереп

** pyhelper ** - бул ар тараптуу Python Python TOULLITE ** маалыматтарды талдоо, визуализация, статистикалык операцияларды жана пайдалуу иш-чараларды өткөрүп берүү үчүн иштелип чыккан.  
Бул сизге сигналдардын кодуна эмес, түшүнүккө көңүл бурууга мүмкүндүк берген академиялык, изилдөө жана кесиптик долбоорлорго бир аз убакыт бөлүп, инкубациялайт.

Негизги артыкчылык:
- 🧮 орнотулган ** Статистика жана математика коммуналдык кызматтары *
- 📊 колдонууга оңой **
- 🗂 Handy ** Файлды иштетүү жана издөө
- 🔍 ** синтаксистик текшерүү ** Python файлдар үчүн
- 🌍 ** Көп тилди колдоо ** даярдалган котормолор менен
- 🚀 ** Оптималдаштырылган ** Fast Prototing ** жана ** Билим **

---

## ✨ Негизги өзгөчөлүктөр

### 📊 маалыматтарды визуализациялоо
- Бар диаграммалар: горизонталдуу жана вертикалдуу (`hbar`, `vbar`)  
- Таркатуу участоктору: ittograms (`histo`), куту участоктору (`boxplot`), KDE PLots (`kdeplot`)  
- Салыштырмалуу участоктор: скрипка, сузул, стрип участоктору  
- Корреляциялоо талдоосу: HOTMAPS (`heatmap`), бактырган участоктор (`scatter`)  
- Өркүндөтүлгөн визуалдашуу: жуп участоктор, биргелешкен участоктор, регрессиялык участоктор  
- Маалымат таблицалары: Форматталган таблица дисплейлер (`table`)  

### 📈 Статистикалык анализ
- ** Борбордук тенденция ** : Аңгеме (`get_media`), медиан (`get_median`), режим, режим (`get_moda`)  
- ** Dispersion ** : Range (`get_rank`), Dariance (`get_var`), стандарттык четтөө (`get_desv`)  
** ** Анализ **: Дисперсия отчеттору (`disp`), IQR эсептөөсү, нормалдаштыруу, шарттуу трансформалар  
- ** Outer Findection ** : IQR жана Z-упай упай ыкмалары  

### 🗂️ Файлды башкаруу
- Smart Discovery `call()` (auto-detect CSV, JSON, XML, etc.) менен  
- Көп форматтагы колдоо (CSV, JSON, XML, PDF, spatial data)  
- SQL маалымат базасын башкаруу `DataBase` классы менен  
- конвертациялоо кызматтары (`convert_file`)  

### 🛠️ иштеп чыгуучунун куралдары
- Switch тутуму (`Switch`, `AsyncSwitch`)  
- Синтаксис Текшерүү (`check_syntax`, `PythonFileChecker`)  
- RICH ERROR ОКУУ (multi-language)  
- интеграцияланган жардам тутуму (`help`)  

### 🌍 Internationalization
- 100+ камтылган котормо  
- Өзгөчөлөштүрүү үчүн жүктөм  
- Убакыттын тилине которулуу (`set_language() `)  
- Automatic English fallback  

---

## Dependencies (handled automatically):

- pandas, numpy (data manipulation)

- matplotlib, seaborn (visualization)

- scikit-learn (statistics)

- sqlalchemy (database)

- geopandas (spatial data)

---

## 🔧 Usage Examples

### Set language 

**support for up to 131 languages** 
```python
from helper import set_language

set_language("en")  # English
set_language("es")  # Spanish
set_language("fr")  # French
set_language("de")  # German
set_language("ru")  # Russian
set_language("tr")  # Turkish
set_language("zh")  # Chinese
set_language("it")  # Italian
set_language("pt")  # Portuguese
set_language("sv")  # Swedish
set_language("ja")  # Japanese
set_language("ar")  # Arabic
...
```


### Негизги статистика
```python
import helper as hp

data = [1, 2, 2, 3, 4, 5]

print(hp.get_media(data))   # Mean
print(hp.get_median(data))  # Median
print(hp.get_moda(data))    # Mode
```

### визуализация
```python
import helper as hp

df = hp.pd.DataFrame({"values": [5, 3, 7, 2, 9]})
hp.histo(df, "values", bins=5, title="Sample Histogram")
```

### файлды иштетүү
```python
from helper import call

data = call(name="my_data", type="csv")  # Finds and loads a CSV file automatically
```

### ЫСМР
```python
from helper import load_user_translations

# Load custom translations from lang.json
load_user_translations("custom/lang.json")
```

### синтаксистин текшерүү
```python
from helper import run

run("./path/to/my_script.py")
#Show gui pop up with results
```

---

## Долбоордун структурасы

```
helper/
├── core.py
├── __init__.py
├── lang/
│   ├── en.json
│   ├── es.json
│   └── ... (100+ files)
└── submodules/
    ├── graph.py
    ├── statics.py
    ├── utils.py
    ├── caller.py
    ├── checker.py
    ├── manager.py
    ├── pyswitch.py
    ├── shared.py
    └── DBManager.py
```

---

## 📜 π __6_

Бул долбоор ** MIT π_4 _ ** деп лицензияланган.  
Чоо-жайын билүү үчүн [LICENSE](LICENSE) файлын караңыз.

---

## 🔮 Жол картасы

- кошумча визуализация түрлөрү

- узартылган маалыматтар базасын колдоо (NoSQL, graph databases)

- Машинаны окутуу интеграциясы

- Веб негизиндеги интерфейс

- Плагин системасы

---

⚡ Сиздин Python Workflows менен ** pyhelper ** * менен иштөөңүзгө даярбы? Бүгүн чала башта!