# ಸಹಾಯಕ ಗ್ರಂಥಾಲಯ

[![License: MIT](https://img.shields.io/badge/License-MIT-yellow.svg)](LICENSE) [![PyPI](https://img.shields.io/pypi/v/pyhelper-tools-jbhm?style=for-the-badge&label=PyPI&color=blue)](https://pypi.org/project/pyhelper-tools-jbhm/)

## ಲಭ್ಯವಿರುವ ಭಾಷೆಗಳು

ಪೈಹೆಲ್ಪರ್ ** 131 ಭಾಷೆಗಳವರೆಗೆ ಅಂತರ್ನಿರ್ಮಿತ ಅನುವಾದಗಳನ್ನು ನೀಡುತ್ತದೆ ** :

.  
.  
.  
.  
.  
.  
.  
[![lo](https://img.shields.io/badge/lang-lo-purple.svg)](readme/README.lo.md) [![la](https://img.shields.io/badge/lang-la-orange.svg)](readme/README.la.md) [![lv](https://img.shields.io/badge/lang-lv-green.svg)](readme/README.lv.md) [![ln](https://img.shields.io/badge/lang-ln-blue.svg)](readme/README.ln.md) [![lt](https://img.shields.io/badge/lang-lt-red.svg)](readme/README.lt.md) [![lg](https://img.shields.io/badge/lang-lg-purple.svg)](readme/README.lg.md) [![lb](https://img.shields.io/badge/lang-lb-orange.svg)](readme/README.lb.md) [![mk](https://img.shields.io/badge/lang-mk-green.svg)](readme/README.mk.md) [![mai](https://img.shields.io/badge/lang-mai-blue.svg)](readme/README.mai.md) [![mg](https://img.shields.io/badge/lang-mg-red.svg)](readme/README.mg.md)  
.  
.  
.  
.  
[![xh](https://img.shields.io/badge/lang-xh-red.svg)](readme/README.xh.md) [![yi](https://img.shields.io/badge/lang-yi-purple.svg)](readme/README.yi.md) [![yo](https://img.shields.io/badge/lang-yo-orange.svg)](readme/README.yo.md) [![zu](https://img.shields.io/badge/lang-zu-green.svg)](readme/README.zu.md)

---


## ಸ್ಥಾಪನೆ

ಪೈಪಿಯಿಂದ ಸ್ಥಾಪಿಸಿ:

```bash
pip install pyhelper-tools-jbhm
```

---

## ಅವಲೋಕನ

;  
ಇದು ಶೈಕ್ಷಣಿಕ, ಸಂಶೋಧನೆ ಮತ್ತು ವೃತ್ತಿಪರ ಯೋಜನೆಗಳಲ್ಲಿ ಮನಬಂದಂತೆ ಸಂಯೋಜನೆಗೊಳ್ಳುತ್ತದೆ, ಇದು ಬಾಯ್ಲರ್ಪ್ಲೇಟ್ ಕೋಡ್ಗಿಂತ ಒಳನೋಟಗಳ ಮೇಲೆ ಕೇಂದ್ರೀಕರಿಸಲು ನಿಮಗೆ ಅನುವು ಮಾಡಿಕೊಡುತ್ತದೆ.

ಪ್ರಮುಖ ಅನುಕೂಲಗಳು:
- 🧮 ಅಂತರ್ನಿರ್ಮಿತ ** ಅಂಕಿಅಂಶಗಳು ಮತ್ತು ಗಣಿತ ಉಪಯುಕ್ತತೆಗಳು ** 
-📊 ಬಳಸಲು ಸುಲಭ ** ಡೇಟಾ ದೃಶ್ಯೀಕರಣ ಹೊದಿಕೆಗಳು ** 
- 🗂 ಹ್ಯಾಂಡಿ ** ಫೈಲ್ ನಿರ್ವಹಣೆ ಮತ್ತು ಹುಡುಕಾಟ ** 
- 🔍_40_ ಫೈಲ್‌ಗಳಿಗಾಗಿ ಸಿಂಟ್ಯಾಕ್ಸ್ ಮೌಲ್ಯಮಾಪನ **
-🌍 ** ಬಹು-ಭಾಷಾ ಬೆಂಬಲ ** ಬಳಸಲು ಸಿದ್ಧ ಅನುವಾದಗಳೊಂದಿಗೆ
-*** ವೇಗದ ಮೂಲಮಾದರಿಗಾಗಿ ಹೊಂದುವಂತೆ ** ಮತ್ತು ** ಶಿಕ್ಷಣ ** 

---

## ಪ್ರಮುಖ ವೈಶಿಷ್ಟ್ಯಗಳು

### ಡೇಟಾ ದೃಶ್ಯೀಕರಣ
- ಬಾರ್ ಚಾರ್ಟ್‌ಗಳು: ಸಮತಲ ಮತ್ತು ಲಂಬ (`hbar`, `vbar`)  
- ವಿತರಣಾ ಪ್ಲಾಟ್‌ಗಳು: ಹಿಸ್ಟೋಗ್ರಾಮ್‌ಗಳು (`histo`), ಬಾಕ್ಸ್ ಪ್ಲಾಟ್‌ಗಳು (`boxplot`), ಕೆಡಿಇ ಪ್ಲಾಟ್‌ಗಳು (`kdeplot`)  
- ತುಲನಾತ್ಮಕ ಪ್ಲಾಟ್‌ಗಳು: ಪಿಟೀಲು, ಸಮೂಹ, ಸ್ಟ್ರಿಪ್ ಪ್ಲಾಟ್‌ಗಳು  
- ಪರಸ್ಪರ ಸಂಬಂಧದ ವಿಶ್ಲೇಷಣೆ: ಹೀಟ್‌ಮ್ಯಾಪ್ಸ್ (`heatmap`), ಸ್ಕ್ಯಾಟರ್ ಪ್ಲಾಟ್‌ಗಳು (`scatter`)  
- ಸುಧಾರಿತ ದೃಶ್ಯೀಕರಣಗಳು: ಜೋಡಿ ಪ್ಲಾಟ್‌ಗಳು, ಜಂಟಿ ಪ್ಲಾಟ್‌ಗಳು, ಹಿಂಜರಿತ ಪ್ಲಾಟ್‌ಗಳು  
- ಡೇಟಾ ಕೋಷ್ಟಕಗಳು: ಫಾರ್ಮ್ಯಾಟ್ ಮಾಡಿದ ಟೇಬಲ್ ಪ್ರದರ್ಶನಗಳು (`table`)  

### 📈 ಸಂಖ್ಯಾಶಾಸ್ತ್ರೀಯ ವಿಶ್ಲೇಷಣೆ
- ** ಕೇಂದ್ರ ಪ್ರವೃತ್ತಿ ** : ಸರಾಸರಿ (`get_media`), ಸರಾಸರಿ (`get_median`), ಮೋಡ್ (`get_moda`)  
- ** ಪ್ರಸರಣ ** : ಶ್ರೇಣಿ (`get_rank`), ವ್ಯತ್ಯಾಸ (`get_var`), ಪ್ರಮಾಣಿತ ವಿಚಲನ (`get_desv`)  
- ** ವಿಶ್ಲೇಷಣೆ ** : ಪ್ರಸರಣ ವರದಿಗಳು (`disp`), ಐಕ್ಯೂಆರ್ ಲೆಕ್ಕಾಚಾರಗಳು, ಸಾಮಾನ್ಯೀಕರಣ, ಷರತ್ತುಬದ್ಧ ರೂಪಾಂತರಗಳು  
- ** ಹೊರಗಿನ ಪತ್ತೆ ** : ಐಕ್ಯೂಆರ್ ಮತ್ತು -ಡ್-ಸ್ಕೋರ್ ವಿಧಾನಗಳು  

### 🗂 ಫೈಲ್ ನಿರ್ವಹಣೆ
- `call()` (auto-detect CSV, JSON, XML, etc.) ನೊಂದಿಗೆ ಸ್ಮಾರ್ಟ್ ಆವಿಷ್ಕಾರ  
- ಬಹು-ಸ್ವರೂಪ ಬೆಂಬಲ (CSV, JSON, XML, PDF, spatial data)  
- `DataBase` ವರ್ಗದೊಂದಿಗೆ SQL ಡೇಟಾಬೇಸ್ ನಿರ್ವಹಣೆ  
- ಪರಿವರ್ತನೆ ಉಪಯುಕ್ತತೆಗಳು (`convert_file`)  

### 🛠 ಡೆವಲಪರ್ ಪರಿಕರಗಳು
- ಸ್ವಿಚ್ ಸಿಸ್ಟಮ್ (`Switch`, `AsyncSwitch`)  
- ಸಿಂಟ್ಯಾಕ್ಸ್ ಪರಿಶೀಲನೆ (`check_syntax`, `PythonFileChecker`)  
- ಶ್ರೀಮಂತ ದೋಷ ವರದಿ (multi-language)  
- ಸಂಯೋಜಿತ ಸಹಾಯ ವ್ಯವಸ್ಥೆ (`help`)  

### 🌍 ಅಂತರರಾಷ್ಟ್ರೀಕರಣ
- 100+ ಅಂತರ್ನಿರ್ಮಿತ ಅನುವಾದಗಳು  
- ಕಸ್ಟಮ್ ಅನುವಾದಗಳನ್ನು ಲೋಡ್ ಮಾಡಿ  
- ರನ್ಟೈಮ್ ಲಾಂಗ್ವೇಜ್ ಸ್ವಿಚಿಂಗ್ (`set_language() π__15_``14_ ``


### ಮೂಲ ಅಂಕಿಅಂಶಗಳು
```python
import helper as hp

data = [1, 2, 2, 3, 4, 5]

print(hp.get_media(data))   # Mean
print(hp.get_median(data))  # Median
print(hp.get_moda(data))    # Mode
```

### ದೃಶ್ಯೀಕರಣ
```python
import helper as hp

df = hp.pd.DataFrame({"values": [5, 3, 7, 2, 9]})
hp.histo(df, "values", bins=5, title="Sample Histogram")
```

### ಫೈಲ್ ಹ್ಯಾಂಡ್ಲಿಂಗ್
```python
from helper import call

data = call(name="my_data", type="csv")  # Finds and loads a CSV file automatically
```

### ಕಸ್ಟಮ್ ಅನುವಾದಗಳು
```python
from helper import load_user_translations

# Load custom translations from lang.json
load_user_translations("custom/lang.json")
```

### ಸಿಂಟ್ಯಾಕ್ಸ್ ಮೌಲ್ಯಮಾಪನ
```python
from helper import run

run("./path/to/my_script.py")
#Show gui pop up with results
```

---

## ಪ್ರಾಜೆಕ್ಟ್ ರಚನೆ

```
helper/
├── core.py
├── __init__.py
├── lang/
│   ├── en.json
│   ├── es.json
│   └── ... (100+ files)
└── submodules/
    ├── graph.py
    ├── statics.py
    ├── utils.py
    ├── caller.py
    ├── checker.py
    ├── manager.py
    ├── pyswitch.py
    ├── shared.py
    └── DBManager.py
```

---

## 📜 License

ಈ ಯೋಜನೆಗೆ ** MIT π_4 _ ** ಅಡಿಯಲ್ಲಿ ಪರವಾನಗಿ ಇದೆ.  
ವಿವರಗಳಿಗಾಗಿ [LICENSE](LICENSE) ಫೈಲ್ ನೋಡಿ.

---

## ರೋಡ್ಮ್ಯಾಪ್

- ಹೆಚ್ಚುವರಿ ದೃಶ್ಯೀಕರಣ ಪ್ರಕಾರಗಳು

- ವಿಸ್ತೃತ ಡೇಟಾಬೇಸ್ ಬೆಂಬಲ (NoSQL, graph databases)

- ಯಂತ್ರ ಕಲಿಕೆ ಏಕೀಕರಣ

- ವೆಬ್ ಆಧಾರಿತ ಇಂಟರ್ಫೇಸ್

- ಪ್ಲಗಿನ್ ವ್ಯವಸ್ಥೆ

---

Your ನಿಮ್ಮ Python ಕೆಲಸದ ಹರಿವುಗಳನ್ನು ** ಪೈಹೆಲ್ಪರ್ ** ನೊಂದಿಗೆ ಸೂಪರ್ಚಾರ್ಜ್ ಮಾಡಲು ಸಿದ್ಧರಿದ್ದೀರಾ? ಇಂದು ಅನ್ವೇಷಿಸಲು ಪ್ರಾರಂಭಿಸಿ!