# បណ្ណាល័យជំនួយ

[![License: MIT](https://img.shields.io/badge/License-MIT-yellow.svg)](LICENSE) [![PyPI](https://img.shields.io/pypi/v/pyhelper-tools-jbhm?style=for-the-badge&label=PyPI&color=blue)](https://pypi.org/project/pyhelper-tools-jbhm/)

## 🌍ភាសាដែលមាន

Pyhelper ផ្តល់ជូនការបកប្រែដែលភ្ជាប់មកជាមួយសម្រាប់រហូតដល់ ** 131 ភាសា ** រួមមាន:

[![en](https://img.shields.io/badge/lang-en-red.svg)](readme/README.md) [![es](https://img.shields.io/badge/lang-es-yellow.svg)](readme/README.es.md) [![fr](https://img.shields.io/badge/lang-fr-blue.svg)](readme/README.fr.md) [![de](https://img.shields.io/badge/lang-de-green.svg)](readme/README.de.md) [![ru](https://img.shields.io/badge/lang-ru-purple.svg)](readme/README.ru.md) [![tr](https://img.shields.io/badge/lang-tr-orange.svg)](readme/README.tr.md) [![zh](https://img.shields.io/badge/lang-zh-black.svg)](readme/README.zh.md) [![it](https://img.shields.io/badge/lang-it-lightgrey.svg)](readme/README.it.md) [![pt](https://img.shields.io/badge/lang-pt-brightgreen.svg)](readme/README.pt.md) [![pt](https://img.shields.io/badge/lang-pt-brightgreen.svg)](readme/README.pt.md) [![sv](https://img.shields.io/badge/lang-sv-blue.svg)](readme/README.sv.md)  
[![ja](https://img.shields.io/badge/lang-ja-red.svg)](readme/README.ja.md) [![ar](https://img.shields.io/badge/lang-ar-brown.svg)](readme/README.ar.md) [![sq](https://img.shields.io/badge/lang-sq-blue.svg)](readme/README.sq.md) [![sq](https://img.shields.io/badge/lang-sq-blue.svg)](readme/README.sq.md) [![hy](https://img.shields.io/badge/lang-hy-red.svg)](readme/README.hy.md) [![hy](https://img.shields.io/badge/lang-hy-red.svg)](readme/README.hy.md) [![as](https://img.shields.io/badge/lang-as-purple.svg)](readme/README.as.md) [![ay](https://img.shields.io/badge/lang-ay-brown.svg)](readme/README.ay.md) [![az](https://img.shields.io/badge/lang-az-lightblue.svg)](readme/README.az.md) [![az](https://img.shields.io/badge/lang-az-lightblue.svg)](readme/README.az.md) [![bm](https://img.shields.io/badge/lang-bm-darkgreen.svg)](readme/README.bm.md)  
[![eu](https://img.shields.io/badge/lang-eu-pink.svg)](readme/README.eu.md) [![be](https://img.shields.io/badge/lang-be-darkblue.svg)](readme/README.be.md) [![bn](https://img.shields.io/badge/lang-bn-teal.svg)](readme/README.bn.md) [![bho](https://img.shields.io/badge/lang-bho-orange.svg)](readme/README.bho.md) [![bs](https://img.shields.io/badge/lang-bs-purple.svg)](readme/README.bm.md) [![bg](https://img.shields.io/badge/lang-bg-green.svg)](readme/README.bg.md) [![ca](https://img.shields.io/badge/lang-ca-yellow.svg)](readme/README.ca.md) [![ceb](https://img.shields.io/badge/lang-ceb-blue.svg)](readme/README.ceb.md) [![ny](https://img.shields.io/badge/lang-ny-red.svg)](readme/README.ny.md) [![ny](https://img.shields.io/badge/lang-ny-red.svg)](readme/README.ny.md) [![ny](https://img.shields.io/badge/lang-ny-red.svg)](readme/README.ny.md)  
[![hr](https://img.shields.io/badge/lang-hr-blue.svg)](readme/README.hr.md) [![cs](https://img.shields.io/badge/lang-cs-red.svg)](readme/README.cs.md) [![da](https://img.shields.io/badge/lang-da-purple.svg)](readme/README.da.md) [![dv](https://img.shields.io/badge/lang-dv-orange.svg)](readme/README.dv.md) [![doi](https://img.shields.io/badge/lang-doi-brown.svg)](readme/README.doi.md) [![nl](https://img.shields.io/badge/lang-nl-orange.svg)](readme/README.nl.md) [![eo](https://img.shields.io/badge/lang-eo-green.svg)](readme/README.eo.md) [![et](https://img.shields.io/badge/lang-et-blue.svg)](readme/README.et.md) [![ee](https://img.shields.io/badge/lang-ee-red.svg)](readme/README.ee.md) [![ee](https://img.shields.io/badge/lang-ee-red.svg)](readme/README.ee.md) [![tl](https://img.shields.io/badge/lang-tl-purple.svg)](readme/README.tl.md)  
[![fi](https://img.shields.io/badge/lang-fi-blue.svg)](readme/README.fi.md) [![fy](https://img.shields.io/badge/lang-fy-orange.svg)](readme/README.fy.md) [![gl](https://img.shields.io/badge/lang-gl-green.svg)](readme/README.gl.md) [![ka](https://img.shields.io/badge/lang-ka-red.svg)](readme/README.ka.md) [![el](https://img.shields.io/badge/lang-el-blue.svg)](readme/README.el.md) [![gn](https://img.shields.io/badge/lang-gn-purple.svg)](readme/README.gn.md) [![gu](https://img.shields.io/badge/lang-gu-orange.svg)](readme/README.gu.md) [![ht](https://img.shields.io/badge/lang-ht-green.svg)](readme/README.ht.md) [![ha](https://img.shields.io/badge/lang-ha-blue.svg)](readme/README.ha.md) [![ha](https://img.shields.io/badge/lang-ha-blue.svg)](readme/README.ha.md) [![haw](https://img.shields.io/badge/lang-haw-red.svg)](readme/README.haw.md)  
[![iw](https://img.shields.io/badge/lang-iw-purple.svg)](readme/README.iw.md) [![hi](https://img.shields.io/badge/lang-hi-orange.svg)](readme/README.hi.md) [![hu](https://img.shields.io/badge/lang-hu-blue.svg)](readme/README.hu.md) [![is](https://img.shields.io/badge/lang-is-red.svg)](readme/README.is.md) [![ig](https://img.shields.io/badge/lang-ig-purple.svg)](readme/README.ig.md) [![ilo](https://img.shields.io/badge/lang-ilo-orange.svg)](readme/README.ilo.md) [![id](https://img.shields.io/badge/lang-id-green.svg)](readme/README.id.md) [![id](https://img.shields.io/badge/lang-id-green.svg)](readme/README.id.md) [![ga](https://img.shields.io/badge/lang-ga-blue.svg)](readme/README.ga.md) [![ga](https://img.shields.io/badge/lang-ga-blue.svg)](readme/README.ga.md) [![jw](https://img.shields.io/badge/lang-jw-red.svg)](readme/README.jw.md)  
[![ckb](https://img.shields.io/badge/lang-ckb-blue.svg)](readme/README.ckb.md) [![ckb](https://img.shields.io/badge/lang-ckb-blue.svg)](readme/README.ckb.md) [![ckb](https://img.shields.io/badge/lang-ckb-blue.svg)](readme/README.ckb.md) [![ckb](https://img.shields.io/badge/lang-ckb-blue.svg)](readme/README.ckb.md) [![ky](https://img.shields.io/badge/lang-ky-red.svg)](readme/README.ky.md) [![ky](https://img.shields.io/badge/lang-ky-red.svg)](readme/README.ky.md) [![ky](https://img.shields.io/badge/lang-ky-red.svg)](readme/README.ky.md)  
[![lo](https://img.shields.io/badge/lang-lo-purple.svg)](readme/README.lo.md) [![la](https://img.shields.io/badge/lang-la-orange.svg)](readme/README.la.md) [![lv](https://img.shields.io/badge/lang-lv-green.svg)](readme/README.lv.md) [![ln](https://img.shields.io/badge/lang-ln-blue.svg)](readme/README.ln.md) [![ln](https://img.shields.io/badge/lang-ln-blue.svg)](readme/README.ln.md) [![lg](https://img.shields.io/badge/lang-lg-purple.svg)](readme/README.lg.md) [![lb](https://img.shields.io/badge/lang-lb-orange.svg)](readme/README.lb.md) [![lb](https://img.shields.io/badge/lang-lb-orange.svg)](readme/README.lb.md) [![mk](https://img.shields.io/badge/lang-mk-green.svg)](readme/README.mk.md) [![mai](https://img.shields.io/badge/lang-mai-blue.svg)](readme/README.mai.md) [![mai](https://img.shields.io/badge/lang-mai-blue.svg)](readme/README.mai.md) [![mg](https://img.shields.io/badge/lang-mg-red.svg)](readme/README.mg.md)  
[![ms](https://img.shields.io/badge/lang-ms-purple.svg)](readme/README.ms.md) [![ml](https://img.shields.io/badge/lang-ml-orange.svg)](readme/README.ml.md) [![mt](https://img.shields.io/badge/lang-mt-green.svg)](readme/README.mt.md) [![mi](https://img.shields.io/badge/lang-mi-blue.svg)](readme/README.mi.md) [![lus](https://img.shields.io/badge/lang-lus-purple.svg)](readme/README.lus.md) [![mn](https://img.shields.io/badge/lang-mn-orange.svg)](readme/README.mn.md) [![mn](https://img.shields.io/badge/lang-mn-orange.svg)](readme/README.mn.md) [![my](https://img.shields.io/badge/lang-my-green.svg)](readme/README.my.md) [![ne](https://img.shields.io/badge/lang-ne-blue.svg)](readme/README.ne.md) [![no](https://img.shields.io/badge/lang-no-red.svg)](readme/README.no.md) [![no](https://img.shields.io/badge/lang-no-red.svg)](readme/README.no.md) [![or](https://img.shields.io/badge/lang-or-purple.svg)](readme/README.or.md)  
[![om](https://img.shields.io/badge/lang-om-orange.svg)](readme/README.om.md) [![ps](https://img.shields.io/badge/lang-ps-green.svg)](readme/README.ps.md) [![fa](https://img.shields.io/badge/lang-fa-blue.svg)](readme/README.fa.md) [![qu](https://img.shields.io/badge/lang-qu-red.svg)](readme/README.qu.md) [![ro](https://img.shields.io/badge/lang-ro-purple.svg)](readme/README.ro.md) [![sm](https://img.shields.io/badge/lang-sm-orange.svg)](readme/README.sm.md) [![sa](https://img.shields.io/badge/lang-sa-green.svg)](readme/README.sa.md) [![gd](https://img.shields.io/badge/lang-gd-blue.svg)](readme/README.gd.md) [![gd](https://img.shields.io/badge/lang-gd-blue.svg)](readme/README.gd.md) [![nso](https://img.shields.io/badge/lang-nso-red.svg)](readme/README.nso.md) [![st](https://img.shields.io/badge/lang-st-purple.svg)](readme/README.st.md) [![st](https://img.shields.io/badge/lang-st-purple.svg)](readme/README.st.md) [![sn](https://img.shields.io/badge/lang-sn-orange.svg)](readme/README.sn.md)  
[![sd](https://img.shields.io/badge/lang-sd-green.svg)](readme/README.sd.md) [![si](https://img.shields.io/badge/lang-si-blue.svg)](readme/README.si.md) [![sk](https://img.shields.io/badge/lang-sk-red.svg)](readme/README.sk.md) [![sl](https://img.shields.io/badge/lang-sl-purple.svg)](readme/README.sl.md) [![so](https://img.shields.io/badge/lang-so-orange.svg)](readme/README.so.md) [![so](https://img.shields.io/badge/lang-so-orange.svg)](readme/README.so.md) [![sw](https://img.shields.io/badge/lang-sw-blue.svg)](readme/README.sw.md) [![sw](https://img.shields.io/badge/lang-sw-blue.svg)](readme/README.sw.md) [![tg](https://img.shields.io/badge/lang-tg-red.svg)](readme/README.tg.md) [![ta](https://img.shields.io/badge/lang-ta-purple.svg)](readme/README.ta.md) [![ug](https://img.shields.io/badge/lang-ug-purple.svg)](readme/README.ug.md) [![tt](https://img.shields.io/badge/lang-tt-orange.svg)](readme/README.tt.md) [![tt](https://img.shields.io/badge/lang-tt-orange.svg)](readme/README.tt.md) [![te](https://img.shields.io/badge/lang-te-green.svg)](readme/README.te.md)  
[![th](https://img.shields.io/badge/lang-th-blue.svg)](readme/README.th.md) [![ti](https://img.shields.io/badge/lang-ti-red.svg)](readme/README.ti.md) [![ts](https://img.shields.io/badge/lang-ts-purple.svg)](readme/README.ts.md) [![tk](https://img.shields.io/badge/lang-tk-orange.svg)](readme/README.tk.md) [![uk](https://img.shields.io/badge/lang-uk-blue.svg)](readme/README.uk.md) [![uk](https://img.shields.io/badge/lang-uk-blue.svg)](readme/README.uk.md) [![ur](https://img.shields.io/badge/lang-ur-red.svg)](readme/README.ur.md) [![ur](https://img.shields.io/badge/lang-ur-red.svg)](readme/README.ur.md) [![ur](https://img.shields.io/badge/lang-ur-red.svg)](readme/README.ur.md) [![uz](https://img.shields.io/badge/lang-uz-orange.svg)](readme/README.uz.md) [![vi](https://img.shields.io/badge/lang-vi-green.svg)](readme/README.vi.md) [![vi](https://img.shields.io/badge/lang-vi-green.svg)](readme/README.vi.md) [![cy](https://img.shields.io/badge/lang-cy-blue.svg)](readme/README.cy.md)  
[![xh](https://img.shields.io/badge/lang-xh-red.svg)](readme/README.xh.md) [![yi](https://img.shields.io/badge/lang-yi-purple.svg)](readme/README.yi.md) [![yo](https://img.shields.io/badge/lang-yo-orange.svg)](readme/README.yo.md) [![zu](https://img.shields.io/badge/lang-zu-green.svg)](readme/README.zu.md)

---


## 🚀ការតំឡើង

ដំឡើងពី PYPI:

π _42_

---

## 📖ទិដ្ឋភាពទូទៅ

** pyhelper ** គឺជាឧបករណ៍ដែលអាចបត់បែនបានPythonរចនាឡើងដើម្បីងាយស្រួល ** ការវិភាគទិន្នន័យការមើលឃើញជាក់ស្តែងប្រតិបត្តិការស្ថិតិនិងលំហូរការងាររបស់ឧបករណ៍ប្រើប្រាស់ ** ។  
វាធ្វើសមាហរណកម្មយ៉ាងរលូនទៅក្នុងគម្រោងសិក្សាស្រាវជ្រាវនិងគម្រោងវិជ្ជាជីវៈដែលអនុញ្ញាតឱ្យអ្នកផ្តោតលើការយល់ដឹងជាជាងលេខកូដទឹកកក។

គុណសម្បត្តិសំខាន់ៗ:
- in ឧបករណ៍ប្រើប្រាស់និងឧបករណ៍គណិតវិទ្យាដែលភ្ជាប់មកជាមួយ
- 📊ងាយស្រួលប្រើ ** ការមើលឃើញទិន្នន័យ ** 
- 🗂ងាយស្រួលគ្រប់គ្រងនិងស្វែងរកឯកសារ **
- 🔍 ** វាក្យសម្ពន្ធសុពលភាព ** សម្រាប់Pythonឯកសារ
- 🌍 ** ការគាំទ្រពហុភាសា ** ជាមួយការបកប្រែដែលត្រៀមរួចជាស្រេច
- 🚀បានធ្វើឱ្យប្រសើរសម្រាប់ ** គំរូដើមរហ័ស ** និង ** ការអប់រំ ** 

---

## ✨លក្ខណៈសំខាន់ៗសំខាន់ៗ

### 📊ការមើលឃើញទិន្នន័យ
- គំនូសតាងរបារ: ផ្ដេកនិងបញ្ឈរ(`hbar`, `vbar`)  
- ដីឡូត៍ចែកចាយ: អ៊ីស្តូក្រាម(`histo`), ប្រអប់ប្រអប់(`boxplot`), ដីឡូតិ៍ KDE (`kdeplot`)  
- ដីឡូតិ៍ប្រៀបធៀប: វីយូឡុង, swarm, ដីឡូត៍  
- ការវិភាគទំនាក់ទំនង: កំដៅផែនទី(`heatmap`)គ្រោងកំចាត់កំបួត(`scatter`)  
- ការមើលឃើញកម្រិតខ្ពស់: ដីឡូត៍ឡូត៍ចម្រុះដីឡូត៍ការតំរែតំរង់  
- តារាងទិន្នន័យ: ការបង្ហាញតារាងដែលមានសំណុំបែបបទ(`table`)  

### 📈ការវិភាគស្ថិតិស្ថិតិ
- ** ទំនោរកណ្តាល ** : មធ្យម(`get_media`), Median (`get_median`), របៀប(`get_moda`)  
- ** ការបែកខ្ចាត់ខ្ចាយ ** : ជួរ(`get_rank`), Veriance (`get_var`), គម្លាតគំរូ(`get_desv`)  
- ** ការវិភាគ ** : របាយការណ៍បញ្ចប់(`disp`), ការគណនា IQR, ការធ្វើឱ្យធម្មតា, ការផ្លាស់ប្តូរលក្ខខណ្ឌ  
- ** ការរកឃើញលើស ** : វិធីសាស្រ្ត izr និង Z-Secations  

### 🗂️ការគ្រប់គ្រងឯកសារ
- ឆ្លាតវៃជាមួយ`call()` (auto-detect CSV, JSON, XML, etc.)  
- ការគាំទ្រពហុទ្រង់ទ្រាយ(CSV, JSON, XML, PDF, spatial data)  
- ការគ្រប់គ្រងមូលដ្ឋានទិន្នន័យ SQL ជាមួយថ្នាក់`DataBase`  
- ឧបករណ៍ប្រើប្រាស់បំលែង(`convert_file`)  

### 🛠️ឧបករណ៍អភិវឌ្ឍន៍
- ប្តូរប្រព័ន្ធ(`Switch`, `AsyncSwitch`)  
- ការត្រួតពិនិត្យវាក្យសម្ព័ន្ធ(`check_syntax`, `PythonFileChecker`)  
- របាយការណ៍កំហុសដ៏សំបូរបែប(multi-language)  
- ប្រព័ន្ធជំនួយចម្រុះ(`help`)  

### 🌍អន្តរជាតិ
- ការបកប្រែដែលមានស្រាប់ 100+  
- ផ្ទុកការបកប្រែផ្ទាល់ខ្លួន  
- ភាសាពេលរត់ប្តូរ(`set_language() `)  
- Automatic English fallback  

---

## Dependencies (handled automatically):

- pandas, numpy (data manipulation)

- matplotlib, seaborn (visualization)

- scikit-learn (statistics)

- sqlalchemy (database)

- geopandas (spatial data)

---

## 🔧 Usage Examples

### Set language 

**support for up to 131 languages** 
`14__14_


### ស្ថិតិមូលដ្ឋាន
```python
import helper as hp

data = [1, 2, 2, 3, 4, 5]

print(hp.get_media(data))   # Mean
print(hp.get_median(data))  # Median
print(hp.get_moda(data))    # Mode
```

### ការមើលឃើញ
```python
import helper as hp

df = hp.pd.DataFrame({"values": [5, 3, 7, 2, 9]})
hp.histo(df, "values", bins=5, title="Sample Histogram")
```

ការដោះស្រាយឯកសារ ###
π10_10_

### ការបកប្រែផ្ទាល់ខ្លួន
```python
from helper import load_user_translations

# Load custom translations from lang.json
load_user_translations("custom/lang.json")
```

### វាក្យសម្ព័ន្ធសុពលភាព
```python
from helper import run

run("./path/to/my_script.py")
#Show gui pop up with results
```8_

---

## structure រចនាសម្ព័ន្ធគម្រោង

```
helper/
├── core.py
├── __init__.py
├── lang/
│   ├── en.json
│   ├── es.json
│   └── ... (100+ files)
└── submodules/
    ├── graph.py
    ├── statics.py
    ├── utils.py
    ├── caller.py
    ├── checker.py
    ├── manager.py
    ├── pyswitch.py
    ├── shared.py
    └── DBManager.py
```

---

## 📜License

គម្រោងនេះត្រូវបានផ្តល់សិទ្ធិក្រោម ** MIT π_4 _ ** ។  
សូមមើលឯកសារ[LICENSE](LICENSE)3_សម្រាប់ព័ត៌មានលម្អិត។

---

## 🔮ផែនទីបង្ហាញផ្លូវ

- ប្រភេទដែលមើលឃើញបន្ថែម

- ការគាំទ្រមូលដ្ឋានទិន្នន័យបន្ថែម(NoSQL, graph databases)

- ការបញ្ចូលសេវាកម្មរៀនម៉ាស៊ីន

- ចំណុចប្រទាក់គេហទំព័រ

- ប្រព័ន្ធកម្មវិធីជំនួយ

---

⚡ត្រៀមខ្លួនជាស្រេចក្នុងការគិតថ្លៃសេវាការងាររបស់អ្នកជាមួយ ** Pyhelper ** **? ចាប់ផ្តើមស្វែងយល់នៅថ្ងៃនេះ!