સહાયક ગ્રંથાલય

[![License: MIT](https://img.shields.io/badge/License-MIT-yellow.svg)](LICENSE) [![PyPI](https://img.shields.io/pypi/v/pyhelper-tools-jbhm?style=for-the-badge&label=PyPI&color=blue)](https://pypi.org/project/pyhelper-tools-jbhm/)

## 🌍 ઉપલબ્ધ ભાષાઓ

પિહેલ્પર ** 131 ભાષાઓ સુધીના બિલ્ટ-ઇન અનુવાદો આપે છે ** સહિત:

.  
.  
.  
.  
.  
.  
.  
.  
.  
[![om](https://img.shields.io/badge/lang-om-orange.svg)](readme/README.om.md) [![ps](https://img.shields.io/badge/lang-ps-green.svg)](readme/README.ps.md) [![fa](https://img.shields.io/badge/lang-fa-blue.svg)](readme/README.fa.md) [![qu](https://img.shields.io/badge/lang-qu-red.svg)](readme/README.qu.md) [![ro](https://img.shields.io/badge/lang-ro-purple.svg)](readme/README.ro.md) [![sm](https://img.shields.io/badge/lang-sm-orange.svg)](readme/README.sm.md) [![sa](https://img.shields.io/badge/lang-sa-green.svg)](readme/README.sa.md) [![gd](https://img.shields.io/badge/lang-gd-blue.svg)](readme/README.gd.md) [![nso](https://img.shields.io/badge/lang-nso-red.svg)](readme/README.nso.md) [![st](https://img.shields.io/badge/lang-st-purple.svg)](readme/README.st.md) [![sn](https://img.shields.io/badge/lang-sn-orange.svg)](readme/README.sn.md)  
.  
[![th](https://img.shields.io/badge/lang-th-blue.svg)](readme/README.th.md) [![ti](https://img.shields.io/badge/lang-ti-red.svg)](readme/README.ti.md) [![ts](https://img.shields.io/badge/lang-ts-purple.svg)](readme/README.ts.md) [![tk](https://img.shields.io/badge/lang-tk-orange.svg)](readme/README.tk.md) [![ak](https://img.shields.io/badge/lang-ak-green.svg)](readme/README.ak.md) [![uk](https://img.shields.io/badge/lang-uk-blue.svg)](readme/README.uk.md) [![ur](https://img.shields.io/badge/lang-ur-red.svg)](readme/README.ur.md) [![ug](https://img.shields.io/badge/lang-ug-purple.svg)](readme/README.ug.md) [![uz](https://img.shields.io/badge/lang-uz-orange.svg)](readme/README.uz.md) [![vi](https://img.shields.io/badge/lang-vi-green.svg)](readme/README.vi.md) [![cy](https://img.shields.io/badge/lang-cy-blue.svg)](readme/README.cy.md)  
[![xh](https://img.shields.io/badge/lang-xh-red.svg)](readme/README.xh.md) [![yi](https://img.shields.io/badge/lang-yi-purple.svg)](readme/README.yi.md) [![yo](https://img.shields.io/badge/lang-yo-orange.svg)](readme/README.yo.md) [![zu](https://img.shields.io/badge/lang-zu-green.svg)](readme/README.zu.md)

---


## 🚀 સ્થાપન

PYPI માંથી ઇન્સ્ટોલ કરો:

```bash
pip install pyhelper-tools-jbhm
```

---

## vide વિહંગાવલોકન

** પાયહેલ્પર ** એક બહુમુખી Python ટૂલકિટ છે ** ડેટા વિશ્લેષણ, વિઝ્યુલાઇઝેશન, આંકડાકીય કામગીરી અને ઉપયોગિતા વર્કફ્લો ** સરળ બનાવવા માટે રચાયેલ છે.  
તે એકીકૃત શૈક્ષણિક, સંશોધન અને વ્યાવસાયિક પ્રોજેક્ટ્સમાં એકીકૃત કરે છે, જે તમને બોઈલરપ્લેટ કોડને બદલે આંતરદૃષ્ટિ પર ધ્યાન કેન્દ્રિત કરવાની મંજૂરી આપે છે.

કી ફાયદા:
- 🧮 બિલ્ટ-ઇન ** આંકડા અને ગણિત ઉપયોગિતાઓ ** 
-📊 ઉપયોગમાં સરળ ** ડેટા વિઝ્યુલાઇઝેશન રેપર્સ ** 
- 🗂 હેન્ડી ** ફાઇલ હેન્ડલિંગ અને શોધ ** 
- 🔍 ** સિન્ટેક્સ માન્યતા ** Python ફાઇલો માટે
-🌍 ** મલ્ટિ-લેંગ્વેજ સપોર્ટ ** તૈયાર અનુવાદો સાથે
-*** ઝડપી પ્રોટોટાઇપિંગ ** અને ** શિક્ષણ ** માટે optim પ્ટિમાઇઝ

---

## ✨ કી સુવિધાઓ

### 📊 ડેટા વિઝ્યુલાઇઝેશન
- બાર ચાર્ટ્સ: આડા અને vert ભી (`hbar`, `vbar`)  
- વિતરણ પ્લોટ્સ: હિસ્ટોગ્રામ્સ (`histo`), બ plots ક્સ પ્લોટ્સ (`boxplot`), કેડીઇ પ્લોટ્સ (`kdeplot`)  
- તુલનાત્મક પ્લોટ્સ: વાયોલિન, સ્વોર્મ, સ્ટ્રીપ પ્લોટ  
- સહસંબંધ વિશ્લેષણ: હીટમેપ્સ (`heatmap`), સ્કેટર પ્લોટ્સ (`scatter`)  
- અદ્યતન વિઝ્યુલાઇઝેશન: જોડી પ્લોટ, સંયુક્ત પ્લોટ, રીગ્રેસન પ્લોટ  
- ડેટા કોષ્ટકો: ફોર્મેટ કોષ્ટક (`table`)  

### 📈 આંકડાકીય વિશ્લેષણ
- ** કેન્દ્રિય વૃત્તિ ** : મીન (`get_media`), સરેરાશ (`get_median`), મોડ (`get_moda`)  
- ** વિખેરી ** : શ્રેણી (`get_rank`), ભિન્નતા (`get_var`), માનક વિચલન (`get_desv`)  
- ** વિશ્લેષણ ** : વિખેરી નાખવાના અહેવાલો (`disp`), આઇક્યુઆર ગણતરીઓ, સામાન્યકરણ, શરતી પરિવર્તન  
- ** આઉટલેટર ડિટેક્શન ** : આઇક્યુઆર અને ઝેડ-સ્કોર પદ્ધતિઓ  

### 🗂 ફાઇલ મેનેજમેન્ટ
- `call()` (auto-detect CSV, JSON, XML, etc.) સાથે સ્માર્ટ શોધ  
- મલ્ટિ-ફોર્મેટ સપોર્ટ (CSV, JSON, XML, PDF, spatial data)  
- `DataBase` વર્ગ સાથે એસક્યુએલ ડેટાબેઝ મેનેજમેન્ટ  
- રૂપાંતર ઉપયોગિતાઓ (`convert_file`)  

### 🛠 વિકાસકર્તા સાધનો
- સ્વિચ સિસ્ટમ (`Switch`, `AsyncSwitch`)  
- સિન્ટેક્સ ચેકિંગ (`check_syntax`, `PythonFileChecker`)  
- સમૃદ્ધ ભૂલ રિપોર્ટિંગ (multi-language)  
- એકીકૃત સહાય સિસ્ટમ (`help`)  

### 🌍 આંતરરાષ્ટ્રીયકરણ
- 100+ બિલ્ટ-ઇન અનુવાદો  
- કસ્ટમ અનુવાદો લોડ કરો  
- રનટાઇમ ભાષા સ્વિચિંગ (`set_language() `)  
- Automatic English fallback  

---

## Dependencies (handled automatically):

- pandas, numpy (data manipulation)

- matplotlib, seaborn (visualization)

- scikit-learn (statistics)

- sqlalchemy (database)

- geopandas (spatial data)

---

## 🔧 Usage Examples

### Set language 

**support for up to 131 languages** 
```python
from helper import set_language

set_language("en")  # English
set_language("es")  # Spanish
set_language("fr")  # French
set_language("de")  # German
set_language("ru")  # Russian
set_language("tr")  # Turkish
set_language("zh")  # Chinese
set_language("it")  # Italian
set_language("pt")  # Portuguese
set_language("sv")  # Swedish
set_language("ja")  # Japanese
set_language("ar")  # Arabic
...
```


### મૂળભૂત આંકડા
```python
import helper as hp

data = [1, 2, 2, 3, 4, 5]

print(hp.get_media(data))   # Mean
print(hp.get_median(data))  # Median
print(hp.get_moda(data))    # Mode
```

### વિઝ્યુલાઇઝેશન
```python
import helper as hp

df = hp.pd.DataFrame({"values": [5, 3, 7, 2, 9]})
hp.histo(df, "values", bins=5, title="Sample Histogram")
```

### ફાઇલ હેન્ડલિંગ
```python
from helper import call

data = call(name="my_data", type="csv")  # Finds and loads a CSV file automatically
```

### કસ્ટમ અનુવાદો
```python
from helper import load_user_translations

# Load custom translations from lang.json
load_user_translations("custom/lang.json")
```

### સિન્ટેક્સ માન્યતા
```python
from helper import run

run("./path/to/my_script.py")
#Show gui pop up with results
```

---

## 📂 પ્રોજેક્ટ સ્ટ્રક્ચર

```
helper/
├── core.py
├── __init__.py
├── lang/
│   ├── en.json
│   ├── es.json
│   └── ... (100+ files)
└── submodules/
    ├── graph.py
    ├── statics.py
    ├── utils.py
    ├── caller.py
    ├── checker.py
    ├── manager.py
    ├── pyswitch.py
    ├── shared.py
    └── DBManager.py
```

---

## 📜 License

આ પ્રોજેક્ટ ** MIT π_4 _ ** હેઠળ લાઇસન્સ છે.  
વિગતો માટે [LICENSE](LICENSE) ફાઇલ જુઓ.

---

## 🔮 રોડમેપ

- વધારાના વિઝ્યુલાઇઝેશન પ્રકારો

- વિસ્તૃત ડેટાબેઝ સપોર્ટ (NoSQL, graph databases)

- મશીન લર્નિંગ એકીકરણ

- વેબ-આધારિત ઇન્ટરફેસ

- પ્લગઇન સિસ્ટમ

---

*** પીહેલ્પર ** સાથે તમારા Python વર્કફ્લોને સુપરચાર્જ કરવા માટે તૈયાર છો? આજની અન્વેષણ શરૂ કરો!