# Helperbibleteek

[![License: MIT](https://img.shields.io/badge/License-MIT-yellow.svg)](LICENSE) [![PyPI](https://img.shields.io/pypi/v/pyhelper-tools-jbhm?style=for-the-badge&label=PyPI&color=blue)](https://pypi.org/project/pyhelper-tools-jbhm/)

## 🌍 Beskikbere talen

Pyhelper biedt ynboude oersettingen foar maksimaal ** 131 talen ** ynklusyf:

[![en](https://img.shields.io/badge/lang-en-red.svg)](readme/README.md) [![es](https://img.shields.io/badge/lang-es-yellow.svg)](readme/README.es.md) [![fr](https://img.shields.io/badge/lang-fr-blue.svg)](readme/README.fr.md) [![de](https://img.shields.io/badge/lang-de-green.svg)](readme/README.de.md) [![ru](https://img.shields.io/badge/lang-ru-purple.svg)](readme/README.ru.md) [![tr](https://img.shields.io/badge/lang-tr-orange.svg)](readme/README.tr.md) [![zh](https://img.shields.io/badge/lang-zh-black.svg)](readme/README.zh.md) [![it](https://img.shields.io/badge/lang-it-lightgrey.svg)](readme/README.it.md) [![pt](https://img.shields.io/badge/lang-pt-brightgreen.svg)](readme/README.pt.md) [![sv](https://img.shields.io/badge/lang-sv-blue.svg)](readme/README.sv.md)  
[![ja](https://img.shields.io/badge/lang-ja-red.svg)](readme/README.ja.md) [![ar](https://img.shields.io/badge/lang-ar-brown.svg)](readme/README.ar.md) [![af](https://img.shields.io/badge/lang-af-orange.svg)](readme/README.af.md) [![sq](https://img.shields.io/badge/lang-sq-blue.svg)](readme/README.sq.md) [![am](https://img.shields.io/badge/lang-am-green.svg)](readme/README.am.md) [![as](https://img.shields.io/badge/lang-as-purple.svg)](readme/README.as.md) [![as](https://img.shields.io/badge/lang-as-purple.svg)](readme/README.as.md) [![ay](https://img.shields.io/badge/lang-ay-brown.svg)](readme/README.ay.md) [![az](https://img.shields.io/badge/lang-az-lightblue.svg)](readme/README.az.md) [![bm](https://img.shields.io/badge/lang-bm-darkgreen.svg)](readme/README.bm.md)  
[![eu](https://img.shields.io/badge/lang-eu-pink.svg)](readme/README.eu.md) [![be](https://img.shields.io/badge/lang-be-darkblue.svg)](readme/README.be.md) [![bn](https://img.shields.io/badge/lang-bn-teal.svg)](readme/README.bn.md) [![bho](https://img.shields.io/badge/lang-bho-orange.svg)](readme/README.bho.md) [![bs](https://img.shields.io/badge/lang-bs-purple.svg)](readme/README.bm.md) [![ca](https://img.shields.io/badge/lang-ca-yellow.svg)](readme/README.ca.md) [![ceb](https://img.shields.io/badge/lang-ceb-blue.svg)](readme/README.ceb.md) [![ceb](https://img.shields.io/badge/lang-ceb-blue.svg)](readme/README.ceb.md) [![ny](https://img.shields.io/badge/lang-ny-red.svg)](readme/README.ny.md) [![co](https://img.shields.io/badge/lang-co-green.svg)](readme/README.co.md)  
[![hr](https://img.shields.io/badge/lang-hr-blue.svg)](readme/README.hr.md) [![cs](https://img.shields.io/badge/lang-cs-red.svg)](readme/README.cs.md) [![da](https://img.shields.io/badge/lang-da-purple.svg)](readme/README.da.md) [![dv](https://img.shields.io/badge/lang-dv-orange.svg)](readme/README.dv.md) [![doi](https://img.shields.io/badge/lang-doi-brown.svg)](readme/README.doi.md) [![nl](https://img.shields.io/badge/lang-nl-orange.svg)](readme/README.nl.md) [![eo](https://img.shields.io/badge/lang-eo-green.svg)](readme/README.eo.md) [![et](https://img.shields.io/badge/lang-et-blue.svg)](readme/README.et.md) [![ee](https://img.shields.io/badge/lang-ee-red.svg)](readme/README.ee.md) [![tl](https://img.shields.io/badge/lang-tl-purple.svg)](readme/README.tl.md)  
[![fi](https://img.shields.io/badge/lang-fi-blue.svg)](readme/README.fi.md)  
[![iw](https://img.shields.io/badge/lang-iw-purple.svg)](readme/README.iw.md) [![hmn](https://img.shields.io/badge/lang-hmn-green.svg)](readme/README.hmn.md) [![hu](https://img.shields.io/badge/lang-hu-blue.svg)](readme/README.hu.md) [![hu](https://img.shields.io/badge/lang-hu-blue.svg)](readme/README.hu.md) [![ilo](https://img.shields.io/badge/lang-ilo-orange.svg)](readme/README.ilo.md) [![ilo](https://img.shields.io/badge/lang-ilo-orange.svg)](readme/README.ilo.md) [![id](https://img.shields.io/badge/lang-id-green.svg)](readme/README.id.md) [![ga](https://img.shields.io/badge/lang-ga-blue.svg)](readme/README.ga.md) [![jw](https://img.shields.io/badge/lang-jw-red.svg)](readme/README.jw.md)  
[![kn](https://img.shields.io/badge/lang-kn-purple.svg)](readme/README.kn.md) [![kk](https://img.shields.io/badge/lang-kk-orange.svg)](readme/README.kk.md) [![rw](https://img.shields.io/badge/lang-rw-blue.svg)](readme/README.rw.md) [![rw](https://img.shields.io/badge/lang-rw-blue.svg)](readme/README.rw.md) [![gom](https://img.shields.io/badge/lang-gom-red.svg)](readme/README.gom.md) [![ko](https://img.shields.io/badge/lang-ko-purple.svg)](readme/README.ko.md) [![kri](https://img.shields.io/badge/lang-kri-orange.svg)](readme/README.kri.md) [![ku](https://img.shields.io/badge/lang-ku-green.svg)](readme/README.ku.md) [![ckb](https://img.shields.io/badge/lang-ckb-blue.svg)](readme/README.ckb.md) [![ky](https://img.shields.io/badge/lang-ky-red.svg)](readme/README.ky.md)  
[![lo](https://img.shields.io/badge/lang-lo-purple.svg)](readme/README.lo.md) [![la](https://img.shields.io/badge/lang-la-orange.svg)](readme/README.la.md) [![lv](https://img.shields.io/badge/lang-lv-green.svg)](readme/README.lv.md) [![ln](https://img.shields.io/badge/lang-ln-blue.svg)](readme/README.ln.md) [![lt](https://img.shields.io/badge/lang-lt-red.svg)](readme/README.lt.md) [![lg](https://img.shields.io/badge/lang-lg-purple.svg)](readme/README.lg.md) π_954_ [![mk](https://img.shields.io/badge/lang-mk-green.svg)](readme/README.mk.md) [![mk](https://img.shields.io/badge/lang-mk-green.svg)](readme/README.mk.md) [![mai](https://img.shields.io/badge/lang-mai-blue.svg)](readme/README.mai.md) [![mg](https://img.shields.io/badge/lang-mg-red.svg)](readme/README.mg.md)  
[![ms](https://img.shields.io/badge/lang-ms-purple.svg)](readme/README.ms.md) [![mt](https://img.shields.io/badge/lang-mt-green.svg)](readme/README.mt.md) [![mt](https://img.shields.io/badge/lang-mt-green.svg)](readme/README.mt.md) [![mr](https://img.shields.io/badge/lang-mr-red.svg)](readme/README.mr.md) [![mr](https://img.shields.io/badge/lang-mr-red.svg)](readme/README.mr.md) [![mn](https://img.shields.io/badge/lang-mn-orange.svg)](readme/README.mn.md) [![mn](https://img.shields.io/badge/lang-mn-orange.svg)](readme/README.mn.md) [![ne](https://img.shields.io/badge/lang-ne-blue.svg)](readme/README.ne.md) [![ne](https://img.shields.io/badge/lang-ne-blue.svg)](readme/README.ne.md) [![no](https://img.shields.io/badge/lang-no-red.svg)](readme/README.no.md) [![or](https://img.shields.io/badge/lang-or-purple.svg)](readme/README.or.md)  
[![om](https://img.shields.io/badge/lang-om-orange.svg)](readme/README.om.md) [![ps](https://img.shields.io/badge/lang-ps-green.svg)](readme/README.ps.md) [![fa](https://img.shields.io/badge/lang-fa-blue.svg)](readme/README.fa.md) TR_76_ [![ro](https://img.shields.io/badge/lang-ro-purple.svg)](readme/README.ro.md) [![sa](https://img.shields.io/badge/lang-sa-green.svg)](readme/README.sa.md) [![sa](https://img.shields.io/badge/lang-sa-green.svg)](readme/README.sa.md) [![nso](https://img.shields.io/badge/lang-nso-red.svg)](readme/README.nso.md) [![nso](https://img.shields.io/badge/lang-nso-red.svg)](readme/README.nso.md) [![st](https://img.shields.io/badge/lang-st-purple.svg)](readme/README.st.md) [![sn](https://img.shields.io/badge/lang-sn-orange.svg)](readme/README.sn.md)  
[![sd](https://img.shields.io/badge/lang-sd-green.svg)](readme/README.sd.md) [![si](https://img.shields.io/badge/lang-si-blue.svg)](readme/README.si.md) [![sk](https://img.shields.io/badge/lang-sk-red.svg)](readme/README.sk.md) [![sl](https://img.shields.io/badge/lang-sl-purple.svg)](readme/README.sl.md) [![so](https://img.shields.io/badge/lang-so-orange.svg)](readme/README.so.md) [![sw](https://img.shields.io/badge/lang-sw-blue.svg)](readme/README.sw.md) [![sw](https://img.shields.io/badge/lang-sw-blue.svg)](readme/README.sw.md) [![ta](https://img.shields.io/badge/lang-ta-purple.svg)](readme/README.ta.md) [![ta](https://img.shields.io/badge/lang-ta-purple.svg)](readme/README.ta.md) [![tt](https://img.shields.io/badge/lang-tt-orange.svg)](readme/README.tt.md) [![te](https://img.shields.io/badge/lang-te-green.svg)](readme/README.te.md)  
[![th](https://img.shields.io/badge/lang-th-blue.svg)](readme/README.th.md) [![ti](https://img.shields.io/badge/lang-ti-red.svg)](readme/README.ti.md) [![ts](https://img.shields.io/badge/lang-ts-purple.svg)](readme/README.ts.md) [![ak](https://img.shields.io/badge/lang-ak-green.svg)](readme/README.ak.md) [![ak](https://img.shields.io/badge/lang-ak-green.svg)](readme/README.ak.md) [![uk](https://img.shields.io/badge/lang-uk-blue.svg)](readme/README.uk.md) [![ur](https://img.shields.io/badge/lang-ur-red.svg)](readme/README.ur.md) [![ur](https://img.shields.io/badge/lang-ur-red.svg)](readme/README.ur.md) [![ug](https://img.shields.io/badge/lang-ug-purple.svg)](readme/README.ug.md) [![vi](https://img.shields.io/badge/lang-vi-green.svg)](readme/README.vi.md) [![vi](https://img.shields.io/badge/lang-vi-green.svg)](readme/README.vi.md) [![vi](https://img.shields.io/badge/lang-vi-green.svg)](readme/README.vi.md) [![cy](https://img.shields.io/badge/lang-cy-blue.svg)](readme/README.cy.md)  
[![xh](https://img.shields.io/badge/lang-xh-red.svg)](readme/README.xh.md) [![yi](https://img.shields.io/badge/lang-yi-purple.svg)](readme/README.yi.md) [![yo](https://img.shields.io/badge/lang-yo-orange.svg)](readme/README.yo.md) [![zu](https://img.shields.io/badge/lang-zu-green.svg)](readme/README.zu.md)

---


## 🚀 Ynstallaasje

Ynstallearje út Pypi:

```bash
pip install pyhelper-tools-jbhm
```

---

## 📖 oersÃ

** Pyhelper ** is in alsidy Python Toolkit ûntworpen om ** Gegevensanalyse, fisualisaasje, statistyske operaasjes en utility-workflows te ferienfâldigjen ** .  
It yntegreart naadloos yn akademysk, ûndersyk, en profesjonele projekten, wêrtroch jo moatte konsintrearje op ynsjoch, ynstee fan ynsjoch.

Kaai foardielen:
- 🧮 Boud-in ** statistiken en wiskundeprogramma's ** 
- 📊 Easy-to-GEBRUK ** Gegevens fisualisaasjeprappers ** 
- 🗂 Handy ** Bestân ôfhanneling en sykje ** 
- 🔍 ** Syntaks Validaasje ** Foar Python-bestannen
- 🌍 ** Multi-taal-stipe ** mei read-to-gebrûk-oersettingen
- 🚀 Optimalisearre foar ** snelle prototyping ** en ** Underwiis ** 

---

## ✨ Key Funksjes

### 📊 gegevens visualisaasje
- Bar Charts: Horizontaal & Vertical (`hbar`, `vbar`)  
- Distribúsjeplots: histogrammen (`histo`), box plots (`boxplot`), KDE plots (`kdeplot`)  
- Fergelikingsplots: fioele, swerm, stripplots  
- Korrelaasjeanalyse: Heatmaps (`heatmap`), scrotter plots (`scatter`)  
- Avansearre Visualisaasjes: Pair-plots, mienskiplike plots, regression plots  
- gegevens tabellen: Formatted Tabel-byldskermen (`table`)  

### 📈 statistyske analyse
- ** Sintrale oanstriid ** : gemiddelde (`get_media`), mediaan (`get_median`), mode fan modus (`get_moda`)  
- ** Fertil ** : RAGE (`get_rank`), fAILIANCE (`get_var`), Standertviation (`get_desv`)  
- ** Analyse ** : Ferpassingsrapporten (`disp`), IQR-berekkeningen, normalisaasje, betingsten, betingsten transformaasjes  
- ** Outlier Detrection ** : IQR- en Z-skoare metoaden  

### 🗂️ File Management
- Smart Discovery With `call()` (auto-detect CSV, JSON, XML, etc.)  
- Multi-format Support (CSV, JSON, XML, PDF, spatial data)  
- SQL-database behear mei `DataBase` klasse  
- Conversion Utilities (`convert_file`)  

### 🛠️ Untwikkelder ark
- Skeakelje systeem (`Switch`, `AsyncSwitch`)  
- Syntaksij kontrolearje (`check_syntax`, `PythonFileChecker`)  
- Rike flaterrapportaazje (multi-language)  
- Yntegreare helpsteem (`help`)  

### 🌍 Internationalisaasje
- 100+ ynboude oersettingen  
- Oanpaste oersettingen laden  
- Runtime Taalwikseling (`set_language() `)  
- Automatic English fallback  

---

## Dependencies (handled automatically):

- pandas, numpy (data manipulation)

- matplotlib, seaborn (visualization)

- scikit-learn (statistics)

- sqlalchemy (database)

- geopandas (spatial data)

---

## 🔧 Usage Examples

### Set language 

**support for up to 131 languages** 
```python
from helper import set_language

set_language("en")  # English
set_language("es")  # Spanish
set_language("fr")  # French
set_language("de")  # German
set_language("ru")  # Russian
set_language("tr")  # Turkish
set_language("zh")  # Chinese
set_language("it")  # Italian
set_language("pt")  # Portuguese
set_language("sv")  # Swedish
set_language("ja")  # Japanese
set_language("ar")  # Arabic
...
```


### Basisstatistiken
```python
import helper as hp

data = [1, 2, 2, 3, 4, 5]

print(hp.get_media(data))   # Mean
print(hp.get_median(data))  # Median
print(hp.get_moda(data))    # Mode
```

### Visualisaasje
```python
import helper as hp

df = hp.pd.DataFrame({"values": [5, 3, 7, 2, 9]})
hp.histo(df, "values", bins=5, title="Sample Histogram")
```

### Bestânbehanneling
```python
from helper import call

data = call(name="my_data", type="csv")  # Finds and loads a CSV file automatically
```

### Oanpaste oersettings
```python
from helper import load_user_translations

# Load custom translations from lang.json
load_user_translations("custom/lang.json")
```

### Syntaksisjouwing
```python
from helper import run

run("./path/to/my_script.py")
#Show gui pop up with results
```

---

## 📂 Projektstruktuer

```
helper/
├── core.py
├── __init__.py
├── lang/
│   ├── en.json
│   ├── es.json
│   └── ... (100+ files)
└── submodules/
    ├── graph.py
    ├── statics.py
    ├── utils.py
    ├── caller.py
    ├── checker.py
    ├── manager.py
    ├── pyswitch.py
    ├── shared.py
    └── DBManager.py
```

---

## 📜 License

Dit projekt is fergunning ûnder de ** MIT π_4 _ ** .  
Sjoch it [LICENSE](LICENSE)-bestân foar details.

---

## 🔮 Roadmap

- ekstra visualisaasjetypen

- Utwreide database-stipe (NoSQL, graph databases)

- Masine Learning-yntegraasje

- Web-basearre ynterface

- Pluginesysteem

---

⚡ ree om jo Python workflows te super te meitsjen mei ** pyhelper ** ? Begjin hjoed te ferkennen!