# Βιβλιοθήκη βοηθού

π.172_ [![PyPI](https://img.shields.io/pypi/v/pyhelper-tools-jbhm?style=for-the-badge&label=PyPI&color=blue)](https://pypi.org/project/pyhelper-tools-jbhm/)

## 🌍 διαθέσιμες γλώσσες

Το Pyhelper προσφέρει ενσωματωμένες μεταφράσεις για μέχρι ** 131 γλώσσες ** συμπεριλαμβανομένων:

π.170_ [![es](https://img.shields.io/badge/lang-es-yellow.svg)](readme/README.es.md) [![fr](https://img.shields.io/badge/lang-fr-blue.svg)](readme/README.fr.md) [![de](https://img.shields.io/badge/lang-de-green.svg)](readme/README.de.md) [![ru](https://img.shields.io/badge/lang-ru-purple.svg)](readme/README.ru.md) [![tr](https://img.shields.io/badge/lang-tr-orange.svg)](readme/README.tr.md) [![zh](https://img.shields.io/badge/lang-zh-black.svg)](readme/README.zh.md) π  
π.160_ [![ar](https://img.shields.io/badge/lang-ar-brown.svg)](readme/README.ar.md) [![af](https://img.shields.io/badge/lang-af-orange.svg)](readme/README.af.md) [![sq](https://img.shields.io/badge/lang-sq-blue.svg)](readme/README.sq.md) [![am](https://img.shields.io/badge/lang-am-green.svg)](readme/README.am.md) [![hy](https://img.shields.io/badge/lang-hy-red.svg)](readme/README.hy.md) [![as](https://img.shields.io/badge/lang-as-purple.svg)](readme/README.as.md) π  
π.150_ [![be](https://img.shields.io/badge/lang-be-darkblue.svg)](readme/README.be.md) [![bn](https://img.shields.io/badge/lang-bn-teal.svg)](readme/README.bn.md) [![bho](https://img.shields.io/badge/lang-bho-orange.svg)](readme/README.bho.md) [![bs](https://img.shields.io/badge/lang-bs-purple.svg)](readme/README.bm.md) [![bg](https://img.shields.io/badge/lang-bg-green.svg)](readme/README.bg.md) [![ca](https://img.shields.io/badge/lang-ca-yellow.svg)](readme/README.ca.md) π  
π.140_ [![cs](https://img.shields.io/badge/lang-cs-red.svg)](readme/README.cs.md) [![da](https://img.shields.io/badge/lang-da-purple.svg)](readme/README.da.md) [![dv](https://img.shields.io/badge/lang-dv-orange.svg)](readme/README.dv.md) [![doi](https://img.shields.io/badge/lang-doi-brown.svg)](readme/README.doi.md) [![nl](https://img.shields.io/badge/lang-nl-orange.svg)](readme/README.nl.md) [![eo](https://img.shields.io/badge/lang-eo-green.svg)](readme/README.eo.md) π  
π.130_ [![fy](https://img.shields.io/badge/lang-fy-orange.svg)](readme/README.fy.md) [![gl](https://img.shields.io/badge/lang-gl-green.svg)](readme/README.gl.md) [![ka](https://img.shields.io/badge/lang-ka-red.svg)](readme/README.ka.md) [![el](https://img.shields.io/badge/lang-el-blue.svg)](readme/README.el.md) [![gn](https://img.shields.io/badge/lang-gn-purple.svg)](readme/README.gn.md) [![gu](https://img.shields.io/badge/lang-gu-orange.svg)](readme/README.gu.md) π  
π.120_ ​​[![hi](https://img.shields.io/badge/lang-hi-orange.svg)](readme/README.hi.md) [![hmn](https://img.shields.io/badge/lang-hmn-green.svg)](readme/README.hmn.md) [![hu](https://img.shields.io/badge/lang-hu-blue.svg)](readme/README.hu.md) [![is](https://img.shields.io/badge/lang-is-red.svg)](readme/README.is.md) [![ig](https://img.shields.io/badge/lang-ig-purple.svg)](readme/README.ig.md) [![ilo](https://img.shields.io/badge/lang-ilo-orange.svg)](readme/README.ilo.md) π  
π.110_ [![kk](https://img.shields.io/badge/lang-kk-orange.svg)](readme/README.kk.md) [![km](https://img.shields.io/badge/lang-km-green.svg)](readme/README.km.md) [![rw](https://img.shields.io/badge/lang-rw-blue.svg)](readme/README.rw.md) [![gom](https://img.shields.io/badge/lang-gom-red.svg)](readme/README.gom.md) [![ko](https://img.shields.io/badge/lang-ko-purple.svg)](readme/README.ko.md) [![kri](https://img.shields.io/badge/lang-kri-orange.svg)](readme/README.kri.md) π  
π.100_ [![la](https://img.shields.io/badge/lang-la-orange.svg)](readme/README.la.md) [![lv](https://img.shields.io/badge/lang-lv-green.svg)](readme/README.lv.md) [![ln](https://img.shields.io/badge/lang-ln-blue.svg)](readme/README.ln.md) [![lt](https://img.shields.io/badge/lang-lt-red.svg)](readme/README.lt.md) [![lg](https://img.shields.io/badge/lang-lg-purple.svg)](readme/README.lg.md) [![lb](https://img.shields.io/badge/lang-lb-orange.svg)](readme/README.lb.md) [![mk](https://img.shields.io/badge/lang-mk-green.svg)](readme/README.mk.md) [![mai](https://img.shields.io/badge/lang-mai-blue.svg)](readme/README.mai.md) [![mg](https://img.shields.io/badge/lang-mg-red.svg)](readme/README.mg.md)  
π.90_ [![ml](https://img.shields.io/badge/lang-ml-orange.svg)](readme/README.ml.md) [![mt](https://img.shields.io/badge/lang-mt-green.svg)](readme/README.mt.md) [![mi](https://img.shields.io/badge/lang-mi-blue.svg)](readme/README.mi.md) [![mr](https://img.shields.io/badge/lang-mr-red.svg)](readme/README.mr.md) [![lus](https://img.shields.io/badge/lang-lus-purple.svg)](readme/README.lus.md) [![mn](https://img.shields.io/badge/lang-mn-orange.svg)](readme/README.mn.md) [![my](https://img.shields.io/badge/lang-my-green.svg)](readme/README.my.md) π  
π.79_ [![ps](https://img.shields.io/badge/lang-ps-green.svg)](readme/README.ps.md) [![fa](https://img.shields.io/badge/lang-fa-blue.svg)](readme/README.fa.md) [![qu](https://img.shields.io/badge/lang-qu-red.svg)](readme/README.qu.md) [![ro](https://img.shields.io/badge/lang-ro-purple.svg)](readme/README.ro.md) [![sm](https://img.shields.io/badge/lang-sm-orange.svg)](readme/README.sm.md) [![sa](https://img.shields.io/badge/lang-sa-green.svg)](readme/README.sa.md) [![gd](https://img.shields.io/badge/lang-gd-blue.svg)](readme/README.gd.md) [![nso](https://img.shields.io/badge/lang-nso-red.svg)](readme/README.nso.md) π  
π.68_ [![si](https://img.shields.io/badge/lang-si-blue.svg)](readme/README.si.md) [![sk](https://img.shields.io/badge/lang-sk-red.svg)](readme/README.sk.md) [![sl](https://img.shields.io/badge/lang-sl-purple.svg)](readme/README.sl.md) [![so](https://img.shields.io/badge/lang-so-orange.svg)](readme/README.so.md) [![su](https://img.shields.io/badge/lang-su-green.svg)](readme/README.su.md) [![sw](https://img.shields.io/badge/lang-sw-blue.svg)](readme/README.sw.md) π  
π.57_ [![ti](https://img.shields.io/badge/lang-ti-red.svg)](readme/README.ti.md) [![ts](https://img.shields.io/badge/lang-ts-purple.svg)](readme/README.ts.md) [![tk](https://img.shields.io/badge/lang-tk-orange.svg)](readme/README.tk.md) [![ak](https://img.shields.io/badge/lang-ak-green.svg)](readme/README.ak.md) [![uk](https://img.shields.io/badge/lang-uk-blue.svg)](readme/README.uk.md) [![ur](https://img.shields.io/badge/lang-ur-red.svg)](readme/README.ur.md) [![ug](https://img.shields.io/badge/lang-ug-purple.svg)](readme/README.ug.md) [![uz](https://img.shields.io/badge/lang-uz-orange.svg)](readme/README.uz.md) π  
π.46_ [![yi](https://img.shields.io/badge/lang-yi-purple.svg)](readme/README.yi.md) [![yo](https://img.shields.io/badge/lang-yo-orange.svg)](readme/README.yo.md) [![zu](https://img.shields.io/badge/lang-zu-green.svg)](readme/README.zu.md)

---


## 🚀 Εγκατάσταση

Εγκαταστήστε από το PYPI:

```bash
pip install pyhelper-tools-jbhm
```

---

## 📖 Επισκόπηση

** Το Pyhelper ** είναι ένα ευπροσάρμοστο Π_41_ Toolkit που έχει σχεδιαστεί για να απλοποιήσει την ανάλυση δεδομένων, την απεικόνιση, τις στατιστικές λειτουργίες και τις ροές εργασιών χρησιμότητας **.  
Ενσωματώνεται απρόσκοπτα σε ακαδημαϊκά, ερευνητικά και επαγγελματικά έργα, επιτρέποντάς σας να επικεντρωθείτε στις πληροφορίες και όχι στον κώδικα boilerplate.

Βασικά πλεονεκτήματα:
- 🧮 ενσωματωμένα ** Στατιστικά και μαθηματικά βοηθητικά προγράμματα ** 
-📊 Εύκολη στη χρήση ** Περιφράξεις απεικόνισης δεδομένων ** 
- 🗂 Handy ** Χειρισμός αρχείων και αναζήτηση ** 
- 🔍 ** Επικύρωση σύνταξης ** για τα αρχεία Python
-🌍 ** Υποστήριξη πολλαπλών γλωσσών ** με μεταφράσεις έτοιμου προς χρήση
- 🚀 Βελτιστοποιημένο για ** Fast Prototyping ** και ** Εκπαίδευση ** 

---

## ✨ Βασικές λειτουργίες

### 📊 Οπτικοποίηση δεδομένων
- Χάρτες μπαρ: οριζόντια & κατακόρυφη (`hbar`, `vbar`)  
- Διαγράμματα διανομής: Ιστογραμμάρια (`histo`), Πλοιαστές π.37_, KDE Οικόπεδα (`kdeplot`)  
- Συγκριτικά οικόπεδα: βιολί, σμήνος, οικόπεδα  
- Ανάλυση συσχέτισης: Heatmaps (`heatmap`), Σχέδια διασποράς (`scatter`)  
- Προηγμένες απεικονίσεις: ζευγάρια, οικόπεδα αρθρώσεων, οικόπεδα παλινδρόμησης  
- Πίνακες δεδομένων: ο πίνακας με μορφοποίηση εμφανίζει (`table`)  

### 📈 Στατιστική ανάλυση
- ** Κεντρική τάση ** : μέσος π.32_, διάμεσος (`get_median`), λειτουργία (`get_moda`)  
- ** Διασπορά ** : Εύρος (`get_rank`), διακύμανση (`get_var`), τυπική απόκλιση (`get_desv`)  
- ** Ανάλυση ** : Αναφορές διασποράς (`disp`), υπολογισμοί IQR, ομαλοποίηση, μετασχηματισμοί υπό όρους  
- ** Ανίχνευση εξωτερικού ** : μεθόδους IQR και Z-Score  

### 🗂ότητες Διαχείριση αρχείων
- Έξυπνη ανακάλυψη με `call()` (auto-detect CSV, JSON, XML, etc.)  
- Υποστήριξη πολλαπλών μορφών (CSV, JSON, XML, PDF, spatial data)  
- Διαχείριση βάσεων δεδομένων SQL με π.χ.22_  
- Υπηρεσίες μετατροπής (`convert_file`)  

Εργαλεία προγραμματιστή ## 🛠️
- Σύστημα διακόπτη (`Switch`, `AsyncSwitch`)  
- Έλεγχος σύνταξης (`check_syntax`, `PythonFileChecker`)  
- Πλούσια αναφορά σφάλματος (multi-language)  
- Ολοκληρωμένο σύστημα βοήθειας (`help`)  

### 🌍 Διεθνοποίηση
- 100+ ενσωματωμένες μεταφράσεις  
- Φορτώστε προσαρμοσμένες μεταφράσεις  
- Μεταγωγή γλώσσας χρόνου εκτέλεσης (`set_language() `)  
- Automatic English fallback  

---

## Dependencies (handled automatically):

- pandas, numpy (data manipulation)

- matplotlib, seaborn (visualization)

- scikit-learn (statistics)

- sqlalchemy (database)

- geopandas (spatial data)

---

## 🔧 Usage Examples

### Set language 

**support for up to 131 languages** 
```python
from helper import set_language

set_language("en")  # English
set_language("es")  # Spanish
set_language("fr")  # French
set_language("de")  # German
set_language("ru")  # Russian
set_language("tr")  # Turkish
set_language("zh")  # Chinese
set_language("it")  # Italian
set_language("pt")  # Portuguese
set_language("sv")  # Swedish
set_language("ja")  # Japanese
set_language("ar")  # Arabic
...
```


### βασικά στατιστικά στοιχεία
```python
import helper as hp

data = [1, 2, 2, 3, 4, 5]

print(hp.get_media(data))   # Mean
print(hp.get_median(data))  # Median
print(hp.get_moda(data))    # Mode
```

### Οπτικοποίηση
```python
import helper as hp

df = hp.pd.DataFrame({"values": [5, 3, 7, 2, 9]})
hp.histo(df, "values", bins=5, title="Sample Histogram")
```

### χειρισμός αρχείων
```python
from helper import call

data = call(name="my_data", type="csv")  # Finds and loads a CSV file automatically
```

### Προσαρμοσμένες μεταφράσεις
```python
from helper import load_user_translations

# Load custom translations from lang.json
load_user_translations("custom/lang.json")
```

### Επικύρωση σύνταξης
```python
from helper import run

run("./path/to/my_script.py")
#Show gui pop up with results
```

---

## 📂 Δομή έργου

```
helper/
├── core.py
├── __init__.py
├── lang/
│   ├── en.json
│   ├── es.json
│   └── ... (100+ files)
└── submodules/
    ├── graph.py
    ├── statics.py
    ├── utils.py
    ├── caller.py
    ├── checker.py
    ├── manager.py
    ├── pyswitch.py
    ├── shared.py
    └── DBManager.py
```

---

## 📜 License

Το έργο αυτό έχει άδεια χρήσης στο ** MIT π_4 _ ** .  
Ανατρέξτε στο αρχείο [LICENSE](LICENSE) για λεπτομέρειες.

---

## 🔮 οδικός χάρτης

- Πρόσθετοι τύποι απεικόνισης

- Υποστήριξη εκτεταμένης βάσης δεδομένων (NoSQL, graph databases)

- Ενσωμάτωση μηχανικής μάθησης

- Διεπαφή βασισμένη στο διαδίκτυο

- Σύστημα plugin

---

⚡ έτοιμη να υπερφορτώσει τις ροές εργασίας σας π.1_ με ** pyhelper ** ; Ξεκινήστε να εξερευνήσετε σήμερα!