# Helper Library

[![License: MIT](https://img.shields.io/badge/License-MIT-yellow.svg)](LICENSE) [![PyPI](https://img.shields.io/pypi/v/pyhelper-tools-jbhm?style=for-the-badge&label=PyPI&color=blue)](https://pypi.org/project/pyhelper-tools-jbhm/)

# # Adunay magamit nga mga sinultian

Gitanyag ni Pyhelper ang mga gitukod nga mga hubad alang sa hangtod sa ** 131 nga mga sinultian ** lakip ang:

[![en](https://img.shields.io/badge/lang-en-red.svg)](readme/README.md) [![es](https://img.shields.io/badge/lang-es-yellow.svg)](readme/README.es.md) [![fr](https://img.shields.io/badge/lang-fr-blue.svg)](readme/README.fr.md) [![de](https://img.shields.io/badge/lang-de-green.svg)](readme/README.de.md) [![it](https://img.shields.io/badge/lang-it-lightgrey.svg)](readme/README.it.md) π_162. π_162.  
[![ja](https://img.shields.io/badge/lang-ja-red.svg)](readme/README.ja.md) [![ar](https://img.shields.io/badge/lang-ar-brown.svg)](readme/README.ar.md) [![af](https://img.shields.io/badge/lang-af-orange.svg)](readme/README.af.md) [![am](https://img.shields.io/badge/lang-am-green.svg)](readme/README.am.md) [![az](https://img.shields.io/badge/lang-az-lightblue.svg)](readme/README.az.md)151_ π_152.152.152  
[![eu](https://img.shields.io/badge/lang-eu-pink.svg)](readme/README.eu.md) [![be](https://img.shields.io/badge/lang-be-darkblue.svg)](readme/README.be.md) [![bn](https://img.shields.io/badge/lang-bn-teal.svg)](readme/README.bn.md) [![bg](https://img.shields.io/badge/lang-bg-green.svg)](readme/README.bg.md) [![ny](https://img.shields.io/badge/lang-ny-red.svg)](readme/README.ny.md) [![ny](https://img.shields.io/badge/lang-ny-red.svg)](readme/README.ny.md) [![ny](https://img.shields.io/badge/lang-ny-red.svg)](readme/README.ny.md) [![ny](https://img.shields.io/badge/lang-ny-red.svg)](readme/README.ny.md)  
[![hr](https://img.shields.io/badge/lang-hr-blue.svg)](readme/README.hr.md) [![cs](https://img.shields.io/badge/lang-cs-red.svg)](readme/README.cs.md) [![da](https://img.shields.io/badge/lang-da-purple.svg)](readme/README.da.md) [![dv](https://img.shields.io/badge/lang-dv-orange.svg)](readme/README.dv.md) [![ee](https://img.shields.io/badge/lang-ee-red.svg)](readme/README.ee.md) [![ee](https://img.shields.io/badge/lang-ee-red.svg)](readme/README.ee.md) [![ee](https://img.shields.io/badge/lang-ee-red.svg)](readme/README.ee.md) [![ee](https://img.shields.io/badge/lang-ee-red.svg)](readme/README.ee.md) π_13  
[![fi](https://img.shields.io/badge/lang-fi-blue.svg)](readme/README.fi.md) [![fy](https://img.shields.io/badge/lang-fy-orange.svg)](readme/README.fy.md) [![gl](https://img.shields.io/badge/lang-gl-green.svg)](readme/README.gl.md) [![gn](https://img.shields.io/badge/lang-gn-purple.svg)](readme/README.gn.md) [![ha](https://img.shields.io/badge/lang-ha-blue.svg)](readme/README.ha.md) [![ha](https://img.shields.io/badge/lang-ha-blue.svg)](readme/README.ha.md) [![ha](https://img.shields.io/badge/lang-ha-blue.svg)](readme/README.ha.md) [![ha](https://img.shields.io/badge/lang-ha-blue.svg)](readme/README.ha.md)  
[![iw](https://img.shields.io/badge/lang-iw-purple.svg)](readme/README.iw.md)  [![hi](https://img.shields.io/badge/lang-hi-orange.svg)](readme/README.hi.md)  [![hmn](https://img.shields.io/badge/lang-hmn-green.svg)](readme/README.hmn.md)  [![hu](https://img.shields.io/badge/lang-hu-blue.svg)](readme/README.hu.md)  [![is](https://img.shields.io/badge/lang-is-red.svg)](readme/README.is.md)  [![ig](https://img.shields.io/badge/lang-ig-purple.svg)](readme/README.ig.md)  [![ilo](https://img.shields.io/badge/lang-ilo-orange.svg)](readme/README.ilo.md)  [![id](https://img.shields.io/badge/lang-id-green.svg)](readme/README.id.md)  [![ga](https://img.shields.io/badge/lang-ga-blue.svg)](readme/README.ga.md)  [![jw](https://img.shields.io/badge/lang-jw-red.svg)](readme/README.jw.md)  
[![kn](https://img.shields.io/badge/lang-kn-purple.svg)](readme/README.kn.md) [![kk](https://img.shields.io/badge/lang-kk-orange.svg)](readme/README.kk.md) [![km](https://img.shields.io/badge/lang-km-green.svg)](readme/README.km.md) [![rw](https://img.shields.io/badge/lang-rw-blue.svg)](readme/README.rw.md) [![ckb](https://img.shields.io/badge/lang-ckb-blue.svg)](readme/README.ckb.md) [![ckb](https://img.shields.io/badge/lang-ckb-blue.svg)](readme/README.ckb.md) [![ckb](https://img.shields.io/badge/lang-ckb-blue.svg)](readme/README.ckb.md) [![ckb](https://img.shields.io/badge/lang-ckb-blue.svg)](readme/README.ckb.md) [![ckb](https://img.shields.io/badge/lang-ckb-blue.svg)](readme/README.ckb.md) [![ckb](https://img.shields.io/badge/lang-ckb-blue.svg)](readme/README.ckb.md) [![ckb](https://img.shields.io/badge/lang-ckb-blue.svg)](readme/README.ckb.md) π_102.  
[![lo](https://img.shields.io/badge/lang-lo-purple.svg)](readme/README.lo.md) [![la](https://img.shields.io/badge/lang-la-orange.svg)](readme/README.la.md) [![lv](https://img.shields.io/badge/lang-lv-green.svg)](readme/README.lv.md) [![ln](https://img.shields.io/badge/lang-ln-blue.svg)](readme/README.ln.md) [![mai](https://img.shields.io/badge/lang-mai-blue.svg)](readme/README.mai.md) [![mai](https://img.shields.io/badge/lang-mai-blue.svg)](readme/README.mai.md) [![mai](https://img.shields.io/badge/lang-mai-blue.svg)](readme/README.mai.md) [![mai](https://img.shields.io/badge/lang-mai-blue.svg)](readme/README.mai.md)  
[![ms](https://img.shields.io/badge/lang-ms-purple.svg)](readme/README.ms.md) [![ml](https://img.shields.io/badge/lang-ml-orange.svg)](readme/README.ml.md) [![mt](https://img.shields.io/badge/lang-mt-green.svg)](readme/README.mt.md) ```python
from helper import run

run("./path/to/my_script.py")
#Show gui pop up with results
``` [![mn](https://img.shields.io/badge/lang-mn-orange.svg)](readme/README.mn.md) π_8. [![no](https://img.shields.io/badge/lang-no-red.svg)](readme/README.no.md) π_8.  
[![om](https://img.shields.io/badge/lang-om-orange.svg)](readme/README.om.md) [![ps](https://img.shields.io/badge/lang-ps-green.svg)](readme/README.ps.md) [![fa](https://img.shields.io/badge/lang-fa-blue.svg)](readme/README.fa.md) [![qu](https://img.shields.io/badge/lang-qu-red.svg)](readme/README.qu.md) [![sm](https://img.shields.io/badge/lang-sm-orange.svg)](readme/README.sm.md) [![nso](https://img.shields.io/badge/lang-nso-red.svg)](readme/README.nso.md) [![nso](https://img.shields.io/badge/lang-nso-red.svg)](readme/README.nso.md) [![nso](https://img.shields.io/badge/lang-nso-red.svg)](readme/README.nso.md)  
[![sd](https://img.shields.io/badge/lang-sd-green.svg)](readme/README.sd.md) [![si](https://img.shields.io/badge/lang-si-blue.svg)](readme/README.si.md) [![sk](https://img.shields.io/badge/lang-sk-red.svg)](readme/README.sk.md) [![sl](https://img.shields.io/badge/lang-sl-purple.svg)](readme/README.sl.md) [![tg](https://img.shields.io/badge/lang-tg-red.svg)](readme/README.tg.md) π_5.55_  
[![th](https://img.shields.io/badge/lang-th-blue.svg)](readme/README.th.md) [![ti](https://img.shields.io/badge/lang-ti-red.svg)](readme/README.ti.md) [![ts](https://img.shields.io/badge/lang-ts-purple.svg)](readme/README.ts.md) [![tk](https://img.shields.io/badge/lang-tk-orange.svg)](readme/README.tk.md) π_5.54 [![vi](https://img.shields.io/badge/lang-vi-green.svg)](readme/README.vi.md) [![vi](https://img.shields.io/badge/lang-vi-green.svg)](readme/README.vi.md)  
[![xh](https://img.shields.io/badge/lang-xh-red.svg)](readme/README.xh.md) [![yi](https://img.shields.io/badge/lang-yi-purple.svg)](readme/README.yi.md) [![yo](https://img.shields.io/badge/lang-yo-orange.svg)](readme/README.yo.md) [![zu](https://img.shields.io/badge/lang-zu-green.svg)](readme/README.zu.md)

---


## 🚀 Pag-instalar

I-install gikan sa PyPI:

```bash
pip install pyhelper-tools-jbhm
```

---

# # 📖 Sulud

** Pyhelper ** usa ka bersikala nga x_41_ nga toolkit nga gidisenyo aron mapagaan ang ** pag-analisar sa datos, paghanduraw, estadiyal nga operasyon, ug utility workflows ** .  
Nag-uban kini nga hapsay sa akademiko, panukiduki, ug propesyonal nga mga proyekto, nga nagtugot kanimo sa pag-focus sa mga panan-aw imbis sa boilerplate code.

KURSO NGA MGA BUTANGA:
- 🧮 Gitukod-sa ** statistics ug mga gamit sa matematika ** 
- 📊 dali nga paggamit ** data nga mga wrappers ** 
- 🗂 Handy ** file nga pagdumala ug pagpangita sa ** 
- 🔍 ** Pag-validate sa Syntax ** alang sa Python file
- 🌍 ** suporta sa multi-sinultian ** nga adunay andam nga paggamit nga mga hubad
- 🚀 Optimized alang sa ** paspas nga prototyping ** ug ** edukasyon ** 

---

# # ✨ Key Features

### 📊 data nga paghanduraw
- Bar Charts: Horizontal & Vertical (`hbar`, `vbar`)  
- Mga Plots sa Pag-apod-apod: Mga Histograms (`histo`), Kahon Plots (`boxplot`), KDE Plots (`kdeplot`)  
- Comparative Plots: Violin, Doksiyon, Strip Plots  
- Pag-analisar sa Correlation: Heatmaps (`heatmap`), Scotter Plots (`scatter`)  
- Advanced Visualizations: Pair Plots, hiniusa nga mga laraw, mga laraw sa regression  
- Mga lamesa sa Data: Ang Formated Table nga Pagpakita (`table`)  

### 📈 istatistika pagtuki
- ** Central Strotency ** : Kahulugan (`get_media`), Median (`get_median`), Mode (`get_moda`)  
- ** Pagkatulog ** : Range (`get_rank`), variance (`get_var`), Standard Deviation (`get_desv`)  
- ** Pagtuki ** : Ang pag-analisar sa pagtubo (`disp`), mga kalkulasyon sa IQR, pag-normalize, kondisyon nga pagbag-o  
- ** Gawas sa Sukwahi ** : Mga pamaagi sa IQR ug Z-Score  

### 🗂️ Pagdumala sa file
- Discovery Discovery nga adunay `call()` (auto-detect CSV, JSON, XML, etc.)  
- Multi-format nga suporta (CSV, JSON, XML, PDF, spatial data)  
- Pagdumala sa Database sa SQL sa `DataBase` Klase  
- Mga gamit sa pagkakabig (`convert_file`)  

### 🛠️ Mga Tool sa Developer
- switch system (`Switch`, `AsyncSwitch`)  
- Syntax pagsusi (`check_syntax`, `PythonFileChecker`)  
- Rich Secright Reporting (multi-language)  
- Integrated System Stand (`help`)  

### 🌍 International
- 100+ nga gitukod nga mga hubad  
- Pag-load sa kostumbre nga mga hubad  
- Runtime nga sinultian nga nag-omulong (`set_language() `)  
- Automatic English fallback  

---

## Dependencies (handled automatically):

- pandas, numpy (data manipulation)

- matplotlib, seaborn (visualization)

- scikit-learn (statistics)

- sqlalchemy (database)

- geopandas (spatial data)

---

## 🔧 Usage Examples

### Set language 

**support for up to 131 languages** 
``_14_13_


### Basic Statistics
```python
import helper as hp

data = [1, 2, 2, 3, 4, 5]

print(hp.get_media(data))   # Mean
print(hp.get_median(data))  # Median
print(hp.get_moda(data))    # Mode
```

### nga paghanduraw
```python
import helper as hp

df = hp.pd.DataFrame({"values": [5, 3, 7, 2, 9]})
hp.histo(df, "values", bins=5, title="Sample Histogram")
```

### nga pagdumala sa file
```python
from helper import call

data = call(name="my_data", type="csv")  # Finds and loads a CSV file automatically
```

### Custom Translations
```python
from helper import load_user_translations

# Load custom translations from lang.json
load_user_translations("custom/lang.json")
```

### Syntax validation
```python
from helper import run

run("./path/to/my_script.py")
#Show gui pop up with results
```

---

# # 📂 istruktura sa proyekto

```
helper/
├── core.py
├── __init__.py
├── lang/
│   ├── en.json
│   ├── es.json
│   └── ... (100+ files)
└── submodules/
    ├── graph.py
    ├── statics.py
    ├── utils.py
    ├── caller.py
    ├── checker.py
    ├── manager.py
    ├── pyswitch.py
    ├── shared.py
    └── DBManager.py
```

---

## 📜_6_

Ang kini nga proyekto lisensyado sa ilawom sa ** MIT π_4 _ ** .  
Tan-awa ang [LICENSE](LICENSE) file alang sa mga detalye.

---

# # 🔮 roadmap

- dugang nga mga tipo sa pagtan-aw

- Gipalapdan ang suporta sa database (NoSQL, graph databases)

- Pag-apil sa Tig-on sa Machine

- Interface nga nakabase sa web

- Sistema sa Plugin

---

⚡ Andam na nga suportahan ang imong Python workflows nga adunay ** pyhelper ** ? Magsugod sa pagsuhid karon!