# Yanaptʼir biblioteca .

[![License: MIT](https://img.shields.io/badge/License-MIT-yellow.svg)](LICENSE) [![PyPI](https://img.shields.io/pypi/v/pyhelper-tools-jbhm?style=for-the-badge&label=PyPI&color=blue)](https://pypi.org/project/pyhelper-tools-jbhm/) 1.1.

## 🌍 Uñt'at arunaka .

Pyhelper ukax **131 arunakar puriñkamaw jaqukipäwinak uñt’ayi** ukanakax akanakawa:

π__170_ [![es](https://img.shields.io/badge/lang-es-yellow.svg)](readme/README.es.md) [![fr](https://img.shields.io/badge/lang-fr-blue.svg)](readme/README.fr.md) [![de](https://img.shields.io/badge/lang-de-green.svg)](readme/README.de.md) π__166_ [![tr](https://img.shields.io/badge/lang-tr-orange.svg)](readme/README.tr.md) [![zh](https://img.shields.io/badge/lang-zh-black.svg)](readme/README.zh.md) [![it](https://img.shields.io/badge/lang-it-lightgrey.svg)](readme/README.it.md) [![pt](https://img.shields.io/badge/lang-pt-brightgreen.svg)](readme/README.pt.md) [![sv](https://img.shields.io/badge/lang-sv-blue.svg)](readme/README.sv.md)  
π__160_ [![ar](https://img.shields.io/badge/lang-ar-brown.svg)](readme/README.ar.md) [![af](https://img.shields.io/badge/lang-af-orange.svg)](readme/README.af.md) [![sq](https://img.shields.io/badge/lang-sq-blue.svg)](readme/README.sq.md) π__156_ [![hy](https://img.shields.io/badge/lang-hy-red.svg)](readme/README.hy.md) [![as](https://img.shields.io/badge/lang-as-purple.svg)](readme/README.as.md) [![ay](https://img.shields.io/badge/lang-ay-brown.svg)](readme/README.ay.md) [![az](https://img.shields.io/badge/lang-az-lightblue.svg)](readme/README.az.md) [![bm](https://img.shields.io/badge/lang-bm-darkgreen.svg)](readme/README.bm.md)  
π__150_ [![be](https://img.shields.io/badge/lang-be-darkblue.svg)](readme/README.be.md) [![bn](https://img.shields.io/badge/lang-bn-teal.svg)](readme/README.bn.md) [![bho](https://img.shields.io/badge/lang-bho-orange.svg)](readme/README.bho.md) π__146_ [![bg](https://img.shields.io/badge/lang-bg-green.svg)](readme/README.bg.md) [![ca](https://img.shields.io/badge/lang-ca-yellow.svg)](readme/README.ca.md) [![ceb](https://img.shields.io/badge/lang-ceb-blue.svg)](readme/README.ceb.md) [![ny](https://img.shields.io/badge/lang-ny-red.svg)](readme/README.ny.md) [![co](https://img.shields.io/badge/lang-co-green.svg)](readme/README.co.md)  
π__140_ [![cs](https://img.shields.io/badge/lang-cs-red.svg)](readme/README.cs.md) [![da](https://img.shields.io/badge/lang-da-purple.svg)](readme/README.da.md) π__137_ π__136_ [![nl](https://img.shields.io/badge/lang-nl-orange.svg)](readme/README.nl.md) [![eo](https://img.shields.io/badge/lang-eo-green.svg)](readme/README.eo.md) [![et](https://img.shields.io/badge/lang-et-blue.svg)](readme/README.et.md) [![ee](https://img.shields.io/badge/lang-ee-red.svg)](readme/README.ee.md) [![tl](https://img.shields.io/badge/lang-tl-purple.svg)](readme/README.tl.md)  
π__130_ [![fy](https://img.shields.io/badge/lang-fy-orange.svg)](readme/README.fy.md) [![gl](https://img.shields.io/badge/lang-gl-green.svg)](readme/README.gl.md) [![ka](https://img.shields.io/badge/lang-ka-red.svg)](readme/README.ka.md) π__126_ [![gn](https://img.shields.io/badge/lang-gn-purple.svg)](readme/README.gn.md) [![gu](https://img.shields.io/badge/lang-gu-orange.svg)](readme/README.gu.md) [![ht](https://img.shields.io/badge/lang-ht-green.svg)](readme/README.ht.md) [![ha](https://img.shields.io/badge/lang-ha-blue.svg)](readme/README.ha.md) [![haw](https://img.shields.io/badge/lang-haw-red.svg)](readme/README.haw.md)  
π__120_ [![hi](https://img.shields.io/badge/lang-hi-orange.svg)](readme/README.hi.md) [![hmn](https://img.shields.io/badge/lang-hmn-green.svg)](readme/README.hmn.md) [![hu](https://img.shields.io/badge/lang-hu-blue.svg)](readme/README.hu.md) π__116_ [![ig](https://img.shields.io/badge/lang-ig-purple.svg)](readme/README.ig.md) [![ilo](https://img.shields.io/badge/lang-ilo-orange.svg)](readme/README.ilo.md) [![id](https://img.shields.io/badge/lang-id-green.svg)](readme/README.id.md) π_1112_ [![jw](https://img.shields.io/badge/lang-jw-red.svg)](readme/README.jw.md)  
π__110_ [![kk](https://img.shields.io/badge/lang-kk-orange.svg)](readme/README.kk.md) [![km](https://img.shields.io/badge/lang-km-green.svg)](readme/README.km.md) [![rw](https://img.shields.io/badge/lang-rw-blue.svg)](readme/README.rw.md) π__106_ [![ko](https://img.shields.io/badge/lang-ko-purple.svg)](readme/README.ko.md) [![kri](https://img.shields.io/badge/lang-kri-orange.svg)](readme/README.kri.md) [![ku](https://img.shields.io/badge/lang-ku-green.svg)](readme/README.ku.md) [![ckb](https://img.shields.io/badge/lang-ckb-blue.svg)](readme/README.ckb.md) [![ky](https://img.shields.io/badge/lang-ky-red.svg)](readme/README.ky.md)  
π__100_ [![la](https://img.shields.io/badge/lang-la-orange.svg)](readme/README.la.md) [![lv](https://img.shields.io/badge/lang-lv-green.svg)](readme/README.lv.md) π__97_ π__96_ [![lg](https://img.shields.io/badge/lang-lg-purple.svg)](readme/README.lg.md) [![lb](https://img.shields.io/badge/lang-lb-orange.svg)](readme/README.lb.md) [![mk](https://img.shields.io/badge/lang-mk-green.svg)](readme/README.mk.md) [![mai](https://img.shields.io/badge/lang-mai-blue.svg)](readme/README.mai.md) [![mg](https://img.shields.io/badge/lang-mg-red.svg)](readme/README.mg.md)  
π__90_ [![ml](https://img.shields.io/badge/lang-ml-orange.svg)](readme/README.ml.md) [![mt](https://img.shields.io/badge/lang-mt-green.svg)](readme/README.mt.md) π__87_ π__86_ [![lus](https://img.shields.io/badge/lang-lus-purple.svg)](readme/README.lus.md) [![mn](https://img.shields.io/badge/lang-mn-orange.svg)](readme/README.mn.md) [![my](https://img.shields.io/badge/lang-my-green.svg)](readme/README.my.md) [![ne](https://img.shields.io/badge/lang-ne-blue.svg)](readme/README.ne.md) [![no](https://img.shields.io/badge/lang-no-red.svg)](readme/README.no.md) [![or](https://img.shields.io/badge/lang-or-purple.svg)](readme/README.or.md) .  
π__79_ [![ps](https://img.shields.io/badge/lang-ps-green.svg)](readme/README.ps.md) [![fa](https://img.shields.io/badge/lang-fa-blue.svg)](readme/README.fa.md) π__76_ [![ro](https://img.shields.io/badge/lang-ro-purple.svg)](readme/README.ro.md) [![sm](https://img.shields.io/badge/lang-sm-orange.svg)](readme/README.sm.md) [![sa](https://img.shields.io/badge/lang-sa-green.svg)](readme/README.sa.md) [![gd](https://img.shields.io/badge/lang-gd-blue.svg)](readme/README.gd.md) [![nso](https://img.shields.io/badge/lang-nso-red.svg)](readme/README.nso.md) [![st](https://img.shields.io/badge/lang-st-purple.svg)](readme/README.st.md) [![sn](https://img.shields.io/badge/lang-sn-orange.svg)](readme/README.sn.md)  
π__68_ [![si](https://img.shields.io/badge/lang-si-blue.svg)](readme/README.si.md) [![sk](https://img.shields.io/badge/lang-sk-red.svg)](readme/README.sk.md) π__65_ [![so](https://img.shields.io/badge/lang-so-orange.svg)](readme/README.so.md) [![su](https://img.shields.io/badge/lang-su-green.svg)](readme/README.su.md) [![sw](https://img.shields.io/badge/lang-sw-blue.svg)](readme/README.sw.md) [![tg](https://img.shields.io/badge/lang-tg-red.svg)](readme/README.tg.md) [![ta](https://img.shields.io/badge/lang-ta-purple.svg)](readme/README.ta.md) [![tt](https://img.shields.io/badge/lang-tt-orange.svg)](readme/README.tt.md) [![te](https://img.shields.io/badge/lang-te-green.svg)](readme/README.te.md)  
π__57_ [![ti](https://img.shields.io/badge/lang-ti-red.svg)](readme/README.ti.md) [![ts](https://img.shields.io/badge/lang-ts-purple.svg)](readme/README.ts.md) [![tk](https://img.shields.io/badge/lang-tk-orange.svg)](readme/README.tk.md) [![ak](https://img.shields.io/badge/lang-ak-green.svg)](readme/README.ak.md) [![uk](https://img.shields.io/badge/lang-uk-blue.svg)](readme/README.uk.md) [![ur](https://img.shields.io/badge/lang-ur-red.svg)](readme/README.ur.md) [![ug](https://img.shields.io/badge/lang-ug-purple.svg)](readme/README.ug.md) [![uz](https://img.shields.io/badge/lang-uz-orange.svg)](readme/README.uz.md) [![vi](https://img.shields.io/badge/lang-vi-green.svg)](readme/README.vi.md) [![cy](https://img.shields.io/badge/lang-cy-blue.svg)](readme/README.cy.md)  
π__46_ [![yi](https://img.shields.io/badge/lang-yi-purple.svg)](readme/README.yi.md) [![yo](https://img.shields.io/badge/lang-yo-orange.svg)](readme/README.yo.md) [![zu](https://img.shields.io/badge/lang-zu-green.svg)](readme/README.zu.md) .

--- .


## 🚀 Instalación ukax mä jach'a uñacht'äwiwa.

PYPI ukan uñt’ayata:

```bash
pip install pyhelper-tools-jbhm
``` .

--- .

## 📖 Jisk'a t'aqa

**Pyhelper** Ukax mä versatil Python herramientas ukawa, ukax simplificar**datos análisis, visualización, operaciones estadísticas ukat flujos de trabajo de utilidad** ukanakaw lurasi.  
Ukax proyectos académicos, investigaciones ukat profesionales ukanakaruw jan kuna jan walt’awimp mayacht’i, ukax código de calderato ukar uñtasit amuyunakaruw uñt’ayi.

Jach’a ventaja: 1.1.
- 🧮 Incorporado **Estadísticas ukat utilidades de matemáticas** 
- 📊 Jasaki apnaqañataki **Data Visualización envolturas** 
- 🗂 Handy **Archivo apnaqaña ukat thaqhaña** 
- 🔍 **SyNtax Validación** Python qillqatanakataki .
- 🌍 **Multi-lenguage yanapt’awi** Jaqukipäwinak wakicht’at jaqukipäwinakampi
- 🚀 optimizado para **FAST prototipo** ukat**educación** 

--- .

## ✨ Jach’a lurawi .

### 📊 Datos ukan uñacht'äwipa .
- Barras ukanakaxa: horizontal & vertical (`hbar`, `vbar`) .  
- Jaljawi chimpunaka: Histogramas (`histo`), TRACKS (`boxplot`), KDE Parcelas (`kdeplot`) .  
- Parcelas comparativas: violín, enjambre, parcelas de tiras ukaxa 1.1.  
- Correlación uñakipaña: (`heatmap`), ch’iqiyaña gráficos (`scatter`) .  
- Avanzada visualizaciones: Parcelas de par, parcelas de juntas, parcelas de regresión ukaxa 1.1.  
- Datos Tablas: Formato tabla uñacht’ayata (`table`) .  

### 📈 Análisis estadístico ukax 1.1.
- **Tendencia Central** : (`get_media`), mediana (`get_median`), modo (`get_moda`) ukaxa mä juk’a pachanakwa lurasi.  
- **Dispersión** : rango (`get_rank`), variancia (`get_var`), Desviación estándar (`get_desv`) .  
- **Análisis** : Yatiyawinak ch’iqiyaña (`disp`), IQR jakhüwinaka, normalización, transformaciones condicionales  
- **Outlier Detección** : IQR ukat Z-puntuación uka thakhinakax .  

### 🗂️ Archivo apnaqaña .
- ch’ikhi jikxataña `call()` (auto-detect CSV, JSON, XML, etc.) .  
- Walja formato yanapt’awi (CSV, JSON, XML, PDF, spatial data) .  
- SQL Base de Datos Gestión ukaxa `DataBase` clase ukampi luratawa.  
- Jaqukipaña Utilidades (`convert_file`) .  

### 🛠️ Desarrollador ukan yänakapa .
- Sistema de cambio (`Switch`, `AsyncSwitch`) ukaxa 1.1.  
- Sintaxis uñakipaña (`check_syntax`, `PythonFileChecker`) .  
- Qamir pantjasiwi yatiyawi (multi-language) .  
- Sistema Integrado de Yanapt’awi (`help`) .  

### 🌍 Internacionalización ukax mä jach'a uñacht'äwiwa.
- 100+ jaqukipäwinak uñt’ayaña .  
- Load costumbre jaqukipaña .  
- Runtime aru mayjt’ayaña (`set_language() `)  
- Automatic English fallback  

---

## Dependencies (handled automatically):

- pandas, numpy (data manipulation)

- matplotlib, seaborn (visualization)

- scikit-learn (statistics)

- sqlalchemy (database)

- geopandas (spatial data)

---

## 🔧 Usage Examples

### Set language 

**support for up to 131 languages** 
```python
from helper import set_language

set_language("en")  # English
set_language("es")  # Spanish
set_language("fr")  # French
set_language("de")  # German
set_language("ru")  # Russian
set_language("tr")  # Turkish
set_language("zh")  # Chinese
set_language("it")  # Italian
set_language("pt")  # Portuguese
set_language("sv")  # Swedish
set_language("ja")  # Japanese
set_language("ar")  # Arabic
...
``` .


### Estadísticas básicas ukax 1.1.
```python
import helper as hp

data = [1, 2, 2, 3, 4, 5]

print(hp.get_media(data))   # Mean
print(hp.get_median(data))  # Median
print(hp.get_moda(data))    # Mode
``` .

### Visualización ukax mä jach'a uñacht'äwiwa.
```python
import helper as hp

df = hp.pd.DataFrame({"values": [5, 3, 7, 2, 9]})
hp.histo(df, "values", bins=5, title="Sample Histogram")
``` .

### archiw apnaqaña .
```python
from helper import call

data = call(name="my_data", type="csv")  # Finds and loads a CSV file automatically
``` .

### costumbre jaqukipäwinaka .
```python
from helper import load_user_translations

# Load custom translations from lang.json
load_user_translations("custom/lang.json")
``` .

### Sintaxis ukax wali askiwa.
```python
from helper import run

run("./path/to/my_script.py")
#Show gui pop up with results
``` .

--- .

## 📂 Proyecto ukan estructurapa .

```
helper/
├── core.py
├── __init__.py
├── lang/
│   ├── en.json
│   ├── es.json
│   └── ... (100+ files)
└── submodules/
    ├── graph.py
    ├── statics.py
    ├── utils.py
    ├── caller.py
    ├── checker.py
    ├── manager.py
    ├── pyswitch.py
    ├── shared.py
    └── DBManager.py
``` .

--- .

## 📜 License .

Aka proyectox **MIT License** ukan licenciat uñt’ayatawa.  
[LICENSE](LICENSE) qillqat uñakipt’aña.

--- .

## 🔮 Ukax mä jach'a uñacht'äwiwa.

- Yaqha uñacht’ayaña kasta .

- Jach’a yatiyawi yanapt’awi (NoSQL, graph databases) .

- Maquina yatiqaña mayachawi .

- Interfaz basada en web ukaxa 1.1.

- Sistema de Plugin ukaxa 1.1.

--- .

⚡ Python irnaqäwinak **pyhelper** ukampi supercarga lurañataki wakicht’ata? ¡Jichhüruw yatxatañ qalltañama!