# সহায়ক লাইব্ৰেৰী

[![License: MIT](https://img.shields.io/badge/License-MIT-yellow.svg)](LICENSE) [![PyPI](https://img.shields.io/pypi/v/pyhelper-tools-jbhm?style=for-the-badge&label=PyPI&color=blue)](https://pypi.org/project/pyhelper-tools-jbhm/)

## 🌍 উপলব্ধ ভাষাসমূহ

Pyhelper এ **131 ভাষা** লৈকে বিল্ট-ইন অনুবাদ আগবঢ়ায় য'ত অন্তৰ্ভুক্ত আছে:

[![en](https://img.shields.io/badge/lang-en-red.svg)](readme/README.md) [![es](https://img.shields.io/badge/lang-es-yellow.svg)](readme/README.es.md) [![fr](https://img.shields.io/badge/lang-fr-blue.svg)](readme/README.fr.md) [![de](https://img.shields.io/badge/lang-de-green.svg)](readme/README.de.md) [![ru](https://img.shields.io/badge/lang-ru-purple.svg)](readme/README.ru.md) [![tr](https://img.shields.io/badge/lang-tr-orange.svg)](readme/README.tr.md) [![zh](https://img.shields.io/badge/lang-zh-black.svg)](readme/README.zh.md) [![it](https://img.shields.io/badge/lang-it-lightgrey.svg)](readme/README.it.md) [![pt](https://img.shields.io/badge/lang-pt-brightgreen.svg)](readme/README.pt.md) [![sv](https://img.shields.io/badge/lang-sv-blue.svg)](readme/README.sv.md)161_161_161_161_161_161_  
[![ja](https://img.shields.io/badge/lang-ja-red.svg)](readme/README.ja.md) [![ar](https://img.shields.io/badge/lang-ar-brown.svg)](readme/README.ar.md) [![af](https://img.shields.io/badge/lang-af-orange.svg)](readme/README.af.md) [![sq](https://img.shields.io/badge/lang-sq-blue.svg)](readme/README.sq.md) [![am](https://img.shields.io/badge/lang-am-green.svg)](readme/README.am.md) [![hy](https://img.shields.io/badge/lang-hy-red.svg)](readme/README.hy.md) [![as](https://img.shields.io/badge/lang-as-purple.svg)](readme/README.as.md)154_ [![ay](https://img.shields.io/badge/lang-ay-brown.svg)](readme/README.ay.md) [![az](https://img.shields.io/badge/lang-az-lightblue.svg)](readme/README.az.md) [![bm](https://img.shields.io/badge/lang-bm-darkgreen.svg)](readme/README.bm.md)151_151_151_151_151_151_151_151_151_151_151_151_151_151_  
π_১৫০_ π_১৪৯_ π_১৪৮_ π_১৪৭_ π_১৪৬_ π_১৪৫_ π_১৪৪_১৪৪_১৪৩_ π_১৪২_ π_১৪১_১৪১_১৪১_১৪১_১৪১_  
[![hr](https://img.shields.io/badge/lang-hr-blue.svg)](readme/README.hr.md)  [![cs](https://img.shields.io/badge/lang-cs-red.svg)](readme/README.cs.md)  [![da](https://img.shields.io/badge/lang-da-purple.svg)](readme/README.da.md)  [![dv](https://img.shields.io/badge/lang-dv-orange.svg)](readme/README.dv.md)  [![doi](https://img.shields.io/badge/lang-doi-brown.svg)](readme/README.doi.md)  [![nl](https://img.shields.io/badge/lang-nl-orange.svg)](readme/README.nl.md)  [![eo](https://img.shields.io/badge/lang-eo-green.svg)](readme/README.eo.md)  [![et](https://img.shields.io/badge/lang-et-blue.svg)](readme/README.et.md)  [![ee](https://img.shields.io/badge/lang-ee-red.svg)](readme/README.ee.md)  [![tl](https://img.shields.io/badge/lang-tl-purple.svg)](readme/README.tl.md)  
[![fi](https://img.shields.io/badge/lang-fi-blue.svg)](readme/README.fi.md)  [![fy](https://img.shields.io/badge/lang-fy-orange.svg)](readme/README.fy.md)  [![gl](https://img.shields.io/badge/lang-gl-green.svg)](readme/README.gl.md)  [![ka](https://img.shields.io/badge/lang-ka-red.svg)](readme/README.ka.md)  [![el](https://img.shields.io/badge/lang-el-blue.svg)](readme/README.el.md)  [![gn](https://img.shields.io/badge/lang-gn-purple.svg)](readme/README.gn.md)  [![gu](https://img.shields.io/badge/lang-gu-orange.svg)](readme/README.gu.md)  [![ht](https://img.shields.io/badge/lang-ht-green.svg)](readme/README.ht.md)  [![ha](https://img.shields.io/badge/lang-ha-blue.svg)](readme/README.ha.md)  [![haw](https://img.shields.io/badge/lang-haw-red.svg)](readme/README.haw.md)  
[![iw](https://img.shields.io/badge/lang-iw-purple.svg)](readme/README.iw.md)  [![hi](https://img.shields.io/badge/lang-hi-orange.svg)](readme/README.hi.md)  [![hmn](https://img.shields.io/badge/lang-hmn-green.svg)](readme/README.hmn.md)  [![hu](https://img.shields.io/badge/lang-hu-blue.svg)](readme/README.hu.md)  [![is](https://img.shields.io/badge/lang-is-red.svg)](readme/README.is.md)  [![ig](https://img.shields.io/badge/lang-ig-purple.svg)](readme/README.ig.md)  [![ilo](https://img.shields.io/badge/lang-ilo-orange.svg)](readme/README.ilo.md)  [![id](https://img.shields.io/badge/lang-id-green.svg)](readme/README.id.md)  [![ga](https://img.shields.io/badge/lang-ga-blue.svg)](readme/README.ga.md)  [![jw](https://img.shields.io/badge/lang-jw-red.svg)](readme/README.jw.md)  
[![kn](https://img.shields.io/badge/lang-kn-purple.svg)](readme/README.kn.md)  [![kk](https://img.shields.io/badge/lang-kk-orange.svg)](readme/README.kk.md)  [![km](https://img.shields.io/badge/lang-km-green.svg)](readme/README.km.md)  [![rw](https://img.shields.io/badge/lang-rw-blue.svg)](readme/README.rw.md)  [![gom](https://img.shields.io/badge/lang-gom-red.svg)](readme/README.gom.md)  [![ko](https://img.shields.io/badge/lang-ko-purple.svg)](readme/README.ko.md)  [![kri](https://img.shields.io/badge/lang-kri-orange.svg)](readme/README.kri.md)  [![ku](https://img.shields.io/badge/lang-ku-green.svg)](readme/README.ku.md)  [![ckb](https://img.shields.io/badge/lang-ckb-blue.svg)](readme/README.ckb.md)  [![ky](https://img.shields.io/badge/lang-ky-red.svg)](readme/README.ky.md)  
[![lo](https://img.shields.io/badge/lang-lo-purple.svg)](readme/README.lo.md) [![la](https://img.shields.io/badge/lang-la-orange.svg)](readme/README.la.md) [![lv](https://img.shields.io/badge/lang-lv-green.svg)](readme/README.lv.md) [![ln](https://img.shields.io/badge/lang-ln-blue.svg)](readme/README.ln.md) [![lt](https://img.shields.io/badge/lang-lt-red.svg)](readme/README.lt.md) [![lg](https://img.shields.io/badge/lang-lg-purple.svg)](readme/README.lg.md) [![lb](https://img.shields.io/badge/lang-lb-orange.svg)](readme/README.lb.md)94_ [![mk](https://img.shields.io/badge/lang-mk-green.svg)](readme/README.mk.md)93_92_ [![mg](https://img.shields.io/badge/lang-mg-red.svg)](readme/README.mg.md)91_  
[![ms](https://img.shields.io/badge/lang-ms-purple.svg)](readme/README.ms.md) [![ml](https://img.shields.io/badge/lang-ml-orange.svg)](readme/README.ml.md) [![mt](https://img.shields.io/badge/lang-mt-green.svg)](readme/README.mt.md) [![mi](https://img.shields.io/badge/lang-mi-blue.svg)](readme/README.mi.md) [![mr](https://img.shields.io/badge/lang-mr-red.svg)](readme/README.mr.md) [![lus](https://img.shields.io/badge/lang-lus-purple.svg)](readme/README.lus.md) [![mn](https://img.shields.io/badge/lang-mn-orange.svg)](readme/README.mn.md) [![my](https://img.shields.io/badge/lang-my-green.svg)](readme/README.my.md)83_83_ [![ne](https://img.shields.io/badge/lang-ne-blue.svg)](readme/README.ne.md) [![no](https://img.shields.io/badge/lang-no-red.svg)](readme/README.no.md) [![or](https://img.shields.io/badge/lang-or-purple.svg)](readme/README.or.md)80_80_80_80_80_80_80_80_80_80_80_80_80_ 81_81_81_ [![no](https://img.shields.io/badge/lang-no-red.svg)](readme/README.no.md)80_80_  
[![om](https://img.shields.io/badge/lang-om-orange.svg)](readme/README.om.md) [![ps](https://img.shields.io/badge/lang-ps-green.svg)](readme/README.ps.md) [![fa](https://img.shields.io/badge/lang-fa-blue.svg)](readme/README.fa.md) [![qu](https://img.shields.io/badge/lang-qu-red.svg)](readme/README.qu.md) [![ro](https://img.shields.io/badge/lang-ro-purple.svg)](readme/README.ro.md) [![sm](https://img.shields.io/badge/lang-sm-orange.svg)](readme/README.sm.md) [![sa](https://img.shields.io/badge/lang-sa-green.svg)](readme/README.sa.md) [![gd](https://img.shields.io/badge/lang-gd-blue.svg)](readme/README.gd.md)72_72_71_ [![nso](https://img.shields.io/badge/lang-nso-red.svg)](readme/README.nso.md) [![sn](https://img.shields.io/badge/lang-sn-orange.svg)](readme/README.sn.md)69_69_69_  
[![sd](https://img.shields.io/badge/lang-sd-green.svg)](readme/README.sd.md) [![si](https://img.shields.io/badge/lang-si-blue.svg)](readme/README.si.md) [![sk](https://img.shields.io/badge/lang-sk-red.svg)](readme/README.sk.md) [![sl](https://img.shields.io/badge/lang-sl-purple.svg)](readme/README.sl.md) [![so](https://img.shields.io/badge/lang-so-orange.svg)](readme/README.so.md) [![su](https://img.shields.io/badge/lang-su-green.svg)](readme/README.su.md) [![sw](https://img.shields.io/badge/lang-sw-blue.svg)](readme/README.sw.md) [![tg](https://img.shields.io/badge/lang-tg-red.svg)](readme/README.tg.md)61_ [![ta](https://img.shields.io/badge/lang-ta-purple.svg)](readme/README.ta.md) [![tt](https://img.shields.io/badge/lang-tt-orange.svg)](readme/README.tt.md) [![te](https://img.shields.io/badge/lang-te-green.svg)](readme/README.te.md) 58_58_58_  
[![th](https://img.shields.io/badge/lang-th-blue.svg)](readme/README.th.md) [![ti](https://img.shields.io/badge/lang-ti-red.svg)](readme/README.ti.md) [![ts](https://img.shields.io/badge/lang-ts-purple.svg)](readme/README.ts.md) [![tk](https://img.shields.io/badge/lang-tk-orange.svg)](readme/README.tk.md) [![ak](https://img.shields.io/badge/lang-ak-green.svg)](readme/README.ak.md) [![uk](https://img.shields.io/badge/lang-uk-blue.svg)](readme/README.uk.md) [![ur](https://img.shields.io/badge/lang-ur-red.svg)](readme/README.ur.md) [![ug](https://img.shields.io/badge/lang-ug-purple.svg)](readme/README.ug.md)50_ [![uz](https://img.shields.io/badge/lang-uz-orange.svg)](readme/README.uz.md) [![vi](https://img.shields.io/badge/lang-vi-green.svg)](readme/README.vi.md) [![cy](https://img.shields.io/badge/lang-cy-blue.svg)](readme/README.cy.md) 47_47_  
[![xh](https://img.shields.io/badge/lang-xh-red.svg)](readme/README.xh.md) [![yi](https://img.shields.io/badge/lang-yi-purple.svg)](readme/README.yi.md) [![yo](https://img.shields.io/badge/lang-yo-orange.svg)](readme/README.yo.md) [![zu](https://img.shields.io/badge/lang-zu-green.svg)](readme/README.zu.md)

---


## 🚀 ইনষ্টলেচন

Pypi ৰ পৰা সংস্থাপন কৰক:

```bash
pip install pyhelper-tools-jbhm
```

---

## 📖 অভাৰভিউ

**PyHelper** এটা বহুমুখী Python সঁজুলিকিট ডিজাইন কৰা হৈছে**তথ্য বিশ্লেষণ, দৃশ্যায়ন, পৰিসংখ্যাগত কাৰ্য্যসমূহ, আৰু উপযোগী কাৰ্য্যপ্ৰবাহসমূহ সৰল কৰিবলৈ ডিজাইন কৰা হৈছে** ।  
ই শৈক্ষিক, গৱেষণা আৰু পেছাদাৰী প্ৰকল্পসমূহৰ সৈতে নিৰৱচ্ছিন্নভাৱে একত্ৰিত হয়, যাৰ ফলত আপুনি বয়লাৰপ্লেট ক'ডৰ পৰিৱৰ্তে অন্তৰ্দৃষ্টিৰ ওপৰত গুৰুত্ব দিব পাৰে।

মূল সুবিধাসমূহ:
- 🧮 বিল্ট-ইন **পৰিসংখ্যা আৰু গণিতৰ উপযোগীতা** 
- 📊 ব্যৱহাৰ কৰিব পৰা সহজ **তথ্যৰ দৃশ্যায়ন ৰেপাৰ** 
- 🗂 হেণ্ডী **ফাইল হেণ্ডলিং আৰু সন্ধান** 
- 🔍 ** Python ফাইলসমূহৰ বাবে Syntax বৈধকৰণ** 
- 🌍 **মাল্টি-ভাষা সমর্থন** 
- 🚀 **দ্রুত প্রোট'টাইপিং** আৰু**শিক্ষা** জন্য অনুকূলিত

---

## ✨ মূল বৈশিষ্ট্যসমূহ

### 📊 ডাটা ভিজুৱেলাইজেচন
- বার চার্ট: অনুভূমিক & উল্লম্ব (`hbar`, `vbar`)  
- বিতৰণ প্লট: হিষ্টোগ্ৰাম (`histo`), বাকচ প্লট (`boxplot`), kde প্লট (`kdeplot`)  
- তুলনামূলক প্লট: ভায়লিন, ঝাঁক, ষ্ট্ৰিপ প্লট  
- সম্পৰ্ক বিশ্লেষণ: হিটমেপ (`heatmap`), স্কেটাৰ প্লট (`scatter`)  
- উন্নত দৃশ্যায়ন: যোৰ প্লট, জইণ্ট প্লট, ৰিগ্ৰেছন প্লট  
- তথ্য টেবুল: ফৰ্মেট কৰা টেবুল প্ৰদৰ্শন কৰে (`table`)  

### 📈 পৰিসংখ্যা বিশ্লেষণ
- **কেন্দ্ৰীয় প্ৰৱণতা** : গড় (`get_media`), মধ্যমা (`get_median`), ধৰণ (`get_moda`)  
- **বিক্ষিপ্তকৰণ** : পৰিসৰ (`get_rank`), ভ্যাৰিয়েন্স (`get_var`), প্ৰামাণিক বিচ্যুতি (`get_desv`)  
- **বিশ্লেষণ** : বিক্ষিপ্ততা প্ৰতিবেদন (`disp`), IQR গণনা, স্বাভাৱিককৰণ, চৰ্তযুক্ত ৰূপান্তৰসমূহ  
- **আউটলিয়াৰ ডিটেকচন** : IQR আৰু Z-Score পদ্ধতি  

### 🗂️ ফাইল ব্যৱস্থাপনা
- `call()` (auto-detect CSV, JSON, XML, etc.) ৰ সৈতে স্মাৰ্ট আৱিষ্কাৰ  
- মাল্টি-ফৰ্মেট সমৰ্থন (CSV, JSON, XML, PDF, spatial data)  
- `DataBase` শ্ৰেণীৰ সৈতে SQL ডাটাবেছ ব্যৱস্থাপনা  
- ৰূপান্তৰ সঁজুলি (`convert_file`)  

### 🛠️ ডেভেলপাৰ সঁজুলি
- চুইচ ব্যৱস্থা (`Switch`, `AsyncSwitch`)  
- বাক্যবিন্যাস পরীক্ষা (`check_syntax`, `PythonFileChecker`)  
- সমৃদ্ধ ভুল reporting (multi-language)  
- সংহত সহায় ব্যৱস্থা (`help`)  

### 🌍 আন্তৰ্জাতিককৰণ
- 100+ বিল্ট-ইন অনুবাদ  
- কাস্টম অনুবাদ লোড করুন  
- চলনসময় ভাষা চুইচিং (`set_language() `)  
- Automatic English fallback  

---

## Dependencies (handled automatically):

- pandas, numpy (data manipulation)

- matplotlib, seaborn (visualization)

- scikit-learn (statistics)

- sqlalchemy (database)

- geopandas (spatial data)

---

## 🔧 Usage Examples

### Set language 

**support for up to 131 languages** 
```python
from helper import set_language

set_language("en")  # English
set_language("es")  # Spanish
set_language("fr")  # French
set_language("de")  # German
set_language("ru")  # Russian
set_language("tr")  # Turkish
set_language("zh")  # Chinese
set_language("it")  # Italian
set_language("pt")  # Portuguese
set_language("sv")  # Swedish
set_language("ja")  # Japanese
set_language("ar")  # Arabic
...
```


### মূল পৰিসংখ্যা
```python
import helper as hp

data = [1, 2, 2, 3, 4, 5]

print(hp.get_media(data))   # Mean
print(hp.get_median(data))  # Median
print(hp.get_moda(data))    # Mode
```

### দৃশ্যায়ন
```python
import helper as hp

df = hp.pd.DataFrame({"values": [5, 3, 7, 2, 9]})
hp.histo(df, "values", bins=5, title="Sample Histogram")
```

### ফাইল নিয়ন্ত্ৰণ
π_১০_

### কাষ্টম অনুবাদ
```python
from helper import load_user_translations

# Load custom translations from lang.json
load_user_translations("custom/lang.json")
```

### বাক্যবিন্যাস বৈধকৰণ
```python
from helper import run

run("./path/to/my_script.py")
#Show gui pop up with results
```

---

## 📂 প্ৰকল্পৰ গঠন

```
helper/
├── core.py
├── __init__.py
├── lang/
│   ├── en.json
│   ├── es.json
│   └── ... (100+ files)
└── submodules/
    ├── graph.py
    ├── statics.py
    ├── utils.py
    ├── caller.py
    ├── checker.py
    ├── manager.py
    ├── pyswitch.py
    ├── shared.py
    └── DBManager.py
```

---

## 📜 License

এই প্ৰকল্পটো **MIT License** ৰ অধীনত অনুজ্ঞাপত্ৰপ্ৰাপ্ত।  
বিৱৰণৰ বাবে [LICENSE](LICENSE) ফাইল চাওক।

---

## 🔮 ৰ'ডমেপ

- অতিৰিক্ত দৃশ্যায়ন প্ৰকাৰ

- সম্প্ৰসাৰিত ডাটাবেছ সমৰ্থন (NoSQL, graph databases)

- মেশিন শিক্ষণ সংহতি

- ওয়েব-ভিত্তিক আন্তঃপৃষ্ঠ

- প্লাগইন সিস্টেম

---

⚡ **pyhelper** ৰ সৈতে আপোনাৰ Python কাৰ্য্যপ্ৰবাহ চুপাৰচাৰ্জ কৰিবলৈ সাজু? আজি অন্বেষণ আৰম্ভ কৰক!