# -*- coding: utf-8 -*-
from setuptools import setup

package_dir = \
{'': 'src'}

modules = \
['d2b_nth_of_type']
install_requires = \
['d2b>=1.4.0rc1,<2.0.0']

entry_points = \
{'d2b': ['nth_of_type = d2b_nth_of_type']}

setup_kwargs = {
    'name': 'd2b-nth-of-type',
    'version': '1.0.0',
    'description': 'Plugin for the d2b package to deterministically uniquify different acquisition runs',
    'long_description': '# d2b-nth-of-type\n\n[![PyPI Version](https://img.shields.io/pypi/v/d2b-nth-of-type.svg)](https://pypi.org/project/d2b-nth-of-type/) [![Code Style](https://github.com/d2b-dev/d2b-nth-of-type/actions/workflows/lint.yaml/badge.svg)](https://github.com/d2b-dev/d2b-nth-of-type/actions/workflows/lint.yaml) [![Type Check](https://github.com/d2b-dev/d2b-nth-of-type/actions/workflows/type-check.yaml/badge.svg)](https://github.com/d2b-dev/d2b-nth-of-type/actions/workflows/type-check.yaml) [![Tests](https://github.com/d2b-dev/d2b-nth-of-type/actions/workflows/test.yaml/badge.svg)](https://github.com/d2b-dev/d2b-nth-of-type/actions/workflows/test.yaml)\n\nPlugin for the d2b package to deterministically uniquify different acquisition runs\n\n## Intallation\n\n```bash\npip install d2b-nth-of-type\n```\n\n## Getting Started\n\nThis plugin will inject properties into each JSON sidecar which distinguish different runs from one another, which can subsequently be used in `criteria` specifications in d2b config files.\n\nSpecifically, this plugin will inject a property, `__nth_of_type__`, into each JSON sidecar. The value of this property is a 0-indexed integer.\n\n**This plugin groups acquisitions and gives each run in the group a unique (0-indexed) label, incrementing in the specified order.**\n\nBy default, acquisitions are grouped by `SeriesDescription` and are ordered by `SeriesNumber` (in _ascending_ order).\n\nFor example, if a subject has a session in which 3 fieldmaps are acquired, and say, for example, the 3 sidecars (truncated) are of the form:\n\n- fieldmap 1:\n\n  ```json\n  {\n    "SeriesDescription": "my_fmap",\n    "SeriesNumber": 3\n  }\n  ```\n\n- fieldmap 2:\n\n  ```json\n  {\n    "SeriesDescription": "my_fmap",\n    "SeriesNumber": 16\n  }\n  ```\n\n- fieldmap 3:\n\n  ```json\n  {\n    "SeriesDescription": "my_fmap",\n    "SeriesNumber": 24\n  }\n  ```\n\nThen, when running `d2b run` with this plugin installed, this plugin will inject `__nth_of_type__` into each sidecar, resulting in sidecars (truncated) which look like:\n\n- fieldmap 1:\n\n  ```json\n  {\n    "SeriesDescription": "my_fmap",\n    "SeriesNumber": 3,\n    "__nth_of_type__": 0\n  }\n  ```\n\n- fieldmap 2:\n\n  ```json\n  {\n    "SeriesDescription": "my_fmap",\n    "SeriesNumber": 16,\n    "__nth_of_type__": 1\n  }\n  ```\n\n- fieldmap 3:\n\n  ```json\n  {\n    "SeriesDescription": "my_fmap",\n    "SeriesNumber": 24,\n    "__nth_of_type__": 2\n  }\n  ```\n\nThe utility is that these values will be invariant under changes to `SeriesNumber`.\n\nSo, if the "first" fmap is intended for a BOLD acquisition, and the "second" fmap is intended for a PCASL acquisition, we can safely pick-out each fmap using the `__nth_of_type__` field.\n\nFor example, we could have a d2b configuration file of the following form (_NOTE: [`d2b-yaml`](https://github.com/d2b-dev/d2b-yaml) plugin required for yaml config files, and you probably also want the [`d2b-asl`](https://github.com/d2b-dev/d2b-asl) plugin for ASL data_):\n\n```yaml\ndescriptions:\n  # BOLD Resting State\n  - id: my-bold-rs\n    dataType: func\n    modalityLabel: bold\n    customLabels: task-rest\n\n    criteria:\n      # ...\n\n  # PCASL\n  - id: my-pcasl\n    dataType: perf\n    modalityLabel: asl\n    customLabels:\n      acq: pcasl\n\n    criteria:\n      # ...\n    aslContext:\n      # ...\n\n  # FIRST FMAP - for BOLD - phase encoding = AP\n  - dataType: fmap\n    modalityLabel: epi\n    customLabels:\n      dir: AP\n    IntendedFor:\n      - my-bold-rs\n    criteria:\n      ManufacturersModelName: Prisma_fit\n      SidecarFilename: "*SpinEchoFieldMap_AP*"\n      __nth_of_type__: 0 # <-- HERE\n\n  # FIRST FMAP - for BOLD - phase encoding = PA\n  - dataType: fmap\n    modalityLabel: epi\n    customLabels:\n      dir: PA\n    IntendedFor:\n      - my-bold-rs\n    criteria:\n      ManufacturersModelName: Prisma_fit\n      SidecarFilename: "*SpinEchoFieldMap_PA*"\n      __nth_of_type__: 0 # <-- HERE\n\n  # SECOND FMAP - for PCASL - phase encoding = AP\n  - dataType: fmap\n    modalityLabel: epi\n    customLabels:\n      dir: AP\n    IntendedFor:\n      - my-pcasl\n    criteria:\n      ManufacturersModelName: Prisma_fit\n      SidecarFilename: "*SpinEchoFieldMap_AP*"\n      __nth_of_type__: 1 # <-- HERE\n\n  # SECOND FMAP - for PCASL - phase encoding = PA\n  - dataType: fmap\n    modalityLabel: epi\n    customLabels:\n      dir: PA\n    IntendedFor:\n      - my-pcasl\n    criteria:\n      ManufacturersModelName: Prisma_fit\n      SidecarFilename: "*SpinEchoFieldMap_PA*"\n      __nth_of_type__: 1 # <-- HERE\n```\n\n## Configuration\n\nThis plugin can be configured by via options to the `d2b run` command or via the environment:\n\n- `--nth-of-type-enabled | --nth-of-type-disabled`\n\n  Enable or disable this plugin. (default: enabled)\n\n  Can also be configured via the `D2B_NTH_OF_TYPE_ENABLED` environment variable. The command line argument takes precedence over the environment variable.\n\n- `--nth-of-type-sort-by <string>`\n\n  Which sidecar field to sort the acquisitions by (default: `SeriesNumber:asc`).\n\n  To sort in descending order append `:desc` onto the fieldname, ex: `SeriesNumber:desc`. If no direction/ordering suffix (`:asc`/`:desc`) is present then the acquisitions are sorted in ascending order.\n\n  Can also be configured via the `D2B_NTH_OF_TYPE_SORT_BY` environment variable. The command line argument takes precedence over the environment variable.\n\n- `--nth-of-type-group-by <string>`\n\n  Which sidecar field(s) to group acquisitions by (default: `SeriesDescription`).\n\n  To group by more then one field pass a comma separated list, ex: `SeriesDescription,RepetitionTime`\n\n  Can also be configured via the `D2B_NTH_OF_TYPE_GROUP_BY` environment variable. The command line argument takes precedence over the environment variable.\n\n## Contributing\n\n1. Have or install a recent version of `poetry` (version >= 1.1)\n1. Fork the repo\n1. Setup a virtual environment (however you prefer)\n1. Run `poetry install`\n1. Run `pre-commit install`\n1. Add your changes (adding/updating tests is always nice too)\n1. Commit your changes + push to your fork\n1. Open a PR\n',
    'author': 'Andrew Ross',
    'author_email': 'andrew.ross.mail@gmail.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/d2b-dev/d2b-nth-of-type',
    'package_dir': package_dir,
    'py_modules': modules,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.8,<4.0',
}


setup(**setup_kwargs)
