import datetime
from south.db import db
from south.v2 import SchemaMigration
from django.db import models
from userena.utils import user_model_label


class Migration(SchemaMigration):
    def forwards(self, orm):

        # Adding model 'UserenaSignup'
        db.create_table(
            "userena_userenasignup",
            (
                ("id", self.gf("django.db.models.fields.AutoField")(primary_key=True)),
                (
                    "user",
                    self.gf("django.db.models.fields.related.OneToOneField")(
                        related_name="userena_signup",
                        unique=True,
                        to=orm[user_model_label],
                    ),
                ),
                (
                    "last_active",
                    self.gf("django.db.models.fields.DateTimeField")(
                        null=True, blank=True
                    ),
                ),
                (
                    "activation_key",
                    self.gf("django.db.models.fields.CharField")(
                        max_length=40, blank=True
                    ),
                ),
                (
                    "activation_notification_send",
                    self.gf("django.db.models.fields.BooleanField")(default=False),
                ),
                (
                    "email_unconfirmed",
                    self.gf("django.db.models.fields.EmailField")(
                        max_length=75, blank=True
                    ),
                ),
                (
                    "email_confirmation_key",
                    self.gf("django.db.models.fields.CharField")(
                        max_length=40, blank=True
                    ),
                ),
                (
                    "email_confirmation_key_created",
                    self.gf("django.db.models.fields.DateTimeField")(
                        null=True, blank=True
                    ),
                ),
            ),
        )
        db.send_create_signal("userena", ["UserenaSignup"])

    def backwards(self, orm):

        # Deleting model 'UserenaSignup'
        db.delete_table("userena_userenasignup")

    models = {
        "auth.group": {
            "Meta": {"object_name": "Group"},
            "id": ("django.db.models.fields.AutoField", [], {"primary_key": "True"}),
            "name": (
                "django.db.models.fields.CharField",
                [],
                {"unique": "True", "max_length": "80"},
            ),
            "permissions": (
                "django.db.models.fields.related.ManyToManyField",
                [],
                {
                    "to": "orm['auth.Permission']",
                    "symmetrical": "False",
                    "blank": "True",
                },
            ),
        },
        "auth.permission": {
            "Meta": {
                "ordering": "('content_type__app_label', 'content_type__model', 'codename')",
                "unique_together": "(('content_type', 'codename'),)",
                "object_name": "Permission",
            },
            "codename": (
                "django.db.models.fields.CharField",
                [],
                {"max_length": "100"},
            ),
            "content_type": (
                "django.db.models.fields.related.ForeignKey",
                [],
                {"to": "orm['contenttypes.ContentType']"},
            ),
            "id": ("django.db.models.fields.AutoField", [], {"primary_key": "True"}),
            "name": ("django.db.models.fields.CharField", [], {"max_length": "50"}),
        },
        user_model_label: {
            "Meta": {"object_name": user_model_label.split(".")[-1]},
            "date_joined": (
                "django.db.models.fields.DateTimeField",
                [],
                {"default": "datetime.datetime.now"},
            ),
            "email": (
                "django.db.models.fields.EmailField",
                [],
                {"max_length": "75", "blank": "True"},
            ),
            "first_name": (
                "django.db.models.fields.CharField",
                [],
                {"max_length": "30", "blank": "True"},
            ),
            "groups": (
                "django.db.models.fields.related.ManyToManyField",
                [],
                {"to": "orm['auth.Group']", "symmetrical": "False", "blank": "True"},
            ),
            "id": ("django.db.models.fields.AutoField", [], {"primary_key": "True"}),
            "is_active": (
                "django.db.models.fields.BooleanField",
                [],
                {"default": "True"},
            ),
            "is_staff": (
                "django.db.models.fields.BooleanField",
                [],
                {"default": "False"},
            ),
            "is_superuser": (
                "django.db.models.fields.BooleanField",
                [],
                {"default": "False"},
            ),
            "last_login": (
                "django.db.models.fields.DateTimeField",
                [],
                {"default": "datetime.datetime.now"},
            ),
            "last_name": (
                "django.db.models.fields.CharField",
                [],
                {"max_length": "30", "blank": "True"},
            ),
            "password": (
                "django.db.models.fields.CharField",
                [],
                {"max_length": "128"},
            ),
            "user_permissions": (
                "django.db.models.fields.related.ManyToManyField",
                [],
                {
                    "to": "orm['auth.Permission']",
                    "symmetrical": "False",
                    "blank": "True",
                },
            ),
            "username": (
                "django.db.models.fields.CharField",
                [],
                {"unique": "True", "max_length": "30"},
            ),
        },
        "contenttypes.contenttype": {
            "Meta": {
                "ordering": "('name',)",
                "unique_together": "(('app_label', 'model'),)",
                "object_name": "ContentType",
                "db_table": "'django_content_type'",
            },
            "app_label": (
                "django.db.models.fields.CharField",
                [],
                {"max_length": "100"},
            ),
            "id": ("django.db.models.fields.AutoField", [], {"primary_key": "True"}),
            "model": ("django.db.models.fields.CharField", [], {"max_length": "100"}),
            "name": ("django.db.models.fields.CharField", [], {"max_length": "100"}),
        },
        "userena.userenasignup": {
            "Meta": {"object_name": "UserenaSignup"},
            "activation_key": (
                "django.db.models.fields.CharField",
                [],
                {"max_length": "40", "blank": "True"},
            ),
            "activation_notification_send": (
                "django.db.models.fields.BooleanField",
                [],
                {"default": "False"},
            ),
            "email_confirmation_key": (
                "django.db.models.fields.CharField",
                [],
                {"max_length": "40", "blank": "True"},
            ),
            "email_confirmation_key_created": (
                "django.db.models.fields.DateTimeField",
                [],
                {"null": "True", "blank": "True"},
            ),
            "email_unconfirmed": (
                "django.db.models.fields.EmailField",
                [],
                {"max_length": "75", "blank": "True"},
            ),
            "id": ("django.db.models.fields.AutoField", [], {"primary_key": "True"}),
            "last_active": (
                "django.db.models.fields.DateTimeField",
                [],
                {"null": "True", "blank": "True"},
            ),
            "user": (
                "django.db.models.fields.related.OneToOneField",
                [],
                {
                    "related_name": "'userena_signup'",
                    "unique": "True",
                    "to": "orm['%s']" % user_model_label,
                },
            ),
        },
    }

    complete_apps = ["userena"]
