import unittest, io

from LaTeXDatax import printvariables

class TestDatax(unittest.TestCase):
    def test_datax(self):
        """
        Test that it writes a number of variables correctly
        """
        f = io.StringIO()
        printvariables(f,
                a = "Literal string",
                b = 3.141592,
                c = (3.141592,"\\meter"),
                d = (3.141592,"\\meter","%.2g"),
                e = (3.141592,"%.2g"),
                )
        f.seek(0)
        written = f.read()
        target ="""\
% File auto-generated by LaTeXDatax.py. Will be overwritten.
\\pgfkeyssetvalue{/datax/a}{Literal string}
\\pgfkeyssetvalue{/datax/b}{\\num{3.142}}
\\pgfkeyssetvalue{/datax/c}{\\SI{3.142}{\\meter}}
\\pgfkeyssetvalue{/datax/d}{\\SI{3.1}{\\meter}}
\\pgfkeyssetvalue{/datax/e}{\\num{3.1}}
"""
        self.assertEqual(written,target)

if __name__ == '__main__':
    unittest.main()
