# coding: utf-8

# flake8: noqa

"""
    Wink API

     # Introduction  Welcome to the Wink API - A programmer-friendly way to manage, sell and book travel inventory on the Wink platform. The API gives you all the tools you need to ready your properties and inventory for sale across 1000s of our native sales channels.  Integrators, affiliates, travel agents and content creators have the ability search for your travel inventory and promote / sell it in a wide variety of ways.   # Integrations  We have already integrated with the most well-known channel managers so you don't have to. To see our current integrations, please go to https://extranet.wink.travel and scroll to Connectivity section. Once your properties are set up, you can finish the setup by mapping your property to Wink using your channel manager partner portal. If your properties don't have a channel manager, you can easily manage rates and availability with this API.   # Intended Audience  Programmers are [most likely] a requirement to start integrating with Wink. Companies and organizations that would most benefit from integrating with us are new and existing travel companies that have relationships with suppliers and that need an advanced system from which to manage their travel inventory and get that same inventory out to as many eyeballs as possible at the lowest price possible.  - Hotel chains  - Hotel brands  - Travel tech companies  - Destination sites  - Integrators  - Aggregators  - Destination management companies  - Travel agencies  - OTAs   ## APIs  Not every integrator needs every API. For that reason, we have separated APIs into context.  ### Test API   - [Ping](/ping): The Ping API is a quick test endpoint to verify that your credentials work Wink.  ### Common APIs  - [Notifications](/notifications): The Notifications API is a way for us to stay in touch with your user, property or affiliate account. - [User Settings](/user-settings): The User Settings API exposes endpoints to allow 3rd party integrators to communicate with Wink.  ### Consume APIs Consume endpoints are for developers who want to find existing travel inventory and either book it or use it to advertise through one of their Wink affiliate accounts.   - [Configuration](/customization-client): A single endpoint to retrieve whitelabel + customization information for the booking customization.  - [Lookup](/lookup): All APIs related to locating inventory by region, locale and property flags.  - [Inventory](/inventory): All APIs related to retrieve known travel inventory as it was found using the Lookup API..  - [Booking](/booking): All APIs related to creating bookings on the platform.  - [Travel Agent](/travel-agent): The Travel Agent API exposes endpoints to manage agent-facilitated bookings.   ### Produce APIs  Produce endpoints are for developers who want to create and manage travel inventory.   #### Property  - [Property registration](/extranet/property/register): As a producer, this is, oftentimes, where you start your journey. These endpoints let you create properties on Wink.  - [Property](/extranet/property): This collection of property endpoints are mostly management endpoints that let you display, change status and similar for your existing properties.  - [Facilities](/extranet/facilities): This collection of endpoints let you manage facilities; such as room types.  - [Experiences](/extranet/experiences): This collection of endpoints let you manage experiences, such as activities.  - [Monetize](/extranet/monetize): The Monetize API exposes endpoints for managing cancellation polies, rate plans, promotions and more on Wink.  - [Distribution](/extranet/distribution): The Distribution API exposes endpoints for sales channels, connecting with affiliates, managing rates and inventory calendars and more on Wink.  - [Property Booking](/extranet/booking): The Property Booking API exposes endpoints for managing bookings and reviews at the property-level.   #### Affiliate  - [Affiliate](/affiliate): This collection of affiliate endpoints are mostly management endpoints that let you display, change status and similar for your existing accounts.  - [Browse](/affiliate/browse): The Browse API exposes endpoints for affiliates to find suppliers and inventory to sell.  - [Inventory](/affiliate/inventory): The Inventory API exposes endpoints for affiliates to manage the inventory they want to sell and how they want to sell it.  - [Sales Channel](/affiliate/sales-channel): The Sales Channel API exposes endpoints for affiliates to manage existing sales channels as well as find new ones.  - [WinkLinks](/affiliate/winklinks): The WinkLinks API exposes endpoints for affiliates to manage their WinkLinks page.   #### Rate provider  - [Channel manager](/channel-manager): The Channel Manager API enables external channel manager partners to map, exchange rate / availability information with us as well as be informed of bookings that occur on the Wink platform for one of their properties.   ### Taxonomy APIs  Taxonomy endpoints are for developers who want to consume and produce travel inventory and need taxonomies of standard and non-standard codes for inventory types, classes, statuses etc.   - [Reference](/reference): All APIs related to retrieving platform-supported taxonomies.   ### Insight APIs  Insight endpoints do exactly what the name implies - They offer platform-level insight into the activities of producers and consumers.   - [Analytics](/analytics): All APIs related to tracking metrics across a wide variety of data source segments including, more entertaining, leaderboard metrics.   ### Payment APIs  Payment endpoints are for developers who want to purchase travel inventory. This can be done via the API as a registered Travel Agent or using our API in conjunction with our PCI compliant payment widget for all other entities.   - [TripPay](/payment): All APIs related to TripPay account management, booking, mapping and integration features.   ## SDKs  We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).   - Java SDK [https://github.com/wink-travel/wink-sdk-java](https://github.com/wink-travel/wink-sdk-java)   ## Usage  These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic.   ## Versioning  We chose to version our endpoints in a way that we hope affects your integration minimally. You request the version of our API you wish to work with via the `Wink-Version` header. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints.   ## Release history  - Follow updates on Github: https://github.com/wink-travel/wink-sdk-java/blob/master/CHANGELOG.md    # Extranet Experiences API This part of the documentation concerns itself with the management of experiences, on and off the property. This API lets you create:  1. Activities: Manage activities on and off the premises. 2. Attractions: Manage attractions on and off the premises. 3. Places: Manage places on and off the premises.  Browse the endpoints in the left navigation bar to get started.  

    The version of the OpenAPI document: 30.29.1
    Contact: bjorn@wink.travel
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


__version__ = "0.0.56"

# Define package exports
__all__ = [
    "ActivityApi",
    "AttractionApi",
    "PlaceApi",
    "ApiResponse",
    "ApiClient",
    "Configuration",
    "OpenApiException",
    "ApiTypeError",
    "ApiValueError",
    "ApiKeyError",
    "ApiAttributeError",
    "ApiException",
    "Activity",
    "Address",
    "AddressSupplier",
    "Attraction",
    "Contact",
    "ContactSupplier",
    "CountryLightweight",
    "CountryLightweightSupplier",
    "CustomMonetaryAmount",
    "DowPatternGroup",
    "DowPatternGroupSupplier",
    "GenericErrorMessage",
    "GeoJsonPoint",
    "GeoJsonPointSupplier",
    "GeoNameLightweight",
    "GeoNameLightweightSupplier",
    "KeyValuePair",
    "KeyValuePairSupplier",
    "MediaAuthorAttribution",
    "MediaAuthorAttributionSupplier",
    "PlaceSupplier",
    "ShowPlace400Response",
    "SimpleDescription",
    "SimpleDescriptionSupplier",
    "SimpleMultimedia",
    "SimpleMultimediaSupplier",
    "Social",
    "SocialSupplier",
    "SubCountryLightweight",
    "SubCountryLightweightSupplier",
    "SubSubCountryLightweight",
    "SubSubCountryLightweightSupplier",
    "TransactionalTravelInventory",
    "TransactionalTravelInventorySupplier",
    "TravelInventoryRecognition",
    "TravelInventoryRecognitionSupplier",
    "UpsertActivityRequest",
    "UpsertAddressRequest",
    "UpsertAddressRequestSupplier",
    "UpsertAttractionRequest",
    "UpsertPlaceRequestSupplier",
    "UpsertSimpleDescription",
    "UpsertSimpleDescriptionSupplier",
]

# import apis into sdk package
from wink_sdk_extranet_experiences.api.activity_api import ActivityApi as ActivityApi
from wink_sdk_extranet_experiences.api.attraction_api import AttractionApi as AttractionApi
from wink_sdk_extranet_experiences.api.place_api import PlaceApi as PlaceApi

# import ApiClient
from wink_sdk_extranet_experiences.api_response import ApiResponse as ApiResponse
from wink_sdk_extranet_experiences.api_client import ApiClient as ApiClient
from wink_sdk_extranet_experiences.configuration import Configuration as Configuration
from wink_sdk_extranet_experiences.exceptions import OpenApiException as OpenApiException
from wink_sdk_extranet_experiences.exceptions import ApiTypeError as ApiTypeError
from wink_sdk_extranet_experiences.exceptions import ApiValueError as ApiValueError
from wink_sdk_extranet_experiences.exceptions import ApiKeyError as ApiKeyError
from wink_sdk_extranet_experiences.exceptions import ApiAttributeError as ApiAttributeError
from wink_sdk_extranet_experiences.exceptions import ApiException as ApiException

# import models into sdk package
from wink_sdk_extranet_experiences.models.activity import Activity as Activity
from wink_sdk_extranet_experiences.models.address import Address as Address
from wink_sdk_extranet_experiences.models.address_supplier import AddressSupplier as AddressSupplier
from wink_sdk_extranet_experiences.models.attraction import Attraction as Attraction
from wink_sdk_extranet_experiences.models.contact import Contact as Contact
from wink_sdk_extranet_experiences.models.contact_supplier import ContactSupplier as ContactSupplier
from wink_sdk_extranet_experiences.models.country_lightweight import CountryLightweight as CountryLightweight
from wink_sdk_extranet_experiences.models.country_lightweight_supplier import CountryLightweightSupplier as CountryLightweightSupplier
from wink_sdk_extranet_experiences.models.custom_monetary_amount import CustomMonetaryAmount as CustomMonetaryAmount
from wink_sdk_extranet_experiences.models.dow_pattern_group import DowPatternGroup as DowPatternGroup
from wink_sdk_extranet_experiences.models.dow_pattern_group_supplier import DowPatternGroupSupplier as DowPatternGroupSupplier
from wink_sdk_extranet_experiences.models.generic_error_message import GenericErrorMessage as GenericErrorMessage
from wink_sdk_extranet_experiences.models.geo_json_point import GeoJsonPoint as GeoJsonPoint
from wink_sdk_extranet_experiences.models.geo_json_point_supplier import GeoJsonPointSupplier as GeoJsonPointSupplier
from wink_sdk_extranet_experiences.models.geo_name_lightweight import GeoNameLightweight as GeoNameLightweight
from wink_sdk_extranet_experiences.models.geo_name_lightweight_supplier import GeoNameLightweightSupplier as GeoNameLightweightSupplier
from wink_sdk_extranet_experiences.models.key_value_pair import KeyValuePair as KeyValuePair
from wink_sdk_extranet_experiences.models.key_value_pair_supplier import KeyValuePairSupplier as KeyValuePairSupplier
from wink_sdk_extranet_experiences.models.media_author_attribution import MediaAuthorAttribution as MediaAuthorAttribution
from wink_sdk_extranet_experiences.models.media_author_attribution_supplier import MediaAuthorAttributionSupplier as MediaAuthorAttributionSupplier
from wink_sdk_extranet_experiences.models.place_supplier import PlaceSupplier as PlaceSupplier
from wink_sdk_extranet_experiences.models.show_place400_response import ShowPlace400Response as ShowPlace400Response
from wink_sdk_extranet_experiences.models.simple_description import SimpleDescription as SimpleDescription
from wink_sdk_extranet_experiences.models.simple_description_supplier import SimpleDescriptionSupplier as SimpleDescriptionSupplier
from wink_sdk_extranet_experiences.models.simple_multimedia import SimpleMultimedia as SimpleMultimedia
from wink_sdk_extranet_experiences.models.simple_multimedia_supplier import SimpleMultimediaSupplier as SimpleMultimediaSupplier
from wink_sdk_extranet_experiences.models.social import Social as Social
from wink_sdk_extranet_experiences.models.social_supplier import SocialSupplier as SocialSupplier
from wink_sdk_extranet_experiences.models.sub_country_lightweight import SubCountryLightweight as SubCountryLightweight
from wink_sdk_extranet_experiences.models.sub_country_lightweight_supplier import SubCountryLightweightSupplier as SubCountryLightweightSupplier
from wink_sdk_extranet_experiences.models.sub_sub_country_lightweight import SubSubCountryLightweight as SubSubCountryLightweight
from wink_sdk_extranet_experiences.models.sub_sub_country_lightweight_supplier import SubSubCountryLightweightSupplier as SubSubCountryLightweightSupplier
from wink_sdk_extranet_experiences.models.transactional_travel_inventory import TransactionalTravelInventory as TransactionalTravelInventory
from wink_sdk_extranet_experiences.models.transactional_travel_inventory_supplier import TransactionalTravelInventorySupplier as TransactionalTravelInventorySupplier
from wink_sdk_extranet_experiences.models.travel_inventory_recognition import TravelInventoryRecognition as TravelInventoryRecognition
from wink_sdk_extranet_experiences.models.travel_inventory_recognition_supplier import TravelInventoryRecognitionSupplier as TravelInventoryRecognitionSupplier
from wink_sdk_extranet_experiences.models.upsert_activity_request import UpsertActivityRequest as UpsertActivityRequest
from wink_sdk_extranet_experiences.models.upsert_address_request import UpsertAddressRequest as UpsertAddressRequest
from wink_sdk_extranet_experiences.models.upsert_address_request_supplier import UpsertAddressRequestSupplier as UpsertAddressRequestSupplier
from wink_sdk_extranet_experiences.models.upsert_attraction_request import UpsertAttractionRequest as UpsertAttractionRequest
from wink_sdk_extranet_experiences.models.upsert_place_request_supplier import UpsertPlaceRequestSupplier as UpsertPlaceRequestSupplier
from wink_sdk_extranet_experiences.models.upsert_simple_description import UpsertSimpleDescription as UpsertSimpleDescription
from wink_sdk_extranet_experiences.models.upsert_simple_description_supplier import UpsertSimpleDescriptionSupplier as UpsertSimpleDescriptionSupplier

