# coding=utf-8
# pylint: disable=too-many-lines
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from typing import Any, Dict, List, Optional, TYPE_CHECKING, Union

from ... import _serialization

if TYPE_CHECKING:
    # pylint: disable=unused-import,ungrouped-imports
    from .. import models as _models


class AccessPolicyEntry(_serialization.Model):
    """An identity that have access to the key vault. All identities in the array must use the same
    tenant ID as the key vault's tenant ID.

    All required parameters must be populated in order to send to Azure.

    :ivar tenant_id: The Azure Active Directory tenant ID that should be used for authenticating
     requests to the key vault. Required.
    :vartype tenant_id: str
    :ivar object_id: The object ID of a user, service principal or security group in the Azure
     Active Directory tenant for the vault. The object ID must be unique for the list of access
     policies. Required.
    :vartype object_id: str
    :ivar application_id: Application ID of the client making request on behalf of a principal.
    :vartype application_id: str
    :ivar permissions: Permissions the identity has for keys, secrets and certificates. Required.
    :vartype permissions: ~azure.mgmt.keyvault.v2016_10_01.models.Permissions
    """

    _validation = {
        "tenant_id": {"required": True},
        "object_id": {"required": True},
        "permissions": {"required": True},
    }

    _attribute_map = {
        "tenant_id": {"key": "tenantId", "type": "str"},
        "object_id": {"key": "objectId", "type": "str"},
        "application_id": {"key": "applicationId", "type": "str"},
        "permissions": {"key": "permissions", "type": "Permissions"},
    }

    def __init__(
        self,
        *,
        tenant_id: str,
        object_id: str,
        permissions: "_models.Permissions",
        application_id: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword tenant_id: The Azure Active Directory tenant ID that should be used for authenticating
         requests to the key vault. Required.
        :paramtype tenant_id: str
        :keyword object_id: The object ID of a user, service principal or security group in the Azure
         Active Directory tenant for the vault. The object ID must be unique for the list of access
         policies. Required.
        :paramtype object_id: str
        :keyword application_id: Application ID of the client making request on behalf of a principal.
        :paramtype application_id: str
        :keyword permissions: Permissions the identity has for keys, secrets and certificates.
         Required.
        :paramtype permissions: ~azure.mgmt.keyvault.v2016_10_01.models.Permissions
        """
        super().__init__(**kwargs)
        self.tenant_id = tenant_id
        self.object_id = object_id
        self.application_id = application_id
        self.permissions = permissions


class CheckNameAvailabilityResult(_serialization.Model):
    """The CheckNameAvailability operation response.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name_available: A boolean value that indicates whether the name is available for you to
     use. If true, the name is available. If false, the name has already been taken or is invalid
     and cannot be used.
    :vartype name_available: bool
    :ivar reason: The reason that a vault name could not be used. The Reason element is only
     returned if NameAvailable is false. Known values are: "AccountNameInvalid" and "AlreadyExists".
    :vartype reason: str or ~azure.mgmt.keyvault.v2016_10_01.models.Reason
    :ivar message: An error message explaining the Reason value in more detail.
    :vartype message: str
    """

    _validation = {
        "name_available": {"readonly": True},
        "reason": {"readonly": True},
        "message": {"readonly": True},
    }

    _attribute_map = {
        "name_available": {"key": "nameAvailable", "type": "bool"},
        "reason": {"key": "reason", "type": "str"},
        "message": {"key": "message", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.name_available = None
        self.reason = None
        self.message = None


class DeletedVault(_serialization.Model):
    """Deleted vault information with extended details.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The resource ID for the deleted key vault.
    :vartype id: str
    :ivar name: The name of the key vault.
    :vartype name: str
    :ivar type: The resource type of the key vault.
    :vartype type: str
    :ivar properties: Properties of the vault.
    :vartype properties: ~azure.mgmt.keyvault.v2016_10_01.models.DeletedVaultProperties
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "properties": {"key": "properties", "type": "DeletedVaultProperties"},
    }

    def __init__(self, *, properties: Optional["_models.DeletedVaultProperties"] = None, **kwargs: Any) -> None:
        """
        :keyword properties: Properties of the vault.
        :paramtype properties: ~azure.mgmt.keyvault.v2016_10_01.models.DeletedVaultProperties
        """
        super().__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.properties = properties


class DeletedVaultListResult(_serialization.Model):
    """List of vaults.

    :ivar value: The list of deleted vaults.
    :vartype value: list[~azure.mgmt.keyvault.v2016_10_01.models.DeletedVault]
    :ivar next_link: The URL to get the next set of deleted vaults.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[DeletedVault]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: Optional[List["_models.DeletedVault"]] = None, next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: The list of deleted vaults.
        :paramtype value: list[~azure.mgmt.keyvault.v2016_10_01.models.DeletedVault]
        :keyword next_link: The URL to get the next set of deleted vaults.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class DeletedVaultProperties(_serialization.Model):
    """Properties of the deleted vault.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar vault_id: The resource id of the original vault.
    :vartype vault_id: str
    :ivar location: The location of the original vault.
    :vartype location: str
    :ivar deletion_date: The deleted date.
    :vartype deletion_date: ~datetime.datetime
    :ivar scheduled_purge_date: The scheduled purged date.
    :vartype scheduled_purge_date: ~datetime.datetime
    :ivar tags: Tags of the original vault.
    :vartype tags: dict[str, str]
    """

    _validation = {
        "vault_id": {"readonly": True},
        "location": {"readonly": True},
        "deletion_date": {"readonly": True},
        "scheduled_purge_date": {"readonly": True},
        "tags": {"readonly": True},
    }

    _attribute_map = {
        "vault_id": {"key": "vaultId", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "deletion_date": {"key": "deletionDate", "type": "iso-8601"},
        "scheduled_purge_date": {"key": "scheduledPurgeDate", "type": "iso-8601"},
        "tags": {"key": "tags", "type": "{str}"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.vault_id = None
        self.location = None
        self.deletion_date = None
        self.scheduled_purge_date = None
        self.tags = None


class LogSpecification(_serialization.Model):
    """Log specification of operation.

    :ivar name: Name of log specification.
    :vartype name: str
    :ivar display_name: Display name of log specification.
    :vartype display_name: str
    :ivar blob_duration: Blob duration of specification.
    :vartype blob_duration: str
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "display_name": {"key": "displayName", "type": "str"},
        "blob_duration": {"key": "blobDuration", "type": "str"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        display_name: Optional[str] = None,
        blob_duration: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: Name of log specification.
        :paramtype name: str
        :keyword display_name: Display name of log specification.
        :paramtype display_name: str
        :keyword blob_duration: Blob duration of specification.
        :paramtype blob_duration: str
        """
        super().__init__(**kwargs)
        self.name = name
        self.display_name = display_name
        self.blob_duration = blob_duration


class Operation(_serialization.Model):
    """Key Vault REST API operation definition.

    :ivar name: Operation name: {provider}/{resource}/{operation}.
    :vartype name: str
    :ivar display: Display metadata associated with the operation.
    :vartype display: ~azure.mgmt.keyvault.v2016_10_01.models.OperationDisplay
    :ivar origin: The origin of operations.
    :vartype origin: str
    :ivar service_specification: One property of operation, include metric specifications.
    :vartype service_specification: ~azure.mgmt.keyvault.v2016_10_01.models.ServiceSpecification
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "display": {"key": "display", "type": "OperationDisplay"},
        "origin": {"key": "origin", "type": "str"},
        "service_specification": {"key": "properties.serviceSpecification", "type": "ServiceSpecification"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        display: Optional["_models.OperationDisplay"] = None,
        origin: Optional[str] = None,
        service_specification: Optional["_models.ServiceSpecification"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: Operation name: {provider}/{resource}/{operation}.
        :paramtype name: str
        :keyword display: Display metadata associated with the operation.
        :paramtype display: ~azure.mgmt.keyvault.v2016_10_01.models.OperationDisplay
        :keyword origin: The origin of operations.
        :paramtype origin: str
        :keyword service_specification: One property of operation, include metric specifications.
        :paramtype service_specification: ~azure.mgmt.keyvault.v2016_10_01.models.ServiceSpecification
        """
        super().__init__(**kwargs)
        self.name = name
        self.display = display
        self.origin = origin
        self.service_specification = service_specification


class OperationDisplay(_serialization.Model):
    """Display metadata associated with the operation.

    :ivar provider: Service provider: Microsoft Key Vault.
    :vartype provider: str
    :ivar resource: Resource on which the operation is performed etc.
    :vartype resource: str
    :ivar operation: Type of operation: get, read, delete, etc.
    :vartype operation: str
    :ivar description: Description of operation.
    :vartype description: str
    """

    _attribute_map = {
        "provider": {"key": "provider", "type": "str"},
        "resource": {"key": "resource", "type": "str"},
        "operation": {"key": "operation", "type": "str"},
        "description": {"key": "description", "type": "str"},
    }

    def __init__(
        self,
        *,
        provider: Optional[str] = None,
        resource: Optional[str] = None,
        operation: Optional[str] = None,
        description: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword provider: Service provider: Microsoft Key Vault.
        :paramtype provider: str
        :keyword resource: Resource on which the operation is performed etc.
        :paramtype resource: str
        :keyword operation: Type of operation: get, read, delete, etc.
        :paramtype operation: str
        :keyword description: Description of operation.
        :paramtype description: str
        """
        super().__init__(**kwargs)
        self.provider = provider
        self.resource = resource
        self.operation = operation
        self.description = description


class OperationListResult(_serialization.Model):
    """Result of the request to list Storage operations. It contains a list of operations and a URL
    link to get the next set of results.

    :ivar value: List of Storage operations supported by the Storage resource provider.
    :vartype value: list[~azure.mgmt.keyvault.v2016_10_01.models.Operation]
    :ivar next_link: The URL to get the next set of operations.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[Operation]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: Optional[List["_models.Operation"]] = None, next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: List of Storage operations supported by the Storage resource provider.
        :paramtype value: list[~azure.mgmt.keyvault.v2016_10_01.models.Operation]
        :keyword next_link: The URL to get the next set of operations.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class Permissions(_serialization.Model):
    """Permissions the identity has for keys, secrets, certificates and storage.

    :ivar keys: Permissions to keys.
    :vartype keys: list[str or ~azure.mgmt.keyvault.v2016_10_01.models.KeyPermissions]
    :ivar secrets: Permissions to secrets.
    :vartype secrets: list[str or ~azure.mgmt.keyvault.v2016_10_01.models.SecretPermissions]
    :ivar certificates: Permissions to certificates.
    :vartype certificates: list[str or
     ~azure.mgmt.keyvault.v2016_10_01.models.CertificatePermissions]
    :ivar storage: Permissions to storage accounts.
    :vartype storage: list[str or ~azure.mgmt.keyvault.v2016_10_01.models.StoragePermissions]
    """

    _attribute_map = {
        "keys": {"key": "keys", "type": "[str]"},
        "secrets": {"key": "secrets", "type": "[str]"},
        "certificates": {"key": "certificates", "type": "[str]"},
        "storage": {"key": "storage", "type": "[str]"},
    }

    def __init__(
        self,
        *,
        keys: Optional[List[Union[str, "_models.KeyPermissions"]]] = None,
        secrets: Optional[List[Union[str, "_models.SecretPermissions"]]] = None,
        certificates: Optional[List[Union[str, "_models.CertificatePermissions"]]] = None,
        storage: Optional[List[Union[str, "_models.StoragePermissions"]]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword keys: Permissions to keys.
        :paramtype keys: list[str or ~azure.mgmt.keyvault.v2016_10_01.models.KeyPermissions]
        :keyword secrets: Permissions to secrets.
        :paramtype secrets: list[str or ~azure.mgmt.keyvault.v2016_10_01.models.SecretPermissions]
        :keyword certificates: Permissions to certificates.
        :paramtype certificates: list[str or
         ~azure.mgmt.keyvault.v2016_10_01.models.CertificatePermissions]
        :keyword storage: Permissions to storage accounts.
        :paramtype storage: list[str or ~azure.mgmt.keyvault.v2016_10_01.models.StoragePermissions]
        """
        super().__init__(**kwargs)
        self.keys = keys
        self.secrets = secrets
        self.certificates = certificates
        self.storage = storage


class Resource(_serialization.Model):
    """Key Vault resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: The Azure Resource Manager resource ID for the key vault.
    :vartype id: str
    :ivar name: The name of the key vault.
    :vartype name: str
    :ivar type: The resource type of the key vault.
    :vartype type: str
    :ivar location: The supported Azure location where the key vault should be created. Required.
    :vartype location: str
    :ivar tags: The tags that will be assigned to the key vault.
    :vartype tags: dict[str, str]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "location": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
    }

    def __init__(self, *, location: str, tags: Optional[Dict[str, str]] = None, **kwargs: Any) -> None:
        """
        :keyword location: The supported Azure location where the key vault should be created.
         Required.
        :paramtype location: str
        :keyword tags: The tags that will be assigned to the key vault.
        :paramtype tags: dict[str, str]
        """
        super().__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.location = location
        self.tags = tags


class ResourceListResult(_serialization.Model):
    """List of vault resources.

    :ivar value: The list of vault resources.
    :vartype value: list[~azure.mgmt.keyvault.v2016_10_01.models.Resource]
    :ivar next_link: The URL to get the next set of vault resources.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[Resource]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: Optional[List["_models.Resource"]] = None, next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: The list of vault resources.
        :paramtype value: list[~azure.mgmt.keyvault.v2016_10_01.models.Resource]
        :keyword next_link: The URL to get the next set of vault resources.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class ServiceSpecification(_serialization.Model):
    """One property of operation, include log specifications.

    :ivar log_specifications: Log specifications of operation.
    :vartype log_specifications: list[~azure.mgmt.keyvault.v2016_10_01.models.LogSpecification]
    """

    _attribute_map = {
        "log_specifications": {"key": "logSpecifications", "type": "[LogSpecification]"},
    }

    def __init__(self, *, log_specifications: Optional[List["_models.LogSpecification"]] = None, **kwargs: Any) -> None:
        """
        :keyword log_specifications: Log specifications of operation.
        :paramtype log_specifications: list[~azure.mgmt.keyvault.v2016_10_01.models.LogSpecification]
        """
        super().__init__(**kwargs)
        self.log_specifications = log_specifications


class Sku(_serialization.Model):
    """SKU details.

    All required parameters must be populated in order to send to Azure.

    :ivar family: SKU family name. Required. "A"
    :vartype family: str or ~azure.mgmt.keyvault.v2016_10_01.models.SkuFamily
    :ivar name: SKU name to specify whether the key vault is a standard vault or a premium vault.
     Required. Known values are: "standard" and "premium".
    :vartype name: str or ~azure.mgmt.keyvault.v2016_10_01.models.SkuName
    """

    _validation = {
        "family": {"required": True},
        "name": {"required": True},
    }

    _attribute_map = {
        "family": {"key": "family", "type": "str"},
        "name": {"key": "name", "type": "str"},
    }

    def __init__(
        self, *, family: Union[str, "_models.SkuFamily"], name: Union[str, "_models.SkuName"], **kwargs: Any
    ) -> None:
        """
        :keyword family: SKU family name. Required. "A"
        :paramtype family: str or ~azure.mgmt.keyvault.v2016_10_01.models.SkuFamily
        :keyword name: SKU name to specify whether the key vault is a standard vault or a premium
         vault. Required. Known values are: "standard" and "premium".
        :paramtype name: str or ~azure.mgmt.keyvault.v2016_10_01.models.SkuName
        """
        super().__init__(**kwargs)
        self.family = family
        self.name = name


class Vault(Resource):
    """Resource information with extended details.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: The Azure Resource Manager resource ID for the key vault.
    :vartype id: str
    :ivar name: The name of the key vault.
    :vartype name: str
    :ivar type: The resource type of the key vault.
    :vartype type: str
    :ivar location: The supported Azure location where the key vault should be created. Required.
    :vartype location: str
    :ivar tags: The tags that will be assigned to the key vault.
    :vartype tags: dict[str, str]
    :ivar properties: Properties of the vault. Required.
    :vartype properties: ~azure.mgmt.keyvault.v2016_10_01.models.VaultProperties
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "location": {"required": True},
        "properties": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "properties": {"key": "properties", "type": "VaultProperties"},
    }

    def __init__(
        self,
        *,
        location: str,
        properties: "_models.VaultProperties",
        tags: Optional[Dict[str, str]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword location: The supported Azure location where the key vault should be created.
         Required.
        :paramtype location: str
        :keyword tags: The tags that will be assigned to the key vault.
        :paramtype tags: dict[str, str]
        :keyword properties: Properties of the vault. Required.
        :paramtype properties: ~azure.mgmt.keyvault.v2016_10_01.models.VaultProperties
        """
        super().__init__(location=location, tags=tags, **kwargs)
        self.properties = properties


class VaultAccessPolicyParameters(_serialization.Model):
    """Parameters for updating the access policy in a vault.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: The resource id of the access policy.
    :vartype id: str
    :ivar name: The resource name of the access policy.
    :vartype name: str
    :ivar type: The resource name of the access policy.
    :vartype type: str
    :ivar location: The resource type of the access policy.
    :vartype location: str
    :ivar properties: Properties of the access policy. Required.
    :vartype properties: ~azure.mgmt.keyvault.v2016_10_01.models.VaultAccessPolicyProperties
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "location": {"readonly": True},
        "properties": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "properties": {"key": "properties", "type": "VaultAccessPolicyProperties"},
    }

    def __init__(self, *, properties: "_models.VaultAccessPolicyProperties", **kwargs: Any) -> None:
        """
        :keyword properties: Properties of the access policy. Required.
        :paramtype properties: ~azure.mgmt.keyvault.v2016_10_01.models.VaultAccessPolicyProperties
        """
        super().__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.location = None
        self.properties = properties


class VaultAccessPolicyProperties(_serialization.Model):
    """Properties of the vault access policy.

    All required parameters must be populated in order to send to Azure.

    :ivar access_policies: An array of 0 to 16 identities that have access to the key vault. All
     identities in the array must use the same tenant ID as the key vault's tenant ID. Required.
    :vartype access_policies: list[~azure.mgmt.keyvault.v2016_10_01.models.AccessPolicyEntry]
    """

    _validation = {
        "access_policies": {"required": True},
    }

    _attribute_map = {
        "access_policies": {"key": "accessPolicies", "type": "[AccessPolicyEntry]"},
    }

    def __init__(self, *, access_policies: List["_models.AccessPolicyEntry"], **kwargs: Any) -> None:
        """
        :keyword access_policies: An array of 0 to 16 identities that have access to the key vault. All
         identities in the array must use the same tenant ID as the key vault's tenant ID. Required.
        :paramtype access_policies: list[~azure.mgmt.keyvault.v2016_10_01.models.AccessPolicyEntry]
        """
        super().__init__(**kwargs)
        self.access_policies = access_policies


class VaultCheckNameAvailabilityParameters(_serialization.Model):
    """The parameters used to check the availability of the vault name.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar name: The vault name. Required.
    :vartype name: str
    :ivar type: The type of resource, Microsoft.KeyVault/vaults. Required. Default value is
     "Microsoft.KeyVault/vaults".
    :vartype type: str
    """

    _validation = {
        "name": {"required": True},
        "type": {"required": True, "constant": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
    }

    type = "Microsoft.KeyVault/vaults"

    def __init__(self, *, name: str, **kwargs: Any) -> None:
        """
        :keyword name: The vault name. Required.
        :paramtype name: str
        """
        super().__init__(**kwargs)
        self.name = name


class VaultCreateOrUpdateParameters(_serialization.Model):
    """Parameters for creating or updating a vault.

    All required parameters must be populated in order to send to Azure.

    :ivar location: The supported Azure location where the key vault should be created. Required.
    :vartype location: str
    :ivar tags: The tags that will be assigned to the key vault.
    :vartype tags: dict[str, str]
    :ivar properties: Properties of the vault. Required.
    :vartype properties: ~azure.mgmt.keyvault.v2016_10_01.models.VaultProperties
    """

    _validation = {
        "location": {"required": True},
        "properties": {"required": True},
    }

    _attribute_map = {
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "properties": {"key": "properties", "type": "VaultProperties"},
    }

    def __init__(
        self,
        *,
        location: str,
        properties: "_models.VaultProperties",
        tags: Optional[Dict[str, str]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword location: The supported Azure location where the key vault should be created.
         Required.
        :paramtype location: str
        :keyword tags: The tags that will be assigned to the key vault.
        :paramtype tags: dict[str, str]
        :keyword properties: Properties of the vault. Required.
        :paramtype properties: ~azure.mgmt.keyvault.v2016_10_01.models.VaultProperties
        """
        super().__init__(**kwargs)
        self.location = location
        self.tags = tags
        self.properties = properties


class VaultListResult(_serialization.Model):
    """List of vaults.

    :ivar value: The list of vaults.
    :vartype value: list[~azure.mgmt.keyvault.v2016_10_01.models.Vault]
    :ivar next_link: The URL to get the next set of vaults.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[Vault]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: Optional[List["_models.Vault"]] = None, next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: The list of vaults.
        :paramtype value: list[~azure.mgmt.keyvault.v2016_10_01.models.Vault]
        :keyword next_link: The URL to get the next set of vaults.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class VaultPatchParameters(_serialization.Model):
    """Parameters for creating or updating a vault.

    :ivar tags: The tags that will be assigned to the key vault.
    :vartype tags: dict[str, str]
    :ivar properties: Properties of the vault.
    :vartype properties: ~azure.mgmt.keyvault.v2016_10_01.models.VaultPatchProperties
    """

    _attribute_map = {
        "tags": {"key": "tags", "type": "{str}"},
        "properties": {"key": "properties", "type": "VaultPatchProperties"},
    }

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        properties: Optional["_models.VaultPatchProperties"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword tags: The tags that will be assigned to the key vault.
        :paramtype tags: dict[str, str]
        :keyword properties: Properties of the vault.
        :paramtype properties: ~azure.mgmt.keyvault.v2016_10_01.models.VaultPatchProperties
        """
        super().__init__(**kwargs)
        self.tags = tags
        self.properties = properties


class VaultPatchProperties(_serialization.Model):
    """Properties of the vault.

    :ivar tenant_id: The Azure Active Directory tenant ID that should be used for authenticating
     requests to the key vault.
    :vartype tenant_id: str
    :ivar sku: SKU details.
    :vartype sku: ~azure.mgmt.keyvault.v2016_10_01.models.Sku
    :ivar access_policies: An array of 0 to 16 identities that have access to the key vault. All
     identities in the array must use the same tenant ID as the key vault's tenant ID.
    :vartype access_policies: list[~azure.mgmt.keyvault.v2016_10_01.models.AccessPolicyEntry]
    :ivar enabled_for_deployment: Property to specify whether Azure Virtual Machines are permitted
     to retrieve certificates stored as secrets from the key vault.
    :vartype enabled_for_deployment: bool
    :ivar enabled_for_disk_encryption: Property to specify whether Azure Disk Encryption is
     permitted to retrieve secrets from the vault and unwrap keys.
    :vartype enabled_for_disk_encryption: bool
    :ivar enabled_for_template_deployment: Property to specify whether Azure Resource Manager is
     permitted to retrieve secrets from the key vault.
    :vartype enabled_for_template_deployment: bool
    :ivar enable_soft_delete: Property specifying whether recoverable deletion ('soft' delete) is
     enabled for this key vault. The property may not be set to false.
    :vartype enable_soft_delete: bool
    :ivar create_mode: The vault's create mode to indicate whether the vault need to be recovered
     or not. Known values are: "recover" and "default".
    :vartype create_mode: str or ~azure.mgmt.keyvault.v2016_10_01.models.CreateMode
    :ivar enable_purge_protection: Property specifying whether protection against purge is enabled
     for this vault; it is only effective if soft delete is also enabled. Once activated, the
     property may no longer be reset to false.
    :vartype enable_purge_protection: bool
    """

    _attribute_map = {
        "tenant_id": {"key": "tenantId", "type": "str"},
        "sku": {"key": "sku", "type": "Sku"},
        "access_policies": {"key": "accessPolicies", "type": "[AccessPolicyEntry]"},
        "enabled_for_deployment": {"key": "enabledForDeployment", "type": "bool"},
        "enabled_for_disk_encryption": {"key": "enabledForDiskEncryption", "type": "bool"},
        "enabled_for_template_deployment": {"key": "enabledForTemplateDeployment", "type": "bool"},
        "enable_soft_delete": {"key": "enableSoftDelete", "type": "bool"},
        "create_mode": {"key": "createMode", "type": "str"},
        "enable_purge_protection": {"key": "enablePurgeProtection", "type": "bool"},
    }

    def __init__(
        self,
        *,
        tenant_id: Optional[str] = None,
        sku: Optional["_models.Sku"] = None,
        access_policies: Optional[List["_models.AccessPolicyEntry"]] = None,
        enabled_for_deployment: Optional[bool] = None,
        enabled_for_disk_encryption: Optional[bool] = None,
        enabled_for_template_deployment: Optional[bool] = None,
        enable_soft_delete: Optional[bool] = None,
        create_mode: Optional[Union[str, "_models.CreateMode"]] = None,
        enable_purge_protection: Optional[bool] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword tenant_id: The Azure Active Directory tenant ID that should be used for authenticating
         requests to the key vault.
        :paramtype tenant_id: str
        :keyword sku: SKU details.
        :paramtype sku: ~azure.mgmt.keyvault.v2016_10_01.models.Sku
        :keyword access_policies: An array of 0 to 16 identities that have access to the key vault. All
         identities in the array must use the same tenant ID as the key vault's tenant ID.
        :paramtype access_policies: list[~azure.mgmt.keyvault.v2016_10_01.models.AccessPolicyEntry]
        :keyword enabled_for_deployment: Property to specify whether Azure Virtual Machines are
         permitted to retrieve certificates stored as secrets from the key vault.
        :paramtype enabled_for_deployment: bool
        :keyword enabled_for_disk_encryption: Property to specify whether Azure Disk Encryption is
         permitted to retrieve secrets from the vault and unwrap keys.
        :paramtype enabled_for_disk_encryption: bool
        :keyword enabled_for_template_deployment: Property to specify whether Azure Resource Manager is
         permitted to retrieve secrets from the key vault.
        :paramtype enabled_for_template_deployment: bool
        :keyword enable_soft_delete: Property specifying whether recoverable deletion ('soft' delete)
         is enabled for this key vault. The property may not be set to false.
        :paramtype enable_soft_delete: bool
        :keyword create_mode: The vault's create mode to indicate whether the vault need to be
         recovered or not. Known values are: "recover" and "default".
        :paramtype create_mode: str or ~azure.mgmt.keyvault.v2016_10_01.models.CreateMode
        :keyword enable_purge_protection: Property specifying whether protection against purge is
         enabled for this vault; it is only effective if soft delete is also enabled. Once activated,
         the property may no longer be reset to false.
        :paramtype enable_purge_protection: bool
        """
        super().__init__(**kwargs)
        self.tenant_id = tenant_id
        self.sku = sku
        self.access_policies = access_policies
        self.enabled_for_deployment = enabled_for_deployment
        self.enabled_for_disk_encryption = enabled_for_disk_encryption
        self.enabled_for_template_deployment = enabled_for_template_deployment
        self.enable_soft_delete = enable_soft_delete
        self.create_mode = create_mode
        self.enable_purge_protection = enable_purge_protection


class VaultProperties(_serialization.Model):
    """Properties of the vault.

    All required parameters must be populated in order to send to Azure.

    :ivar tenant_id: The Azure Active Directory tenant ID that should be used for authenticating
     requests to the key vault. Required.
    :vartype tenant_id: str
    :ivar sku: SKU details. Required.
    :vartype sku: ~azure.mgmt.keyvault.v2016_10_01.models.Sku
    :ivar access_policies: An array of 0 to 16 identities that have access to the key vault. All
     identities in the array must use the same tenant ID as the key vault's tenant ID. When
     ``createMode`` is set to ``recover``\ , access policies are not required. Otherwise, access
     policies are required.
    :vartype access_policies: list[~azure.mgmt.keyvault.v2016_10_01.models.AccessPolicyEntry]
    :ivar vault_uri: The URI of the vault for performing operations on keys and secrets.
    :vartype vault_uri: str
    :ivar enabled_for_deployment: Property to specify whether Azure Virtual Machines are permitted
     to retrieve certificates stored as secrets from the key vault.
    :vartype enabled_for_deployment: bool
    :ivar enabled_for_disk_encryption: Property to specify whether Azure Disk Encryption is
     permitted to retrieve secrets from the vault and unwrap keys.
    :vartype enabled_for_disk_encryption: bool
    :ivar enabled_for_template_deployment: Property to specify whether Azure Resource Manager is
     permitted to retrieve secrets from the key vault.
    :vartype enabled_for_template_deployment: bool
    :ivar enable_soft_delete: Property specifying whether recoverable deletion is enabled for this
     key vault. Setting this property to true activates the soft delete feature, whereby vaults or
     vault entities can be recovered after deletion. Enabling this functionality is irreversible -
     that is, the property does not accept false as its value.
    :vartype enable_soft_delete: bool
    :ivar create_mode: The vault's create mode to indicate whether the vault need to be recovered
     or not. Known values are: "recover" and "default".
    :vartype create_mode: str or ~azure.mgmt.keyvault.v2016_10_01.models.CreateMode
    :ivar enable_purge_protection: Property specifying whether protection against purge is enabled
     for this vault. Setting this property to true activates protection against purge for this vault
     and its content - only the Key Vault service may initiate a hard, irrecoverable deletion. The
     setting is effective only if soft delete is also enabled. Enabling this functionality is
     irreversible - that is, the property does not accept false as its value.
    :vartype enable_purge_protection: bool
    """

    _validation = {
        "tenant_id": {"required": True},
        "sku": {"required": True},
    }

    _attribute_map = {
        "tenant_id": {"key": "tenantId", "type": "str"},
        "sku": {"key": "sku", "type": "Sku"},
        "access_policies": {"key": "accessPolicies", "type": "[AccessPolicyEntry]"},
        "vault_uri": {"key": "vaultUri", "type": "str"},
        "enabled_for_deployment": {"key": "enabledForDeployment", "type": "bool"},
        "enabled_for_disk_encryption": {"key": "enabledForDiskEncryption", "type": "bool"},
        "enabled_for_template_deployment": {"key": "enabledForTemplateDeployment", "type": "bool"},
        "enable_soft_delete": {"key": "enableSoftDelete", "type": "bool"},
        "create_mode": {"key": "createMode", "type": "str"},
        "enable_purge_protection": {"key": "enablePurgeProtection", "type": "bool"},
    }

    def __init__(
        self,
        *,
        tenant_id: str,
        sku: "_models.Sku",
        access_policies: Optional[List["_models.AccessPolicyEntry"]] = None,
        vault_uri: Optional[str] = None,
        enabled_for_deployment: Optional[bool] = None,
        enabled_for_disk_encryption: Optional[bool] = None,
        enabled_for_template_deployment: Optional[bool] = None,
        enable_soft_delete: Optional[bool] = None,
        create_mode: Optional[Union[str, "_models.CreateMode"]] = None,
        enable_purge_protection: Optional[bool] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword tenant_id: The Azure Active Directory tenant ID that should be used for authenticating
         requests to the key vault. Required.
        :paramtype tenant_id: str
        :keyword sku: SKU details. Required.
        :paramtype sku: ~azure.mgmt.keyvault.v2016_10_01.models.Sku
        :keyword access_policies: An array of 0 to 16 identities that have access to the key vault. All
         identities in the array must use the same tenant ID as the key vault's tenant ID. When
         ``createMode`` is set to ``recover``\ , access policies are not required. Otherwise, access
         policies are required.
        :paramtype access_policies: list[~azure.mgmt.keyvault.v2016_10_01.models.AccessPolicyEntry]
        :keyword vault_uri: The URI of the vault for performing operations on keys and secrets.
        :paramtype vault_uri: str
        :keyword enabled_for_deployment: Property to specify whether Azure Virtual Machines are
         permitted to retrieve certificates stored as secrets from the key vault.
        :paramtype enabled_for_deployment: bool
        :keyword enabled_for_disk_encryption: Property to specify whether Azure Disk Encryption is
         permitted to retrieve secrets from the vault and unwrap keys.
        :paramtype enabled_for_disk_encryption: bool
        :keyword enabled_for_template_deployment: Property to specify whether Azure Resource Manager is
         permitted to retrieve secrets from the key vault.
        :paramtype enabled_for_template_deployment: bool
        :keyword enable_soft_delete: Property specifying whether recoverable deletion is enabled for
         this key vault. Setting this property to true activates the soft delete feature, whereby vaults
         or vault entities can be recovered after deletion. Enabling this functionality is irreversible
         - that is, the property does not accept false as its value.
        :paramtype enable_soft_delete: bool
        :keyword create_mode: The vault's create mode to indicate whether the vault need to be
         recovered or not. Known values are: "recover" and "default".
        :paramtype create_mode: str or ~azure.mgmt.keyvault.v2016_10_01.models.CreateMode
        :keyword enable_purge_protection: Property specifying whether protection against purge is
         enabled for this vault. Setting this property to true activates protection against purge for
         this vault and its content - only the Key Vault service may initiate a hard, irrecoverable
         deletion. The setting is effective only if soft delete is also enabled. Enabling this
         functionality is irreversible - that is, the property does not accept false as its value.
        :paramtype enable_purge_protection: bool
        """
        super().__init__(**kwargs)
        self.tenant_id = tenant_id
        self.sku = sku
        self.access_policies = access_policies
        self.vault_uri = vault_uri
        self.enabled_for_deployment = enabled_for_deployment
        self.enabled_for_disk_encryption = enabled_for_disk_encryption
        self.enabled_for_template_deployment = enabled_for_template_deployment
        self.enable_soft_delete = enable_soft_delete
        self.create_mode = create_mode
        self.enable_purge_protection = enable_purge_protection
