# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from enum import Enum
from azure.core import CaseInsensitiveEnumMeta


class AccessPolicyUpdateKind(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """AccessPolicyUpdateKind."""

    ADD = "add"
    REPLACE = "replace"
    REMOVE = "remove"


class CertificatePermissions(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """CertificatePermissions."""

    GET = "get"
    LIST = "list"
    DELETE = "delete"
    CREATE = "create"
    IMPORT = "import"
    UPDATE = "update"
    MANAGECONTACTS = "managecontacts"
    GETISSUERS = "getissuers"
    LISTISSUERS = "listissuers"
    SETISSUERS = "setissuers"
    DELETEISSUERS = "deleteissuers"
    MANAGEISSUERS = "manageissuers"
    RECOVER = "recover"
    PURGE = "purge"


class CreateMode(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The vault's create mode to indicate whether the vault need to be recovered or not."""

    RECOVER = "recover"
    DEFAULT = "default"


class Enum5(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Enum5."""

    RESOURCE_TYPE_EQ_MICROSOFT_KEY_VAULT_VAULTS_ = "resourceType eq 'Microsoft.KeyVault/vaults'"


class Enum6(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Enum6."""

    TWO_THOUSAND_FIFTEEN11_01 = "2015-11-01"


class KeyPermissions(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """KeyPermissions."""

    ENCRYPT = "encrypt"
    DECRYPT = "decrypt"
    WRAP_KEY = "wrapKey"
    UNWRAP_KEY = "unwrapKey"
    SIGN = "sign"
    VERIFY = "verify"
    GET = "get"
    LIST = "list"
    CREATE = "create"
    UPDATE = "update"
    IMPORT = "import"
    DELETE = "delete"
    BACKUP = "backup"
    RESTORE = "restore"
    RECOVER = "recover"
    PURGE = "purge"


class Reason(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The reason that a vault name could not be used. The Reason element is only returned if
    NameAvailable is false.
    """

    ACCOUNT_NAME_INVALID = "AccountNameInvalid"
    ALREADY_EXISTS = "AlreadyExists"


class SecretPermissions(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """SecretPermissions."""

    GET = "get"
    LIST = "list"
    SET = "set"
    DELETE = "delete"
    BACKUP = "backup"
    RESTORE = "restore"
    RECOVER = "recover"
    PURGE = "purge"


class SkuFamily(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """SKU family name."""

    A = "A"


class SkuName(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """SKU name to specify whether the key vault is a standard vault or a premium vault."""

    STANDARD = "standard"
    PREMIUM = "premium"


class StoragePermissions(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """StoragePermissions."""

    GET = "get"
    LIST = "list"
    DELETE = "delete"
    SET = "set"
    UPDATE = "update"
    REGENERATEKEY = "regeneratekey"
    RECOVER = "recover"
    PURGE = "purge"
    BACKUP = "backup"
    RESTORE = "restore"
    SETSAS = "setsas"
    LISTSAS = "listsas"
    GETSAS = "getsas"
    DELETESAS = "deletesas"
