#!/usr/bin/env python
# -*- coding: utf-8 -*-

"""The setup script."""

from setuptools import setup, find_packages

with open('README.rst') as readme_file:
    readme = readme_file.read()

with open('HISTORY.rst') as history_file:
    history = history_file.read()

requirements = [
    'Click>=7.0',
    'beautifulsoup4>=4.6',
    'pylev>=1.3',
    'prompt-toolkit>=2.0',
    'tinydb>=3.11',
    'toml>=0.10',
    'bullet==2.0.0',
    "requests>=2.22",
    "logzero==1.5",
    "cmd2==0.9.23",
    "hydra-core==0.11.3",
    "Flask==1.1.1", ]

setup_requirements = ['pytest-runner', ]

test_requirements = ['pytest>=3', ]

setup(
    author="Unviray",
    author_email='unviray@gmail.com',
    python_requires='>=3.6',
    classifiers=[
        'Development Status :: 2 - Pre-Alpha',
        'Intended Audience :: Developers',
        'License :: OSI Approved :: MIT License',
        'Natural Language :: English',
        'Programming Language :: Python :: 3.6',
        'Programming Language :: Python :: 3.7',
    ],
    description="Bible new world translation",
    entry_points={
        'console_scripts': [
            'nwt=nwt.controllers.cli:main',
        ],
    },
    install_requires=requirements,
    license="MIT license",
    long_description=readme + '\n\n' + history,
    include_package_data=True,
    keywords='nwt bible',
    name='nwt',
    packages=find_packages(include=['nwt', 'nwt.*']),
    setup_requires=setup_requirements,
    test_suite='tests',
    tests_require=test_requirements,
    url='https://github.com/Unviray/nwt',
    version='0.1.2',
    zip_safe=False,
)
