# GPViz: Visualizing Gaussian processes

[![codecov](https://codecov.io/gh/thomaspinder/GPViz/branch/master/graph/badge.svg?token=3FK9ZMU9PB)](https://codecov.io/gh/thomaspinder/GPViz)
[![Documentation Status](https://readthedocs.org/projects/gpviz/badge/?version=latest)](https://gpviz.readthedocs.io/en/latest/?badge=latest)

GPViz is an extension library to [GPJax](https://github.com/thomaspinder/GPJax) that facilitates fast and informative plotting of Gaussian processes and kernels.

All plots can be generated by simply calling the `plot()` command on the relevant Gaussian process object, a dataset, Jax PRNGKey, and a parameter set. For a full introduction, see the [demo notebook here](https://gpviz.readthedocs.io/en/latest/nbs/demo.html).

## Gallery

### Prior

![Gaussian proces prior](media/prior.jpg)

### Posteriors

![Gaussian process posterior](media/posterior.jpg)

![Posterior samples](media/posterior2.jpg)

### Kernels

![Kernel shape](media/kernel_shape.jpg)

![Gram matrix](media/kernel_gram.jpg)

## Installation

GPViz is available on [PyPi](https://pypi.org/project/GPViz/) and can be installed through
```shell
pip install gpviz
```