/*
 * Decompiled with CFR 0.152.
 */
package soot.util;

import java.util.Iterator;
import java.util.NoSuchElementException;
import soot.util.ArrayNumberer;
import soot.util.Numberable;

public final class LargeNumberedMap<K extends Numberable, V> {
    private Object[] values;
    private ArrayNumberer<K> universe;

    public LargeNumberedMap(ArrayNumberer<K> universe) {
        this.universe = universe;
        int newsize = universe.size();
        if (newsize < 8) {
            newsize = 8;
        }
        this.values = new Object[newsize];
    }

    public boolean put(Numberable key, V value) {
        int number = key.getNumber();
        if (number == 0) {
            throw new RuntimeException("oops, forgot to initialize");
        }
        if (number >= this.values.length) {
            Object[] oldValues = this.values;
            this.values = new Object[this.universe.size() * 2 + 5];
            System.arraycopy(oldValues, 0, this.values, 0, oldValues.length);
        }
        boolean ret = this.values[number] != value;
        this.values[number] = value;
        return ret;
    }

    public V get(Numberable key) {
        int i = key.getNumber();
        if (i >= this.values.length) {
            return null;
        }
        return (V)this.values[i];
    }

    public Iterator<K> keyIterator() {
        return new Iterator<K>(){
            int cur = 0;

            private void advance() {
                while (this.cur < LargeNumberedMap.this.values.length && LargeNumberedMap.this.values[this.cur] == null) {
                    ++this.cur;
                }
            }

            @Override
            public boolean hasNext() {
                this.advance();
                return this.cur < LargeNumberedMap.this.values.length;
            }

            @Override
            public K next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return LargeNumberedMap.this.universe.get(this.cur++);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }
}

