/*
 * Decompiled with CFR 0.152.
 */
package soot.toolkits.scalar;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import soot.G;
import soot.Unit;
import soot.options.Options;
import soot.toolkits.graph.UnitGraph;
import soot.toolkits.scalar.FlowSet;
import soot.toolkits.scalar.GuaranteedDefsAnalysis;

public class GuaranteedDefs {
    protected Map<Unit, List> unitToGuaranteedDefs;

    public GuaranteedDefs(UnitGraph graph) {
        if (Options.v().verbose()) {
            G.v().out.println("[" + graph.getBody().getMethod().getName() + "]     Constructing GuaranteedDefs...");
        }
        GuaranteedDefsAnalysis analysis = new GuaranteedDefsAnalysis(graph);
        this.unitToGuaranteedDefs = new HashMap<Unit, List>(graph.size() * 2 + 1, 0.7f);
        for (Unit s : graph) {
            FlowSet set = (FlowSet)analysis.getFlowBefore(s);
            this.unitToGuaranteedDefs.put(s, Collections.unmodifiableList(set.toList()));
        }
    }

    public List getGuaranteedDefs(Unit s) {
        return this.unitToGuaranteedDefs.get(s);
    }
}

