/*
 * Decompiled with CFR 0.152.
 */
package soot.toolkits.scalar;

import java.util.BitSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import soot.options.Options;
import soot.toolkits.graph.DirectedGraph;
import soot.toolkits.scalar.FlowAnalysis;

public abstract class BackwardFlowAnalysis<N, A>
extends FlowAnalysis<N, A> {
    public BackwardFlowAnalysis(DirectedGraph<N> graph) {
        super(graph);
    }

    @Override
    protected boolean isForward() {
        return false;
    }

    @Override
    protected void doAnalysis() {
        boolean interactiveMode = Options.v().interactive_mode();
        List orderedUnits = this.constructOrderer().newList(this.graph, true);
        int n = orderedUnits.size();
        BitSet tail = new BitSet();
        BitSet work = new BitSet(n);
        work.set(0, n);
        IdentityHashMap index = new IdentityHashMap(n * 2 + 1);
        int i = 0;
        for (Object s : orderedUnits) {
            index.put(s, i++);
            this.unitToBeforeFlow.put(s, this.newInitialFlow());
            this.unitToAfterFlow.put(s, this.newInitialFlow());
        }
        for (Object s : this.graph.getTails()) {
            tail.set((Integer)index.get(s));
            this.unitToAfterFlow.put(s, this.entryInitialFlow());
        }
        Object previousFlow = this.newInitialFlow();
        int i2 = work.nextSetBit(0);
        while (i2 >= 0) {
            boolean hasChanged;
            Object s;
            work.clear(i2);
            s = orderedUnits.get(i2);
            Object afterFlow = this.unitToAfterFlow.get(s);
            Iterator it = this.graph.getSuccsOf(s).iterator();
            if (it.hasNext()) {
                this.copy(this.unitToBeforeFlow.get(it.next()), afterFlow);
                while (it.hasNext()) {
                    this.mergeInto(s, afterFlow, this.unitToBeforeFlow.get(it.next()));
                }
                if (tail.get(i2)) {
                    this.mergeInto(s, afterFlow, this.entryInitialFlow());
                }
            }
            Object beforeFlow = this.unitToBeforeFlow.get(s);
            this.copy(beforeFlow, previousFlow);
            if (interactiveMode) {
                this.afterFlowThrough(s, afterFlow, true);
                this.flowThrough(afterFlow, s, beforeFlow);
                this.beforeFlowThrough(s, beforeFlow, false);
            } else {
                this.flowThrough(afterFlow, s, beforeFlow);
            }
            boolean bl = hasChanged = !previousFlow.equals(beforeFlow);
            if (hasChanged) {
                for (Object v : this.graph.getPredsOf(s)) {
                    int j = (Integer)index.get(v);
                    work.set(j);
                    i2 = Math.min(i2, j - 1);
                }
            }
            i2 = work.nextSetBit(i2 + 1);
        }
    }
}

