/*
 * Decompiled with CFR 0.152.
 */
package soot.toolkits.graph;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import soot.toolkits.graph.DirectedGraph;
import soot.toolkits.graph.DominatorsFinder;
import soot.toolkits.graph.SimpleDominatorsAnalysis;
import soot.toolkits.scalar.FlowSet;

public class SimpleDominatorsFinder<N>
implements DominatorsFinder<N> {
    protected DirectedGraph<N> graph;
    protected Map<N, FlowSet<N>> nodeToDominators;

    public SimpleDominatorsFinder(DirectedGraph<N> graph) {
        this.graph = graph;
        SimpleDominatorsAnalysis<N> analysis = new SimpleDominatorsAnalysis<N>(graph);
        this.nodeToDominators = new HashMap<N, FlowSet<N>>(graph.size() * 2 + 1, 0.7f);
        for (N node : graph) {
            FlowSet set = (FlowSet)analysis.getFlowAfter(node);
            this.nodeToDominators.put(node, set);
        }
    }

    @Override
    public DirectedGraph<N> getGraph() {
        return this.graph;
    }

    @Override
    public List<N> getDominators(N node) {
        return this.nodeToDominators.get(node).toList();
    }

    @Override
    public N getImmediateDominator(N node) {
        if (this.getGraph().getHeads().contains(node)) {
            return null;
        }
        List<N> dominatorsList = this.getDominators(node);
        dominatorsList.remove(node);
        Iterator<N> dominatorsIt = dominatorsList.iterator();
        N immediateDominator = null;
        while (immediateDominator == null && dominatorsIt.hasNext()) {
            N dominator = dominatorsIt.next();
            if (!this.isDominatedByAll(dominator, dominatorsList)) continue;
            immediateDominator = dominator;
        }
        if (immediateDominator == null) {
            throw new RuntimeException("Assertion failed.");
        }
        return immediateDominator;
    }

    @Override
    public boolean isDominatedBy(N node, N dominator) {
        return this.getDominators(node).contains(dominator);
    }

    @Override
    public boolean isDominatedByAll(N node, Collection<N> dominators) {
        return this.getDominators(node).containsAll(dominators);
    }
}

