/*
 * Decompiled with CFR 0.152.
 */
package soot.toolkits.graph;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import soot.toolkits.graph.DirectedGraph;
import soot.toolkits.scalar.ArrayPackedSet;
import soot.toolkits.scalar.BoundedFlowSet;
import soot.toolkits.scalar.CollectionFlowUniverse;
import soot.toolkits.scalar.FlowSet;
import soot.toolkits.scalar.ForwardFlowAnalysis;

class SimpleDominatorsAnalysis<N>
extends ForwardFlowAnalysis<N, FlowSet<N>> {
    FlowSet<N> emptySet;
    Map<N, FlowSet<N>> nodeToGenerateSet;

    SimpleDominatorsAnalysis(DirectedGraph<N> graph) {
        super(graph);
        ArrayList<N> nodes = new ArrayList<N>();
        Iterator<N> nodesIt = graph.iterator();
        while (nodesIt.hasNext()) {
            nodes.add(nodesIt.next());
        }
        CollectionFlowUniverse nodeUniverse = new CollectionFlowUniverse(nodes);
        this.emptySet = new ArrayPackedSet(nodeUniverse);
        this.nodeToGenerateSet = new HashMap<N, FlowSet<N>>(graph.size() * 2 + 1, 0.7f);
        for (N s : graph) {
            FlowSet<N> genSet = this.emptySet.clone();
            genSet.add(s, genSet);
            this.nodeToGenerateSet.put(s, genSet);
        }
        this.doAnalysis();
    }

    @Override
    protected FlowSet<N> newInitialFlow() {
        BoundedFlowSet initSet = (BoundedFlowSet)this.emptySet.clone();
        initSet.complement();
        return initSet;
    }

    @Override
    protected FlowSet<N> entryInitialFlow() {
        List heads = this.graph.getHeads();
        if (heads.size() != 1) {
            throw new RuntimeException("Assertion failed:  Only one head expected.");
        }
        BoundedFlowSet initSet = (BoundedFlowSet)this.emptySet.clone();
        initSet.add(heads.get(0));
        return initSet;
    }

    @Override
    protected void flowThrough(FlowSet<N> in, N block, FlowSet<N> out) {
        in.union(this.nodeToGenerateSet.get(block), out);
    }

    @Override
    protected void merge(FlowSet<N> in1, FlowSet<N> in2, FlowSet<N> out) {
        in1.intersection(in2, out);
    }

    @Override
    protected void copy(FlowSet<N> source, FlowSet<N> dest) {
        source.copy(dest);
    }
}

