/*
 * Decompiled with CFR 0.152.
 */
package soot.toDex;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import soot.Local;
import soot.SootMethod;
import soot.Type;
import soot.Value;
import soot.jimple.ClassConstant;
import soot.jimple.Constant;
import soot.jimple.DoubleConstant;
import soot.jimple.FloatConstant;
import soot.jimple.IntConstant;
import soot.jimple.LongConstant;
import soot.jimple.NullConstant;
import soot.jimple.StringConstant;
import soot.jimple.internal.JimpleLocal;
import soot.toDex.ConstantVisitor;
import soot.toDex.Register;
import soot.toDex.SootToDexUtils;

public class RegisterAllocator {
    private int nextRegNum;
    private Map<String, Integer> localToLastRegNum;
    private int paramRegCount;
    List<Register> classConstantReg = new ArrayList<Register>();
    List<Register> nullConstantReg = new ArrayList<Register>();
    List<Register> floatConstantReg = new ArrayList<Register>();
    List<Register> intConstantReg = new ArrayList<Register>();
    List<Register> longConstantReg = new ArrayList<Register>();
    List<Register> doubleConstantReg = new ArrayList<Register>();
    List<Register> stringConstantReg = new ArrayList<Register>();
    AtomicInteger classI = new AtomicInteger(0);
    AtomicInteger nullI = new AtomicInteger(0);
    AtomicInteger floatI = new AtomicInteger(0);
    AtomicInteger intI = new AtomicInteger(0);
    AtomicInteger longI = new AtomicInteger(0);
    AtomicInteger doubleI = new AtomicInteger(0);
    AtomicInteger stringI = new AtomicInteger(0);
    private boolean multipleConstantsPossible = false;

    public RegisterAllocator() {
        this.localToLastRegNum = new HashMap<String, Integer>();
    }

    private Register asConstant(Value v, ConstantVisitor constantV) {
        Constant c = (Constant)v;
        Register constantRegister = null;
        List<Register> rArray = null;
        AtomicInteger iI = null;
        if (c instanceof ClassConstant) {
            rArray = this.classConstantReg;
            iI = this.classI;
        } else if (c instanceof NullConstant) {
            rArray = this.nullConstantReg;
            iI = this.nullI;
        } else if (c instanceof FloatConstant) {
            rArray = this.floatConstantReg;
            iI = this.floatI;
        } else if (c instanceof IntConstant) {
            rArray = this.intConstantReg;
            iI = this.intI;
        } else if (c instanceof LongConstant) {
            rArray = this.longConstantReg;
            iI = this.longI;
        } else if (c instanceof DoubleConstant) {
            rArray = this.doubleConstantReg;
            iI = this.doubleI;
        } else if (c instanceof StringConstant) {
            rArray = this.stringConstantReg;
            iI = this.stringI;
        } else {
            throw new RuntimeException("Error. Unknown constant type: '" + c.getType() + "'");
        }
        if (rArray.size() == 0 || iI.intValue() >= rArray.size()) {
            rArray.add(new Register(c.getType(), this.nextRegNum));
            this.nextRegNum += SootToDexUtils.getDexWords(c.getType());
        }
        if (this.isMultipleConstantsPossible()) {
            constantRegister = rArray.get(iI.intValue()).clone();
            iI.set(iI.intValue() + 1);
        } else {
            constantRegister = rArray.get(0).clone();
        }
        constantV.setDestination(constantRegister);
        c.apply(constantV);
        return constantRegister.clone();
    }

    public void setMultipleConstantsPossible(boolean b) {
        this.multipleConstantsPossible = b;
        this.classI = new AtomicInteger(0);
        this.nullI = new AtomicInteger(0);
        this.floatI = new AtomicInteger(0);
        this.intI = new AtomicInteger(0);
        this.longI = new AtomicInteger(0);
        this.doubleI = new AtomicInteger(0);
        this.stringI = new AtomicInteger(0);
    }

    public boolean isMultipleConstantsPossible() {
        return this.multipleConstantsPossible;
    }

    public Map<String, Integer> getLocalToRegisterMapping() {
        return this.localToLastRegNum;
    }

    public Register asLocal(Value v) {
        Register localRegister;
        Local l = (Local)v;
        String localName = l.getName();
        if (this.localToLastRegNum.containsKey(localName)) {
            int oldRegNum = this.localToLastRegNum.get(localName);
            localRegister = new Register(l.getType(), oldRegNum);
        } else {
            localRegister = new Register(l.getType(), this.nextRegNum);
            this.localToLastRegNum.put(localName, this.nextRegNum);
            this.nextRegNum += SootToDexUtils.getDexWords(l.getType());
        }
        return localRegister;
    }

    public void asParameter(SootMethod sm, Local l) {
        if (this.localToLastRegNum.containsKey(l.getName())) {
            return;
        }
        int paramRegNum = 0;
        boolean found = false;
        if (!sm.isStatic()) {
            try {
                if (sm.getActiveBody().getThisLocal() == l) {
                    paramRegNum = 0;
                    found = true;
                }
            }
            catch (RuntimeException e) {
                // empty catch block
            }
        }
        if (!found) {
            for (int i = 0; i < sm.getParameterCount(); ++i) {
                if (sm.getActiveBody().getParameterLocal(i) == l) {
                    if (!sm.isStatic()) {
                        ++paramRegNum;
                    }
                    found = true;
                    break;
                }
                Type paramType = sm.getParameterType(i);
                paramRegNum += SootToDexUtils.getDexWords(paramType);
            }
        }
        if (!found) {
            throw new RuntimeException("Parameter local not found");
        }
        this.localToLastRegNum.put(l.getName(), paramRegNum);
        int wordsforParameters = SootToDexUtils.getDexWords(l.getType());
        this.nextRegNum = Math.max(this.nextRegNum + wordsforParameters, paramRegNum + wordsforParameters);
        this.paramRegCount += wordsforParameters;
    }

    public Register asImmediate(Value v, ConstantVisitor constantV) {
        if (v instanceof Constant) {
            return this.asConstant(v, constantV);
        }
        if (v instanceof Local) {
            return this.asLocal(v);
        }
        throw new RuntimeException("expected Immediate (Constant or Local), but was: " + v.getClass());
    }

    public Register asTmpReg(Type regType) {
        String tmpRegName = "tmp" + this.getRegCount();
        return this.asLocal(new JimpleLocal(tmpRegName, regType));
    }

    public void increaseRegCount(int amount) {
        this.nextRegNum += amount;
    }

    public int getParamRegCount() {
        return this.paramRegCount;
    }

    public int getRegCount() {
        return this.nextRegNum;
    }
}

