/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.toolkits.thread.mhp;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import soot.jimple.toolkits.thread.mhp.PegChain;
import soot.jimple.toolkits.thread.mhp.PegGraph;
import soot.jimple.toolkits.thread.mhp.stmt.BeginStmt;
import soot.jimple.toolkits.thread.mhp.stmt.JPegStmt;
import soot.jimple.toolkits.thread.mhp.stmt.JoinStmt;
import soot.jimple.toolkits.thread.mhp.stmt.MonitorEntryStmt;
import soot.jimple.toolkits.thread.mhp.stmt.NotifiedEntryStmt;
import soot.jimple.toolkits.thread.mhp.stmt.NotifyAllStmt;
import soot.jimple.toolkits.thread.mhp.stmt.NotifyStmt;
import soot.jimple.toolkits.thread.mhp.stmt.StartStmt;
import soot.jimple.toolkits.thread.mhp.stmt.WaitingStmt;
import soot.tagkit.Tag;
import soot.toolkits.scalar.ArraySparseSet;
import soot.toolkits.scalar.FlowSet;
import soot.util.Chain;

class MhpAnalysis {
    private PegGraph g;
    private final Map<Object, FlowSet> unitToGen;
    private final Map<Object, FlowSet> unitToKill;
    private final Map<Object, FlowSet> unitToM;
    private final Map<Object, FlowSet> unitToOut;
    private final Map<Object, FlowSet> notifySucc;
    private final Map<String, FlowSet> monitor;
    private final Map<JPegStmt, Set<JPegStmt>> notifyPred;
    FlowSet fullSet = new ArraySparseSet();
    LinkedList<Object> workList = new LinkedList();

    MhpAnalysis(PegGraph g) {
        this.g = g;
        int size = g.size();
        Map<JPegStmt, List> startToThread = g.getStartToThread();
        this.unitToGen = new HashMap<Object, FlowSet>(size * 2 + 1, 0.7f);
        this.unitToKill = new HashMap<Object, FlowSet>(size * 2 + 1, 0.7f);
        this.unitToM = new HashMap<Object, FlowSet>(size * 2 + 1, 0.7f);
        this.unitToOut = new HashMap<Object, FlowSet>(size * 2 + 1, 0.7f);
        this.notifySucc = new HashMap<Object, FlowSet>(size * 2 + 1, 0.7f);
        this.notifyPred = new HashMap<JPegStmt, Set<JPegStmt>>(size * 2 + 1, 0.7f);
        this.monitor = g.getMonitor();
        for (Object stmt : g) {
            ArraySparseSet genSet = new ArraySparseSet();
            ArraySparseSet killSet = new ArraySparseSet();
            ArraySparseSet mSet = new ArraySparseSet();
            ArraySparseSet outSet = new ArraySparseSet();
            ArraySparseSet notifySuccSet = new ArraySparseSet();
            this.unitToGen.put(stmt, genSet);
            this.unitToKill.put(stmt, killSet);
            this.unitToM.put(stmt, mSet);
            this.unitToOut.put(stmt, outSet);
            this.notifySucc.put(stmt, notifySuccSet);
        }
        Set<JPegStmt> keys = startToThread.keySet();
        for (JPegStmt stmt : keys) {
            if (this.workList.contains(stmt)) continue;
            this.workList.addLast(stmt);
        }
        Iterator it = g.iterator();
        while (it.hasNext()) {
            Iterator nodesIt;
            FlowSet killNodes;
            Map<String, FlowSet> waitingNodes;
            ArraySparseSet genSet = new ArraySparseSet();
            FlowSet killSet = new ArraySparseSet();
            Object o = it.next();
            if (!(o instanceof JPegStmt)) continue;
            JPegStmt s = (JPegStmt)o;
            if (s instanceof JoinStmt) {
                if (g.getSpecialJoin().contains(s)) continue;
                Chain chain = g.getJoinStmtToThread().get(s);
                Iterator nodesIt2 = chain.iterator();
                if (nodesIt2.hasNext()) {
                    while (nodesIt2.hasNext()) {
                        killSet.add(nodesIt2.next());
                    }
                }
                this.unitToGen.put(s, genSet);
                this.unitToKill.put(s, killSet);
                continue;
            }
            if (s instanceof MonitorEntryStmt || s instanceof NotifiedEntryStmt) {
                Iterator It = g.iterator();
                if (this.monitor.containsKey(s.getObject())) {
                    killSet = this.monitor.get(s.getObject());
                }
                this.unitToGen.put(s, genSet);
                this.unitToKill.put(s, killSet);
                continue;
            }
            if (s instanceof NotifyAllStmt) {
                waitingNodes = g.getWaitingNodes();
                if (waitingNodes.containsKey(s.getObject())) {
                    killNodes = waitingNodes.get(s.getObject());
                    nodesIt = killNodes.iterator();
                    while (nodesIt.hasNext()) {
                        killSet.add(nodesIt.next());
                    }
                }
                this.unitToGen.put(s, genSet);
                this.unitToKill.put(s, killSet);
                continue;
            }
            if (s instanceof NotifyStmt) {
                waitingNodes = g.getWaitingNodes();
                if (waitingNodes.containsKey(s.getObject()) && (killNodes = waitingNodes.get(s.getObject())).size() == 1) {
                    nodesIt = killNodes.iterator();
                    while (nodesIt.hasNext()) {
                        killSet.add(nodesIt.next());
                    }
                }
                this.unitToGen.put(s, genSet);
                this.unitToKill.put(s, killSet);
                continue;
            }
            if (!(s instanceof StartStmt) || !g.getStartToThread().containsKey(s)) continue;
            for (PegChain chain : g.getStartToThread().get(s)) {
                Iterator beginNodesIt = chain.getHeads().iterator();
                while (beginNodesIt.hasNext()) {
                    genSet.add(beginNodesIt.next());
                }
            }
            this.unitToGen.put(s, genSet);
            this.unitToKill.put(s, killSet);
        }
        this.doAnalysis();
        long beginTime = System.currentTimeMillis();
        this.computeMPairs();
        this.computeMSet();
        long buildPegDuration = System.currentTimeMillis() - beginTime;
        System.err.println("compute parir + mset: " + buildPegDuration);
    }

    protected void doAnalysis() {
        while (this.workList.size() > 0) {
            Map<JPegStmt, List> map;
            Object currentObj = this.workList.removeFirst();
            FlowSet killSet = this.unitToKill.get(currentObj);
            FlowSet genSet = this.unitToGen.get(currentObj);
            ArraySparseSet<Object> mSet = new ArraySparseSet<Object>();
            FlowSet outSet = this.unitToOut.get(currentObj);
            FlowSet notifySuccSet = this.notifySucc.get(currentObj);
            FlowSet mOld = this.unitToM.get(currentObj);
            FlowSet outOld = outSet.clone();
            FlowSet notifySuccSetOld = notifySuccSet.clone();
            ArraySparseSet<JPegStmt> genNotifyAllSet = new ArraySparseSet<JPegStmt>();
            JPegStmt waitingPred = null;
            if (!(currentObj instanceof JPegStmt)) {
                for (Object tempStmt : this.g.getPredsOf(currentObj)) {
                    FlowSet flowSet = this.unitToOut.get(tempStmt);
                    if (flowSet == null) continue;
                    mSet.union(flowSet);
                }
                mSet.union(mOld);
                this.unitToM.put(currentObj, mSet);
                mSet.union(genSet, outSet);
                if (killSet.size() > 0) {
                    for (Object t : killSet) {
                        if (!outSet.contains(t)) continue;
                        outSet.remove(t);
                    }
                }
                if (!mOld.equals(mSet)) {
                    for (Object t : mSet) {
                        if (!mOld.contains(t) && this.unitToM.containsKey(t)) {
                            FlowSet mSetMSym = this.unitToM.get(t);
                            if (mSetMSym.size() != 0) {
                                if (!mSetMSym.contains(currentObj)) {
                                    mSetMSym.add(currentObj);
                                }
                            } else {
                                mSetMSym.add(currentObj);
                            }
                        }
                        if (this.workList.contains(t)) continue;
                        this.workList.addLast(t);
                    }
                }
                if (outOld.equals(outSet)) continue;
                for (Object e : this.g.getSuccsOf(currentObj)) {
                    if (e instanceof JPegStmt) {
                        if ((JPegStmt)e instanceof NotifiedEntryStmt || this.workList.contains(e)) continue;
                        this.workList.addLast(e);
                        continue;
                    }
                    if (this.workList.contains(e)) continue;
                    this.workList.addLast(e);
                }
                continue;
            }
            JPegStmt currentNode = (JPegStmt)currentObj;
            Tag tag = currentNode.getTags().get(0);
            if (currentNode instanceof NotifyStmt || currentNode instanceof NotifyAllStmt) {
                Map<String, FlowSet> map2 = this.g.getWaitingNodes();
                if (map2.containsKey(currentNode.getObject())) {
                    FlowSet waitingNodeSet = map2.get(currentNode.getObject());
                    for (JPegStmt tempNode : waitingNodeSet) {
                        if (!mOld.contains(tempNode)) continue;
                        List waitingSuccList = this.g.getSuccsOf(tempNode);
                        for (JPegStmt waitingSucc : waitingSuccList) {
                            Set<Object> notifyPredSet;
                            notifySuccSet.add(waitingSucc);
                            if (!(waitingSucc instanceof NotifiedEntryStmt)) continue;
                            FlowSet notifySet = this.notifySucc.get(currentNode);
                            notifySet.add(waitingSucc);
                            this.notifySucc.put(currentNode, notifySet);
                            if (this.notifyPred.containsKey(waitingSucc)) {
                                notifyPredSet = this.notifyPred.get(waitingSucc);
                                notifyPredSet.add(currentNode);
                                this.notifyPred.put(waitingSucc, notifyPredSet);
                                continue;
                            }
                            notifyPredSet = new HashSet<JPegStmt>();
                            notifyPredSet.add(currentNode);
                            this.notifyPred.put(waitingSucc, notifyPredSet);
                        }
                    }
                } else {
                    throw new RuntimeException("Fail to find waiting node for: " + currentObj);
                }
            }
            if (!notifySuccSetOld.equals(notifySuccSet)) {
                for (Object notifySuccNode : notifySuccSet) {
                    if (this.workList.contains(notifySuccNode)) continue;
                    this.workList.addLast(notifySuccNode);
                }
            }
            if (currentNode instanceof NotifiedEntryStmt) {
                Iterator iterator = this.g.getPredsOf(currentNode).iterator();
                while (!(!iterator.hasNext() || (waitingPred = (JPegStmt)iterator.next()) instanceof WaitingStmt && waitingPred.getObject().equals(currentNode.getObject()) && waitingPred.getCaller().equals(currentNode.getCaller()))) {
                }
                Map<String, FlowSet> waitingNodes = this.g.getWaitingNodes();
                ArraySparseSet<JPegStmt> arraySparseSet = new ArraySparseSet<JPegStmt>();
                if (waitingNodes.containsKey(currentNode.getObject())) {
                    FlowSet waitingNodesSet = waitingNodes.get(currentNode.getObject());
                    Iterator waitingNodesIt = waitingNodesSet.iterator();
                    while (waitingNodesIt.hasNext()) {
                        List waitingNodesSucc = this.g.getSuccsOf(waitingNodesIt.next());
                        for (JPegStmt notifyEntry : waitingNodesSucc) {
                            if (!(notifyEntry instanceof NotifiedEntryStmt)) continue;
                            arraySparseSet.add(notifyEntry);
                        }
                    }
                }
                for (JPegStmt notifyEntry : arraySparseSet) {
                    Map<String, Set<JPegStmt>> notifyAll;
                    FlowSet mWaitingPredM;
                    Iterator waitingPredIterator = this.g.getPredsOf(notifyEntry).iterator();
                    JPegStmt waitingPredNode = null;
                    while (!(!waitingPredIterator.hasNext() || (waitingPredNode = (JPegStmt)waitingPredIterator.next()) instanceof WaitingStmt && waitingPredNode.getObject().equals(currentNode.getObject()) && waitingPredNode.getCaller().equals(currentNode.getCaller()))) {
                    }
                    if (!this.unitToM.containsKey(waitingPredNode) || !(mWaitingPredM = this.unitToM.get(waitingPredNode)).contains(waitingPred) || !(notifyAll = this.g.getNotifyAll()).containsKey(currentNode.getObject())) continue;
                    Set<JPegStmt> notifyAllSet = notifyAll.get(currentNode.getObject());
                    for (JPegStmt notifyAllStmt : notifyAllSet) {
                        if (!this.unitToM.containsKey(waitingPred)) continue;
                        FlowSet mWaitingPredN = this.unitToM.get(waitingPred);
                        if (!mWaitingPredM.contains(notifyAllStmt) || !mWaitingPredN.contains(notifyAllStmt)) continue;
                        genNotifyAllSet.add(notifyEntry);
                    }
                }
            }
            ArraySparseSet arraySparseSet = new ArraySparseSet();
            if (currentNode instanceof NotifiedEntryStmt) {
                if (!this.unitToOut.containsKey(waitingPred)) {
                    throw new RuntimeException("unitToOut does not contains " + waitingPred);
                }
                ArraySparseSet<Object> mSetOfNotifyEntry = new ArraySparseSet<Object>();
                Set<JPegStmt> set = this.notifyPred.get(currentNode);
                if (set != null) {
                    for (JPegStmt notifyPred : set) {
                        FlowSet outWaitingPredTemp = this.unitToOut.get(notifyPred);
                        outWaitingPredTemp.copy(arraySparseSet);
                    }
                    FlowSet outWaitingPredSet = this.unitToOut.get(waitingPred);
                    arraySparseSet.intersection(outWaitingPredSet, mSetOfNotifyEntry);
                    mSetOfNotifyEntry.union(genNotifyAllSet, mSet);
                }
            } else if (currentNode instanceof BeginStmt) {
                mSet = new ArraySparseSet();
                Map<JPegStmt, List> startToThread2 = this.g.getStartToThread();
                Set<JPegStmt> set = startToThread2.keySet();
                for (JPegStmt tempStmt : set) {
                    Iterator chainListIt = startToThread2.get(tempStmt).iterator();
                    while (chainListIt.hasNext()) {
                        List beginNodes = ((PegChain)chainListIt.next()).getHeads();
                        if (!beginNodes.contains(currentNode)) continue;
                        for (Object startPred : this.unitToOut.get(tempStmt)) {
                            mSet.add(startPred);
                        }
                    }
                }
                for (JPegStmt tempStmt : startToThread2.keySet()) {
                    for (Chain chain : startToThread2.get(tempStmt)) {
                        if (!chain.contains(currentNode)) continue;
                        for (Object stmt : chain) {
                            if (!mSet.contains(stmt)) continue;
                            mSet.remove(stmt);
                        }
                    }
                }
            } else {
                Iterator localPredIt = this.g.getPredsOf(currentNode).iterator();
                if (!(currentNode instanceof NotifiedEntryStmt)) {
                    while (localPredIt.hasNext()) {
                        Object e = localPredIt.next();
                        FlowSet out = this.unitToOut.get(e);
                        if (out == null) continue;
                        mSet.union(out);
                    }
                }
            }
            mSet.union(mOld);
            this.unitToM.put(currentNode, mSet);
            if (currentNode instanceof NotifyStmt || currentNode instanceof NotifyAllStmt) {
                notifySuccSet.copy(genSet);
                this.unitToGen.put(currentNode, genSet);
            }
            mSet.union(genSet, outSet);
            if (killSet.size() > 0) {
                for (Object t : killSet) {
                    if (!outSet.contains(t)) continue;
                    outSet.remove(t);
                }
            }
            if (!mOld.equals(mSet)) {
                for (Object t : mSet) {
                    if (!mOld.contains(t)) {
                        if (!this.unitToM.containsKey(t)) {
                            throw new RuntimeException("unitToM does not contain: " + t);
                        }
                        FlowSet mSetMSym = this.unitToM.get(t);
                        if (mSetMSym.size() != 0) {
                            if (!mSetMSym.contains(currentNode)) {
                                mSetMSym.add(currentNode);
                            }
                        } else {
                            mSetMSym.add(currentNode);
                        }
                    }
                    if (this.workList.contains(t)) continue;
                    this.workList.addLast(t);
                }
            }
            if (outOld.equals(outSet)) continue;
            for (Object e : this.g.getSuccsOf(currentNode)) {
                if (e instanceof JPegStmt) {
                    if ((JPegStmt)e instanceof NotifiedEntryStmt || this.workList.contains(e)) continue;
                    this.workList.addLast(e);
                    continue;
                }
                if (this.workList.contains(e)) continue;
                this.workList.addLast(e);
            }
            if (!(currentNode instanceof StartStmt) || !(map = this.g.getStartToThread()).containsKey(currentNode)) continue;
            Iterator<JPegStmt> it = map.get(currentNode).iterator();
            block25: while (it.hasNext()) {
                for (JPegStmt tempStmt : (Chain)((Object)it.next())) {
                    if (!(tempStmt instanceof JPegStmt) || !(tempStmt instanceof BeginStmt)) continue;
                    if (this.workList.contains(tempStmt)) continue block25;
                    this.workList.addLast(tempStmt);
                    continue block25;
                }
            }
        }
    }

    protected Object entryInitialFlow() {
        return new ArraySparseSet();
    }

    protected Object newInitialFlow() {
        return this.fullSet.clone();
    }

    protected Map<Object, FlowSet> getUnitToM() {
        return this.unitToM;
    }

    private void computeMPairs() {
        HashSet mSetPairs = new HashSet();
        Set<Map.Entry<Object, FlowSet>> maps = this.unitToM.entrySet();
        for (Map.Entry<Object, FlowSet> entry : maps) {
            Object obj = entry.getKey();
            FlowSet fs = entry.getValue();
            for (Object m : fs) {
                HashSet<Object> pair = new HashSet<Object>();
                pair.add(obj);
                pair.add(m);
                if (mSetPairs.contains(pair)) continue;
                mSetPairs.add(pair);
            }
        }
        System.err.println("Number of pairs: " + mSetPairs.size());
    }

    private void computeMSet() {
        long min = 0L;
        long max = 0L;
        long nodes = 0L;
        long totalNodes = 0L;
        Set<Map.Entry<Object, FlowSet>> maps = this.unitToM.entrySet();
        boolean first = true;
        for (Map.Entry<Object, FlowSet> entry : maps) {
            Object obj = entry.getKey();
            FlowSet fs = entry.getValue();
            if (fs.size() <= 0) continue;
            totalNodes += (long)fs.size();
            ++nodes;
            if ((long)fs.size() > max) {
                max = fs.size();
            }
            if (first) {
                min = fs.size();
                first = false;
                continue;
            }
            if ((long)fs.size() >= min) continue;
            min = fs.size();
        }
        System.err.println("average: " + totalNodes / nodes);
        System.err.println("min: " + min);
        System.err.println("max: " + max);
    }
}

