/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.toolkits.pointer;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import soot.Body;
import soot.Local;
import soot.RefLikeType;
import soot.RefType;
import soot.Unit;
import soot.Value;
import soot.jimple.DefinitionStmt;
import soot.jimple.NewExpr;
import soot.jimple.Stmt;
import soot.jimple.internal.AbstractNewExpr;
import soot.toolkits.graph.DirectedGraph;
import soot.toolkits.graph.UnitGraph;
import soot.toolkits.scalar.ForwardFlowAnalysis;

public class LocalMustNotAliasAnalysis
extends ForwardFlowAnalysis<Unit, HashMap<Local, Set<NewExpr>>> {
    protected static final NewExpr UNKNOWN = new AbstractNewExpr(){

        @Override
        public String toString() {
            return "UNKNOWN";
        }

        @Override
        public Object clone() {
            return this;
        }
    };
    protected Set<Local> locals = new HashSet<Local>();

    public LocalMustNotAliasAnalysis(UnitGraph g) {
        this(g, g.getBody());
    }

    public LocalMustNotAliasAnalysis(DirectedGraph<Unit> directedGraph, Body b) {
        super(directedGraph);
        this.locals.addAll(b.getLocals());
        for (Local l : b.getLocals()) {
            if (!(l.getType() instanceof RefLikeType)) continue;
            this.locals.add(l);
        }
        this.doAnalysis();
    }

    @Override
    protected void merge(HashMap<Local, Set<NewExpr>> in1, HashMap<Local, Set<NewExpr>> in2, HashMap<Local, Set<NewExpr>> o) {
        for (Local l : this.locals) {
            Set<NewExpr> l1 = in1.get(l);
            Set<NewExpr> l2 = in2.get(l);
            Set<NewExpr> out = o.get(l);
            out.clear();
            if (l1.contains(UNKNOWN) || l2.contains(UNKNOWN)) {
                out.add(UNKNOWN);
                continue;
            }
            out.addAll(l1);
            out.addAll(l2);
        }
    }

    @Override
    protected void flowThrough(HashMap<Local, Set<NewExpr>> in, Unit unit, HashMap<Local, Set<NewExpr>> out) {
        Stmt s = (Stmt)unit;
        out.clear();
        out.putAll(in);
        if (s instanceof DefinitionStmt) {
            DefinitionStmt ds = (DefinitionStmt)s;
            Value lhs = ds.getLeftOp();
            Value rhs = ds.getRightOp();
            if (lhs instanceof Local) {
                HashSet<NewExpr> lv = new HashSet<NewExpr>();
                out.put((Local)lhs, lv);
                if (rhs instanceof NewExpr) {
                    lv.add((NewExpr)rhs);
                } else if (rhs instanceof Local) {
                    lv.addAll((Collection)in.get(rhs));
                } else {
                    lv.add(UNKNOWN);
                }
            }
        }
    }

    @Override
    protected void copy(HashMap<Local, Set<NewExpr>> source, HashMap<Local, Set<NewExpr>> dest) {
        dest.putAll(source);
    }

    @Override
    protected HashMap<Local, Set<NewExpr>> entryInitialFlow() {
        HashMap<Local, Set<NewExpr>> m = new HashMap<Local, Set<NewExpr>>();
        for (Local l : this.locals) {
            HashSet<NewExpr> s = new HashSet<NewExpr>();
            s.add(UNKNOWN);
            m.put(l, s);
        }
        return m;
    }

    @Override
    protected HashMap<Local, Set<NewExpr>> newInitialFlow() {
        HashMap<Local, Set<NewExpr>> m = new HashMap<Local, Set<NewExpr>>();
        for (Local l : this.locals) {
            HashSet s = new HashSet();
            m.put(l, s);
        }
        return m;
    }

    public boolean hasInfoOn(Local l, Stmt s) {
        HashMap flowBefore = (HashMap)this.getFlowBefore(s);
        if (flowBefore == null) {
            return false;
        }
        Set info = (Set)flowBefore.get(l);
        return info != null && !info.contains(UNKNOWN);
    }

    public boolean notMayAlias(Local l1, Stmt s1, Local l2, Stmt s2) {
        Set l1n = (Set)((HashMap)this.getFlowBefore(s1)).get(l1);
        Set l2n = (Set)((HashMap)this.getFlowBefore(s2)).get(l2);
        if (l1n.contains(UNKNOWN) || l2n.contains(UNKNOWN)) {
            return false;
        }
        HashSet n = new HashSet();
        n.addAll(l1n);
        n.retainAll(l2n);
        return n.isEmpty();
    }

    public RefType concreteType(Local l, Stmt s) {
        HashMap flowBefore = (HashMap)this.getFlowBefore(s);
        Set set = (Set)flowBefore.get(l);
        if (set.size() != 1) {
            return null;
        }
        NewExpr singleNewExpr = (NewExpr)set.iterator().next();
        if (singleNewExpr == UNKNOWN) {
            return null;
        }
        return (RefType)singleNewExpr.getType();
    }
}

