/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.toolkits.base;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import soot.Body;
import soot.BodyTransformer;
import soot.G;
import soot.Local;
import soot.PatchingChain;
import soot.Unit;
import soot.Value;
import soot.ValueBox;
import soot.jimple.AssignStmt;
import soot.jimple.InstanceInvokeExpr;
import soot.jimple.InvokeExpr;
import soot.jimple.InvokeStmt;
import soot.jimple.Jimple;
import soot.jimple.JimpleBody;
import soot.jimple.NewExpr;
import soot.jimple.SpecialInvokeExpr;
import soot.jimple.Stmt;
import soot.options.Options;
import soot.toolkits.graph.BriefUnitGraph;
import soot.toolkits.graph.DirectedGraph;
import soot.toolkits.scalar.ForwardFlowAnalysis;
import soot.util.HashMultiMap;
import soot.util.MultiMap;

public class JimpleConstructorFolder
extends BodyTransformer {
    static boolean isNew(Stmt s) {
        if (!(s instanceof AssignStmt)) {
            return false;
        }
        return JimpleConstructorFolder.rhs(s) instanceof NewExpr;
    }

    static boolean isConstructor(Stmt s) {
        if (!(s instanceof InvokeStmt)) {
            return false;
        }
        InvokeStmt is = (InvokeStmt)s;
        InvokeExpr expr = is.getInvokeExpr();
        if (!(expr instanceof SpecialInvokeExpr)) {
            return false;
        }
        SpecialInvokeExpr sie = (SpecialInvokeExpr)expr;
        return sie.getMethodRef().name().equals("<init>");
    }

    static Local base(Stmt s) {
        InvokeStmt is = (InvokeStmt)s;
        InstanceInvokeExpr expr = (InstanceInvokeExpr)is.getInvokeExpr();
        return (Local)expr.getBase();
    }

    static void setBase(Stmt s, Local l) {
        InvokeStmt is = (InvokeStmt)s;
        InstanceInvokeExpr expr = (InstanceInvokeExpr)is.getInvokeExpr();
        expr.getBaseBox().setValue(l);
    }

    static boolean isCopy(Stmt s) {
        if (!(s instanceof AssignStmt)) {
            return false;
        }
        if (!(JimpleConstructorFolder.rhs(s) instanceof Local)) {
            return false;
        }
        return JimpleConstructorFolder.lhs(s) instanceof Local;
    }

    static Value rhs(Stmt s) {
        AssignStmt as = (AssignStmt)s;
        return as.getRightOp();
    }

    static Value lhs(Stmt s) {
        AssignStmt as = (AssignStmt)s;
        return as.getLeftOp();
    }

    static Local rhsLocal(Stmt s) {
        return (Local)JimpleConstructorFolder.rhs(s);
    }

    static Local lhsLocal(Stmt s) {
        return (Local)JimpleConstructorFolder.lhs(s);
    }

    public void internalTransform(Body b, String phaseName, Map options) {
        Fact before;
        JimpleBody body = (JimpleBody)b;
        if (Options.v().verbose()) {
            G.v().out.println("[" + body.getMethod().getName() + "] Folding Jimple constructors...");
        }
        Analysis analysis = new Analysis(new BriefUnitGraph(body));
        PatchingChain<Unit> units = body.getUnits();
        ArrayList<Unit> stmtList = new ArrayList<Unit>();
        stmtList.addAll(units);
        for (Stmt stmt : stmtList) {
            if (JimpleConstructorFolder.isCopy(stmt) || JimpleConstructorFolder.isConstructor(stmt)) continue;
            before = (Fact)analysis.getFlowBefore(stmt);
            for (ValueBox usebox : stmt.getUseBoxes()) {
                Local local;
                Value value = usebox.getValue();
                if (!(value instanceof Local) || before.get(local = (Local)value) == null) continue;
                throw new RuntimeException("Use of an unitialized value before constructor call; are you sure this bytecode is verifiable?\n" + stmt);
            }
        }
        for (Stmt stmt : stmtList) {
            if (!JimpleConstructorFolder.isNew(stmt)) continue;
            units.remove(stmt);
        }
        for (Stmt stmt : stmtList) {
            Stmt newStmt;
            before = (Fact)analysis.getFlowBefore(stmt);
            Fact after = (Fact)analysis.getFlowAfter(stmt);
            if (JimpleConstructorFolder.isCopy(stmt)) {
                newStmt = before.get(JimpleConstructorFolder.rhsLocal(stmt));
                if (newStmt == null) continue;
                units.remove(stmt);
                continue;
            }
            if (after.alloc() == null) continue;
            newStmt = before.get(JimpleConstructorFolder.base(stmt));
            JimpleConstructorFolder.setBase(stmt, JimpleConstructorFolder.lhsLocal(newStmt));
            units.insertBefore(newStmt, (Unit)stmt);
            for (Local l : before.get(newStmt)) {
                if (l.equals(JimpleConstructorFolder.base(stmt))) continue;
                units.insertAfter(Jimple.v().newAssignStmt(l, JimpleConstructorFolder.base(stmt)), (Unit)stmt);
            }
        }
    }

    private class Analysis
    extends ForwardFlowAnalysis {
        public Analysis(DirectedGraph graph) {
            super(graph);
            this.doAnalysis();
        }

        @Override
        protected Object entryInitialFlow() {
            return new Fact();
        }

        @Override
        protected Object newInitialFlow() {
            return new Fact();
        }

        @Override
        public void flowThrough(Object inFact, Object unit, Object outFact) {
            Stmt newStmt;
            Stmt s = (Stmt)unit;
            Fact in = (Fact)inFact;
            Fact out = (Fact)outFact;
            this.copy(in, out);
            out.setAlloc(null);
            if (JimpleConstructorFolder.isNew(s)) {
                out.add(JimpleConstructorFolder.lhsLocal(s), s);
            } else if (JimpleConstructorFolder.isCopy(s)) {
                Stmt newStmt2 = out.get(JimpleConstructorFolder.rhsLocal(s));
                if (newStmt2 != null) {
                    out.add(JimpleConstructorFolder.lhsLocal(s), newStmt2);
                }
            } else if (JimpleConstructorFolder.isConstructor(s) && (newStmt = out.get(JimpleConstructorFolder.base(s))) != null) {
                out.removeAll(newStmt);
                out.setAlloc(newStmt);
            }
        }

        @Override
        public void copy(Object source, Object dest) {
            ((Fact)dest).copyFrom((Fact)source);
        }

        @Override
        public void merge(Object in1, Object in2, Object out) {
            ((Fact)out).mergeFrom((Fact)in1, (Fact)in2);
        }
    }

    private class Fact {
        private Map<Local, Stmt> varToStmt = new HashMap<Local, Stmt>();
        private MultiMap stmtToVar = new HashMultiMap();
        private Stmt alloc = null;

        private Fact() {
        }

        public void add(Local l, Stmt s) {
            this.varToStmt.put(l, s);
            this.stmtToVar.put(s, l);
        }

        public Stmt get(Local l) {
            return this.varToStmt.get(l);
        }

        public Set get(Stmt s) {
            return this.stmtToVar.get(s);
        }

        public void removeAll(Stmt s) {
            for (Local var : this.stmtToVar.get(s)) {
                this.varToStmt.remove(var);
            }
            this.stmtToVar.remove(s);
        }

        public void copyFrom(Fact in) {
            this.varToStmt = new HashMap<Local, Stmt>(in.varToStmt);
            this.stmtToVar = new HashMultiMap(in.stmtToVar);
            this.alloc = in.alloc;
        }

        public void mergeFrom(Fact in1, Fact in2) {
            Stmt newStmt;
            this.varToStmt = new HashMap<Local, Stmt>();
            for (Local l : in1.varToStmt.keySet()) {
                Stmt newStmt2;
                newStmt = in1.varToStmt.get(l);
                if (in2.varToStmt.containsKey(l) && !newStmt.equals(newStmt2 = in2.varToStmt.get(l))) {
                    throw new RuntimeException("Merge of different uninitialized values; are you sure this bytecode is verifiable?");
                }
                this.add(l, newStmt);
            }
            for (Local l : in2.varToStmt.keySet()) {
                newStmt = in2.varToStmt.get(l);
                this.add(l, newStmt);
            }
            this.alloc = in1.alloc != null && in1.alloc.equals(in2.alloc) ? in1.alloc : null;
        }

        public boolean equals(Object other) {
            if (!(other instanceof Fact)) {
                return false;
            }
            Fact o = (Fact)other;
            if (!this.stmtToVar.equals(o.stmtToVar)) {
                return false;
            }
            if (this.alloc == null && o.alloc != null) {
                return false;
            }
            if (this.alloc != null && o.alloc == null) {
                return false;
            }
            return this.alloc == null || this.alloc.equals(o.alloc);
        }

        public Stmt alloc() {
            return this.alloc;
        }

        public void setAlloc(Stmt newAlloc) {
            this.alloc = newAlloc;
        }
    }
}

