/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.toolkits.annotation.purity;

import java.util.Date;
import java.util.Iterator;
import java.util.List;
import soot.Body;
import soot.G;
import soot.Local;
import soot.RefLikeType;
import soot.SootMethod;
import soot.Type;
import soot.Value;
import soot.jimple.AssignStmt;
import soot.jimple.InstanceInvokeExpr;
import soot.jimple.InvokeExpr;
import soot.jimple.StaticInvokeExpr;
import soot.jimple.Stmt;
import soot.jimple.toolkits.annotation.purity.AbstractInterproceduralAnalysis;
import soot.jimple.toolkits.annotation.purity.PurityGraph;
import soot.jimple.toolkits.annotation.purity.PurityGraphBox;
import soot.jimple.toolkits.annotation.purity.PurityIntraproceduralAnalysis;
import soot.jimple.toolkits.annotation.purity.SootMethodFilter;
import soot.jimple.toolkits.callgraph.CallGraph;
import soot.options.PurityOptions;
import soot.tagkit.GenericAttribute;
import soot.tagkit.StringTag;
import soot.toolkits.graph.ExceptionalUnitGraph;
import soot.util.dot.DotGraph;

public class PurityInterproceduralAnalysis
extends AbstractInterproceduralAnalysis {
    private static final String[][] pureMethods = new String[][]{{"java.lang.", "valueOf"}, {"java.", "equals"}, {"javax.", "equals"}, {"sun.", "equals"}, {"java.", "compare"}, {"javax.", "compare"}, {"sun.", "compare"}, {"java.", "getClass"}, {"javax.", "getClass"}, {"sun.", "getClass"}, {"java.", "hashCode"}, {"javax.", "hashCode"}, {"sun.", "hashCode"}, {"java.", "toString"}, {"javax.", "toString"}, {"sun.", "toString"}, {"java.", "valueOf"}, {"javax.", "valueOf"}, {"sun.", "valueOf"}, {"java.", "compareTo"}, {"javax.", "compareTo"}, {"sun.", "compareTo"}, {"java.lang.System", "identityHashCode"}, {"java.", "<clinit>"}, {"javax.", "<clinit>"}, {"sun.", "<clinit>"}, {"java.lang.Math", "abs"}, {"java.lang.Math", "acos"}, {"java.lang.Math", "asin"}, {"java.lang.Math", "atan"}, {"java.lang.Math", "atan2"}, {"java.lang.Math", "ceil"}, {"java.lang.Math", "cos"}, {"java.lang.Math", "exp"}, {"java.lang.Math", "floor"}, {"java.lang.Math", "IEEEremainder"}, {"java.lang.Math", "log"}, {"java.lang.Math", "max"}, {"java.lang.Math", "min"}, {"java.lang.Math", "pow"}, {"java.lang.Math", "rint"}, {"java.lang.Math", "round"}, {"java.lang.Math", "sin"}, {"java.lang.Math", "sqrt"}, {"java.lang.Math", "tan"}, {"java.lang.Throwable", "<init>"}, {"java.lang.StringIndexOutOfBoundsException", "<init>"}};
    private static final String[][] impureMethods = new String[][]{{"java.io.", "<init>"}, {"java.io.", "close"}, {"java.io.", "read"}, {"java.io.", "write"}, {"java.io.", "flush"}, {"java.io.", "flushBuffer"}, {"java.io.", "print"}, {"java.io.", "println"}, {"java.lang.Runtime", "exit"}};
    private static final String[][] alterMethods = new String[][]{{"java.lang.System", "arraycopy"}, {"java.lang.FloatingDecimal", "dtoa"}, {"java.lang.FloatingDecimal", "developLongDigits"}, {"java.lang.FloatingDecimal", "big5pow"}, {"java.lang.FloatingDecimal", "getChars"}, {"java.lang.FloatingDecimal", "roundup"}};

    PurityInterproceduralAnalysis(CallGraph cg, Iterator<SootMethod> heads, PurityOptions opts) {
        super(cg, new Filter(), heads, opts.dump_cg());
        Iterator it;
        if (opts.dump_cg()) {
            G.v().out.println("[AM] Dumping empty .dot call-graph");
            this.drawAsOneDot("EmptyCallGraph");
        }
        Date start = new Date();
        G.v().out.println("[AM] Analysis began");
        this.doAnalysis(opts.verbose());
        G.v().out.println("[AM] Analysis finished");
        Date finish = new Date();
        long runtime = finish.getTime() - start.getTime();
        G.v().out.println("[AM] run time: " + (double)runtime / 1000.0 + " s");
        if (opts.dump_cg()) {
            G.v().out.println("[AM] Dumping annotated .dot call-graph");
            this.drawAsOneDot("CallGraph");
        }
        if (opts.dump_summaries()) {
            G.v().out.println("[AM] Dumping .dot summaries of analysed methods");
            this.drawAsManyDot("Summary_", false);
        }
        if (opts.dump_intra()) {
            G.v().out.println("[AM] Dumping .dot full intra-procedural method analyses");
            it = this.getAnalysedMethods();
            while (it.hasNext()) {
                SootMethod method = (SootMethod)it.next();
                Body body = method.retrieveActiveBody();
                ExceptionalUnitGraph graph = new ExceptionalUnitGraph(body);
                if (opts.verbose()) {
                    G.v().out.println("  |- " + method);
                }
                PurityIntraproceduralAnalysis r = new PurityIntraproceduralAnalysis(graph, this);
                r.drawAsOneDot("Intra_", method.toString());
                PurityGraphBox b = new PurityGraphBox();
                r.copyResult(b);
            }
        }
        G.v().out.println("[AM] Annotate methods. ");
        it = this.getAnalysedMethods();
        while (it.hasNext()) {
            SootMethod m = (SootMethod)it.next();
            PurityGraphBox b = (PurityGraphBox)this.getSummaryFor(m);
            boolean isPure = m.toString().indexOf("<init>") != -1 ? b.g.isPureConstructor() : b.g.isPure();
            m.addTag(new StringTag("purity: " + (isPure ? "pure" : "impure")));
            if (isPure && opts.annotate()) {
                m.addTag(new GenericAttribute("Pure", new byte[0]));
            }
            if (opts.print()) {
                G.v().out.println("  |- method " + m.toString() + " is " + (isPure ? "pure" : "impure"));
            }
            if (!m.isStatic()) {
                String s;
                int status = b.g.thisStatus();
                switch (status) {
                    case 0: {
                        s = "read/write";
                        break;
                    }
                    case 1: {
                        s = "read-only";
                        break;
                    }
                    case 2: {
                        s = "Safe";
                        break;
                    }
                    default: {
                        s = "unknown";
                    }
                }
                m.addTag(new StringTag("this: " + s));
                if (opts.print()) {
                    G.v().out.println("  |   |- this is " + s);
                }
            }
            Iterator<Type> itt = m.getParameterTypes().iterator();
            int i = 0;
            while (itt.hasNext()) {
                if (itt.next() instanceof RefLikeType) {
                    String s;
                    int status = b.g.paramStatus(i);
                    switch (status) {
                        case 0: {
                            s = "read/write";
                            break;
                        }
                        case 1: {
                            s = "read-only";
                            break;
                        }
                        case 2: {
                            s = "safe";
                            break;
                        }
                        default: {
                            s = "unknown";
                        }
                    }
                    m.addTag(new StringTag("param" + i + ": " + s));
                    if (opts.print()) {
                        G.v().out.println("  |   |- param " + i + " is " + s);
                    }
                }
                ++i;
            }
        }
    }

    @Override
    protected Object newInitialSummary() {
        return new PurityGraphBox();
    }

    @Override
    protected void merge(Object in1, Object in2, Object out) {
        PurityGraphBox i1 = (PurityGraphBox)in1;
        PurityGraphBox i2 = (PurityGraphBox)in2;
        PurityGraphBox o = (PurityGraphBox)out;
        if (out != i1) {
            o.g = new PurityGraph(i1.g);
        }
        o.g.union(i2.g);
    }

    @Override
    protected void copy(Object source, Object dest) {
        PurityGraphBox src = (PurityGraphBox)source;
        PurityGraphBox dst = (PurityGraphBox)dest;
        dst.g = new PurityGraph(src.g);
    }

    @Override
    protected void analyseMethod(SootMethod method, Object dst) {
        Body body = method.retrieveActiveBody();
        ExceptionalUnitGraph graph = new ExceptionalUnitGraph(body);
        PurityIntraproceduralAnalysis r = new PurityIntraproceduralAnalysis(graph, this);
        r.copyResult(dst);
    }

    @Override
    protected Object summaryOfUnanalysedMethod(SootMethod method) {
        String[][] o;
        PurityGraphBox b = new PurityGraphBox();
        String c = method.getDeclaringClass().toString();
        String m = method.getName();
        b.g = PurityGraph.conservativeGraph(method, true);
        for (String[] element : o = pureMethods) {
            if (!m.equals(element[1]) || !c.startsWith(element[0])) continue;
            b.g = PurityGraph.freshGraph(method);
        }
        for (String[] element : o = alterMethods) {
            if (!m.equals(element[1]) || !c.startsWith(element[0])) continue;
            b.g = PurityGraph.conservativeGraph(method, false);
        }
        return b;
    }

    @Override
    protected void applySummary(Object src, Stmt stmt, Object summary, Object dst) {
        Local v;
        InvokeExpr e = stmt.getInvokeExpr();
        Local ret = null;
        if (stmt instanceof AssignStmt && (v = (Local)((AssignStmt)stmt).getLeftOp()).getType() instanceof RefLikeType) {
            ret = v;
        }
        Local obj = null;
        if (!(e instanceof StaticInvokeExpr)) {
            obj = (Local)((InstanceInvokeExpr)e).getBase();
        }
        List<Value> args = e.getArgs();
        PurityGraphBox s = (PurityGraphBox)src;
        PurityGraphBox d = (PurityGraphBox)dst;
        PurityGraph g = new PurityGraph(s.g);
        g.methodCall(((PurityGraphBox)summary).g, obj, args, ret);
        d.g = g;
    }

    @Override
    protected void fillDotGraph(String prefix, Object o, DotGraph out) {
        PurityGraphBox b = (PurityGraphBox)o;
        b.g.fillDotGraph(prefix, out);
    }

    private static class Filter
    implements SootMethodFilter {
        private Filter() {
        }

        @Override
        public boolean want(SootMethod method) {
            String[][] o;
            String c = method.getDeclaringClass().toString();
            String m = method.getName();
            for (String[] element : o = pureMethods) {
                if (!m.equals(element[1]) || !c.startsWith(element[0])) continue;
                return false;
            }
            for (String[] element : o = impureMethods) {
                if (!m.equals(element[1]) || !c.startsWith(element[0])) continue;
                return false;
            }
            for (String[] element : o = alterMethods) {
                if (!m.equals(element[1]) || !c.startsWith(element[0])) continue;
                return false;
            }
            return true;
        }
    }
}

