/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.spark.geom.geomPA;

import java.util.ArrayList;
import java.util.Deque;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import soot.SootClass;
import soot.jimple.InstanceInvokeExpr;
import soot.jimple.Stmt;
import soot.jimple.spark.geom.dataRep.PlainConstraint;
import soot.jimple.spark.geom.geomPA.GeomPointsTo;
import soot.jimple.spark.geom.geomPA.IVarAbstraction;
import soot.jimple.spark.geom.geomPA.Parameters;
import soot.jimple.spark.geom.utils.ZArrayNumberer;
import soot.jimple.spark.pag.AllocNode;
import soot.jimple.spark.pag.GlobalVarNode;
import soot.jimple.spark.pag.LocalVarNode;
import soot.jimple.spark.pag.Node;
import soot.jimple.spark.pag.SparkField;
import soot.jimple.spark.pag.VarNode;
import soot.jimple.spark.sets.P2SetVisitor;

public class OfflineProcessor {
    private boolean visitedFlag;
    GeomPointsTo geomPTA;
    ZArrayNumberer<IVarAbstraction> int2var;
    ArrayList<off_graph_edge> varGraph;
    int[] pre;
    int[] low;
    int[] count;
    int[] rep;
    int[] repsize;
    Deque<Integer> queue;
    int pre_cnt;
    int n_var;

    public OfflineProcessor(GeomPointsTo pta) {
        this.int2var = pta.pointers;
        int size = this.int2var.size();
        this.varGraph = new ArrayList(size);
        this.queue = new LinkedList<Integer>();
        this.pre = new int[size];
        this.low = new int[size];
        this.count = new int[size];
        this.rep = new int[size];
        this.repsize = new int[size];
        this.geomPTA = pta;
        for (int i = 0; i < size; ++i) {
            this.varGraph.add(null);
        }
    }

    public void init() {
        this.n_var = this.int2var.size();
        for (int i = 0; i < this.n_var; ++i) {
            this.varGraph.set(i, null);
            ((IVarAbstraction)this.int2var.get((long)((long)i))).willUpdate = false;
        }
    }

    public void defaultFeedPtsRoutines() {
        switch (Parameters.seedPts) {
            case 15: {
                this.setAllUserCodeVariablesUseful();
                break;
            }
            case 0x7FFFFFFF: {
                for (int i = 0; i < this.n_var; ++i) {
                    IVarAbstraction pn = (IVarAbstraction)this.int2var.get(i);
                    if (pn == null || pn.getRepresentative() != pn) continue;
                    pn.willUpdate = true;
                }
                return;
            }
        }
        HashSet<Node> multiBaseptrs = new HashSet<Node>();
        for (Stmt callsite : this.geomPTA.multiCallsites) {
            InstanceInvokeExpr iie = (InstanceInvokeExpr)callsite.getInvokeExpr();
            LocalVarNode vn = this.geomPTA.findLocalVarNode(iie.getBase());
            multiBaseptrs.add(vn);
        }
        this.addUserDefPts(multiBaseptrs);
    }

    public void addUserDefPts(Set<Node> initVars) {
        for (Node vn : initVars) {
            IVarAbstraction pn = this.geomPTA.findInternalNode(vn);
            if (pn == null || !(pn = pn.getRepresentative()).reachable()) continue;
            pn.willUpdate = true;
        }
    }

    public void releaseSparkMem() {
        for (int i = 0; i < this.n_var; ++i) {
            IVarAbstraction pn = (IVarAbstraction)this.int2var.get(i);
            if (pn != pn.getRepresentative() || !pn.willUpdate) continue;
            Node vn = pn.getWrappedNode();
            vn.discardP2Set();
        }
        System.gc();
        System.gc();
        System.gc();
        System.gc();
    }

    public void runOptimizations() {
        this.buildDependenceGraph();
        this.distillConstraints();
        this.buildImpactGraph();
        this.computeWeightsForPts();
    }

    public void destroy() {
        this.pre = null;
        this.low = null;
        this.count = null;
        this.rep = null;
        this.repsize = null;
        this.varGraph = null;
        this.queue = null;
    }

    protected void buildDependenceGraph() {
        block5: for (PlainConstraint cons : this.geomPTA.constraints) {
            final IVarAbstraction lhs = cons.getLHS();
            final IVarAbstraction rhs = cons.getRHS();
            final SparkField field = cons.f;
            switch (cons.type) {
                case 1: {
                    this.add_graph_edge(rhs.id, lhs.id);
                    break;
                }
                case 2: {
                    off_graph_edge e;
                    IVarAbstraction padf;
                    IVarAbstraction rep = lhs.getRepresentative();
                    if (!rep.hasPTResult()) {
                        lhs.getWrappedNode().getP2Set().forall(new P2SetVisitor(){

                            @Override
                            public void visit(Node n) {
                                IVarAbstraction padf = OfflineProcessor.this.geomPTA.findInstanceField((AllocNode)n, field);
                                if (padf == null || !padf.reachable()) {
                                    return;
                                }
                                off_graph_edge e = OfflineProcessor.this.add_graph_edge(rhs.id, padf.id);
                                e.base_var = lhs;
                            }
                        });
                        break;
                    }
                    for (AllocNode o : rep.get_all_points_to_objects()) {
                        padf = this.geomPTA.findInstanceField(o, field);
                        if (padf == null || !padf.reachable()) continue;
                        e = this.add_graph_edge(rhs.id, padf.id);
                        e.base_var = lhs;
                    }
                    continue block5;
                }
                case 3: {
                    off_graph_edge e;
                    IVarAbstraction padf;
                    IVarAbstraction rep = rhs.getRepresentative();
                    if (!rep.hasPTResult()) {
                        rhs.getWrappedNode().getP2Set().forall(new P2SetVisitor(){

                            @Override
                            public void visit(Node n) {
                                IVarAbstraction padf = OfflineProcessor.this.geomPTA.findInstanceField((AllocNode)n, field);
                                if (padf == null || !padf.reachable()) {
                                    return;
                                }
                                off_graph_edge e = OfflineProcessor.this.add_graph_edge(padf.id, lhs.id);
                                e.base_var = rhs;
                            }
                        });
                        break;
                    }
                    for (AllocNode o : rep.get_all_points_to_objects()) {
                        padf = this.geomPTA.findInstanceField(o, field);
                        if (padf == null || !padf.reachable()) continue;
                        e = this.add_graph_edge(padf.id, lhs.id);
                        e.base_var = rhs;
                    }
                    break;
                }
            }
        }
    }

    protected void setAllUserCodeVariablesUseful() {
        for (int i = 0; i < this.n_var; ++i) {
            SootClass sc;
            IVarAbstraction pn = (IVarAbstraction)this.int2var.get(i);
            if (pn != pn.getRepresentative()) continue;
            Node node = pn.getWrappedNode();
            int sm_id = this.geomPTA.getMappedMethodID(pn);
            if (!this.geomPTA.isReachableMethod(sm_id) || !(node instanceof VarNode)) continue;
            boolean defined_in_lib = false;
            if (node instanceof LocalVarNode) {
                defined_in_lib = ((LocalVarNode)node).getMethod().isJavaLibraryMethod();
            } else if (node instanceof GlobalVarNode && (sc = ((GlobalVarNode)node).getDeclaringClass()) != null) {
                defined_in_lib = sc.isJavaLibraryClass();
            }
            if (defined_in_lib || this.geomPTA.isExceptionPointer(node)) continue;
            pn.willUpdate = true;
        }
    }

    protected void computeReachablePts() {
        IVarAbstraction pn;
        int i;
        this.queue.clear();
        for (i = 0; i < this.n_var; ++i) {
            pn = (IVarAbstraction)this.int2var.get(i);
            if (!pn.willUpdate) continue;
            this.queue.add(i);
        }
        while (!this.queue.isEmpty()) {
            i = this.queue.getFirst();
            this.queue.removeFirst();
            off_graph_edge p = this.varGraph.get(i);
            while (p != null) {
                pn = (IVarAbstraction)this.int2var.get(p.t);
                if (!pn.willUpdate) {
                    pn.willUpdate = true;
                    this.queue.add(p.t);
                }
                if ((pn = p.base_var) != null && !pn.willUpdate) {
                    pn.willUpdate = true;
                    this.queue.add(pn.id);
                }
                p = p.next;
            }
        }
    }

    protected void distillConstraints() {
        this.computeReachablePts();
        for (PlainConstraint cons : this.geomPTA.constraints) {
            IVarAbstraction pn = cons.getRHS();
            final SparkField field = cons.f;
            this.visitedFlag = false;
            block0 : switch (cons.type) {
                case 0: 
                case 1: 
                case 2: {
                    this.visitedFlag = pn.willUpdate;
                    break;
                }
                case 3: {
                    pn = pn.getRepresentative();
                    if (!pn.hasPTResult()) {
                        pn.getWrappedNode().getP2Set().forall(new P2SetVisitor(){

                            @Override
                            public void visit(Node n) {
                                if (OfflineProcessor.this.visitedFlag) {
                                    return;
                                }
                                IVarAbstraction padf = OfflineProcessor.this.geomPTA.findInstanceField((AllocNode)n, field);
                                if (padf == null || !padf.reachable()) {
                                    return;
                                }
                                OfflineProcessor.this.visitedFlag = (byte)(OfflineProcessor.this.visitedFlag | (padf.willUpdate ? 1 : 0));
                            }
                        });
                        break;
                    }
                    for (AllocNode o : pn.get_all_points_to_objects()) {
                        IVarAbstraction padf = this.geomPTA.findInstanceField(o, field);
                        if (padf == null || !padf.reachable()) continue;
                        this.visitedFlag |= padf.willUpdate;
                        if (!this.visitedFlag) continue;
                        break block0;
                    }
                    break;
                }
            }
            cons.isActive = this.visitedFlag;
        }
    }

    protected void buildImpactGraph() {
        for (int i = 0; i < this.n_var; ++i) {
            this.varGraph.set(i, null);
        }
        this.queue.clear();
        block7: for (PlainConstraint cons : this.geomPTA.constraints) {
            if (!cons.isActive) continue;
            final IVarAbstraction lhs = cons.getLHS();
            final IVarAbstraction rhs = cons.getRHS();
            final SparkField field = cons.f;
            switch (cons.type) {
                case 0: {
                    this.queue.add(rhs.id);
                    break;
                }
                case 1: {
                    this.add_graph_edge(lhs.id, rhs.id);
                    break;
                }
                case 2: {
                    IVarAbstraction padf;
                    IVarAbstraction rep = lhs.getRepresentative();
                    if (!rep.hasPTResult()) {
                        lhs.getWrappedNode().getP2Set().forall(new P2SetVisitor(){

                            @Override
                            public void visit(Node n) {
                                IVarAbstraction padf = OfflineProcessor.this.geomPTA.findInstanceField((AllocNode)n, field);
                                if (padf == null || !padf.reachable()) {
                                    return;
                                }
                                OfflineProcessor.this.add_graph_edge(padf.id, rhs.id);
                            }
                        });
                        break;
                    }
                    for (AllocNode o : rep.get_all_points_to_objects()) {
                        padf = this.geomPTA.findInstanceField(o, field);
                        if (padf == null || !padf.reachable()) continue;
                        this.add_graph_edge(padf.id, rhs.id);
                    }
                    continue block7;
                }
                case 3: {
                    IVarAbstraction padf;
                    IVarAbstraction rep = rhs.getRepresentative();
                    if (!rep.hasPTResult()) {
                        rhs.getWrappedNode().getP2Set().forall(new P2SetVisitor(){

                            @Override
                            public void visit(Node n) {
                                IVarAbstraction padf = OfflineProcessor.this.geomPTA.findInstanceField((AllocNode)n, field);
                                if (padf == null || !padf.reachable()) {
                                    return;
                                }
                                OfflineProcessor.this.add_graph_edge(lhs.id, padf.id);
                            }
                        });
                        break;
                    }
                    for (AllocNode o : rep.get_all_points_to_objects()) {
                        padf = this.geomPTA.findInstanceField(o, field);
                        if (padf == null || !padf.reachable()) continue;
                        this.add_graph_edge(lhs.id, padf.id);
                    }
                    break;
                }
            }
        }
    }

    protected void computeWeightsForPts() {
        int t;
        int s;
        off_graph_edge p;
        IVarAbstraction node;
        int i;
        this.pre_cnt = 0;
        for (i = 0; i < this.n_var; ++i) {
            this.pre[i] = -1;
            this.count[i] = 0;
            this.rep[i] = i;
            this.repsize[i] = 1;
            node = (IVarAbstraction)this.int2var.get(i);
            node.top_value = Integer.MIN_VALUE;
        }
        for (i = 0; i < this.n_var; ++i) {
            if (this.pre[i] != -1) continue;
            this.tarjan_scc(i);
        }
        for (i = 0; i < this.n_var; ++i) {
            p = this.varGraph.get(i);
            s = this.find_parent(i);
            while (p != null) {
                t = this.find_parent(p.t);
                if (t != s) {
                    int n = t;
                    this.count[n] = this.count[n] + 1;
                }
                p = p.next;
            }
        }
        for (i = 0; i < this.n_var; ++i) {
            p = this.varGraph.get(i);
            if (p == null || this.rep[i] == i) continue;
            t = this.find_parent(i);
            while (p.next != null) {
                p = p.next;
            }
            p.next = this.varGraph.get(t);
            this.varGraph.set(t, this.varGraph.get(i));
            this.varGraph.set(i, null);
        }
        this.queue.clear();
        for (i = 0; i < this.n_var; ++i) {
            if (this.rep[i] != i || this.count[i] != 0) continue;
            this.queue.addLast(i);
        }
        i = 0;
        while (!this.queue.isEmpty()) {
            s = this.queue.getFirst();
            this.queue.removeFirst();
            node = (IVarAbstraction)this.int2var.get(s);
            node.top_value = i;
            i += this.repsize[s];
            p = this.varGraph.get(s);
            while (p != null) {
                t = this.find_parent(p.t);
                if (t != s) {
                    int n = t;
                    this.count[n] = this.count[n] - 1;
                    if (this.count[n] == 0) {
                        this.queue.addLast(t);
                    }
                }
                p = p.next;
            }
        }
        for (i = this.n_var - 1; i > -1; --i) {
            if (this.rep[i] == i) continue;
            node = (IVarAbstraction)this.int2var.get(this.find_parent(i));
            IVarAbstraction me = (IVarAbstraction)this.int2var.get(i);
            me.top_value = node.top_value + this.repsize[node.id] - 1;
            int n = node.id;
            this.repsize[n] = this.repsize[n] - 1;
        }
    }

    private off_graph_edge add_graph_edge(int s, int t) {
        off_graph_edge e = new off_graph_edge();
        e.s = s;
        e.t = t;
        e.next = this.varGraph.get(s);
        this.varGraph.set(s, e);
        return e;
    }

    private void tarjan_scc(int s) {
        int t;
        ++this.pre_cnt;
        this.pre[s] = this.low[s];
        this.queue.addLast(s);
        off_graph_edge p = this.varGraph.get(s);
        while (p != null) {
            t = p.t;
            if (this.pre[t] == -1) {
                this.tarjan_scc(t);
            }
            if (this.low[t] < this.low[s]) {
                this.low[s] = this.low[t];
            }
            p = p.next;
        }
        if (this.low[s] < this.pre[s]) {
            return;
        }
        int w = s;
        do {
            t = this.queue.getLast();
            this.queue.removeLast();
            int n = t;
            this.low[n] = this.low[n] + this.n_var;
            w = this.merge_nodes(w, t);
        } while (t != s);
    }

    private int find_parent(int v) {
        return v == this.rep[v] ? v : this.find_parent(this.rep[v]);
    }

    private int merge_nodes(int v1, int v2) {
        if ((v1 = this.find_parent(v1)) != (v2 = this.find_parent(v2))) {
            if (this.repsize[v1] < this.repsize[v2]) {
                int t = v1;
                v1 = v2;
                v2 = t;
            }
            this.rep[v2] = v1;
            int n = v1;
            this.repsize[n] = this.repsize[n] + this.repsize[v2];
        }
        return v1;
    }

    class off_graph_edge {
        int s;
        int t;
        IVarAbstraction base_var;
        off_graph_edge next;

        off_graph_edge() {
        }
    }
}

