/*
 * Decompiled with CFR 0.152.
 */
package soot.javaToJimple;

import soot.Body;
import soot.Local;
import soot.MethodSource;
import soot.Scene;
import soot.SootFieldRef;
import soot.SootMethod;
import soot.Type;
import soot.javaToJimple.LocalGenerator;
import soot.jimple.AssignStmt;
import soot.jimple.FieldRef;
import soot.jimple.IdentityStmt;
import soot.jimple.Jimple;
import soot.jimple.JimpleBody;
import soot.jimple.ParameterRef;
import soot.jimple.ReturnStmt;

public class PrivateFieldSetMethodSource
implements MethodSource {
    private final Type fieldType;
    private final String fieldName;
    private final boolean isStatic;

    public PrivateFieldSetMethodSource(Type fieldType, String fieldName, boolean isStatic) {
        this.fieldType = fieldType;
        this.fieldName = fieldName;
        this.isStatic = isStatic;
    }

    @Override
    public Body getBody(SootMethod sootMethod, String phaseName) {
        JimpleBody body = Jimple.v().newBody(sootMethod);
        LocalGenerator lg = new LocalGenerator(body);
        Local fieldBase = null;
        Local assignLocal = null;
        int paramCounter = 0;
        for (Type sootType : sootMethod.getParameterTypes()) {
            Local paramLocal = lg.generateLocal(sootType);
            ParameterRef paramRef = Jimple.v().newParameterRef(sootType, paramCounter);
            IdentityStmt stmt = Jimple.v().newIdentityStmt(paramLocal, paramRef);
            body.getUnits().add(stmt);
            if (paramCounter == 0) {
                fieldBase = paramLocal;
            }
            assignLocal = paramLocal;
            ++paramCounter;
        }
        SootFieldRef field = Scene.v().makeFieldRef(sootMethod.getDeclaringClass(), this.fieldName, this.fieldType, this.isStatic);
        FieldRef fieldRef = null;
        fieldRef = this.isStatic ? Jimple.v().newStaticFieldRef(field) : Jimple.v().newInstanceFieldRef(fieldBase, field);
        AssignStmt assign = Jimple.v().newAssignStmt(fieldRef, assignLocal);
        body.getUnits().add(assign);
        ReturnStmt retStmt = Jimple.v().newReturnStmt(assignLocal);
        body.getUnits().add(retStmt);
        return body;
    }
}

