/*
 * Decompiled with CFR 0.152.
 */
package soot.dava.toolkits.base.finders;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import soot.G;
import soot.Singletons;
import soot.Trap;
import soot.Unit;
import soot.dava.Dava;
import soot.dava.DavaBody;
import soot.dava.RetriggerAnalysisException;
import soot.dava.internal.SET.SETNode;
import soot.dava.internal.SET.SETTryNode;
import soot.dava.internal.asg.AugmentedStmt;
import soot.dava.internal.asg.AugmentedStmtGraph;
import soot.dava.toolkits.base.finders.ExceptionNode;
import soot.dava.toolkits.base.finders.FactFinder;
import soot.jimple.GotoStmt;
import soot.jimple.Stmt;
import soot.util.IterableSet;

public class ExceptionFinder
implements FactFinder {
    public ExceptionFinder(Singletons.Global g) {
    }

    public static ExceptionFinder v() {
        return G.v().soot_dava_toolkits_base_finders_ExceptionFinder();
    }

    @Override
    public void find(DavaBody body, AugmentedStmtGraph asg, SETNode SET) throws RetriggerAnalysisException {
        Dava.v().log("ExceptionFinder::find()");
        for (ExceptionNode en : body.get_ExceptionFacts()) {
            if (body.get_SynchronizedBlockFacts().contains(en)) continue;
            IterableSet fullBody = new IterableSet();
            Iterator cit = en.get_CatchList().iterator();
            while (cit.hasNext()) {
                fullBody.addAll((IterableSet)cit.next());
            }
            fullBody.addAll(en.get_TryBody());
            if (SET.nest(new SETTryNode(fullBody, en, asg, body))) continue;
            throw new RetriggerAnalysisException();
        }
    }

    public void preprocess(DavaBody body, AugmentedStmtGraph asg) {
        Dava.v().log("ExceptionFinder::preprocess()");
        IterableSet<ExceptionNode> enlist = new IterableSet<ExceptionNode>();
        for (Trap trap : body.getTraps()) {
            Unit endUnit = trap.getEndUnit();
            IterableSet<AugmentedStmt> tryBody = new IterableSet<AugmentedStmt>();
            Iterator<Unit> btit = body.getUnits().iterator(trap.getBeginUnit());
            Unit u = btit.next();
            while (u != endUnit) {
                tryBody.add(asg.get_AugStmt((Stmt)u));
                u = btit.next();
            }
            enlist.add(new ExceptionNode(tryBody, trap.getException(), asg.get_AugStmt((Stmt)trap.getHandlerUnit())));
        }
        for (ExceptionNode en : enlist) {
            IterableSet try_body = en.get_TryBody();
            Iterator tryIt = try_body.snapshotIterator();
            while (tryIt.hasNext()) {
                AugmentedStmt tras = (AugmentedStmt)tryIt.next();
                for (AugmentedStmt pas : tras.cpreds) {
                    Stmt ps = pas.get_Stmt();
                    if (try_body.contains(pas) || !(ps instanceof GotoStmt)) continue;
                    boolean add_it = true;
                    Iterator<AugmentedStmt> cpit = pas.cpreds.iterator();
                    while (cpit.hasNext() && (add_it = try_body.contains(cpit.next()))) {
                    }
                    if (!add_it) continue;
                    en.add_TryStmt(pas);
                }
            }
        }
        block6: while (true) {
            Iterator enlit = enlist.iterator();
            while (enlit.hasNext()) {
                ((ExceptionNode)enlit.next()).refresh_CatchBody(this);
            }
            ExceptionNode[] ena = new ExceptionNode[enlist.size()];
            Iterator enlit2 = enlist.iterator();
            int i = 0;
            while (enlit2.hasNext()) {
                ena[i] = (ExceptionNode)enlit2.next();
                ++i;
            }
            for (i = 0; i < ena.length - 1; ++i) {
                ExceptionNode eni = ena[i];
                for (int j = i + 1; j < ena.length; ++j) {
                    IterableSet enjTryBody;
                    ExceptionNode enj = ena[j];
                    IterableSet eniTryBody = eni.get_TryBody();
                    if (eniTryBody.equals(enjTryBody = enj.get_TryBody()) || !eniTryBody.intersects(enjTryBody) || eniTryBody.isSupersetOf(enj.get_Body()) || enjTryBody.isSupersetOf(eni.get_Body())) continue;
                    IterableSet newTryBody = eniTryBody.intersection(enjTryBody);
                    if (newTryBody.equals(enjTryBody)) {
                        eni.splitOff_ExceptionNode(newTryBody, asg, enlist);
                        continue block6;
                    }
                    enj.splitOff_ExceptionNode(newTryBody, asg, enlist);
                    continue block6;
                }
            }
            for (ExceptionNode en : enlist) {
                IterableSet tryBody = en.get_TryBody();
                LinkedList<AugmentedStmt> heads = new LinkedList<AugmentedStmt>();
                block12: for (AugmentedStmt as : tryBody) {
                    if (as.cpreds.isEmpty()) {
                        heads.add(as);
                        continue;
                    }
                    Iterator<AugmentedStmt> pit = as.cpreds.iterator();
                    while (pit.hasNext()) {
                        if (tryBody.contains(pit.next())) continue;
                        heads.add(as);
                        continue block12;
                    }
                }
                HashSet<AugmentedStmt> touchSet = new HashSet<AugmentedStmt>();
                touchSet.addAll(heads);
                AugmentedStmt head = (AugmentedStmt)heads.removeFirst();
                IterableSet<AugmentedStmt> subTryBlock = new IterableSet<AugmentedStmt>();
                LinkedList<AugmentedStmt> worklist = new LinkedList<AugmentedStmt>();
                worklist.add(head);
                while (!worklist.isEmpty()) {
                    AugmentedStmt as = (AugmentedStmt)worklist.removeFirst();
                    subTryBlock.add(as);
                    for (AugmentedStmt sas : as.csuccs) {
                        if (!tryBody.contains(sas) || touchSet.contains(sas)) continue;
                        touchSet.add(sas);
                        if (sas.get_Dominators().contains(head)) {
                            worklist.add(sas);
                            continue;
                        }
                        heads.addLast(sas);
                    }
                }
                if (heads.isEmpty()) continue;
                en.splitOff_ExceptionNode(subTryBlock, asg, enlist);
                continue block6;
            }
            break;
        }
        LinkedList<ExceptionNode> reps = new LinkedList<ExceptionNode>();
        HashMap hCode2bucket = new HashMap();
        HashMap<IterableSet, ExceptionNode> tryBody2exceptionNode = new HashMap<IterableSet, ExceptionNode>();
        for (ExceptionNode en : enlist) {
            int hashCode = 0;
            IterableSet curTryBody = en.get_TryBody();
            Iterator trit = curTryBody.iterator();
            while (trit.hasNext()) {
                hashCode ^= trit.next().hashCode();
            }
            Integer I = new Integer(hashCode);
            LinkedList<IterableSet> bucket = (LinkedList<IterableSet>)hCode2bucket.get(I);
            if (bucket == null) {
                bucket = new LinkedList<IterableSet>();
                hCode2bucket.put(I, bucket);
            }
            ExceptionNode repExceptionNode = null;
            for (IterableSet bucketTryBody : bucket) {
                if (!bucketTryBody.equals(curTryBody)) continue;
                repExceptionNode = (ExceptionNode)tryBody2exceptionNode.get(bucketTryBody);
                break;
            }
            if (repExceptionNode == null) {
                tryBody2exceptionNode.put(curTryBody, en);
                bucket.add(curTryBody);
                reps.add(en);
                continue;
            }
            repExceptionNode.add_CatchBody(en);
        }
        enlist.clear();
        enlist.addAll(reps);
        body.get_ExceptionFacts().clear();
        body.get_ExceptionFacts().addAll(enlist);
    }

    public IterableSet get_CatchBody(AugmentedStmt handlerAugmentedStmt) {
        IterableSet<AugmentedStmt> catchBody = new IterableSet<AugmentedStmt>();
        LinkedList<AugmentedStmt> catchQueue = new LinkedList<AugmentedStmt>();
        catchBody.add(handlerAugmentedStmt);
        catchQueue.addAll(handlerAugmentedStmt.csuccs);
        while (!catchQueue.isEmpty()) {
            AugmentedStmt as = (AugmentedStmt)catchQueue.removeFirst();
            if (catchBody.contains(as) || !as.get_Dominators().contains(handlerAugmentedStmt)) continue;
            catchBody.add(as);
            catchQueue.addAll(as.csuccs);
        }
        return catchBody;
    }
}

