/*
 * Decompiled with CFR 0.152.
 */
package soot.dava.toolkits.base.AST.transformations;

import java.util.HashMap;
import java.util.List;
import soot.Local;
import soot.SootField;
import soot.Value;
import soot.ValueBox;
import soot.dava.internal.AST.ASTAggregatedCondition;
import soot.dava.internal.AST.ASTBinaryCondition;
import soot.dava.internal.AST.ASTCondition;
import soot.dava.internal.AST.ASTDoWhileNode;
import soot.dava.internal.AST.ASTForLoopNode;
import soot.dava.internal.AST.ASTIfElseNode;
import soot.dava.internal.AST.ASTIfNode;
import soot.dava.internal.AST.ASTMethodNode;
import soot.dava.internal.AST.ASTStatementSequenceNode;
import soot.dava.internal.AST.ASTSwitchNode;
import soot.dava.internal.AST.ASTUnaryCondition;
import soot.dava.internal.AST.ASTWhileNode;
import soot.dava.internal.asg.AugmentedStmt;
import soot.dava.toolkits.base.AST.analysis.DepthFirstAdapter;
import soot.dava.toolkits.base.AST.structuredAnalysis.CP;
import soot.dava.toolkits.base.AST.structuredAnalysis.CPFlowSet;
import soot.dava.toolkits.base.AST.structuredAnalysis.CPHelper;
import soot.dava.toolkits.base.AST.structuredAnalysis.DavaFlowSet;
import soot.jimple.ConditionExpr;
import soot.jimple.FieldRef;
import soot.jimple.Stmt;

public class CPApplication
extends DepthFirstAdapter {
    CP cp = null;
    String className = null;

    public CPApplication(ASTMethodNode AST, HashMap<String, Object> constantValueFields, HashMap<String, SootField> classNameFieldNameToSootFieldMapping) {
        this.className = AST.getDavaBody().getMethod().getDeclaringClass().getName();
        this.cp = new CP(AST, constantValueFields, classNameFieldNameToSootFieldMapping);
    }

    public CPApplication(boolean verbose, ASTMethodNode AST, HashMap<String, Object> constantValueFields, HashMap<String, SootField> classNameFieldNameToSootFieldMapping) {
        super(verbose);
        this.className = AST.getDavaBody().getMethod().getDeclaringClass().getName();
        this.cp = new CP(AST, constantValueFields, classNameFieldNameToSootFieldMapping);
    }

    @Override
    public void inASTSwitchNode(ASTSwitchNode node) {
        Value newValue;
        FieldRef useField;
        SootField usedSootField;
        Object value;
        DavaFlowSet obj = this.cp.getBeforeSet(node);
        if (obj == null) {
            return;
        }
        if (!(obj instanceof CPFlowSet)) {
            return;
        }
        CPFlowSet beforeSet = (CPFlowSet)obj;
        Value key = node.get_Key();
        if (key instanceof Local) {
            Value newValue2;
            Local useLocal = (Local)key;
            Object value2 = beforeSet.contains(this.className, useLocal.toString());
            if (value2 != null && (newValue2 = CPHelper.createConstant(value2)) != null) {
                node.set_Key(newValue2);
            }
        } else if (key instanceof FieldRef && (value = beforeSet.contains((usedSootField = (useField = (FieldRef)key).getField()).getDeclaringClass().getName(), usedSootField.getName().toString())) != null && (newValue = CPHelper.createConstant(value)) != null) {
            node.set_Key(newValue);
        }
    }

    @Override
    public void inASTForLoopNode(ASTForLoopNode node) {
        for (AugmentedStmt augmentedStmt : node.getInit()) {
            Stmt s = augmentedStmt.get_Stmt();
            List<ValueBox> useBoxes = s.getUseBoxes();
            DavaFlowSet davaFlowSet = this.cp.getBeforeSet(s);
            if (davaFlowSet == null || !(davaFlowSet instanceof CPFlowSet)) continue;
            CPFlowSet beforeSet = (CPFlowSet)davaFlowSet;
            this.substituteUses(useBoxes, beforeSet);
        }
        DavaFlowSet davaFlowSet = this.cp.getAfterSet(node);
        if (davaFlowSet == null) {
            return;
        }
        if (!(davaFlowSet instanceof CPFlowSet)) {
            return;
        }
        CPFlowSet afterSet = (CPFlowSet)davaFlowSet;
        ASTCondition cond = node.get_Condition();
        this.changedCondition(cond, afterSet);
        for (AugmentedStmt augmentedStmt : node.getUpdate()) {
            Stmt s = augmentedStmt.get_Stmt();
            List<ValueBox> useBoxes = s.getUseBoxes();
            this.substituteUses(useBoxes, afterSet);
        }
    }

    @Override
    public void inASTWhileNode(ASTWhileNode node) {
        DavaFlowSet obj = this.cp.getAfterSet(node);
        if (obj == null) {
            return;
        }
        if (!(obj instanceof CPFlowSet)) {
            return;
        }
        CPFlowSet afterSet = (CPFlowSet)obj;
        ASTCondition cond = node.get_Condition();
        this.changedCondition(cond, afterSet);
    }

    @Override
    public void inASTDoWhileNode(ASTDoWhileNode node) {
        DavaFlowSet obj = this.cp.getAfterSet(node);
        if (obj == null) {
            return;
        }
        if (!(obj instanceof CPFlowSet)) {
            return;
        }
        CPFlowSet afterSet = (CPFlowSet)obj;
        ASTCondition cond = node.get_Condition();
        this.changedCondition(cond, afterSet);
    }

    @Override
    public void inASTIfNode(ASTIfNode node) {
        DavaFlowSet obj = this.cp.getBeforeSet(node);
        if (obj == null) {
            return;
        }
        if (!(obj instanceof CPFlowSet)) {
            return;
        }
        CPFlowSet beforeSet = (CPFlowSet)obj;
        ASTCondition cond = node.get_Condition();
        this.changedCondition(cond, beforeSet);
    }

    @Override
    public void inASTIfElseNode(ASTIfElseNode node) {
        DavaFlowSet obj = this.cp.getBeforeSet(node);
        if (obj == null) {
            return;
        }
        if (!(obj instanceof CPFlowSet)) {
            return;
        }
        CPFlowSet beforeSet = (CPFlowSet)obj;
        ASTCondition cond = node.get_Condition();
        this.changedCondition(cond, beforeSet);
    }

    public ASTCondition changedCondition(ASTCondition cond, CPFlowSet set) {
        if (cond instanceof ASTAggregatedCondition) {
            ASTCondition left = this.changedCondition(((ASTAggregatedCondition)cond).getLeftOp(), set);
            ASTCondition right = this.changedCondition(((ASTAggregatedCondition)cond).getRightOp(), set);
            ((ASTAggregatedCondition)cond).setLeftOp(left);
            ((ASTAggregatedCondition)cond).setRightOp(right);
            return cond;
        }
        if (cond instanceof ASTUnaryCondition) {
            Value val = ((ASTUnaryCondition)cond).getValue();
            if (val instanceof Local) {
                Value newValue;
                Object value = set.contains(this.className, ((Local)val).toString());
                if (value != null && (newValue = CPHelper.createConstant(value)) != null) {
                    ((ASTUnaryCondition)cond).setValue(newValue);
                }
            } else if (val instanceof FieldRef) {
                Value newValue;
                FieldRef useField = (FieldRef)val;
                SootField usedSootField = useField.getField();
                Object value = set.contains(usedSootField.getDeclaringClass().getName(), usedSootField.getName().toString());
                if (value != null && (newValue = CPHelper.createConstant(value)) != null) {
                    ((ASTUnaryCondition)cond).setValue(newValue);
                }
            } else {
                this.substituteUses(val.getUseBoxes(), set);
            }
            return cond;
        }
        if (cond instanceof ASTBinaryCondition) {
            ConditionExpr val = ((ASTBinaryCondition)cond).getConditionExpr();
            this.substituteUses(val.getUseBoxes(), set);
            return cond;
        }
        throw new RuntimeException("Method getUseList in ASTUsesAndDefs encountered unknown condition type");
    }

    @Override
    public void inASTStatementSequenceNode(ASTStatementSequenceNode node) {
        List<Object> statements = node.getStatements();
        for (AugmentedStmt augmentedStmt : statements) {
            Stmt s = augmentedStmt.get_Stmt();
            List<ValueBox> useBoxes = s.getUseBoxes();
            DavaFlowSet obj = this.cp.getBeforeSet(s);
            if (obj == null || !(obj instanceof CPFlowSet)) continue;
            CPFlowSet beforeSet = (CPFlowSet)obj;
            this.substituteUses(useBoxes, beforeSet);
        }
    }

    public void substituteUses(List useBoxes, CPFlowSet beforeSet) {
        for (Object useObj : useBoxes) {
            Value newValue;
            FieldRef useField;
            SootField usedSootField;
            Object value;
            Value use = ((ValueBox)useObj).getValue();
            if (use instanceof Local) {
                Value newValue2;
                Local useLocal = (Local)use;
                Object value2 = beforeSet.contains(this.className, useLocal.toString());
                if (value2 == null || (newValue2 = CPHelper.createConstant(value2)) == null) continue;
                ((ValueBox)useObj).setValue(newValue2);
                continue;
            }
            if (!(use instanceof FieldRef) || (value = beforeSet.contains((usedSootField = (useField = (FieldRef)use).getField()).getDeclaringClass().getName(), usedSootField.getName().toString())) == null || (newValue = CPHelper.createConstant(value)) == null) continue;
            ((ValueBox)useObj).setValue(newValue);
        }
    }
}

