/*
 * Decompiled with CFR 0.152.
 */
package soot.JastAddJ;

import java.util.HashMap;
import java.util.Map;
import soot.JastAddJ.ASTNode;
import soot.JastAddJ.ASTNode$State;
import soot.JastAddJ.BoundFieldAccess;
import soot.JastAddJ.CastExpr;
import soot.JastAddJ.ClassInstanceExpr;
import soot.JastAddJ.Expr;
import soot.JastAddJ.FieldDeclaration;
import soot.JastAddJ.IfStmt;
import soot.JastAddJ.List;
import soot.JastAddJ.LogNotExpr;
import soot.JastAddJ.Opt;
import soot.JastAddJ.OrLogicalExpr;
import soot.JastAddJ.ParExpr;
import soot.JastAddJ.Stmt;
import soot.JastAddJ.ThrowStmt;
import soot.JastAddJ.TypeAccess;
import soot.JastAddJ.TypeDecl;
import soot.JastAddJ.Variable;

public class AssertStmt
extends Stmt
implements Cloneable {
    protected Map isDAafter_Variable_values;
    protected Map isDUafter_Variable_values;

    @Override
    public void flushCache() {
        super.flushCache();
        this.isDAafter_Variable_values = null;
        this.isDUafter_Variable_values = null;
    }

    @Override
    public void flushCollectionCache() {
        super.flushCollectionCache();
    }

    @Override
    public AssertStmt clone() throws CloneNotSupportedException {
        AssertStmt node = (AssertStmt)super.clone();
        node.isDAafter_Variable_values = null;
        node.isDUafter_Variable_values = null;
        node.in$Circle(false);
        node.is$Final(false);
        return node;
    }

    public AssertStmt copy() {
        try {
            AssertStmt node = this.clone();
            node.parent = null;
            if (this.children != null) {
                node.children = (ASTNode[])this.children.clone();
            }
            return node;
        }
        catch (CloneNotSupportedException e) {
            throw new Error("Error: clone not supported for " + this.getClass().getName());
        }
    }

    public AssertStmt fullCopy() {
        AssertStmt tree = this.copy();
        if (this.children != null) {
            for (int i = 0; i < this.children.length; ++i) {
                ASTNode child = this.children[i];
                if (child == null) continue;
                child = child.fullCopy();
                tree.setChild(child, i);
            }
        }
        return tree;
    }

    @Override
    public void toString(StringBuffer s) {
        s.append(this.indent());
        s.append("assert ");
        this.getfirst().toString(s);
        if (this.hasExpr()) {
            s.append(" : ");
            this.getExpr().toString(s);
        }
        s.append(";");
    }

    @Override
    public void typeCheck() {
        if (!this.getfirst().type().isBoolean()) {
            this.error("Assert requires boolean condition");
        }
        if (this.hasExpr() && this.getExpr().type().isVoid()) {
            this.error("The second part of an assert statement may not be void");
        }
    }

    @Override
    public void transformation() {
        super.transformation();
        FieldDeclaration f = this.hostType().topLevelType().createStaticClassField(this.hostType().topLevelType().referenceClassFieldName());
        FieldDeclaration assertionsDisabled = this.hostType().createAssertionsDisabled();
        Expr condition = (Expr)this.getfirst().fullCopy();
        List<Expr> args = new List<Expr>();
        if (this.hasExpr()) {
            if (this.getExpr().type().isString()) {
                args.add(new CastExpr(new TypeAccess("java.lang", "Object"), (Expr)this.getExpr().fullCopy()));
            } else {
                args.add((Expr)this.getExpr().fullCopy());
            }
        }
        IfStmt stmt = new IfStmt((Expr)new LogNotExpr(new ParExpr(new OrLogicalExpr(new BoundFieldAccess(assertionsDisabled), condition))), (Stmt)new ThrowStmt(new ClassInstanceExpr(this.lookupType("java.lang", "AssertionError").createQualifiedAccess(), args, new Opt<TypeDecl>())), new Opt<Stmt>());
        this.replace(this).with(stmt);
        stmt.transformation();
    }

    public AssertStmt() {
    }

    @Override
    public void init$Children() {
        this.children = new ASTNode[2];
        this.setChild(new Opt(), 1);
    }

    public AssertStmt(Expr p0, Opt<Expr> p1) {
        this.setChild(p0, 0);
        this.setChild(p1, 1);
    }

    @Override
    protected int numChildren() {
        return 2;
    }

    @Override
    public boolean mayHaveRewrite() {
        return false;
    }

    public void setfirst(Expr node) {
        this.setChild(node, 0);
    }

    public Expr getfirst() {
        return (Expr)this.getChild(0);
    }

    public Expr getfirstNoTransform() {
        return (Expr)this.getChildNoTransform(0);
    }

    public void setExprOpt(Opt<Expr> opt) {
        this.setChild(opt, 1);
    }

    public boolean hasExpr() {
        return this.getExprOpt().getNumChild() != 0;
    }

    public Expr getExpr() {
        return (Expr)this.getExprOpt().getChild(0);
    }

    public void setExpr(Expr node) {
        this.getExprOpt().setChild(node, 0);
    }

    public Opt<Expr> getExprOpt() {
        return (Opt)this.getChild(1);
    }

    public Opt<Expr> getExprOptNoTransform() {
        return (Opt)this.getChildNoTransform(1);
    }

    @Override
    public boolean isDAafter(Variable v) {
        Variable _parameters = v;
        if (this.isDAafter_Variable_values == null) {
            this.isDAafter_Variable_values = new HashMap(4);
        }
        if (this.isDAafter_Variable_values.containsKey(_parameters)) {
            return (Boolean)this.isDAafter_Variable_values.get(_parameters);
        }
        ASTNode$State state = this.state();
        int num = state.boundariesCrossed;
        boolean isFinal = this.is$Final();
        boolean isDAafter_Variable_value = this.isDAafter_compute(v);
        if (isFinal && num == this.state().boundariesCrossed) {
            this.isDAafter_Variable_values.put(_parameters, isDAafter_Variable_value);
        }
        return isDAafter_Variable_value;
    }

    private boolean isDAafter_compute(Variable v) {
        return this.getfirst().isDAafter(v);
    }

    @Override
    public boolean isDUafter(Variable v) {
        Variable _parameters = v;
        if (this.isDUafter_Variable_values == null) {
            this.isDUafter_Variable_values = new HashMap(4);
        }
        if (this.isDUafter_Variable_values.containsKey(_parameters)) {
            return (Boolean)this.isDUafter_Variable_values.get(_parameters);
        }
        ASTNode$State state = this.state();
        int num = state.boundariesCrossed;
        boolean isFinal = this.is$Final();
        boolean isDUafter_Variable_value = this.isDUafter_compute(v);
        if (isFinal && num == this.state().boundariesCrossed) {
            this.isDUafter_Variable_values.put(_parameters, isDUafter_Variable_value);
        }
        return isDUafter_Variable_value;
    }

    private boolean isDUafter_compute(Variable v) {
        return this.getfirst().isDUafter(v);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean modifiedInScope(Variable var) {
        ASTNode$State state = this.state();
        boolean bl = false;
        return bl;
    }

    @Override
    public boolean Define_boolean_isDAbefore(ASTNode caller, ASTNode child, Variable v) {
        if (caller == this.getExprOptNoTransform()) {
            return this.getfirst().isDAafter(v);
        }
        return this.getParent().Define_boolean_isDAbefore(this, caller, v);
    }

    @Override
    public ASTNode rewriteTo() {
        return super.rewriteTo();
    }
}

