/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib2.analysis.util;

import java.util.Iterator;
import java.util.NoSuchElementException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.jf.dexlib2.analysis.TypeProto;
import org.jf.dexlib2.analysis.UnresolvedClassException;

public class TypeProtoUtils {
    @Nonnull
    public static Iterable<TypeProto> getSuperclassChain(final @Nonnull TypeProto typeProto) {
        return new Iterable<TypeProto>(){

            @Override
            public Iterator<TypeProto> iterator() {
                return new Iterator<TypeProto>(){
                    @Nullable
                    private TypeProto type;
                    {
                        this.type = TypeProtoUtils.getSuperclassAsTypeProto(typeProto);
                    }

                    @Override
                    public boolean hasNext() {
                        return this.type != null;
                    }

                    @Override
                    public TypeProto next() {
                        TypeProto type = this.type;
                        if (type == null) {
                            throw new NoSuchElementException();
                        }
                        this.type = TypeProtoUtils.getSuperclassAsTypeProto(type);
                        return type;
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    @Nullable
    public static TypeProto getSuperclassAsTypeProto(@Nonnull TypeProto type) {
        try {
            String next = type.getSuperclass();
            if (next != null) {
                return type.getClassPath().getClass(next);
            }
            return null;
        }
        catch (UnresolvedClassException ex) {
            return type.getClassPath().getUnknownClass();
        }
    }
}

