/*
 * Decompiled with CFR 0.152.
 */
package jInst.util;

import jInst.Instrumentation.InstrumentHelper;
import jInst.util.FileUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class XMLParser {
    private static String launcher = "";
    private static String launcherLabel = "";
    private static String buildPackage = "";
    private static String devPackage = "";
    private static String testProjName = "";
    private static ArrayList<String> editedProjects = new ArrayList();
    public static List<String> permissions = new ArrayList<String>();
    private static final String permExtWrite = "android.permission.WRITE_EXTERNAL_STORAGE";
    private static final String permExtRead = "android.permission.READ_EXTERNAL_STORAGE";
    private static final String permInt = "android.permission.INTERNET";
    private static final String permLoc = "android.permission.ACCESS_FINE_LOCATION";
    private static final String permWifi = "android.permission.ACCESS_WIFI_STATE";
    private static final String permPhone = "android.permission.READ_PHONE_STATE";
    private static final String permNet = "android.permission.ACCESS_NETWORK_STATE";
    private static final String permBoot = "android.permission.RECEIVE_BOOT_COMPLETED";

    public static String getXmlPropertyValue(String element, String property, String file2) {
        String res2 = "";
        File fXmlFile = new File(file2);
        try {
            DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
            Document doc = dBuilder.parse(fXmlFile);
            doc.getDocumentElement().normalize();
            Element cElem = doc.getDocumentElement();
            if (cElem.hasAttribute(property)) {
                res2 = cElem.getAttribute(property);
                return res2;
            }
            NodeList list2 = cElem.getElementsByTagName(element);
            for (int i = 0; i < list2.getLength(); ++i) {
                Element x = (Element)list2.item(i);
                if (!x.hasAttribute(property)) continue;
                res2 = x.getAttribute(property);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return res2;
    }

    public static void loadAndSendApplicationJSON(String projectJSonPath) {
        JSONParser parser = new JSONParser();
        JSONObject ja = new JSONObject();
        try {
            Object obj = parser.parse(new FileReader(projectJSonPath));
            ja = (JSONObject)obj;
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
    }

    public static boolean buildAppPermissionsJSON(String manif, String folderDest) {
        List<String> l = XMLParser.getPermissions(manif);
        JSONArray ja = new JSONArray();
        for (String permission : l) {
            JSONObject jo = new JSONObject();
            jo.put("application", InstrumentHelper.projectID);
            jo.put("permission", permission.toLowerCase().replace("android.permission.", ""));
            ja.add(jo);
        }
        if (!ja.isEmpty()) {
            try {
                FileUtils.writeFile(new File(folderDest + "/appPermissions.json"), ja.toJSONString());
            }
            catch (IOException e) {
                System.out.println("!!!!!!!!!!! Error writing " + folderDest + "appPermissions.json");
                return false;
            }
            return true;
        }
        return false;
    }

    public static List<String> getPermissions(String manifFile) {
        ArrayList<String> l = new ArrayList<String>();
        DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder docBuilder = null;
        Document doc = null;
        try {
            docBuilder = docFactory.newDocumentBuilder();
            doc = docBuilder.parse(manifFile);
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        Node manifest2 = doc.getElementsByTagName("manifest").item(0);
        NodeList permissions = doc.getElementsByTagName("uses-permission");
        if (manifest2 == null) {
            return l;
        }
        for (int i = 0; i < permissions.getLength(); ++i) {
            Node n = permissions.item(i);
            if (n.getNodeType() != 1) continue;
            Element e = (Element)n;
            l.add(e.getAttribute("android:name"));
        }
        return l;
    }

    public static void parseManifest(String file2) {
        buildPackage = "";
        devPackage = "";
        try {
            String cName = "";
            String cLabel = "";
            String cPack = "";
            File fXmlFile = new File(file2);
            DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
            Document doc = dBuilder.parse(fXmlFile);
            doc.getDocumentElement().normalize();
            Element cElem = doc.getDocumentElement();
            buildPackage = cPack = cElem.hasAttribute("package") ? cElem.getAttribute("package") : "";
            NodeList appList = doc.getElementsByTagName("application");
            Element app = (Element)appList.item(0);
            NodeList nList = app.getElementsByTagName("activity");
            for (int temp = 0; temp < nList.getLength(); ++temp) {
                Node nNode = nList.item(temp);
                if (nNode.getNodeType() != 1) continue;
                Element eElement = (Element)nNode;
                cName = eElement.hasAttribute("android:name") ? eElement.getAttribute("android:name") : "";
                String string = cLabel = eElement.hasAttribute("android:label") ? eElement.getAttribute("android:label") : "";
                if (cName.startsWith(".")) {
                    cName = cPack + cName;
                    devPackage = cName.substring(0, cName.lastIndexOf("."));
                } else {
                    devPackage = cName.substring(0, cName.lastIndexOf("."));
                    if (buildPackage.equals("")) {
                        buildPackage = devPackage;
                    }
                }
                NodeList intents = eElement.getElementsByTagName("intent-filter");
                for (int i = 0; i < intents.getLength(); ++i) {
                    Node nIntent = intents.item(i);
                    if (nIntent.getNodeType() != 1) continue;
                    Element eIntent = (Element)nIntent;
                    NodeList categories = eIntent.getElementsByTagName("category");
                    for (int j = 0; j < categories.getLength(); ++j) {
                        Element eCategory;
                        Node nCategory = categories.item(j);
                        if (nCategory.getNodeType() != 1 || !(eCategory = (Element)nCategory).getAttribute("android:name").contains("LAUNCHER")) continue;
                        launcher = cName;
                        launcherLabel = cLabel;
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void insertReadWriteExternalPermissionsAndDebbugable(String manifestFile) {
        DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder docBuilder = null;
        boolean hasExtWrite = false;
        boolean hasExtRead = false;
        String pName = "";
        try {
            docBuilder = docFactory.newDocumentBuilder();
            Document doc = docBuilder.parse(manifestFile);
            NodeList permissions = doc.getElementsByTagName("uses-permission");
            System.out.println(permissions.getLength());
            if (permissions == null || permissions.getLength() == 0) {
                Node manifest2 = doc.getElementsByTagName("manifest").item(0);
                Element nPerm = doc.createElement("uses-permission");
                nPerm.setAttribute("android:name", permExtRead);
                Element nPerm1 = doc.createElement("uses-permission");
                nPerm1.setAttribute("android:name", permExtWrite);
                manifest2.appendChild(nPerm);
                manifest2.appendChild(nPerm1);
            } else {
                for (int i = 0; i < permissions.getLength(); ++i) {
                    Node n = permissions.item(i);
                    if (n.getNodeType() != 1) continue;
                    Element e = (Element)n;
                    String string = pName = e.hasAttribute("android:name") ? e.getAttribute("android:name") : "";
                    if (pName.equals(permExtWrite)) {
                        hasExtWrite = true;
                    }
                    if (!pName.equals(permExtRead)) continue;
                    hasExtRead = true;
                }
            }
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            DOMSource source = new DOMSource(doc);
            StreamResult result2 = new StreamResult(new File(manifestFile));
            transformer.transform(source, result2);
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (TransformerConfigurationException e) {
            e.printStackTrace();
        }
        catch (TransformerException e) {
            e.printStackTrace();
        }
    }

    public static void insertReadWriteExternalPermissions(String manifestFile) {
        DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder docBuilder = null;
        boolean hasExtWrite = false;
        boolean hasExtRead = false;
        String pName = "";
        try {
            docBuilder = docFactory.newDocumentBuilder();
            Document doc = docBuilder.parse(manifestFile);
            Node manifest2 = doc.getElementsByTagName("manifest").item(0);
            NodeList permissions = doc.getElementsByTagName("uses-permission");
            System.out.println(permissions);
            if (permissions != null && permissions.getLength() != 0) {
                for (int i = 0; i < permissions.getLength(); ++i) {
                    Node n = permissions.item(i);
                    if (n.getNodeType() != 1) continue;
                    Element e = (Element)n;
                    String string = pName = e.hasAttribute("android:name") ? e.getAttribute("android:name") : "";
                    if (pName.equals(permExtWrite)) {
                        hasExtWrite = true;
                    }
                    if (!pName.equals(permExtRead)) continue;
                    hasExtRead = true;
                }
            }
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            DOMSource source = new DOMSource(doc);
            StreamResult result2 = new StreamResult(new File(manifestFile));
            transformer.transform(source, result2);
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (TransformerConfigurationException e) {
            e.printStackTrace();
        }
        catch (TransformerException e) {
            e.printStackTrace();
        }
    }

    public static void editManifest(String file2) {
        try {
            Node n;
            String pName = "";
            boolean hasExt = false;
            boolean hasExtRead = false;
            boolean hasInt = false;
            boolean hasLoc = false;
            boolean hasWifi = false;
            boolean hasPhone = false;
            boolean hasNet = false;
            boolean hasBoot = false;
            DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
            Document doc = docBuilder.parse(file2);
            Node manifest2 = doc.getElementsByTagName("manifest").item(0);
            NodeList permissions = doc.getElementsByTagName("uses-permission");
            boolean has_xmlns_tools = false;
            for (int i = 0; i < manifest2.getAttributes().getLength(); ++i) {
                Node n2 = manifest2.getAttributes().item(i);
                if (!n2.getNodeName().equals("xmlns:tools")) continue;
                has_xmlns_tools = true;
            }
            if (!has_xmlns_tools) {
                Attr attr = doc.createAttribute("xmlns:tools");
                attr.setNodeValue("http://schemas.android.com/tools");
                manifest2.getAttributes().setNamedItem(attr);
            }
            boolean has_uses_sdk = false;
            for (int i = 0; i < manifest2.getChildNodes().getLength(); ++i) {
                n = manifest2.getChildNodes().item(i);
                if (!n.getNodeName().equals("uses-sdk")) continue;
                has_uses_sdk = true;
                Attr attr = doc.createAttribute("tools:overrideLibrary");
                String s = InstrumentHelper.getInstrumenter().getLibraryName();
                attr.setNodeValue(s);
                n.getAttributes().setNamedItem(attr);
            }
            if (!has_uses_sdk) {
                Element uses_sdk = doc.createElement("uses-sdk");
                Attr attr = doc.createAttribute("tools:overrideLibrary");
                String s = InstrumentHelper.getInstrumenter().getLibraryName();
                attr.setNodeValue(s);
                uses_sdk.getAttributes().setNamedItem(attr);
                manifest2.appendChild(uses_sdk);
            }
            if (permissions != null) {
                for (int i = 0; i < permissions.getLength(); ++i) {
                    n = permissions.item(i);
                    if (n.getNodeType() != 1) continue;
                    Element e = (Element)n;
                    String string = pName = e.hasAttribute("android:name") ? e.getAttribute("android:name") : "";
                    if (pName.equals(permExtWrite)) {
                        hasExt = true;
                    }
                    if (pName.equals(permExtRead)) {
                        hasExtRead = true;
                    }
                    if (pName.equals(permBoot)) {
                        hasBoot = true;
                    }
                    if (pName.equals(permInt)) {
                        hasInt = true;
                    }
                    if (pName.equals(permLoc)) {
                        hasLoc = true;
                    }
                    if (pName.equals(permWifi)) {
                        hasWifi = true;
                    }
                    if (pName.equals(permPhone)) {
                        hasPhone = true;
                    }
                    if (!pName.equals(permNet)) continue;
                    hasNet = true;
                }
            }
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            DOMSource source = new DOMSource(doc);
            StreamResult result2 = new StreamResult(new File(file2));
            transformer.transform(source, result2);
        }
        catch (ParserConfigurationException pce) {
            pce.printStackTrace();
        }
        catch (TransformerException tfe) {
            tfe.printStackTrace();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        catch (SAXException sae) {
            sae.printStackTrace();
        }
    }

    public static void addLibOverrideToManifests(Iterable<String> files2) {
        for (String file2 : files2) {
            try {
                DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
                DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
                Document doc = docBuilder.parse(file2);
                Node manifest2 = doc.getElementsByTagName("manifest").item(0);
                boolean has_xmlns_tools = false;
                for (int i = 0; i < manifest2.getAttributes().getLength(); ++i) {
                    Node n = manifest2.getAttributes().item(i);
                    if (!n.getNodeName().equals("xmlns:tools")) continue;
                    has_xmlns_tools = true;
                }
                if (!has_xmlns_tools) {
                    Attr attr = doc.createAttribute("xmlns:tools");
                    attr.setNodeValue("http://schemas.android.com/tools");
                    manifest2.getAttributes().setNamedItem(attr);
                }
                boolean has_uses_sdk = false;
                for (int i = 0; i < manifest2.getChildNodes().getLength(); ++i) {
                    Node n = manifest2.getChildNodes().item(i);
                    if (!n.getNodeName().equals("uses-sdk")) continue;
                    has_uses_sdk = true;
                    Attr attr = doc.createAttribute("tools:overrideLibrary");
                    String s = InstrumentHelper.getInstrumenter().getLibraryName();
                    attr.setNodeValue(s);
                    n.getAttributes().setNamedItem(attr);
                }
                if (!has_uses_sdk) {
                    Element uses_sdk = doc.createElement("uses-sdk");
                    Attr attr = doc.createAttribute("tools:overrideLibrary");
                    String s = InstrumentHelper.getInstrumenter().getLibraryName();
                    attr.setNodeValue(s);
                    uses_sdk.getAttributes().setNamedItem(attr);
                    manifest2.appendChild(uses_sdk);
                }
                TransformerFactory transformerFactory = TransformerFactory.newInstance();
                Transformer transformer = transformerFactory.newTransformer();
                DOMSource source = new DOMSource(doc);
                StreamResult result2 = new StreamResult(new File(file2));
                transformer.transform(source, result2);
            }
            catch (ParserConfigurationException pce) {
                pce.printStackTrace();
            }
            catch (TransformerException tfe) {
                tfe.printStackTrace();
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
            catch (SAXException sae) {
                sae.printStackTrace();
            }
        }
    }

    public static void editProjectDesc(String file2) {
        try {
            DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
            Document doc = docBuilder.parse(file2);
            String pName = "";
            Node description2 = doc.getElementsByTagName("projectDescription").item(0);
            NodeList list2 = description2.getChildNodes();
            for (int i = 0; i < list2.getLength(); ++i) {
                Node tag = list2.item(i);
                if (tag.getNodeName().equals("name")) {
                    editedProjects.add(tag.getTextContent());
                    testProjName = pName = "__" + tag.getTextContent();
                    tag.setTextContent(pName);
                    continue;
                }
                if (!tag.getNodeName().equals("projects")) continue;
                NodeList projects = tag.getChildNodes();
                for (int j = 0; j < projects.getLength(); ++j) {
                    Node p = projects.item(j);
                    if (!editedProjects.contains(p.getTextContent())) continue;
                    p.setTextContent("__" + p.getTextContent());
                }
            }
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            DOMSource source = new DOMSource(doc);
            StreamResult result2 = new StreamResult(new File(file2));
            transformer.transform(source, result2);
        }
        catch (ParserConfigurationException pce) {
            pce.printStackTrace();
        }
        catch (TransformerException tfe) {
            tfe.printStackTrace();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        catch (SAXException sae) {
            sae.printStackTrace();
        }
    }

    public static void editClasspath(String file2) {
        try {
            DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
            Document doc = docBuilder.parse(file2);
            String pName = "";
            Node classpath = doc.getElementsByTagName("classpath").item(0);
            NodeList list2 = classpath.getChildNodes();
            for (int i = 0; i < list2.getLength(); ++i) {
                NamedNodeMap atts;
                Node tag = list2.item(i);
                if (!tag.hasAttributes() || (atts = tag.getAttributes()).getNamedItem("combineaccessrules") == null) continue;
                pName = atts.getNamedItem("path").getTextContent().replaceFirst("/", "/__");
                atts.getNamedItem("path").setTextContent(pName);
            }
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            DOMSource source = new DOMSource(doc);
            StreamResult result2 = new StreamResult(new File(file2));
            transformer.transform(source, result2);
        }
        catch (ParserConfigurationException pce) {
            pce.printStackTrace();
        }
        catch (TransformerException tfe) {
            tfe.printStackTrace();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        catch (SAXException sae) {
            sae.printStackTrace();
        }
    }

    public static String getLauncher() {
        return launcher;
    }

    public static String getLauncherLabel() {
        return launcherLabel;
    }

    public static String getDevPackage() {
        return devPackage;
    }

    public static String getBuildPackage() {
        return buildPackage;
    }

    public static String getTestProjName() {
        return testProjName;
    }

    public static String getAppPackage() {
        String res2 = "";
        String[] tok = launcher.split("\\.");
        int tam = tok.length;
        for (int i = 0; i < tam - 1; ++i) {
            res2 = res2 + tok[i] + ".";
        }
        return res2.substring(0, res2.length() - 1);
    }

    public static void editRunConfiguration(String file2, String value) {
        try {
            String cName = "";
            String cLabel = "";
            String cPack = "";
            File fXmlFile = new File(file2);
            DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
            Document doc = dBuilder.parse(fXmlFile);
            doc.getDocumentElement().normalize();
            NodeList attrList = doc.getElementsByTagName("stringAttribute");
            for (int i = 0; i < attrList.getLength(); ++i) {
                Element elem = (Element)attrList.item(i);
                if (!elem.hasAttribute("key") || !elem.getAttribute("key").equals("com.android.ide.adt.instrumentation")) continue;
                elem.setAttribute("value", value);
            }
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            DOMSource source = new DOMSource(doc);
            StreamResult result2 = new StreamResult(new File(file2));
            transformer.transform(source, result2);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static String getApplicationClass(String manifest2) {
        String s = null;
        try {
            Node nodo;
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document document = db.parse(new File(manifest2));
            NodeList nodeList = document.getElementsByTagName("application");
            if (nodeList != null && (nodo = nodeList.item(0).getAttributes().getNamedItem("android:name")) != null) {
                s = nodo.getNodeValue();
                System.out.println(" A classe de aplicattion s \u00e9 " + s);
            }
            return s;
        }
        catch (Exception e) {
            e.printStackTrace();
            return s;
        }
    }

    public static void addApplicationName(String file2, String classe) {
        try {
            File fXmlFile = new File(file2);
            DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
            Document doc = dBuilder.parse(fXmlFile);
            doc.getDocumentElement().normalize();
            NodeList attrList = doc.getElementsByTagName("application");
            if (attrList != null) {
                System.out.println("entrei aqui ");
                Element e = (Element)attrList.item(0);
                e.setAttribute("android:name", classe);
                TransformerFactory transformerFactory = TransformerFactory.newInstance();
                Transformer transformer = transformerFactory.newTransformer();
                DOMSource source = new DOMSource(doc);
                StreamResult result2 = new StreamResult(new File(file2));
                transformer.transform(source, result2);
            } else {
                System.out.println("olha nao tem application");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
    }

    public static void editRunner(String file2) {
        try {
            String cName = "";
            String cLabel = "";
            String cPack = "";
            File fXmlFile = new File(file2);
            DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
            Document doc = dBuilder.parse(fXmlFile);
            doc.getDocumentElement().normalize();
            NodeList instList = doc.getElementsByTagName("instrumentation");
            Element inst = (Element)instList.item(0);
            if (inst.hasAttribute("android:name")) {
                inst.setAttribute("android:name", "com.zutubi.android.junitreport.JUnitReportTestRunner");
            }
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            DOMSource source = new DOMSource(doc);
            StreamResult result2 = new StreamResult(new File(file2));
            transformer.transform(source, result2);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

