/*
 * Decompiled with CFR 0.152.
 */
package jInst.util;

import jInst.util.PackageM;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.List;
import java.util.stream.Stream;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

public class FileUtils {
    public static void registMethod(String filename, String method) {
        File file2 = new File(filename);
        if (!file2.exists()) {
            try {
                file2.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        FileOutputStream fOut = null;
        try {
            fOut = new FileOutputStream(file2, true);
        }
        catch (FileNotFoundException e) {
            System.out.println("[Jinst] Error opening allMethods.txt");
        }
        OutputStreamWriter osw = new OutputStreamWriter(fOut);
        try {
            osw.write(method + "\n");
            osw.flush();
            osw.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            System.out.println("[Jinst] An error occured while appending to allMethods file ");
        }
    }

    public static void copyFolder(File src, File dest) throws IOException {
        if (src.isDirectory()) {
            String[] files2;
            if (!dest.exists()) {
                dest.mkdir();
            }
            for (String file2 : files2 = src.list()) {
                File srcFile = new File(src, file2);
                File destFile = new File(dest, file2);
                FileUtils.copyFolder(srcFile, destFile);
            }
        } else {
            dest.createNewFile();
            FileUtils.copyFile(src, dest);
        }
    }

    public static void copyFile(File source, File dest) throws IOException {
        Path copied = dest.toPath();
        Path originalPath = source.toPath();
        Files.copy(originalPath, copied, StandardCopyOption.REPLACE_EXISTING);
        if (!copied.toFile().exists()) {
            throw new IOException("Unable to create file " + copied.toAbsolutePath());
        }
    }

    public static void writeFile(File file2, String content) throws IOException {
        FileWriter fw = new FileWriter(file2.getAbsoluteFile());
        BufferedWriter bw = new BufferedWriter(fw);
        bw.write(content);
        bw.flush();
        bw.close();
    }

    public static void writeFile(File file2, JSONObject jo) throws IOException {
        FileWriter fw = new FileWriter(file2.getAbsoluteFile());
        BufferedWriter bw = new BufferedWriter(fw);
        JSONArray jas = new JSONArray();
        jas.addAll(jo.values());
        bw.write(jas.toJSONString());
        jas.clear();
        bw.flush();
        bw.close();
    }

    public static void copyAll(List<PackageM> source, List<PackageM> destiny) {
        for (PackageM obj : source) {
            destiny.add(obj.clone());
        }
    }

    public static String stringFromFile(String filePath) {
        StringBuilder contentBuilder = new StringBuilder();
        try (Stream<String> stream2 = Files.lines(Paths.get(filePath, new String[0]), StandardCharsets.UTF_8);){
            stream2.forEach(s -> contentBuilder.append((String)s).append("\n"));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return contentBuilder.toString();
    }
}

