/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.probdist;

import umontreal.iro.lecuyer.functions.MathFunction;
import umontreal.iro.lecuyer.probdist.ContinuousDistribution;
import umontreal.iro.lecuyer.probdist.NormalDist;
import umontreal.iro.lecuyer.util.Num;
import umontreal.iro.lecuyer.util.RootFinder;

public class FoldedNormalDist
extends ContinuousDistribution {
    protected double mu;
    protected double sigma;
    private static final double RACPI = 1.772453850905516;

    public FoldedNormalDist(double mu, double sigma) {
        this.setParams(mu, sigma);
    }

    public double density(double x) {
        return FoldedNormalDist.density(this.mu, this.sigma, x);
    }

    public double cdf(double x) {
        return FoldedNormalDist.cdf(this.mu, this.sigma, x);
    }

    public double inverseF(double u) {
        return FoldedNormalDist.inverseF(this.mu, this.sigma, u);
    }

    public double getMean() {
        return FoldedNormalDist.getMean(this.mu, this.sigma);
    }

    public double getVariance() {
        return FoldedNormalDist.getVariance(this.mu, this.sigma);
    }

    public double getStandardDeviation() {
        return FoldedNormalDist.getStandardDeviation(this.mu, this.sigma);
    }

    public static double density(double mu, double sigma, double x) {
        if (sigma <= 0.0) {
            throw new IllegalArgumentException("sigma <= 0");
        }
        if (mu < 0.0) {
            throw new IllegalArgumentException("mu < 0");
        }
        if (x < 0.0) {
            return 0.0;
        }
        return NormalDist.density(mu, sigma, x) + NormalDist.density(mu, sigma, -x);
    }

    public static double cdf(double mu, double sigma, double x) {
        if (sigma <= 0.0) {
            throw new IllegalArgumentException("sigma <= 0");
        }
        if (mu < 0.0) {
            throw new IllegalArgumentException("mu < 0");
        }
        if (x <= 0.0) {
            return 0.0;
        }
        return NormalDist.cdf01((x - mu) / sigma) - NormalDist.cdf01((-x - mu) / sigma);
    }

    public static double barF(double mu, double sigma, double x) {
        if (sigma <= 0.0) {
            throw new IllegalArgumentException("sigma <= 0");
        }
        if (mu < 0.0) {
            throw new IllegalArgumentException("mu < 0");
        }
        if (x <= 0.0) {
            return 1.0;
        }
        return NormalDist.barF01((x - mu) / sigma) - NormalDist.barF01((-x - mu) / sigma);
    }

    public static double inverseF(double mu, double sigma, double u) {
        if (sigma <= 0.0) {
            throw new IllegalArgumentException("sigma <= 0");
        }
        if (mu < 0.0) {
            throw new IllegalArgumentException("mu < 0");
        }
        if (u > 1.0 || u < 0.0) {
            throw new IllegalArgumentException("u not in [0,1]");
        }
        if (u <= 0.0) {
            return 0.0;
        }
        if (u >= 1.0) {
            return Double.POSITIVE_INFINITY;
        }
        FunctionInverse f = new FunctionInverse(mu, sigma, u);
        return RootFinder.brentDekker(0.0, mu + 10.0 * sigma, f, 1.0E-14);
    }

    public static double getMean(double mu, double sigma) {
        if (sigma <= 0.0) {
            throw new IllegalArgumentException("sigma <= 0");
        }
        if (mu < 0.0) {
            throw new IllegalArgumentException("mu < 0");
        }
        return sigma * 1.4142135623730951 / 1.772453850905516 * Math.exp(-mu * mu / (2.0 * sigma * sigma)) + mu * Num.erf(mu / (sigma * 1.4142135623730951));
    }

    public static double getVariance(double mu, double sigma) {
        if (sigma <= 0.0) {
            throw new IllegalArgumentException("sigma <= 0");
        }
        if (mu < 0.0) {
            throw new IllegalArgumentException("mu < 0");
        }
        double mean = sigma * 1.4142135623730951 / 1.772453850905516 * Math.exp(-mu * mu / (2.0 * sigma * sigma)) + mu * Num.erf(mu / (sigma * 1.4142135623730951));
        return mu * mu + sigma * sigma - mean * mean;
    }

    public static double getStandardDeviation(double mu, double sigma) {
        return Math.sqrt(FoldedNormalDist.getVariance(mu, sigma));
    }

    public static double[] getMLE(double[] x, int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("n <= 0");
        }
        throw new UnsupportedOperationException("getMLE is not implemented ");
    }

    public double getMu() {
        return this.mu;
    }

    public double getSigma() {
        return this.sigma;
    }

    public void setParams(double mu, double sigma) {
        if (sigma <= 0.0) {
            throw new IllegalArgumentException("sigma <= 0");
        }
        if (mu < 0.0) {
            throw new IllegalArgumentException("mu < 0");
        }
        this.mu = mu;
        this.sigma = sigma;
    }

    public double[] getParams() {
        double[] retour = new double[]{this.mu, this.sigma};
        return retour;
    }

    public String toString() {
        return this.getClass().getName() + " : mu = " + this.mu + ", sigma = " + this.sigma;
    }

    private static class FunctionInverse
    implements MathFunction {
        private double u;
        private double mu;
        private double sigma;

        public FunctionInverse(double mu, double sigma, double u) {
            this.u = u;
            this.mu = mu;
            this.sigma = sigma;
        }

        public double evaluate(double x) {
            return this.u - FoldedNormalDist.cdf(this.mu, this.sigma, x);
        }
    }
}

