/*
 * Decompiled with CFR 0.152.
 */
package projects.inmode.utils;

import de.jstacs.data.AlphabetContainer;
import de.jstacs.data.DataSet;
import de.jstacs.data.alphabets.Alphabet;
import de.jstacs.data.alphabets.DNAAlphabet;
import de.jstacs.data.alphabets.DiscreteAlphabet;
import de.jstacs.data.sequences.Sequence;
import de.jstacs.data.sequences.SparseSequence;
import de.jstacs.io.SparseStringExtractor;
import de.jstacs.utils.Normalisation;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Random;
import projects.inmode.utils.BasicSamplingAlgorithms;

public class DataReader {
    public static String[][] readStringMatrix(File f) throws IOException {
        BufferedReader br = new BufferedReader(new FileReader(f));
        int N = 0;
        while (br.ready()) {
            br.readLine();
            ++N;
        }
        br.close();
        br = new BufferedReader(new FileReader(f));
        String[][] res = new String[N][];
        int i = 0;
        while (i < res.length) {
            String s = br.readLine();
            res[i] = s.contains("\t") ? s.split("\t") : s.split(" ");
            ++i;
        }
        return res;
    }

    public static double[][] readDoubleMatrix(File f) throws IOException {
        String[][] s = DataReader.readStringMatrix(f);
        double[][] res = new double[s.length][];
        int i = 0;
        while (i < res.length) {
            res[i] = new double[s[i].length];
            int j = 0;
            while (j < res[i].length) {
                res[i][j] = Double.parseDouble(s[i][j]);
                ++j;
            }
            ++i;
        }
        return res;
    }

    public static double[] readDoubleArray(File f) throws IOException {
        String[][] s = DataReader.readStringMatrix(f);
        int L = 0;
        int i = 0;
        while (i < s.length) {
            L += s[i].length;
            ++i;
        }
        double[] res = new double[L];
        int k = 0;
        int i2 = 0;
        while (i2 < s.length) {
            int j = 0;
            while (j < s[i2].length) {
                res[k] = Double.parseDouble(s[i2][j]);
                ++k;
                ++j;
            }
            ++i2;
        }
        return res;
    }

    public static int[][] readIntegerMatrix(File f) throws IOException {
        String[][] s = DataReader.readStringMatrix(f);
        int[][] res = new int[s.length][];
        int i = 0;
        while (i < res.length) {
            res[i] = new int[s[i].length];
            int j = 0;
            while (j < res[i].length) {
                res[i][j] = Integer.parseInt(s[i][j]);
                ++j;
            }
            ++i;
        }
        return res;
    }

    public static DataSet replaceIUPACSymbols(SparseStringExtractor se) throws Exception {
        DataSet ds = new DataSet(new AlphabetContainer((Alphabet)new DiscreteAlphabet(true, "A", "C", "G", "T", "N", "W", "S", "M", "K", "R", "Y", "B", "D", "H", "V")), se);
        double[] prob = new double[4];
        int i = 0;
        while (i < ds.getNumberOfElements()) {
            int j = 0;
            while (j < ds.getElementAt(i).getLength()) {
                int val = ds.getElementAt(i).discreteVal(j);
                if (val < 4) {
                    int n = val;
                    prob[n] = prob[n] + 1.0;
                }
                ++j;
            }
            ++i;
        }
        prob = new double[]{1.0, 1.0, 1.0, 1.0};
        Normalisation.sumNormalisation(prob);
        Random rand = new Random();
        Sequence[] seq = new Sequence[ds.getNumberOfElements()];
        int i2 = 0;
        while (i2 < ds.getNumberOfElements()) {
            StringBuffer sb = new StringBuffer();
            int j = 0;
            while (j < ds.getElementAt(i2).getLength()) {
                int val = ds.getElementAt(i2).discreteVal(j);
                if (val < 4) {
                    sb.append(ds.getAlphabetContainer().getSymbol(0, val));
                } else if (val == 4) {
                    sb.append(ds.getAlphabetContainer().getSymbol(0, BasicSamplingAlgorithms.sampleDiscreteRandomVariable(prob, rand)));
                } else {
                    double[] pr = null;
                    if (val == 5) {
                        pr = new double[]{prob[0], 0.0, 0.0, prob[3]};
                    }
                    if (val == 6) {
                        pr = new double[]{0.0, prob[1], prob[2], 0.0};
                    }
                    if (val == 7) {
                        pr = new double[]{prob[0], prob[1], 0.0, 0.0};
                    }
                    if (val == 8) {
                        pr = new double[]{0.0, 0.0, prob[2], prob[3]};
                    }
                    if (val == 9) {
                        pr = new double[]{prob[0], 0.0, prob[2], 0.0};
                    }
                    if (val == 10) {
                        pr = new double[]{0.0, prob[1], 0.0, prob[3]};
                    }
                    if (val == 11) {
                        pr = new double[]{0.0, prob[1], prob[2], prob[3]};
                    }
                    if (val == 12) {
                        pr = new double[]{prob[0], 0.0, prob[2], prob[3]};
                    }
                    if (val == 13) {
                        pr = new double[]{prob[0], prob[1], 0.0, prob[3]};
                    }
                    if (val == 14) {
                        pr = new double[]{prob[0], prob[1], prob[2], 0.0};
                    }
                    Normalisation.sumNormalisation(pr);
                    sb.append(ds.getAlphabetContainer().getSymbol(0, BasicSamplingAlgorithms.sampleDiscreteRandomVariable(pr, rand)));
                }
                ++j;
            }
            seq[i2] = new SparseSequence(new AlphabetContainer((Alphabet)DNAAlphabet.SINGLETON), sb.toString());
            ++i2;
        }
        return new DataSet(ds.getAnnotation(), seq);
    }
}

