/*
 * Decompiled with CFR 0.152.
 */
package projects.inmode.utils;

import de.jstacs.utils.SeqLogoPlotter;
import de.jstacs.utils.ToolBox;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Rectangle2D;

public class CustomizedSeqLogoPlotter
extends SeqLogoPlotter {
    protected static void plotStack(Graphics2D g, int x, int y, int w, int h, double[] p, String label, boolean scaled) {
        int border = 20;
        CustomizedSeqLogoPlotter.plotLogo(g, (double)(x + border), (double)(y - 25), w - 2 * border, h - 25, p, scaled);
        g.setColor(Color.BLACK);
        g.drawString(label, (int)((long)x + Math.round((double)w - g.getFontMetrics().getStringBounds(label, g).getWidth()) / 2L), y - 5);
    }

    protected static void plotYAxis(Graphics2D g, int x, int y, int h) {
        String[] labs = new String[]{"0", "0.5", "1", "1.5", "2"};
        double wl = (double)h * 0.4;
        double x2 = wl * 0.9;
        double h2 = h - 25;
        double y2 = y - 25;
        g.drawLine(x + (int)(x2 * 0.94), (int)y2, x + (int)(x2 * 0.94), (int)(y2 - h2));
        int i = 0;
        while (i <= 4) {
            g.drawLine(x + (int)(x2 * 0.7), (int)(y2 - (double)i * h2 / 4.0), x + (int)(x2 * 0.94), (int)(y2 - (double)i * h2 / 4.0));
            Rectangle2D rect = g.getFontMetrics().getStringBounds(labs[i], g);
            g.drawString(labs[i], x + (int)(x2 * 0.6 - rect.getWidth()), (int)(y2 - (double)i * h2 / 4.0 - rect.getCenterY()));
            ++i;
        }
        AffineTransform back = g.getTransform();
        g.rotate(-1.5707963267948966);
        String labY = "bits";
        Rectangle2D rect = g.getFontMetrics().getStringBounds(labY, g);
        g.drawString(labY, -((int)(y2 - 2.0 * h2 / 4.0 + rect.getCenterX())), (int)((double)x + rect.getWidth() / 2.0));
        g.setTransform(back);
    }

    protected static void plotLogo(Graphics2D g, double x, double y, double w, double h, double[] p, boolean scaled) {
        double ic = 1.0;
        if (scaled) {
            ic = CustomizedSeqLogoPlotter.getICScale(p);
        }
        h *= ic;
        double[] mp = (double[])p.clone();
        int i = 0;
        while (i < mp.length) {
            int n = i++;
            mp[n] = mp[n] * -1.0;
        }
        int[] r = ToolBox.rank(mp, false);
        int[] order = new int[r.length];
        int i2 = 0;
        while (i2 < r.length) {
            order[r[i2]] = i2;
            ++i2;
        }
        i2 = 0;
        while (i2 < order.length) {
            double curr = p[order[i2]];
            if (order[i2] == 0) {
                g.setColor(Color.GREEN);
                g.fill(CustomizedSeqLogoPlotter.getA(x, y, w, h * curr));
            } else if (order[i2] == 1) {
                g.setColor(Color.BLUE);
                g.fill(CustomizedSeqLogoPlotter.getC(x, y, w, h * curr));
            } else if (order[i2] == 2) {
                g.setColor(Color.ORANGE);
                g.fill(CustomizedSeqLogoPlotter.getG(x, y, w, h * curr));
            } else {
                g.setColor(Color.RED);
                g.fill(CustomizedSeqLogoPlotter.getT(x, y, w, h * curr));
            }
            y -= h * curr;
            ++i2;
        }
    }

    private static Area getC(double x, double y, double w, double h) {
        Ellipse2D.Double s = new Ellipse2D.Double(0.0, -90.0, 90.0, 90.0);
        Area a1 = new Area(s);
        Ellipse2D.Double s2 = new Ellipse2D.Double(15.0, -75.0, 60.0, 60.0);
        Area a2 = new Area(s2);
        a1.subtract(a2);
        Rectangle2D.Double s3 = new Rectangle2D.Double(65.0, -60.0, 30.0, 30.0);
        Area a3 = new Area(s3);
        a1.subtract(a3);
        AffineTransform t = new AffineTransform();
        t.scale(0.011363636363636364, 0.011111111111111112);
        t.scale(w, h);
        a1.transform(t);
        t = new AffineTransform();
        t.translate(x, y);
        a1.transform(t);
        return a1;
    }

    private static Area getT(double x, double y, double w, double h) {
        Rectangle2D.Double s = new Rectangle2D.Double(37.5, -100.0, 15.0, 100.0);
        Area a1 = new Area(s);
        Rectangle2D.Double s2 = new Rectangle2D.Double(0.0, -100.0, 90.0, 15.0);
        Area a2 = new Area(s2);
        a1.add(a2);
        AffineTransform t = new AffineTransform();
        t.scale(0.011111111111111112, 0.01);
        t.scale(w, h);
        a1.transform(t);
        t = new AffineTransform();
        t.translate(x, y);
        a1.transform(t);
        return a1;
    }

    private static Area getG(double x, double y, double w, double h) {
        Ellipse2D.Double s = new Ellipse2D.Double(0.0, -90.0, 90.0, 90.0);
        Area a1 = new Area(s);
        Ellipse2D.Double s2 = new Ellipse2D.Double(15.0, -75.0, 60.0, 60.0);
        Area a2 = new Area(s2);
        a1.subtract(a2);
        Rectangle2D.Double s3 = new Rectangle2D.Double(65.0, -60.0, 30.0, 30.0);
        Area a3 = new Area(s3);
        a1.subtract(a3);
        Rectangle2D.Double s4 = new Rectangle2D.Double(55.0, -40.0, 35.0, 15.0);
        Area a4 = new Area(s4);
        a1.add(a4);
        Rectangle2D.Double s5 = new Rectangle2D.Double(80.0, -40.0, 10.0, 40.0);
        Area a5 = new Area(s5);
        a1.add(a5);
        AffineTransform t = new AffineTransform();
        t.scale(0.011111111111111112, 0.011111111111111112);
        t.scale(w, h);
        a1.transform(t);
        t = new AffineTransform();
        t.translate(x, y);
        a1.transform(t);
        return a1;
    }

    private static Area getA(double x, double y, double w, double h) {
        int[] nArray = new int[9];
        nArray[1] = 40;
        nArray[2] = 50;
        nArray[3] = 90;
        nArray[4] = 75;
        nArray[5] = 45;
        nArray[6] = 45;
        nArray[7] = 15;
        int[] nArray2 = new int[9];
        nArray2[1] = -100;
        nArray2[2] = -100;
        nArray2[5] = -80;
        nArray2[6] = -80;
        Polygon s = new Polygon(nArray, nArray2, 9);
        Area a = new Area(s);
        Polygon s2 = new Polygon(new int[]{20, 70, 70, 20}, new int[]{-35, -35, -50, -50}, 4);
        Area a2 = new Area(s2);
        a.add(a2);
        AffineTransform t = new AffineTransform();
        t.scale(0.011111111111111112, 0.01);
        t.scale(w, h);
        a.transform(t);
        t = new AffineTransform();
        t.translate(x, y);
        a.transform(t);
        return a;
    }
}

