/*
 * Decompiled with CFR 0.152.
 */
package projects.inmode.tools;

import de.jstacs.DataType;
import de.jstacs.data.AlphabetContainer;
import de.jstacs.data.DataSet;
import de.jstacs.data.WrongAlphabetException;
import de.jstacs.data.alphabets.Alphabet;
import de.jstacs.data.alphabets.DNAAlphabet;
import de.jstacs.io.FileManager;
import de.jstacs.io.SparseStringExtractor;
import de.jstacs.parameters.FileParameter;
import de.jstacs.parameters.Parameter;
import de.jstacs.parameters.ParameterSet;
import de.jstacs.parameters.SimpleParameter;
import de.jstacs.parameters.SimpleParameterSet;
import de.jstacs.parameters.validation.NumberValidator;
import de.jstacs.results.PlotGeneratorResult;
import de.jstacs.results.Result;
import de.jstacs.results.ResultSet;
import de.jstacs.results.ResultSetResult;
import de.jstacs.results.StorableResult;
import de.jstacs.results.TextResult;
import de.jstacs.sequenceScores.statisticalModels.trainable.discrete.homogeneous.HomogeneousMM;
import de.jstacs.sequenceScores.statisticalModels.trainable.discrete.homogeneous.parameters.HomMMParameterSet;
import de.jstacs.tools.JstacsTool;
import de.jstacs.tools.ProgressUpdater;
import de.jstacs.tools.Protocol;
import de.jstacs.tools.ToolResult;
import de.jstacs.utils.SeqLogoPlotter;
import de.jstacs.utils.graphics.RasterizedAdaptor;
import java.io.File;
import java.io.IOException;
import java.util.Date;
import java.util.LinkedList;
import projects.inmode.models.latentVariables.MultiComponentOOPSModel;
import projects.inmode.models.variableStructure.AbstractVariableStructureModel;
import projects.inmode.models.variableStructure.parsimonious.inhomogeneous.InhPMMParameterSet;
import projects.inmode.models.variableStructure.parsimonious.inhomogeneous.InhomogeneousPMM;
import projects.inmode.utils.CSLPlotter;
import projects.inmode.utils.DataReader;

public class DeNovoMoDe
implements JstacsTool {
    @Override
    public ParameterSet getToolParameters() {
        LinkedList<Parameter> parameters = new LinkedList<Parameter>();
        try {
            parameters.add(new FileParameter("Input data", "The file containing the input data.", "*", true));
            parameters.add(new SimpleParameter(DataType.INT, "Motif width", "The width of the motif.", true, new NumberValidator<Integer>(4, 100), 15));
            parameters.add(new SimpleParameter(DataType.BYTE, "Motif order", "The maximal order of iPMM.", true, new NumberValidator<Byte>((byte)0, (byte)8), (byte)2));
            parameters.add(new SimpleParameter(DataType.BYTE, "Flanking order", "The order of the model for the flanking sequences.", true, new NumberValidator<Byte>((byte)0, (byte)3), (byte)2));
            parameters.add(new SimpleParameter(DataType.INT, "Initial iterations", "The number of initial iteration steps in the stochastic search.", true, new NumberValidator<Integer>(1, Integer.MAX_VALUE), 50));
            parameters.add(new SimpleParameter(DataType.INT, "Additional iterations", "The number of additional iteration steps that need to pass since the last optimal iteration step before termination.", true, new NumberValidator<Integer>(0, Integer.MAX_VALUE), 10));
            parameters.add(new SimpleParameter(DataType.INT, "Number of restarts", "The number of restarts of the stochastic search for reducing the risk of finding local optima.", true, new NumberValidator<Integer>(1, Integer.MAX_VALUE), 3));
            parameters.add(new SimpleParameter(DataType.STRING, "Name", "An arbitrary name that can make the output identifiable.", false, null, null));
        }
        catch (Exception e) {
            throw new RuntimeException();
        }
        return new SimpleParameterSet(parameters.toArray(new Parameter[0]));
    }

    @Override
    public ToolResult run(ParameterSet parameters, Protocol protocol, ProgressUpdater progress, int threads) throws Exception {
        DataSet data;
        String outputName = (String)parameters.getParameterForName("Name").getValue();
        if (outputName == null || outputName.equals("")) {
            outputName = "DeNovo(" + parameters.getParameterForName("Motif width").getValue() + "," + (Byte)parameters.getParameterForName("Motif order").getValue() + "," + (Byte)parameters.getParameterForName("Flanking order").getValue() + ")";
        }
        protocol.append("Reading data... ");
        AlphabetContainer con = new AlphabetContainer((Alphabet)DNAAlphabet.SINGLETON);
        File f = new File((String)parameters.getParameterForName("Input data").getValue());
        char ignore = '#';
        if (FileManager.readFile(f).toString().charAt(0) == '>') {
            ignore = '>';
        }
        try {
            data = new DataSet(con, new SparseStringExtractor(f, ignore));
        }
        catch (WrongAlphabetException wae) {
            protocol.append("replace IUPAC symbols... ");
            data = DataReader.replaceIUPACSymbols(new SparseStringExtractor(f, ignore));
        }
        protocol.append("completed.\n");
        protocol.append("Initializing algorithm... ");
        InhPMMParameterSet params = new InhPMMParameterSet(con, (Integer)parameters.getParameterForName("Motif width").getValue(), (Byte)parameters.getParameterForName("Motif order").getValue());
        AbstractVariableStructureModel[] motif = new InhomogeneousPMM[]{new InhomogeneousPMM(params)};
        HomogeneousMM flanking = new HomogeneousMM(new HomMMParameterSet(con, 1.0, "Flanking model", (Byte)parameters.getParameterForName("Flanking order").getValue()));
        MultiComponentOOPSModel model = new MultiComponentOOPSModel(motif, flanking, true, (Integer)parameters.getParameterForName("Initial iterations").getValue(), (Integer)parameters.getParameterForName("Additional iterations").getValue(), (Integer)parameters.getParameterForName("Number of restarts").getValue());
        model.setProtocol(protocol);
        progress.setLast((Integer)parameters.getParameterForName("Number of restarts").getValue() * (Integer)parameters.getParameterForName("Initial iterations").getValue());
        progress.setCurrent(0.0);
        model.setProgressUpdater(progress);
        protocol.append("completed.\n");
        protocol.append("Learning:\n");
        model.train(data);
        LinkedList<Result> result = new LinkedList<Result>();
        result.add(new TextResult("Logfile of " + outputName + " stochastic search", "Logfile for the stochastic search of " + outputName, new FileParameter.FileRepresentation("", model.getLog()), "txt", null, null, true));
        LinkedList<Result> resultLocal = new LinkedList<Result>();
        InhomogeneousPMM local = (InhomogeneousPMM)model.getMotifModels()[0];
        resultLocal.add(new StorableResult("XML of " + outputName + " motif", "XML representation of " + outputName + " motif", local));
        resultLocal.add(new TextResult("Parameters of " + outputName + " motif", "Conditional probability parameters for all PCTs leaves of " + outputName + " motif", new FileParameter.FileRepresentation("", local.getParameterRepresentation()), "txt", null, null, true));
        double[][] pwm = local.getPositionSpecificMononucleotideMarginals();
        double[][] pwmrc = new double[pwm.length][pwm[0].length];
        int i = 0;
        while (i < pwm.length) {
            int a = 0;
            while (a < pwm[i].length) {
                pwmrc[pwm.length - 1 - i][pwm[i].length - 1 - a] = pwm[i][a];
                ++a;
            }
            ++i;
        }
        RasterizedAdaptor ra = new RasterizedAdaptor("png");
        PlotGeneratorResult.PlotGenerator slpg = new SeqLogoPlotter.SeqLogoPlotGenerator(pwm, 500);
        ((SeqLogoPlotter.SeqLogoPlotGenerator)slpg).generatePlot(ra);
        PlotGeneratorResult pnr = new PlotGeneratorResult("SL of " + outputName + " motif", "The sequence logo of the position-specific mononucleotide marginal distribution of " + outputName + " motif", slpg, true);
        resultLocal.add(pnr);
        ra = new RasterizedAdaptor("png");
        slpg = new SeqLogoPlotter.SeqLogoPlotGenerator(pwmrc, 500);
        ((SeqLogoPlotter.SeqLogoPlotGenerator)slpg).generatePlot(ra);
        pnr = new PlotGeneratorResult("SL(rc) of " + outputName, "The reverse complement sequence logo of the position-specific mononucleotide marginal distribution of " + outputName, slpg, true);
        resultLocal.add(pnr);
        if ((Byte)parameters.getParameterForName("Motif order").getValue() > 0) {
            ra = new RasterizedAdaptor("png");
            slpg = new CSLPlotter.CSLPlotGenerator((InhomogeneousPMM)model.getMotifModels()[0]);
            ((CSLPlotter.CSLPlotGenerator)slpg).generatePlot(ra);
            pnr = new PlotGeneratorResult("CSL of " + outputName, "Conditional Sequence logo of " + outputName, slpg, true);
            resultLocal.add(pnr);
        }
        ResultSet rs = new ResultSet(resultLocal);
        ResultSetResult rsr = new ResultSetResult("Learned " + outputName + " motif", String.valueOf(outputName) + " motif", null, rs);
        result.add(rsr);
        ToolResult res = new ToolResult("Learned " + outputName, "All results of " + outputName, null, new ResultSet(result), parameters, this.getToolName(), new Date(System.currentTimeMillis()));
        return res;
    }

    @Override
    public String getToolName() {
        return "DeNovoMoDe";
    }

    @Override
    public String getToolVersion() {
        return "1.0";
    }

    @Override
    public String getShortName() {
        return "denovo";
    }

    @Override
    public String getDescription() {
        return "infers an iPMM via de novo motif discovery.";
    }

    @Override
    public String getHelpText() {
        try {
            return FileManager.readInputStream(DeNovoMoDe.class.getClassLoader().getResourceAsStream("projects/inmode/tools/helpDeNovoMoDe.txt")).toString();
        }
        catch (IOException e) {
            e.printStackTrace();
            return "";
        }
    }

    @Override
    public JstacsTool.ResultEntry[] getDefaultResultInfos() {
        return null;
    }
}

