/*
 * Decompiled with CFR 0.152.
 */
package projects.inmode.tools;

import de.jstacs.DataType;
import de.jstacs.classifiers.trainSMBased.TrainSMBasedClassifier;
import de.jstacs.data.AlphabetContainer;
import de.jstacs.data.DataSet;
import de.jstacs.data.WrongAlphabetException;
import de.jstacs.data.alphabets.Alphabet;
import de.jstacs.data.alphabets.DNAAlphabet;
import de.jstacs.io.FileManager;
import de.jstacs.io.SparseStringExtractor;
import de.jstacs.parameters.FileParameter;
import de.jstacs.parameters.Parameter;
import de.jstacs.parameters.ParameterSet;
import de.jstacs.parameters.SelectionParameter;
import de.jstacs.parameters.SimpleParameter;
import de.jstacs.parameters.SimpleParameterSet;
import de.jstacs.parameters.validation.NumberValidator;
import de.jstacs.results.ResultSet;
import de.jstacs.results.TextResult;
import de.jstacs.sequenceScores.statisticalModels.trainable.AbstractTrainableStatisticalModel;
import de.jstacs.sequenceScores.statisticalModels.trainable.PFMWrapperTrainSM;
import de.jstacs.sequenceScores.statisticalModels.trainable.discrete.homogeneous.HomogeneousMM;
import de.jstacs.sequenceScores.statisticalModels.trainable.discrete.homogeneous.parameters.HomMMParameterSet;
import de.jstacs.tools.JstacsTool;
import de.jstacs.tools.ProgressUpdater;
import de.jstacs.tools.Protocol;
import de.jstacs.tools.ToolResult;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Date;
import java.util.LinkedList;
import projects.inmode.models.variableStructure.parsimonious.inhomogeneous.InhomogeneousPMM;
import projects.inmode.tools.ScanApp;
import projects.inmode.utils.DataReader;

public class ClassificationApp
implements JstacsTool {
    @Override
    public ParameterSet getToolParameters() {
        LinkedList<Parameter> parameters = new LinkedList<Parameter>();
        try {
            parameters.add(new FileParameter("Input data", "The input data file containing the sequences to be classified.", "*", true));
            parameters.add(new FileParameter("Foreground model", "The foreground model file.", "xml", true));
            SimpleParameterSet p0 = new SimpleParameterSet(new Parameter[0]);
            SimpleParameterSet p1 = new SimpleParameterSet(new FileParameter("Model", "The model file.", "xml", true));
            SimpleParameterSet p2 = new SimpleParameterSet(new FileParameter("Data", "The data file for learning a background model from.", "*", true), new SimpleParameter(DataType.BYTE, "Order", "The order of the homogeneous background model.", true, new NumberValidator<Byte>((byte)0, (byte)5), (byte)1));
            SelectionParameter sel = new SelectionParameter(DataType.PARAMETERSET, new String[]{"Uniform PWM", "Previously learned", "Generated from data"}, new ParameterSet[]{p0, p1, p2}, "Background", "The type of background model that is used.", true);
            parameters.add(sel);
            parameters.add(new SimpleParameter(DataType.STRING, "Name", "An arbitrary name that can make the output identifiable.", false, null, null));
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException();
        }
        return new SimpleParameterSet(parameters.toArray(new Parameter[0]));
    }

    @Override
    public ToolResult run(ParameterSet parameters, Protocol protocol, ProgressUpdater progress, int threads) throws Exception {
        DataSet data;
        String outputName = (String)parameters.getParameterForName("Name").getValue();
        if (outputName == null || outputName.equals("")) {
            outputName = "Classification";
        }
        protocol.append("Reading data... ");
        AlphabetContainer con = new AlphabetContainer((Alphabet)DNAAlphabet.SINGLETON);
        File f = new File((String)parameters.getParameterForName("Input data").getValue());
        char ignore = '#';
        if (FileManager.readFile(f).toString().charAt(0) == '>') {
            ignore = '>';
        }
        try {
            data = new DataSet(con, new SparseStringExtractor(f, ignore));
        }
        catch (WrongAlphabetException wae) {
            protocol.append("replace IUPAC symbols... ");
            data = DataReader.replaceIUPACSymbols(new SparseStringExtractor(f, ignore));
        }
        StringBuffer sbIn = new StringBuffer();
        sbIn.append(((FileParameter)parameters.getParameterForName("Foreground model")).getFileContents().getContent());
        InhomogeneousPMM fgModel = new InhomogeneousPMM(sbIn);
        AbstractTrainableStatisticalModel bgModel = null;
        SelectionParameter sel = (SelectionParameter)parameters.getParameterForName("Background");
        if (sel.getSelected() == 0) {
            double[][] pwm = new double[fgModel.getLength()][4];
            int i = 0;
            while (i < pwm.length) {
                Arrays.fill(pwm[i], 1.0);
                ++i;
            }
            bgModel = new PFMWrapperTrainSM(new AlphabetContainer((Alphabet)DNAAlphabet.SINGLETON), "", pwm, 0.0);
            ((PFMWrapperTrainSM)bgModel).getPWM();
        }
        if (sel.getSelected() == 1) {
            sbIn = new StringBuffer();
            sbIn.append(((FileParameter)((SimpleParameterSet)sel.getValue()).getParameterForName("Model")).getFileContents().getContent());
            bgModel = new InhomogeneousPMM(sbIn);
        }
        if (sel.getSelected() == 2) {
            DataSet bgData;
            bgModel = new HomogeneousMM(new HomMMParameterSet(con, 1.0, "", (Byte)((SimpleParameterSet)sel.getValue()).getParameterForName("Order").getValue()));
            File fb = new File((String)((SimpleParameterSet)sel.getValue()).getParameterForName("Data").getValue());
            char ignorebg = '#';
            if (FileManager.readFile(fb).toString().charAt(0) == '>') {
                ignorebg = '>';
            }
            try {
                bgData = new DataSet(con, new SparseStringExtractor(fb, ignorebg));
            }
            catch (WrongAlphabetException wae) {
                protocol.append("replace IUPAC symbols... ");
                bgData = DataReader.replaceIUPACSymbols(new SparseStringExtractor(fb, ignorebg));
            }
            bgModel.train(bgData);
        }
        TrainSMBasedClassifier classifier = new TrainSMBasedClassifier(fgModel, bgModel);
        protocol.append("completed.\n");
        protocol.append("Classify sequences... ");
        byte[] classResults = classifier.classify(data);
        StringBuffer sb = new StringBuffer();
        sb.append("Sequence ID\tClass\n");
        int i = 0;
        while (i < classResults.length) {
            sb.append(String.valueOf(i) + "\t" + classResults[i] + "\n");
            ++i;
        }
        protocol.append("completed.\n");
        LinkedList<TextResult> result = new LinkedList<TextResult>();
        TextResult tr = new TextResult("Classification result of " + outputName, "All class assignments of " + outputName, new FileParameter.FileRepresentation("", sb.toString()), "txt", null, null, true);
        result.add(tr);
        ToolResult res = new ToolResult("Classification result of " + outputName, "Classification result of " + outputName, null, new ResultSet(result), parameters, this.getToolName(), new Date(System.currentTimeMillis()));
        return res;
    }

    @Override
    public String getToolName() {
        return "ClassificationApp";
    }

    @Override
    public String getToolVersion() {
        return "1.0";
    }

    @Override
    public String getShortName() {
        return "classify";
    }

    @Override
    public String getDescription() {
        return "performs a binary classification according to two iPMMs.";
    }

    @Override
    public String getHelpText() {
        try {
            return FileManager.readInputStream(ScanApp.class.getClassLoader().getResourceAsStream("projects/inmode/tools/helpClassificationApp.txt")).toString();
        }
        catch (IOException e) {
            e.printStackTrace();
            return "";
        }
    }

    @Override
    public JstacsTool.ResultEntry[] getDefaultResultInfos() {
        return null;
    }
}

