/*
 * Decompiled with CFR 0.152.
 */
package projects.inmode.models.variableStructure.parsimonious.inhomogeneous;

import de.jstacs.InstantiableFromParameterSet;
import de.jstacs.data.DataSet;
import de.jstacs.data.WrongLengthException;
import de.jstacs.data.sequences.Sequence;
import de.jstacs.io.NonParsableException;
import de.jstacs.io.XMLParser;
import de.jstacs.parameters.InstanceParameterSet;
import de.jstacs.results.NumericalResult;
import de.jstacs.results.NumericalResultSet;
import de.jstacs.sequenceScores.statisticalModels.trainable.discrete.inhomogeneous.SequenceIterator;
import de.jstacs.tools.ProgressUpdater;
import de.jstacs.utils.Normalisation;
import java.text.NumberFormat;
import java.util.Arrays;
import projects.inmode.models.variableStructure.parsimonious.AbstractParsimoniousModel;
import projects.inmode.models.variableStructure.parsimonious.dataStructures.ParsimoniousContextTree;
import projects.inmode.models.variableStructure.parsimonious.inhomogeneous.InhPMMParameterSet;

public class InhomogeneousPMM
extends AbstractParsimoniousModel
implements InstantiableFromParameterSet {
    protected static final String XML_TAG = "InhomogeneousPMM";
    protected InhPMMParameterSet params;
    private byte order;
    private boolean memoization = false;
    private boolean pruning = false;
    private ProgressUpdater progress;

    public InhomogeneousPMM(InhPMMParameterSet params) throws Exception {
        super(params.getAlphabetContainer(), params.getLength());
        try {
            this.params = params.clone();
        }
        catch (CloneNotSupportedException cnse) {
            System.out.println("ParameterSet could not be cloned. Use reference instead");
            this.params = params;
        }
        this.tree = new ParsimoniousContextTree[params.getLength()];
        this.order = (Byte)params.getParameterAt(0).getValue();
    }

    public InhomogeneousPMM(StringBuffer sb) throws NonParsableException {
        super(XMLParser.extractForTag(sb, XML_TAG));
    }

    @Override
    protected void fromXML(StringBuffer xml) throws NonParsableException {
        this.tree = XMLParser.extractObjectForTags(xml, "ParsimoniousContextTrees", ParsimoniousContextTree[].class);
        this.params = XMLParser.extractObjectForTags(xml, "params", InhPMMParameterSet.class);
        this.trained = XMLParser.extractObjectForTags(xml, "trained", Boolean.TYPE);
        this.alphabets = this.params.getAlphabetContainer();
        this.length = this.params.getLength();
        this.order = (Byte)this.params.getParameterAt(0).getValue();
    }

    @Override
    public StringBuffer toXML() {
        StringBuffer xml = new StringBuffer();
        XMLParser.appendObjectWithTags(xml, this.params, "params");
        XMLParser.appendObjectWithTags(xml, this.tree, "ParsimoniousContextTrees");
        XMLParser.appendObjectWithTags(xml, this.trained, "trained");
        XMLParser.addTags(xml, XML_TAG);
        return xml;
    }

    @Override
    public String getInstanceName() {
        return "iPMM(" + this.params.getParameterAt(0).getValue() + ")";
    }

    @Override
    public double getLogPriorTerm() throws Exception {
        return 0.0;
    }

    @Override
    public NumericalResultSet getNumericalCharacteristics() throws Exception {
        return new NumericalResultSet(new NumericalResult("numberOfLeaves", "The total number of leaves of the inh. PMM", this.getNumberOfLeaves()));
    }

    @Override
    public double getLogProbFor(Sequence seq, int start, int end) throws Exception {
        if (end - start + 1 != this.length) {
            throw new WrongLengthException("Sequence and model length do not match: " + (end - start + 1) + "!=" + this.length);
        }
        double res = 0.0;
        int i = 0;
        while (i <= end - start) {
            double p = this.tree[i].getLogProbFor(seq, i + start);
            res += p;
            ++i;
        }
        return res;
    }

    public String getXMLTag() {
        return XML_TAG;
    }

    @Override
    public InhomogeneousPMM clone() throws CloneNotSupportedException {
        InhomogeneousPMM cl = (InhomogeneousPMM)super.clone();
        cl.params = this.params.clone();
        cl.tree = new ParsimoniousContextTree[this.tree.length];
        int i = 0;
        while (i < this.tree.length) {
            if (this.tree[i] != null) {
                cl.tree[i] = this.tree[i].clone();
            }
            ++i;
        }
        cl.trained = this.trained;
        return cl;
    }

    public int getNumberOfLeaves() {
        int res = 0;
        int i = 0;
        while (i < this.tree.length) {
            res += this.tree[i].getNumberOfLeaves();
            ++i;
        }
        return res;
    }

    @Override
    public void train(DataSet data, double[] weights) throws Exception {
        if (weights == null) {
            weights = new double[data.getNumberOfElements()];
            Arrays.fill(weights, 1.0);
        }
        int i = 0;
        while (i < this.tree.length) {
            DataSet dataForThisTree = data.getInfixDataSet(i - Math.min(i, this.order), 1 + Math.min(i, this.order));
            this.tree[i] = new ParsimoniousContextTree(this.params.getAlphabetContainer(), (byte)Math.min(i, this.order));
            this.tree[i].setTreeNumber(i);
            this.tree[i].setRuntimeImprovements(this.memoization, this.pruning);
            this.tree[i].maximize(dataForThisTree, weights);
            if (this.progress != null) {
                this.progress.setCurrent(i);
            }
            ++i;
        }
        this.trained = true;
    }

    public byte getOrder() {
        return (Byte)this.params.getParameterAt(0).getValue();
    }

    @Override
    public double getLogScoreOfCurrentStructure() {
        double res = 0.0;
        int i = 0;
        while (i < this.tree.length) {
            res += this.tree[i].getScore();
            ++i;
        }
        return res;
    }

    @Override
    public InstanceParameterSet<? extends InstantiableFromParameterSet> getCurrentParameterSet() throws Exception {
        return this.params.clone();
    }

    @Override
    public String toString(NumberFormat nf) {
        return this.getSparseParameterRepresentation();
    }

    public double[][] getPositionSpecificMononucleotideMarginals() {
        double[][] res = new double[this.length][];
        int i = 0;
        while (i < res.length) {
            int locL = Math.min(i, this.order);
            SequenceIterator it = new SequenceIterator(locL);
            res[i] = new double[(int)this.alphabets.getAlphabetAt(i).length()];
            if (i == 0 || this.order == 0) {
                int a = 0;
                while (a < res[i].length) {
                    try {
                        Sequence seq = Sequence.create(this.alphabets, this.alphabets.getSymbol(i, a));
                        res[i][a] = Math.exp(this.tree[i].getLogProbFor(seq, 0));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    ++a;
                }
            } else {
                int[] bounds = new int[locL];
                int j = 0;
                while (j < bounds.length) {
                    bounds[j] = (int)this.alphabets.getAlphabetAt(i).length();
                    ++j;
                }
                it.setBounds(bounds);
                int a = 0;
                while (a < res[i].length) {
                    it.reset();
                    res[i][a] = 0.0;
                    do {
                        double condFactor = 1.0;
                        int k = 0;
                        while (k < bounds.length) {
                            condFactor *= res[i - bounds.length + k][it.discreteValAt(k)];
                            ++k;
                        }
                        String str = "";
                        int j2 = 0;
                        while (j2 < bounds.length) {
                            str = String.valueOf(str) + this.alphabets.getSymbol(j2, it.discreteValAt(j2));
                            ++j2;
                        }
                        str = String.valueOf(str) + this.alphabets.getSymbol(i, a);
                        Sequence seq = null;
                        try {
                            seq = Sequence.create(this.alphabets, str);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        try {
                            double[] dArray = res[i];
                            int n = a;
                            dArray[n] = dArray[n] + condFactor * Math.exp(this.tree[i].getLogProbFor(seq, seq.getLength() - 1));
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    } while (it.next());
                    ++a;
                }
                Normalisation.sumNormalisation(res[i]);
            }
            ++i;
        }
        return res;
    }

    public void setRuntimeImprovements(boolean memoization, boolean pruning) {
        this.memoization = memoization;
        this.pruning = pruning;
    }

    public void setProgressUpdater(ProgressUpdater progress) {
        this.progress = progress;
    }
}

