/*
 * Decompiled with CFR 0.152.
 */
package projects.inmode.models.variableStructure.parsimonious.dataStructures;

import de.jstacs.data.alphabets.DiscreteAlphabet;
import java.util.Iterator;
import java.util.TreeSet;
import projects.inmode.models.variableStructure.parsimonious.dataStructures.SymbolSet;

public class Partition
implements Comparable<Partition> {
    private double score;
    private DiscreteAlphabet alph;
    private TreeSet<SymbolSet> set = new TreeSet();
    private int numberOfSymbols = 0;
    private int numberOfMergedNodes = 0;

    protected Partition(DiscreteAlphabet alph, SymbolSet ... sets) {
        this.alph = alph;
        int i = 0;
        while (i < sets.length) {
            this.set.add(sets[i]);
            this.numberOfSymbols += sets[i].getNumberOfElements();
            if (sets[i].getNumberOfElements() > 1) {
                ++this.numberOfMergedNodes;
            }
            ++i;
        }
    }

    protected void add(SymbolSet s) {
        this.set.add(s);
        this.numberOfSymbols += s.getNumberOfElements();
    }

    public String toString() {
        return this.set.toString();
    }

    protected Boolean equals(Partition p) {
        if (this.alph.equals(p.getAlphabet())) {
            return this.set.equals(p.set);
        }
        return false;
    }

    protected DiscreteAlphabet getAlphabet() {
        return this.alph;
    }

    protected Boolean isValidPartition() {
        try {
            Object[] arr = this.set.toArray();
            SymbolSet[] sysearr = new SymbolSet[arr.length];
            int numberOfElements = 0;
            int i = 0;
            while (i < arr.length) {
                sysearr[i] = (SymbolSet)arr[i];
                numberOfElements += sysearr[i].getNumberOfElements();
                ++i;
            }
            if ((double)numberOfElements != this.alph.length()) {
                return false;
            }
            return new DiscreteAlphabet(true, new SymbolSet(this.alph, false).union(sysearr).getElements()).checkConsistency(this.alph);
        }
        catch (Exception e) {
            return false;
        }
    }

    protected Boolean isValidPartitionUnderSizeConstraint(int allowedSize, int allowedNumberOfExceptions) {
        if (!this.isValidPartition().booleanValue()) {
            return false;
        }
        int exceptions = 0;
        Iterator<SymbolSet> it = this.set.iterator();
        while (it.hasNext()) {
            if (it.next().size() > allowedSize) {
                ++exceptions;
            }
            if (exceptions <= allowedNumberOfExceptions) continue;
            return false;
        }
        return true;
    }

    protected void setScore(double score) {
        this.score = score;
    }

    protected double getScore() {
        return this.score;
    }

    protected int getNumberOfSymbols() {
        return this.numberOfSymbols;
    }

    protected boolean isExtendableBy(SymbolSet s) {
        if ((double)(this.getNumberOfSymbols() + s.getNumberOfElements()) > this.alph.length()) {
            return false;
        }
        Object[] arr = this.set.toArray();
        SymbolSet[] sysearr = new SymbolSet[arr.length];
        int i = 0;
        while (i < arr.length) {
            sysearr[i] = (SymbolSet)arr[i];
            if (sysearr[i].containsAtLeastOneElementOf(s)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    @Override
    public int compareTo(Partition o) {
        if (o.set.size() != this.set.size()) {
            return (int)Math.signum(o.set.size() - this.set.size());
        }
        Iterator<SymbolSet> ownIt = this.set.iterator();
        Iterator<SymbolSet> foreignIt = o.set.iterator();
        int i = 0;
        while (i < Math.min(o.set.size(), this.set.size())) {
            SymbolSet ownSymbolSet = ownIt.next();
            SymbolSet foreignSymbolSet = foreignIt.next();
            boolean equal = foreignSymbolSet.equals(ownSymbolSet);
            if (!equal) {
                return ownSymbolSet.compareTo(foreignSymbolSet);
            }
            ++i;
        }
        return 0;
    }

    protected boolean contains(SymbolSet s) {
        for (SymbolSet t : this.set) {
            if (s.compareTo(t) != 0) continue;
            return true;
        }
        return false;
    }

    protected int getNumberOfMergedNodes() {
        return this.numberOfMergedNodes;
    }
}

