/*
 * Decompiled with CFR 0.152.
 */
package projects.inmode.models.variableStructure.parsimonious.dataStructures;

import de.jstacs.NotTrainedException;
import de.jstacs.Storable;
import de.jstacs.data.AlphabetContainer;
import de.jstacs.data.DataSet;
import de.jstacs.data.alphabets.DNAAlphabet;
import de.jstacs.data.alphabets.DiscreteAlphabet;
import de.jstacs.data.sequences.Sequence;
import de.jstacs.io.XMLParser;
import de.jstacs.sequenceScores.statisticalModels.trainable.discrete.inhomogeneous.SequenceIterator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import java.util.Vector;
import projects.inmode.models.variableStructure.parsimonious.dataStructures.BinaryArray;
import projects.inmode.models.variableStructure.parsimonious.dataStructures.SymbolSet;
import projects.inmode.utils.NML;

public class ParsimoniousContextTree
implements Cloneable,
Storable {
    boolean memoization = false;
    boolean pruning = false;
    private final String XML_TAG = "ParsimoniousContextTree";
    public ContextTreeNode root;
    private Byte maximalDepth;
    protected DataSet data;
    protected double[] weights;
    private double weightSum;
    private AlphabetContainer alphCon;
    private String graphViz;
    private double[][] probabilityParameters;
    private String[] regEx;
    private int PCTnumber;
    private int nextNode;
    private int nextLeaf;
    private String treeStructure = "";
    public List<HashMap<BinaryArray, ContextTreeNode>> hml;
    public List<TreeSet<SymbolSet>> symbolsets;
    int maxLookAhead = 1;
    private boolean trained;
    HashMap<Sequence, Double> hmProbs;
    double[] condProbs;
    int[] condProbHelper;

    public ParsimoniousContextTree(AlphabetContainer con, Byte maximalDepth) throws Exception {
        this.maximalDepth = maximalDepth;
        this.alphCon = con;
        this.symbolsets = new ArrayList<TreeSet<SymbolSet>>();
        int i = 0;
        while (i < maximalDepth) {
            this.symbolsets.add(i, SymbolSet.createSymbolSets((DiscreteAlphabet)con.getAlphabetAt(i)));
            ++i;
        }
    }

    public ParsimoniousContextTree(StringBuffer xml) throws Exception {
        StringBuffer buff = XMLParser.extractForTag(xml, "ParsimoniousContextTree");
        this.alphCon = XMLParser.extractObjectForTags(buff, "AlphabetContainer", AlphabetContainer.class);
        this.maximalDepth = XMLParser.extractObjectForTags(buff, "maximalDepth", Byte.class);
        this.trained = XMLParser.extractObjectForTags(buff, "trained", Boolean.class);
        if (this.trained) {
            this.treeStructure = XMLParser.extractObjectForTags(buff, "treeStructure", String.class);
            this.graphViz = XMLParser.extractObjectForTags(buff, "graphViz", String.class);
            this.regEx = XMLParser.extractObjectForTags(buff, "regularExpressions", String[].class);
            this.probabilityParameters = XMLParser.extractObjectForTags(buff, "probabilityParameters", double[][].class);
            this.condProbHelper = XMLParser.extractObjectForTags(buff, "condProbHelper", int[].class);
            this.condProbs = XMLParser.extractObjectForTags(buff, "condProbs", double[].class);
        }
    }

    @Override
    public StringBuffer toXML() {
        StringBuffer xml = new StringBuffer();
        XMLParser.appendObjectWithTags(xml, this.alphCon, "AlphabetContainer");
        XMLParser.appendObjectWithTags(xml, this.maximalDepth, "maximalDepth");
        XMLParser.appendObjectWithTags(xml, this.trained, "trained");
        if (this.trained) {
            XMLParser.appendObjectWithTags(xml, this.treeStructure, "treeStructure");
            XMLParser.appendObjectWithTags(xml, this.graphViz, "graphViz");
            XMLParser.appendObjectWithTags(xml, this.regEx, "regularExpressions");
            XMLParser.appendObjectWithTags(xml, this.probabilityParameters, "probabilityParameters");
            XMLParser.appendObjectWithTags(xml, this.condProbs, "condProbs");
            XMLParser.appendObjectWithTags(xml, this.condProbHelper, "condProbHelper");
        }
        XMLParser.addTags(xml, "ParsimoniousContextTree");
        return xml;
    }

    public void maximize(DataSet data, double[] weights) {
        this.hml = new ArrayList<HashMap<BinaryArray, ContextTreeNode>>();
        int i = 0;
        while (i < this.maximalDepth) {
            this.hml.add(i, new HashMap());
            ++i;
        }
        this.data = data;
        if (weights == null) {
            this.weights = new double[data.getNumberOfElements()];
            Arrays.fill(this.weights, 1.0);
        } else {
            this.weights = weights;
        }
        i = 0;
        while (i < this.weights.length) {
            this.weightSum += this.weights[i];
            ++i;
        }
        this.root = new ContextTreeNode(null, null, this.maximalDepth.byteValue());
        this.graphViz = "";
        this.probabilityParameters = new double[this.root.getNumberOfLeaves()][(int)this.alphCon.getAlphabetLengthAt(this.maximalDepth.byteValue())];
        this.regEx = new String[this.root.getNumberOfLeaves()];
        this.nextNode = 0;
        this.nextLeaf = 0;
        this.root.traverseAfterConstruction();
        this.createCondProbTable();
        this.trained = true;
    }

    private void createCondProbTable() {
        this.hmProbs = new HashMap();
        this.condProbs = new double[(int)Math.pow(DNAAlphabet.SINGLETON.length(), this.maximalDepth + 1)];
        SequenceIterator it = new SequenceIterator(this.maximalDepth + 1);
        if (this.maximalDepth > 0) {
            this.condProbHelper = new int[this.maximalDepth.byteValue()];
            int s = 0;
            while (s < this.maximalDepth) {
                this.condProbHelper[s] = (int)Math.pow(DNAAlphabet.SINGLETON.length(), s + 1);
                ++s;
            }
        }
        int[] bounds = new int[this.maximalDepth + 1];
        Arrays.fill(bounds, (int)DNAAlphabet.SINGLETON.length());
        it.setBounds(bounds);
        int i = 0;
        do {
            String str = "";
            int j = 0;
            while (j < bounds.length) {
                str = String.valueOf(str) + this.alphCon.getSymbol(j, it.discreteValAt(j));
                ++j;
            }
            Sequence seq = null;
            try {
                seq = Sequence.create(this.alphCon, str);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.condProbs[i] = Math.log(this.root.getProbFor(seq, this.maximalDepth.byteValue()));
            this.hmProbs.put(seq, this.condProbs[i]);
            ++i;
        } while (it.next());
    }

    public int getNumberOfLeaves() {
        return this.probabilityParameters.length;
    }

    public double getScore() {
        return this.root.getLogScore();
    }

    public String getTreeStructure() {
        if (this.maximalDepth == 0) {
            return "()";
        }
        return "(" + this.treeStructure.toString() + ")";
    }

    public double getLogProbFor(Sequence seq, int position) throws NotTrainedException {
        if (!this.trained) {
            throw new NotTrainedException();
        }
        return this.condProbs[this.getIDofCondProb(seq, position - this.maximalDepth, position)];
    }

    public static double getOptimalPartitionScore(SymbolSet s, HashMap<String, SymbolSet> hm, double[] score) throws Exception {
        double res = Double.NEGATIVE_INFINITY;
        TreeSet<String> ts = s.createSymbolMinimalSubSetsAsStrings();
        Iterator<String> it = ts.iterator();
        String best = "";
        while (it.hasNext()) {
            SymbolSet t = hm.get(it.next());
            String str = s.getSetDifferenceAsString(t);
            if (str.equals("")) {
                if (!(s.getScore() >= res)) continue;
                res = t.getScore();
                best = t.toSparseString();
                continue;
            }
            if (!(score[hm.get((Object)str).ID] + t.getScore() >= res)) continue;
            res = score[hm.get((Object)str).ID] + t.getScore();
            best = t.toSparseString();
        }
        s.optimalSubSetIDs.clear();
        if (best.equals(s.toSparseString())) {
            s.optimalSubSetIDs.add(s.ID);
        } else {
            s.optimalSubSetIDs.add(hm.get((Object)best).ID);
            s.optimalSubSetIDs.addAll(hm.get((Object)s.getSetDifferenceAsString((SymbolSet)hm.get((Object)best))).optimalSubSetIDs);
        }
        return res;
    }

    public void setRuntimeImprovements(boolean memoization, boolean pruning, int maxLookAhead) {
        this.memoization = memoization;
        this.pruning = pruning;
        this.maxLookAhead = maxLookAhead;
    }

    public void setRuntimeImprovements(boolean memoization, boolean pruning) {
        this.memoization = memoization;
        this.pruning = pruning;
        this.maxLookAhead = 1;
    }

    public String getGraphviz() {
        return this.graphViz;
    }

    public void setTreeNumber(int i) {
        this.PCTnumber = i;
    }

    public ParsimoniousContextTree clone() throws CloneNotSupportedException {
        ParsimoniousContextTree cl = (ParsimoniousContextTree)super.clone();
        if (this.probabilityParameters != null) {
            cl.probabilityParameters = (double[][])this.probabilityParameters.clone();
        }
        if (this.regEx != null) {
            cl.regEx = (String[])this.regEx.clone();
        }
        if (this.root != null) {
            cl.root = this.root.clone();
        }
        return cl;
    }

    public String getSparseParameterRepresentation() {
        StringBuffer res = new StringBuffer();
        int i = 0;
        while (i < this.probabilityParameters.length) {
            res.append(this.regEx[i]);
            res.append("\t");
            int j = 0;
            while (j < this.probabilityParameters[i].length) {
                res.append(this.probabilityParameters[i][j]);
                res.append("\t");
                ++j;
            }
            res.append("%");
            ++i;
        }
        return res.toString();
    }

    public int getIDofCondProb(Sequence seq, int start, int end) {
        int res = 0;
        int d = end;
        while (d > start) {
            res += seq.discreteVal(d) * this.condProbHelper[d - start - 1];
            --d;
        }
        return res += seq.discreteVal(start);
    }

    private class ContextTreeNode
    implements Comparable<ContextTreeNode>,
    Cloneable {
        private int distanceToRoot;
        private final SymbolSet label;
        private String regExStr;
        private int numberOfLeaves = 0;
        private double logScore;
        private TreeSet<ContextTreeNode> children;
        protected int nodeNumber = 0;
        private int leafIndex;
        private double[] counts;
        protected HashSet<Short> representedSequenceIDs;
        protected Vector<HashSet<Short>> representedSequenceIDsNextVariable;
        TreeSet<SymbolSet> childNodeLabels;
        protected int lookAheadStatus;

        protected ContextTreeNode(ContextTreeNode parent) {
            this.distanceToRoot = parent.getDistanceToRoot() + 1;
            this.label = ParsimoniousContextTree.this.symbolsets.get(this.distanceToRoot - 1).last();
            this.logScore = parent.logScore;
            String str = "[";
            int i = 0;
            while (i < this.label.getNumberOfElements()) {
                str = String.valueOf(str) + this.label.getElements()[i];
                ++i;
            }
            str = String.valueOf(str) + "]";
            this.regExStr = String.valueOf(str) + parent.getRegExStr();
            this.numberOfLeaves = 1;
            this.counts = parent.counts;
            this.children = new TreeSet();
            if (this.distanceToRoot < ParsimoniousContextTree.this.maximalDepth) {
                this.children.add(new ContextTreeNode(this));
            }
        }

        protected ContextTreeNode(ContextTreeNode parent, SymbolSet label, int lookAheadLevel) {
            this.representedSequenceIDsNextVariable = new Vector();
            int c = 0;
            while ((double)c < ParsimoniousContextTree.this.data.getAlphabetContainer().getMaximalAlphabetLength()) {
                this.representedSequenceIDsNextVariable.add(new HashSet());
                ++c;
            }
            if (parent == null && label == null) {
                this.label = null;
                this.distanceToRoot = 0;
                this.regExStr = "";
                this.representedSequenceIDs = new HashSet();
                Short i = 0;
                while (i < ParsimoniousContextTree.this.data.getNumberOfElements()) {
                    this.representedSequenceIDs.add(i);
                    i = (short)(i + 1);
                }
                if (ParsimoniousContextTree.this.maximalDepth > 0) {
                    i = 0;
                    while (i < ParsimoniousContextTree.this.data.getNumberOfElements()) {
                        int s = ParsimoniousContextTree.this.data.getElementAt(i.shortValue()).discreteVal(ParsimoniousContextTree.this.data.getElementAt(i.shortValue()).getLength() - 2);
                        this.representedSequenceIDsNextVariable.get(s).add(i);
                        i = (short)(i + 1);
                    }
                }
            } else {
                this.label = label;
                this.distanceToRoot = parent.getDistanceToRoot() + 1;
                String str = "[";
                int i = 0;
                while (i < label.getNumberOfElements()) {
                    str = String.valueOf(str) + label.getElements()[i];
                    ++i;
                }
                str = String.valueOf(str) + "]";
                this.regExStr = String.valueOf(str) + parent.getRegExStr();
                if ((double)label.getNumberOfElements() == ParsimoniousContextTree.this.alphCon.getAlphabetLengthAt(0)) {
                    this.representedSequenceIDs = parent.representedSequenceIDs;
                    if (this.distanceToRoot < ParsimoniousContextTree.this.maximalDepth) {
                        for (Short id : this.representedSequenceIDs) {
                            int s = ParsimoniousContextTree.this.data.getElementAt(id.shortValue()).discreteVal(ParsimoniousContextTree.this.data.getElementAt(id.shortValue()).getLength() - 2 - this.distanceToRoot);
                            this.representedSequenceIDsNextVariable.get(s).add(id);
                        }
                    }
                } else {
                    this.representedSequenceIDs = new HashSet();
                    int[] symbolsCode = label.getCode();
                    int s = 0;
                    while (s < symbolsCode.length) {
                        this.representedSequenceIDs.addAll((Collection<Short>)parent.representedSequenceIDsNextVariable.elementAt(symbolsCode[s]));
                        ++s;
                    }
                    if (this.distanceToRoot < ParsimoniousContextTree.this.maximalDepth) {
                        for (Short id : this.representedSequenceIDs) {
                            int s2 = ParsimoniousContextTree.this.data.getElementAt(id.shortValue()).discreteVal(ParsimoniousContextTree.this.data.getElementAt(id.shortValue()).getLength() - 2 - this.distanceToRoot);
                            this.representedSequenceIDsNextVariable.get(s2).add(id);
                        }
                    }
                }
            }
            this.counts = this.computeCounts();
            if (ParsimoniousContextTree.this.pruning) {
                if (this.distanceToRoot == lookAheadLevel) {
                    if (this.distanceToRoot == ParsimoniousContextTree.this.maximalDepth) {
                        this.logScore = this.computeLogBICScoreOfLeaf();
                        this.numberOfLeaves = 1;
                    } else {
                        this.logScore = Math.max(this.getLogLikelihoodTermOfDistinctSequenceSplit(this.representedSequenceIDs, this.distanceToRoot) - 2.0 * (ParsimoniousContextTree.this.alphCon.getAlphabetLengthAt(0) - 1.0) * Math.log(ParsimoniousContextTree.this.data.getNumberOfElements()) / 2.0, this.computeLogBICScoreOfLeaf());
                    }
                } else if (this.getLogLikelihoodTermOfDistinctSequenceSplit(this.representedSequenceIDs, this.distanceToRoot) - 2.0 * (ParsimoniousContextTree.this.alphCon.getAlphabetLengthAt(0) - 1.0) * Math.log(ParsimoniousContextTree.this.data.getNumberOfElements()) / 2.0 <= this.computeLogBICScoreOfLeaf()) {
                    this.logScore = this.computeLogBICScoreOfLeaf();
                    this.numberOfLeaves = 1;
                    this.children = new TreeSet();
                    this.children.add(new ContextTreeNode(this));
                } else {
                    int numberOfLookAheads = Math.min(ParsimoniousContextTree.this.maxLookAhead + 1, lookAheadLevel - this.distanceToRoot);
                    int p = 0;
                    while (p < numberOfLookAheads) {
                        int j = this.distanceToRoot + 1 + p;
                        if (p == numberOfLookAheads - 1) {
                            j = lookAheadLevel;
                        }
                        BinaryArray bn = null;
                        boolean memoActive = false;
                        if (ParsimoniousContextTree.this.memoization) {
                            bn = new BinaryArray(ParsimoniousContextTree.this.data.getNumberOfElements());
                            bn.fillAccordingTo(this.representedSequenceIDs);
                            if (ParsimoniousContextTree.this.hml.get(this.distanceToRoot).containsKey(bn)) {
                                ContextTreeNode cn = ParsimoniousContextTree.this.hml.get(this.distanceToRoot).get(bn);
                                if (cn.lookAheadStatus >= j) {
                                    this.lookAheadStatus = cn.lookAheadStatus;
                                    this.logScore = cn.logScore;
                                    if (cn.lookAheadStatus == ParsimoniousContextTree.this.maximalDepth) {
                                        this.numberOfLeaves = cn.numberOfLeaves;
                                        this.children = (TreeSet)cn.children.clone();
                                    }
                                    memoActive = true;
                                    p = numberOfLookAheads;
                                }
                            }
                        }
                        if (!memoActive) {
                            if (this.childNodeLabels == null) {
                                try {
                                    this.childNodeLabels = SymbolSet.createSymbolSets((DiscreteAlphabet)ParsimoniousContextTree.this.alphCon.getAlphabetAt(ParsimoniousContextTree.this.maximalDepth - 1 - this.distanceToRoot));
                                }
                                catch (Exception e) {
                                    e.printStackTrace();
                                }
                                this.children = new TreeSet();
                                ContextTreeNode child = new ContextTreeNode(this, this.childNodeLabels.last(), lookAheadLevel);
                                this.childNodeLabels.last().setScore(child.logScore);
                                this.children.add(child);
                            }
                            for (SymbolSet set : this.childNodeLabels) {
                                if (!set.isActiveChild || !((double)set.size() < ParsimoniousContextTree.this.alphCon.getMaximalAlphabetLength())) continue;
                                ContextTreeNode child = new ContextTreeNode(this, set, j);
                                if (this.children.contains(child)) {
                                    this.children.remove(child);
                                }
                                this.children.add(child);
                                set.setScore(child.logScore);
                            }
                            double[] partitionScore = new double[this.childNodeLabels.size()];
                            Arrays.fill(partitionScore, 0.0);
                            SymbolSet[] ssarr = new SymbolSet[this.childNodeLabels.size()];
                            HashMap<String, SymbolSet> hm = new HashMap<String, SymbolSet>();
                            int k = 0;
                            for (SymbolSet s : this.childNodeLabels) {
                                hm.put(s.toSparseString(), s);
                                ssarr[k] = s;
                                s.ID = k++;
                            }
                            int i = 0;
                            while (i < ssarr.length) {
                                try {
                                    partitionScore[i] = ParsimoniousContextTree.getOptimalPartitionScore(ssarr[i], hm, partitionScore);
                                }
                                catch (Exception e) {
                                    partitionScore[i] = Double.NEGATIVE_INFINITY;
                                    System.out.println("Exception at score computation.");
                                }
                                ++i;
                            }
                            this.logScore = partitionScore[ssarr.length - 1];
                            if (this.distanceToRoot > 0) {
                                this.label.setScore(this.logScore);
                            }
                            if (j < ParsimoniousContextTree.this.maximalDepth) {
                                if (partitionScore[partitionScore.length - 1] <= this.computeLogBICScoreOfLeaf()) {
                                    this.logScore = this.computeLogBICScoreOfLeaf();
                                    this.numberOfLeaves = 1;
                                    this.children.clear();
                                    this.children.add(new ContextTreeNode(this));
                                    p = numberOfLookAheads + 1;
                                } else {
                                    int a = 0;
                                    while (a < partitionScore.length - 1) {
                                        int b = 0;
                                        while (b < partitionScore.length - 1) {
                                            if (!ssarr[a].containsAtLeastOneElementOf(ssarr[b]) && ssarr[a].isActiveChild() && ssarr[b].isActiveChild()) {
                                                TreeSet<String> tsloc = new TreeSet<String>();
                                                tsloc.addAll(ssarr[a].getSymbolsAsSet());
                                                tsloc.addAll(ssarr[b].getSymbolsAsSet());
                                                if (tsloc.equals(ssarr[ssarr.length - 1].getSymbolsAsSet()) && ssarr[ssarr.length - 1].getScore() > ssarr[a].getScore() + partitionScore[b]) {
                                                    ssarr[a].disable();
                                                }
                                            }
                                            ++b;
                                        }
                                        ++a;
                                    }
                                }
                            } else {
                                TreeSet<Integer> tsi = ssarr[ssarr.length - 1].optimalSubSetIDs;
                                TreeSet<SymbolSet> tobeRetained = new TreeSet<SymbolSet>();
                                while (!tsi.isEmpty()) {
                                    SymbolSet s = ssarr[tsi.pollFirst()];
                                    tobeRetained.add(s);
                                }
                                TreeSet<ContextTreeNode> toBeRemoved = new TreeSet<ContextTreeNode>();
                                for (ContextTreeNode tau : this.children) {
                                    if (tobeRetained.contains(tau.getLabel())) continue;
                                    toBeRemoved.add(tau);
                                }
                                for (ContextTreeNode tau : toBeRemoved) {
                                    this.children.remove(tau);
                                }
                                toBeRemoved.clear();
                                for (ContextTreeNode tau : this.children) {
                                    this.numberOfLeaves += tau.getNumberOfLeaves();
                                }
                                this.lookAheadStatus = j;
                                if (ParsimoniousContextTree.this.memoization) {
                                    ParsimoniousContextTree.this.hml.get(this.distanceToRoot).remove(bn);
                                    ParsimoniousContextTree.this.hml.get(this.distanceToRoot).put(bn, this);
                                }
                            }
                        }
                        ++p;
                    }
                }
            } else if (this.distanceToRoot < ParsimoniousContextTree.this.maximalDepth) {
                boolean memoActive = false;
                BinaryArray bn = null;
                if (ParsimoniousContextTree.this.memoization) {
                    bn = new BinaryArray(ParsimoniousContextTree.this.data.getNumberOfElements());
                    bn.fillAccordingTo(this.representedSequenceIDs);
                    if (ParsimoniousContextTree.this.hml.get(this.distanceToRoot).containsKey(bn)) {
                        ContextTreeNode cn = ParsimoniousContextTree.this.hml.get(this.distanceToRoot).get(bn);
                        this.children = (TreeSet)cn.children.clone();
                        this.logScore = cn.logScore;
                        this.numberOfLeaves = cn.numberOfLeaves;
                        memoActive = true;
                    }
                }
                if (!memoActive) {
                    try {
                        this.childNodeLabels = SymbolSet.createSymbolSets((DiscreteAlphabet)ParsimoniousContextTree.this.alphCon.getAlphabetAt(ParsimoniousContextTree.this.maximalDepth - 1 - this.distanceToRoot));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    this.children = new TreeSet();
                    for (SymbolSet set : this.childNodeLabels) {
                        ContextTreeNode child = new ContextTreeNode(this, set, 0);
                        this.children.add(child);
                        set.setScore(child.logScore);
                    }
                    double[] gScore = new double[this.childNodeLabels.size()];
                    Arrays.fill(gScore, 0.0);
                    SymbolSet[] ssarr = new SymbolSet[this.childNodeLabels.size()];
                    HashMap<String, SymbolSet> hm = new HashMap<String, SymbolSet>();
                    int k = 0;
                    for (SymbolSet s : this.childNodeLabels) {
                        hm.put(s.toSparseString(), s);
                        ssarr[k] = s;
                        s.ID = k++;
                    }
                    int i = 0;
                    while (i < ssarr.length) {
                        try {
                            gScore[i] = ParsimoniousContextTree.getOptimalPartitionScore(ssarr[i], hm, gScore);
                        }
                        catch (Exception e) {
                            gScore[i] = Double.NEGATIVE_INFINITY;
                            System.out.println("Exception at score computation.");
                        }
                        ++i;
                    }
                    TreeSet<Integer> tsi = ssarr[ssarr.length - 1].optimalSubSetIDs;
                    TreeSet<SymbolSet> tobeRetained = new TreeSet<SymbolSet>();
                    while (!tsi.isEmpty()) {
                        SymbolSet s = ssarr[tsi.pollFirst()];
                        tobeRetained.add(s);
                    }
                    TreeSet<ContextTreeNode> toBeRemoved = new TreeSet<ContextTreeNode>();
                    for (ContextTreeNode tau : this.children) {
                        if (tobeRetained.contains(tau.getLabel())) continue;
                        toBeRemoved.add(tau);
                    }
                    for (ContextTreeNode tau : toBeRemoved) {
                        this.children.remove(tau);
                    }
                    toBeRemoved.clear();
                    for (ContextTreeNode tau : this.children) {
                        this.logScore += tau.getLogScore();
                        this.numberOfLeaves += tau.getNumberOfLeaves();
                    }
                    if (ParsimoniousContextTree.this.memoization) {
                        ParsimoniousContextTree.this.hml.get(this.distanceToRoot).put(bn, this);
                    }
                }
            } else {
                this.numberOfLeaves = 1;
                this.logScore = this.computeLogBICScoreOfLeaf();
            }
        }

        @Override
        public int compareTo(ContextTreeNode o) {
            return this.label.compareTo(o.label);
        }

        protected double getLogScore() {
            return this.logScore;
        }

        protected int getDistanceToRoot() {
            return this.distanceToRoot;
        }

        protected SymbolSet getLabel() {
            return this.label;
        }

        protected int getNumberOfLeaves() {
            return this.numberOfLeaves;
        }

        protected String getRegExStr() {
            return this.regExStr;
        }

        protected void traverseAfterConstruction() {
            String l = "";
            if (this.label != null) {
                l = this.label.toString().substring(1, this.label.toString().length() - 1);
            }
            ParsimoniousContextTree parsimoniousContextTree = ParsimoniousContextTree.this;
            parsimoniousContextTree.graphViz = String.valueOf(parsimoniousContextTree.graphViz) + "t" + ParsimoniousContextTree.this.PCTnumber + "n" + this.nodeNumber + "[label=\"" + l + "\"];\n";
            if (this.distanceToRoot < ParsimoniousContextTree.this.maximalDepth) {
                Iterator<ContextTreeNode> iter = this.children.iterator();
                while (iter.hasNext()) {
                    ParsimoniousContextTree parsimoniousContextTree2 = ParsimoniousContextTree.this;
                    parsimoniousContextTree2.nextNode = parsimoniousContextTree2.nextNode + 1;
                    ContextTreeNode n = iter.next();
                    n.nodeNumber = ParsimoniousContextTree.this.nextNode;
                    ParsimoniousContextTree parsimoniousContextTree3 = ParsimoniousContextTree.this;
                    parsimoniousContextTree3.graphViz = String.valueOf(parsimoniousContextTree3.graphViz) + "t" + ParsimoniousContextTree.this.PCTnumber + "n" + this.nodeNumber + "-> t" + ParsimoniousContextTree.this.PCTnumber + "n" + n.nodeNumber + ";\n";
                }
                if (this.label != null) {
                    ParsimoniousContextTree parsimoniousContextTree4 = ParsimoniousContextTree.this;
                    parsimoniousContextTree4.treeStructure = String.valueOf(parsimoniousContextTree4.treeStructure) + this.label + "(";
                }
                Iterator<ContextTreeNode> it = this.children.iterator();
                while (it.hasNext()) {
                    it.next().traverseAfterConstruction();
                }
                if (this.label != null) {
                    ParsimoniousContextTree parsimoniousContextTree5 = ParsimoniousContextTree.this;
                    parsimoniousContextTree5.treeStructure = String.valueOf(parsimoniousContextTree5.treeStructure) + ")";
                }
            } else {
                ParsimoniousContextTree parsimoniousContextTree6 = ParsimoniousContextTree.this;
                parsimoniousContextTree6.treeStructure = String.valueOf(parsimoniousContextTree6.treeStructure) + this.label;
                this.leafIndex = ParsimoniousContextTree.this.nextLeaf;
                double sum = 0.0;
                int i = 0;
                while (i < this.counts.length) {
                    sum += NML.fsNMLeTerm((int)this.counts[i]) * (this.counts[i] + 1.0);
                    ++i;
                }
                i = 0;
                while (i < this.counts.length) {
                    ((ParsimoniousContextTree)ParsimoniousContextTree.this).probabilityParameters[this.leafIndex][i] = NML.fsNMLeTerm((int)this.counts[i]) * (this.counts[i] + 1.0) / sum;
                    ++i;
                }
                ((ParsimoniousContextTree)ParsimoniousContextTree.this).regEx[this.leafIndex] = this.regExStr;
                ParsimoniousContextTree parsimoniousContextTree7 = ParsimoniousContextTree.this;
                parsimoniousContextTree7.nextLeaf = parsimoniousContextTree7.nextLeaf + 1;
            }
        }

        protected double[] computeCounts() {
            double[] lcounts = new double[(int)ParsimoniousContextTree.this.alphCon.getAlphabetAt(ParsimoniousContextTree.this.alphCon.getNumberOfAlphabets() - 1).length()];
            for (short next : this.representedSequenceIDs) {
                int n = ParsimoniousContextTree.this.data.getElementAt(next).discreteVal(ParsimoniousContextTree.this.data.getElementAt(next).getLength() - 1);
                lcounts[n] = lcounts[n] + ParsimoniousContextTree.this.weights[next];
            }
            return lcounts;
        }

        public double getLogLikelihoodTermOfDistinctSequenceSplit(HashSet<Short> representedSequenceIDs, int distanceToRoot) {
            double res = 0.0;
            Iterator<Short> its = representedSequenceIDs.iterator();
            TreeSet<String> tss = new TreeSet<String>();
            HashMap<String, double[]> hm = new HashMap<String, double[]>();
            while (its.hasNext()) {
                double[] localCounts;
                short locID = its.next();
                String context = ParsimoniousContextTree.this.data.getElementAt(locID).getSubSequence(0, ParsimoniousContextTree.this.data.getElementAt(locID).getLength() - 1 - distanceToRoot).toString();
                if (hm.containsKey(context)) {
                    localCounts = (double[])hm.get(context);
                } else {
                    tss.add(context);
                    localCounts = new double[(int)ParsimoniousContextTree.this.alphCon.getAlphabetAt(ParsimoniousContextTree.this.alphCon.getNumberOfAlphabets() - 1).length()];
                }
                int n = ParsimoniousContextTree.this.data.getElementAt(locID).discreteVal(ParsimoniousContextTree.this.data.getElementAt(locID).getLength() - 1);
                localCounts[n] = localCounts[n] + ParsimoniousContextTree.this.weights[locID];
                hm.put(context, localCounts);
            }
            Iterator ittss = tss.iterator();
            while (ittss.hasNext()) {
                double[] localCounts = (double[])hm.get(ittss.next());
                double localN = 0.0;
                int i = 0;
                while (i < localCounts.length) {
                    localN += localCounts[i];
                    ++i;
                }
                double logLikelihoodTerm = 0.0;
                int i2 = 0;
                while (i2 < localCounts.length) {
                    if (localCounts[i2] > 0.0) {
                        logLikelihoodTerm += localCounts[i2] * (Math.log(localCounts[i2]) - Math.log(localN));
                    }
                    ++i2;
                }
                res += logLikelihoodTerm;
            }
            return res;
        }

        protected double computeLogBICScoreOfLeaf() {
            double localN = 0.0;
            int i = 0;
            while (i < this.counts.length) {
                localN += this.counts[i];
                ++i;
            }
            double logLikelihoodTerm = 0.0;
            int i2 = 0;
            while (i2 < this.counts.length) {
                if (this.counts[i2] > 0.0) {
                    logLikelihoodTerm += this.counts[i2] * (Math.log(this.counts[i2]) - Math.log(localN));
                }
                ++i2;
            }
            return logLikelihoodTerm - (double)(this.counts.length - 1) * Math.log(ParsimoniousContextTree.this.weightSum) / 2.0;
        }

        protected double getProbFor(Sequence seq, int position) {
            double res = 0.0;
            if (this.distanceToRoot < ParsimoniousContextTree.this.maximalDepth) {
                for (ContextTreeNode child : this.children) {
                    if (!child.label.contains(((DiscreteAlphabet)ParsimoniousContextTree.this.alphCon.getAlphabetAt(ParsimoniousContextTree.this.maximalDepth - 1 - this.distanceToRoot)).getSymbolAt(seq.discreteVal(position - 1 - this.distanceToRoot)))) continue;
                    res = child.getProbFor(seq, position);
                    break;
                }
            } else {
                res = ParsimoniousContextTree.this.probabilityParameters[this.leafIndex][seq.discreteVal(position)];
            }
            return res;
        }

        public ContextTreeNode clone() throws CloneNotSupportedException {
            ContextTreeNode cl = (ContextTreeNode)super.clone();
            return cl;
        }
    }
}

