/*
 * Decompiled with CFR 0.152.
 */
package projects.inmode.models.latentVariables;

import de.jstacs.NotTrainedException;
import de.jstacs.data.AlphabetContainer;
import de.jstacs.data.DataSet;
import de.jstacs.data.EmptyDataSetException;
import de.jstacs.data.WrongAlphabetException;
import de.jstacs.data.alphabets.Alphabet;
import de.jstacs.data.alphabets.DNAAlphabet;
import de.jstacs.data.sequences.Sequence;
import de.jstacs.io.NonParsableException;
import de.jstacs.io.XMLParser;
import de.jstacs.results.NumericalResultSet;
import de.jstacs.sequenceScores.statisticalModels.trainable.AbstractTrainableStatisticalModel;
import de.jstacs.tools.ProgressUpdater;
import de.jstacs.tools.Protocol;
import de.jstacs.utils.Normalisation;
import java.text.NumberFormat;
import java.util.Arrays;
import java.util.Locale;
import java.util.Random;
import javax.naming.OperationNotSupportedException;
import projects.inmode.models.latentVariables.AbstractLatentVariableModel;
import projects.inmode.models.variableStructure.AbstractVariableStructureModel;
import projects.inmode.utils.BasicSamplingAlgorithms;
import projects.inmode.utils.NML;

public class MultiComponentOOPSModel
extends AbstractLatentVariableModel {
    private static final String XML_TAG = "MultiComponentOOPSModel";
    private AbstractVariableStructureModel[] motifModel;
    private AbstractTrainableStatisticalModel flankingModel;
    private double[] strandOrientationLogProbabilityParameter;
    private double[] motifTypeLogProbabilityParameter;
    private boolean[] activeComponents;
    protected int numberOfInitialIterations;
    protected int numberOfAdditionalIterations;
    protected int numberOfRestarts;
    private static DataSet[] currentBindingSites;
    private static double[][] currentWeights;
    private static int[] bestLV;
    private static double maxScore;
    private static int bestRs;
    private static int bestIt;
    private static int[] bestLVLocal;
    private static int lastOptimalModelUpdate;
    private static int it;
    private static double maxScoreLocal;
    private static double currentProgress;
    private static boolean fullyObservable;
    private static boolean updateLVParams;
    private ProgressUpdater progress;
    private Protocol protocol;
    private StringBuffer log;
    private NumberFormat nf;
    private static boolean textOutput;
    private double jointStructureScore;

    static {
        fullyObservable = false;
        updateLVParams = false;
        textOutput = true;
    }

    public MultiComponentOOPSModel(AbstractVariableStructureModel[] motifModel, AbstractTrainableStatisticalModel flankingModel, boolean bothStrands, int numberOfInitialIterations, int numberOfAdditionalIterations, int numberOfRestarts) {
        super(new AlphabetContainer((Alphabet)DNAAlphabet.SINGLETON), 0);
        this.numberOfInitialIterations = numberOfInitialIterations;
        this.numberOfAdditionalIterations = numberOfAdditionalIterations;
        this.numberOfRestarts = numberOfRestarts;
        this.motifModel = motifModel;
        this.flankingModel = flankingModel;
        this.strandOrientationLogProbabilityParameter = bothStrands ? new double[]{Math.log(0.5), Math.log(0.5)} : new double[]{0.0};
        this.motifTypeLogProbabilityParameter = new double[motifModel.length];
        this.activeComponents = new boolean[motifModel.length];
        Arrays.fill(this.activeComponents, true);
        Arrays.fill(this.motifTypeLogProbabilityParameter, Math.log(1.0 / (double)motifModel.length));
        currentWeights = new double[motifModel.length][];
        currentBindingSites = new DataSet[motifModel.length];
        this.length = 0;
        textOutput = false;
        updateLVParams = false;
        this.nf = NumberFormat.getInstance(Locale.US);
        this.nf.setGroupingUsed(false);
        this.nf.setMaximumFractionDigits(2);
        this.nf.setMinimumFractionDigits(2);
    }

    public MultiComponentOOPSModel(StringBuffer sb) throws NonParsableException {
        super(XMLParser.extractForTag(sb, XML_TAG));
    }

    @Override
    protected void fromXML(StringBuffer xml) throws NonParsableException {
        this.alphabets = XMLParser.extractObjectForTags(xml, "alphabets", AlphabetContainer.class);
        this.length = XMLParser.extractObjectForTags(xml, "length", Integer.TYPE);
        this.flankingModel = XMLParser.extractObjectForTags(xml, "flankingModel", AbstractTrainableStatisticalModel.class);
        this.motifModel = XMLParser.extractObjectForTags(xml, "motifModel", AbstractVariableStructureModel[].class);
        this.activeComponents = XMLParser.extractObjectForTags(xml, "activeComponents", boolean[].class);
        this.strandOrientationLogProbabilityParameter = XMLParser.extractObjectForTags(xml, "strandParameter", double[].class);
        this.motifTypeLogProbabilityParameter = XMLParser.extractObjectForTags(xml, "typeParameter", double[].class);
        this.numberOfInitialIterations = XMLParser.extractObjectForTags(xml, "numberOfInitialIterations", Integer.TYPE);
        this.numberOfAdditionalIterations = XMLParser.extractObjectForTags(xml, "numberOfAdditionalIterations", Integer.TYPE);
        this.numberOfRestarts = XMLParser.extractObjectForTags(xml, "numberOfRestarts", Integer.TYPE);
        this.jointStructureScore = XMLParser.extractObjectForTags(xml, "jointStructureScore", Double.TYPE);
    }

    @Override
    public StringBuffer toXML() {
        StringBuffer xml = new StringBuffer();
        XMLParser.appendObjectWithTags(xml, this.alphabets, "alphabets");
        XMLParser.appendObjectWithTags(xml, this.length, "length");
        XMLParser.appendObjectWithTags(xml, this.flankingModel, "flankingModel");
        XMLParser.appendObjectWithTags(xml, this.motifModel, "motifModel");
        XMLParser.appendObjectWithTags(xml, this.activeComponents, "activeComponents");
        XMLParser.appendObjectWithTags(xml, this.strandOrientationLogProbabilityParameter, "strandParameter");
        XMLParser.appendObjectWithTags(xml, this.motifTypeLogProbabilityParameter, "typeParameter");
        XMLParser.appendObjectWithTags(xml, this.numberOfInitialIterations, "numberOfInitialIterations");
        XMLParser.appendObjectWithTags(xml, this.numberOfAdditionalIterations, "numberOfAdditionalIterations");
        XMLParser.appendObjectWithTags(xml, this.numberOfRestarts, "numberOfRestarts");
        XMLParser.appendObjectWithTags(xml, this.jointStructureScore, "jointStructureScore");
        XMLParser.addTags(xml, XML_TAG);
        return xml;
    }

    @Override
    public MultiComponentOOPSModel clone() throws CloneNotSupportedException {
        MultiComponentOOPSModel m = (MultiComponentOOPSModel)super.clone();
        m.activeComponents = (boolean[])this.activeComponents.clone();
        m.flankingModel = this.flankingModel.clone();
        m.motifModel = new AbstractVariableStructureModel[this.motifModel.length];
        int c = 0;
        while (c < this.motifModel.length) {
            m.motifModel[c] = this.motifModel[c].clone();
            ++c;
        }
        m.strandOrientationLogProbabilityParameter = (double[])this.strandOrientationLogProbabilityParameter.clone();
        m.motifTypeLogProbabilityParameter = (double[])this.motifTypeLogProbabilityParameter.clone();
        return m;
    }

    @Override
    public void train(DataSet data, double[] weights) throws Exception {
        this.log = new StringBuffer();
        currentProgress = 0.0;
        if (this.motifModel.length == 1 && data.getElementLength() == this.motifModel[0].getLength() && this.strandOrientationLogProbabilityParameter.length == 1) {
            this.numberOfInitialIterations = 1;
            this.numberOfRestarts = 1;
            this.numberOfAdditionalIterations = 0;
            this.protocol.append("Data is fully observable. Proceed with exact learning.");
            fullyObservable = true;
        }
        if (weights == null) {
            weights = new double[data.getNumberOfElements()];
            Arrays.fill(weights, 1.0);
        }
        int[] lv = new int[data.getNumberOfElements()];
        Random rand = new Random();
        if (!this.flankingModel.isInitialized()) {
            this.flankingModel.train(data, weights);
        }
        if (data.getMinimalElementLength() < this.motifModel[0].getLength()) {
            throw new Exception("Each input sequence needs to be at least as long as the width of the motif.");
        }
        maxScore = Double.NEGATIVE_INFINITY;
        bestRs = 0;
        bestIt = 0;
        int i = 0;
        while (i < data.getNumberOfElements()) {
            data.getElementAt(i).reverseComplement();
            ++i;
        }
        int rs = 0;
        while (rs < this.numberOfRestarts) {
            double maxScoreLocal;
            int i2 = 0;
            while (i2 < data.getNumberOfElements()) {
                int sL = data.getElementAt(i2).getLength() - this.motifModel[0].getLength() + 1;
                int position = BasicSamplingAlgorithms.sampleDiscreteRandomVariableFromUniformDistribution(sL, rand);
                int type = BasicSamplingAlgorithms.sampleDiscreteRandomVariableFromLogProbs(this.motifTypeLogProbabilityParameter, rand);
                int strand = BasicSamplingAlgorithms.sampleDiscreteRandomVariableFromLogProbs(this.strandOrientationLogProbabilityParameter, rand);
                lv[i2] = this.getLV(position, type, strand);
                ++i2;
            }
            MultiComponentOOPSModel.maxScoreLocal = Double.NEGATIVE_INFINITY;
            if (textOutput && !fullyObservable) {
                this.protocol.append("\nRestart " + rs + ":");
                this.log.append("Restart " + rs + "\n");
            }
            if ((maxScoreLocal = this.getLVAssignment(data, weights, lv)) > maxScore) {
                maxScore = maxScoreLocal;
                bestIt = lastOptimalModelUpdate;
                bestRs = rs;
                bestLV = (int[])bestLVLocal.clone();
            }
            ++rs;
        }
        this.jointStructureScore = maxScore;
        this.updateDataForLatentVariables(data, weights, bestLV);
        int k = 0;
        while (k < this.motifModel.length) {
            if (this.activeComponents[k]) {
                this.motifModel[k].train(currentBindingSites[k], weights);
            }
            ++k;
        }
        if (updateLVParams) {
            this.updateLVParameters(bestLV, weights);
        }
        if (textOutput && !fullyObservable) {
            this.protocol.append("\nLearning completed:\n");
            this.protocol.append("Best model seen at restart " + bestRs + ", iteration step " + bestIt + ", with score " + this.nf.format(this.jointStructureScore) + "\n");
            if (this.motifModel.length == 1) {
                this.protocol.append("Learned model:\n");
                this.protocol.append(String.valueOf(this.motifModel[0].getInstanceName()) + " of length " + this.motifModel[0].getLength() + " with " + this.motifModel[0].getNumericalCharacteristics().getResultAt(0).getValue() + " parameters\n");
            } else {
                this.protocol.append("Learned models:\n");
                NumberFormat nf = NumberFormat.getNumberInstance(Locale.US);
                nf.setMaximumFractionDigits(4);
                int k2 = 0;
                while (k2 < this.motifModel.length) {
                    if (this.activeComponents[k2]) {
                        this.protocol.append(String.valueOf(k2 + 1) + "-th model: " + this.motifModel[k2].getInstanceName() + " of length " + this.motifModel[k2].getLength() + " with " + this.motifModel[k2].getNumericalCharacteristics().getResultAt(0).getValue() + " parameters and occurence probability " + nf.format(Math.exp(this.motifTypeLogProbabilityParameter[k2])) + "\n");
                    } else {
                        this.protocol.append(String.valueOf(k2 + 1) + "-th model shrinked.\n");
                    }
                    ++k2;
                }
            }
        }
    }

    private double getLVAssignment(DataSet data, double[] weights, int[] lv) throws Exception {
        Random rand = new Random();
        double previousScore = 0.0;
        lastOptimalModelUpdate = 0;
        this.protocol.append(" Initial phase...");
        boolean add = false;
        if (textOutput && !fullyObservable) {
            this.log.append("It.step\tScore \tDifference\tlastOptimalStep\n");
        }
        it = 0;
        while (it < this.numberOfInitialIterations || it - lastOptimalModelUpdate < this.numberOfAdditionalIterations) {
            if (textOutput && !fullyObservable) {
                this.log.append(String.valueOf(it) + "\t");
            }
            if (it == this.numberOfInitialIterations) {
                this.protocol.append(" Additional phase...");
                add = true;
            }
            this.updateDataForLatentVariables(data, weights, lv);
            int k = 0;
            while (k < this.motifModel.length) {
                if (this.activeComponents[k]) {
                    this.motifModel[k].train(currentBindingSites[k], weights);
                }
                ++k;
            }
            if (updateLVParams) {
                this.updateLVParameters(lv, weights);
            }
            double score = 0.0;
            int k2 = 0;
            while (k2 < this.motifModel.length) {
                if (this.activeComponents[k2]) {
                    score += 2.0 * this.motifModel[k2].getLogScoreOfCurrentStructure();
                }
                ++k2;
            }
            if (score > maxScoreLocal) {
                maxScoreLocal = score;
                lastOptimalModelUpdate = it;
                bestLVLocal = (int[])lv.clone();
            }
            if (textOutput && !fullyObservable) {
                this.log.append(String.valueOf(this.nf.format(score)) + "\t" + this.nf.format(score - previousScore) + "\t" + lastOptimalModelUpdate);
            }
            int i = 0;
            while (i < data.getNumberOfElements()) {
                double[] profile = this.getUnnormalizedSequenceProfile(data.getElementAt(i));
                Normalisation.logSumNormalisation(profile);
                lv[i] = BasicSamplingAlgorithms.sampleDiscreteRandomVariable(profile, rand);
                ++i;
            }
            previousScore = score;
            if (textOutput && !fullyObservable) {
                this.log.append("\n");
            }
            if (it < this.numberOfInitialIterations) {
                this.progress.setCurrent(currentProgress += 1.0);
            }
            if (it == this.numberOfInitialIterations - 1) {
                this.protocol.append(" completed.");
            }
            ++it;
        }
        if (!add) {
            this.protocol.append(" No additional phase required.");
        } else {
            this.protocol.append(" completed.");
        }
        return maxScoreLocal;
    }

    private void updateDataForLatentVariables(DataSet data, double[] weights, int[] lv) throws EmptyDataSetException, WrongAlphabetException {
        Sequence[][] newBS = new Sequence[this.motifModel.length][];
        int k = 0;
        while (k < this.motifModel.length) {
            int numberOfBS = 0;
            int i = 0;
            while (i < lv.length) {
                if (this.getType(lv[i]) == k) {
                    ++numberOfBS;
                }
                ++i;
            }
            newBS[k] = new Sequence[numberOfBS];
            MultiComponentOOPSModel.currentWeights[k] = new double[numberOfBS];
            ++k;
        }
        int[] n = new int[this.motifModel.length];
        Arrays.fill(n, 0);
        int i = 0;
        while (i < data.getNumberOfElements()) {
            int type = this.getType(lv[i]);
            int position = this.getPosition(lv[i]);
            int strand = this.getStrand(lv[i]);
            Sequence seq = data.getElementAt(i).getSubSequence(position, this.motifModel[type].getLength());
            if (strand == 0) {
                newBS[type][n[type]] = seq;
            } else {
                try {
                    newBS[type][n[type]] = seq.reverseComplement();
                }
                catch (OperationNotSupportedException e) {
                    this.protocol.append("Warning: Reverse complement not supported. Use forward strand instead.\n");
                    newBS[type][n[type]] = seq;
                }
            }
            MultiComponentOOPSModel.currentWeights[type][n[type]] = weights[i];
            int n2 = type;
            n[n2] = n[n2] + 1;
            ++i;
        }
        int k2 = 0;
        while (k2 < this.motifModel.length) {
            if (n[k2] == 0) {
                this.activeComponents[k2] = false;
                this.motifTypeLogProbabilityParameter[k2] = Double.NEGATIVE_INFINITY;
            } else {
                this.activeComponents[k2] = true;
                MultiComponentOOPSModel.currentBindingSites[k2] = new DataSet("", newBS[k2]);
            }
            ++k2;
        }
        Normalisation.logSumNormalisation(this.motifTypeLogProbabilityParameter);
        k2 = 0;
        while (k2 < this.motifModel.length) {
            this.motifTypeLogProbabilityParameter[k2] = Math.log(this.motifTypeLogProbabilityParameter[k2]);
            ++k2;
        }
    }

    private void updateLVParameters(int[] lv, double[] weights) {
        int forward = 0;
        int backward = 0;
        int[] mt = new int[this.motifModel.length];
        Arrays.fill(mt, 0);
        int i = 0;
        while (i < lv.length) {
            int n = this.getType(lv[i]);
            mt[n] = (int)((double)mt[n] + weights[i]);
            if (this.strandOrientationLogProbabilityParameter.length == 2) {
                if (this.getStrand(lv[i]) == 0) {
                    forward = (int)((double)forward + weights[i]);
                } else {
                    backward = (int)((double)backward + weights[i]);
                }
            }
            ++i;
        }
        if (this.strandOrientationLogProbabilityParameter.length == 2) {
            this.strandOrientationLogProbabilityParameter = new double[]{NML.fsNMLeTerm(forward) * (double)(forward + 1), NML.fsNMLeTerm(backward) * (double)(backward + 1)};
            Normalisation.sumNormalisation(this.strandOrientationLogProbabilityParameter);
            this.strandOrientationLogProbabilityParameter[0] = Math.log(this.strandOrientationLogProbabilityParameter[0]);
            this.strandOrientationLogProbabilityParameter[1] = Math.log(this.strandOrientationLogProbabilityParameter[1]);
        }
        int k = 0;
        while (k < this.motifModel.length) {
            this.motifTypeLogProbabilityParameter[k] = this.activeComponents[k] ? NML.fsNMLeTerm(mt[k]) * (double)(mt[k] + 1) : 0.0;
            ++k;
        }
        Normalisation.sumNormalisation(this.motifTypeLogProbabilityParameter);
        k = 0;
        while (k < this.motifModel.length) {
            this.motifTypeLogProbabilityParameter[k] = Math.log(this.motifTypeLogProbabilityParameter[k]);
            ++k;
        }
    }

    @Override
    public double getLogPriorTerm() throws Exception {
        return 0.0;
    }

    @Override
    public double getLogProbFor(Sequence sequence, int startpos, int endpos) throws Exception {
        return Normalisation.logSumNormalisation(this.getUnnormalizedSequenceProfile(sequence.getSubSequence(startpos, endpos - startpos + 1)));
    }

    public double getLogProbFor(DataSet data) throws Exception {
        double res = 0.0;
        int i = 0;
        while (i < data.getNumberOfElements()) {
            res += this.getLogProbFor(data.getElementAt(i), 0, data.getElementAt(i).getLength() - 1);
            ++i;
        }
        return res;
    }

    @Override
    public String getInstanceName() {
        return "MultiOOPS";
    }

    @Override
    public NumericalResultSet getNumericalCharacteristics() throws Exception {
        return null;
    }

    @Override
    public boolean isInitialized() {
        return this.flankingModel.isInitialized() && this.motifModel[0].isInitialized();
    }

    private double[] getUnnormalizedSequenceProfile(Sequence sequence) throws NotTrainedException, Exception {
        Sequence rc = null;
        if (this.strandOrientationLogProbabilityParameter.length != 1) {
            rc = sequence.reverseComplement();
        }
        double[] res = new double[this.motifModel.length * this.strandOrientationLogProbabilityParameter.length * (sequence.getLength() - this.motifModel[0].getLength() + 1)];
        int i = 0;
        while (i < sequence.getLength() - this.motifModel[0].getLength() + 1) {
            int k;
            int p1 = Math.max(0, i - this.flankingModel.getMaximalMarkovOrder());
            int d1 = i - p1;
            int p2 = i + this.motifModel[0].getLength();
            int d2 = Math.min(sequence.getLength() - i - this.motifModel[0].getLength(), this.flankingModel.getMaximalMarkovOrder());
            int usedPositions = i * this.strandOrientationLogProbabilityParameter.length * this.motifModel.length;
            double flank = -this.flankingModel.getLogProbFor(sequence, p1, p1 + this.motifModel[0].getLength() + d1 + d2 - 1) + this.flankingModel.getLogProbFor(sequence, p1, p1 + d1 - 1) + this.flankingModel.getLogProbFor(sequence, p2, p2 + d2 - 1);
            if (this.strandOrientationLogProbabilityParameter.length == 1) {
                k = 0;
                while (k < this.motifModel.length) {
                    res[usedPositions + k] = this.activeComponents[k] ? flank + this.motifTypeLogProbabilityParameter[k] + this.motifModel[k].getLogProbFor(sequence, i, i + this.motifModel[k].getLength() - 1) : 0.0;
                    ++k;
                }
            } else {
                k = 0;
                while (k < this.motifModel.length) {
                    if (this.activeComponents[k]) {
                        res[usedPositions + 2 * k] = flank + this.strandOrientationLogProbabilityParameter[0] + this.motifModel[k].getLogProbFor(sequence, i, i + this.motifModel[k].getLength() - 1);
                        res[usedPositions + 2 * k + 1] = flank + this.strandOrientationLogProbabilityParameter[1] + this.motifTypeLogProbabilityParameter[k] + this.motifModel[k].getLogProbFor(rc, rc.getLength() - this.motifModel[k].getLength() - i, rc.getLength() - 1 - i);
                    } else {
                        res[usedPositions + 2 * k] = 0.0;
                        res[usedPositions + 2 * k + 1] = 0.0;
                    }
                    ++k;
                }
            }
            ++i;
        }
        return res;
    }

    public AbstractVariableStructureModel[] getMotifModels() {
        return this.motifModel;
    }

    public AbstractTrainableStatisticalModel getFlankingModel() {
        return this.flankingModel;
    }

    @Override
    public String toString(NumberFormat nf) {
        return null;
    }

    private int getLV(int position, int type, int strand) {
        return position * this.motifModel.length * this.strandOrientationLogProbabilityParameter.length + type * this.strandOrientationLogProbabilityParameter.length + strand;
    }

    private int getPosition(int lv) {
        return (int)Math.floor(lv / (this.motifModel.length * this.strandOrientationLogProbabilityParameter.length));
    }

    private int getType(int lv) {
        return (int)Math.floor(lv % (this.strandOrientationLogProbabilityParameter.length * this.motifModel.length) / this.strandOrientationLogProbabilityParameter.length);
    }

    private int getStrand(int lv) {
        return lv % this.strandOrientationLogProbabilityParameter.length;
    }

    public void setProtocol(Protocol protocol) {
        this.protocol = protocol;
        textOutput = true;
    }

    public void setProgressUpdater(ProgressUpdater progress) {
        this.progress = progress;
    }

    public String getLog() {
        return this.log.toString();
    }

    public boolean checkComponentActivity(int k) {
        return this.activeComponents[k];
    }

    public void updateLVParam(boolean d) {
        updateLVParams = d;
    }
}

