/*
 * Decompiled with CFR 0.152.
 */
package projects.dream2016;

import de.jstacs.data.AlphabetContainer;
import de.jstacs.data.DataSet;
import de.jstacs.data.alphabets.Alphabet;
import de.jstacs.data.alphabets.ContinuousAlphabet;
import de.jstacs.data.sequences.Sequence;
import de.jstacs.io.NonParsableException;
import de.jstacs.io.XMLParser;
import de.jstacs.sequenceScores.statisticalModels.differentiable.AbstractDifferentiableStatisticalModel;
import de.jstacs.utils.DoubleList;
import de.jstacs.utils.IntList;
import java.text.NumberFormat;

public class ScoreReadingDiffSM
extends AbstractDifferentiableStatisticalModel {
    private int column;
    private double ess;
    private double offset;
    private double scale;
    private boolean transform;

    public ScoreReadingDiffSM(int column, int length, double ess, boolean transform) throws IllegalArgumentException {
        super(new AlphabetContainer((Alphabet)new ContinuousAlphabet()), length);
        this.column = column;
        this.ess = ess;
        this.offset = 0.0;
        this.scale = -1.0;
        this.transform = transform;
    }

    public ScoreReadingDiffSM(StringBuffer xml) throws NonParsableException {
        super(xml);
    }

    @Override
    public ScoreReadingDiffSM clone() throws CloneNotSupportedException {
        ScoreReadingDiffSM clone = (ScoreReadingDiffSM)super.clone();
        return clone;
    }

    @Override
    public int getSizeOfEventSpaceForRandomVariablesOfParameter(int index) {
        return 0;
    }

    @Override
    public double getLogNormalizationConstant() {
        return 0.0;
    }

    @Override
    public double getLogPartialNormalizationConstant(int parameterIndex) throws Exception {
        return 0.0;
    }

    @Override
    public double getLogPriorTerm() {
        return 0.0;
    }

    @Override
    public void addGradientOfLogPriorTerm(double[] grad, int start) throws Exception {
    }

    @Override
    public double getESS() {
        return this.ess;
    }

    @Override
    public void initializeFunction(int index, boolean freeParams, DataSet[] data, double[][] weights) throws Exception {
        this.initializeFunctionRandomly(freeParams);
    }

    @Override
    public void initializeFunctionRandomly(boolean freeParams) throws Exception {
        this.offset = 0.0;
        this.scale = -1.0;
    }

    @Override
    public double getLogScoreAndPartialDerivation(Sequence seq, int start, IntList indices, DoubleList partialDer) {
        double val = seq.continuousVal(start + this.column);
        if (this.transform) {
            indices.add(0);
            partialDer.add(1.0);
            indices.add(1);
            partialDer.add(val);
        }
        return this.scale * val + this.offset;
    }

    @Override
    public int getNumberOfParameters() {
        return this.transform ? 2 : 0;
    }

    @Override
    public double[] getCurrentParameterValues() throws Exception {
        if (this.transform) {
            return new double[]{this.offset, this.scale};
        }
        return new double[0];
    }

    @Override
    public void setParameters(double[] params, int start) {
        if (this.transform) {
            this.offset = params[start];
            this.scale = params[start + 1];
        }
    }

    @Override
    public String getInstanceName() {
        return "ScoreReadingDiffSM(" + this.column + ")";
    }

    @Override
    public double getLogScoreFor(Sequence seq, int start) {
        return this.scale * seq.continuousVal(start + this.column) + this.offset;
    }

    @Override
    public boolean isInitialized() {
        return true;
    }

    @Override
    public String toString(NumberFormat nf) {
        return "ScoreReadingDiffSM(" + this.column + ")";
    }

    @Override
    public StringBuffer toXML() {
        StringBuffer xml = new StringBuffer();
        XMLParser.appendObjectWithTags(xml, this.length, "length");
        XMLParser.appendObjectWithTags(xml, this.ess, "ess");
        XMLParser.appendObjectWithTags(xml, this.column, "column");
        XMLParser.appendObjectWithTags(xml, this.offset, "offset");
        XMLParser.appendObjectWithTags(xml, this.scale, "scale");
        XMLParser.appendObjectWithTags(xml, this.transform, "transform");
        XMLParser.addTags(xml, "ScoreRead");
        return xml;
    }

    @Override
    protected void fromXML(StringBuffer xml) throws NonParsableException {
        this.alphabets = new AlphabetContainer((Alphabet)new ContinuousAlphabet());
        xml = XMLParser.extractForTag(xml, "ScoreRead");
        this.length = (Integer)XMLParser.extractObjectForTags(xml, "length");
        this.ess = (Double)XMLParser.extractObjectForTags(xml, "ess");
        this.column = (Integer)XMLParser.extractObjectForTags(xml, "column");
        this.offset = (Double)XMLParser.extractObjectForTags(xml, "offset");
        this.scale = (Double)XMLParser.extractObjectForTags(xml, "scale");
        this.transform = (Boolean)XMLParser.extractObjectForTags(xml, "transform");
    }
}

