/*
 * Decompiled with CFR 0.152.
 */
package projects.dream2016;

import de.jstacs.algorithms.optimization.termination.IterationCondition;
import de.jstacs.algorithms.optimization.termination.TerminationCondition;
import de.jstacs.data.DataSet;
import de.jstacs.data.alphabets.DNAAlphabetContainer;
import de.jstacs.data.sequences.Sequence;
import de.jstacs.data.sequences.annotation.SequenceAnnotation;
import de.jstacs.io.FileManager;
import de.jstacs.results.Result;
import de.jstacs.sequenceScores.statisticalModels.trainable.TrainableStatisticalModel;
import de.jstacs.sequenceScores.statisticalModels.trainable.mixture.AbstractMixtureTrainSM;
import de.jstacs.sequenceScores.statisticalModels.trainable.mixture.StrandTrainSM;
import de.jstacs.utils.IntList;
import de.jstacs.utils.Normalisation;
import de.jstacs.utils.Pair;
import de.jstacs.utils.ToolBox;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.PrintWriter;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import projects.inmode.models.variableStructure.parsimonious.inhomogeneous.InhomogeneousPMM;

public class RegionPMMScan2 {
    public static void main(String[] args) throws Exception {
        InhomogeneousPMM pmm = new InhomogeneousPMM(FileManager.readFile(args[0]));
        StrandTrainSM model2 = new StrandTrainSM((TrainableStatisticalModel)pmm, 1, 0.5, 1.0, (TerminationCondition)new IterationCondition(1), AbstractMixtureTrainSM.Parameterization.THETA);
        double t1 = (double)model2.getLength() * Math.log(0.25);
        double t2 = (double)model2.getLength() * Math.log(0.3333333333333333);
        Pair<int[][], DataSet> seqs = null;
        StringBuffer lastHeader = new StringBuffer();
        BufferedReader read = new BufferedReader(new FileReader(args[1]));
        DecimalFormat nf = new DecimalFormat("#.####");
        DecimalFormatSymbols syms = nf.getDecimalFormatSymbols();
        syms.setInfinity("Inf");
        syms.setNaN("NaN");
        nf.setDecimalFormatSymbols(syms);
        PrintWriter wr = new PrintWriter(String.valueOf(args[0]) + "_winscores2.txt");
        double[] scores1 = new double[50];
        Arrays.fill(scores1, Double.NEGATIVE_INFINITY);
        byte[] strand1 = new byte[50];
        int currIdx = 0;
        int lastOff = 0;
        String lastId = null;
        while ((seqs = RegionPMMScan2.readNextSequences(read, lastHeader)) != null) {
            DataSet ds = seqs.getSecondElement();
            int[][] idxs = seqs.getFirstElement();
            int i = 0;
            while (i < ds.getNumberOfElements()) {
                Sequence seq = ds.getElementAt(i);
                String id = seq.getSequenceAnnotationByType("id", 0).getIdentifier();
                if (!id.equals(lastId)) {
                    currIdx = 0;
                    lastOff = 0;
                    Arrays.fill(scores1, Double.NEGATIVE_INFINITY);
                    wr.println("[" + id + "]");
                }
                int off = idxs[0][i];
                int j = lastOff;
                while (j < off) {
                    scores1[currIdx] = Double.NEGATIVE_INFINITY;
                    strand1[currIdx] = 0;
                    if (++currIdx == scores1.length) {
                        RegionPMMScan2.print(wr, nf, id, scores1, strand1, t1, t2, lastOff, j, currIdx);
                        currIdx = 0;
                        Arrays.fill(scores1, Double.NEGATIVE_INFINITY);
                        Arrays.fill(strand1, (byte)0);
                    }
                    ++j;
                }
                j = 0;
                while (j < seq.getLength() - model2.getLength() + 1) {
                    double[] compScore = new double[]{model2.getLogProbFor(0, seq, j, j + model2.getLength() - 1), model2.getLogProbFor(1, seq, j, j + model2.getLength() - 1)};
                    double score = Normalisation.getLogSum(compScore);
                    int strand = compScore[0] == compScore[1] ? 0 : (compScore[0] > compScore[1] ? 1 : -1);
                    scores1[currIdx] = score;
                    strand1[currIdx] = strand;
                    if (++currIdx == scores1.length) {
                        RegionPMMScan2.print(wr, nf, id, scores1, strand1, t1, t2, off, j, currIdx);
                        currIdx = 0;
                        Arrays.fill(scores1, Double.NEGATIVE_INFINITY);
                        Arrays.fill(strand1, (byte)0);
                    }
                    lastOff = off + j + 1;
                    ++j;
                }
                lastId = id;
                ++i;
            }
        }
        read.close();
        wr.close();
    }

    private static void print(PrintWriter wr, NumberFormat nf, String id, double[] scores1, byte[] strands, double t1, double t2, int off, int j, int end) {
        int nabove2;
        int nabove1;
        String strand;
        double mean;
        double max;
        int idx = -1;
        double ns = 0.0;
        if (scores1 == null) {
            max = Double.NEGATIVE_INFINITY;
            mean = Double.NEGATIVE_INFINITY;
            strand = "..";
            nabove1 = 0;
            nabove2 = 0;
        } else {
            mean = Normalisation.getLogSum(0, end, scores1);
            ns = 0.0;
            int i = 0;
            while (i < end) {
                ns += (double)strands[i] * Math.exp(scores1[i] - mean);
                ++i;
            }
            idx = ToolBox.getMaxIndex(0, end, scores1);
            max = scores1[idx];
            strand = String.valueOf(strands[idx] == 0 ? "." : (strands[idx] > 0 ? "+" : "-")) + (ns == 0.0 || Double.isNaN(ns) ? "." : (ns > 0.0 ? "+" : "-"));
            nabove1 = RegionPMMScan2.aboveThreshold(scores1, t1, end);
            nabove2 = RegionPMMScan2.aboveThreshold(scores1, t2, end);
        }
        wr.println(String.valueOf(nf.format(-mean)) + "\t" + nf.format(-max) + "\t" + nabove1 + "\t" + nabove2 + "\t" + strand + idx);
    }

    private static int aboveThreshold(double[] scores1, double t, int end) {
        int n = 0;
        int i = 0;
        while (i < end) {
            if (scores1[i] > t) {
                ++n;
            }
            ++i;
        }
        return n;
    }

    public static double getConsensusScore(double[][] pwm) {
        double score = 0.0;
        int i = 0;
        while (i < pwm.length) {
            score += ToolBox.max(pwm[i]);
            ++i;
        }
        return score;
    }

    public static Pair<int[][], DataSet> readNextSequences(BufferedReader read, StringBuffer lastHeader) throws Exception {
        String str = null;
        StringBuffer line = new StringBuffer();
        IntList starts = new IntList();
        LinkedList<Sequence> seqs = new LinkedList<Sequence>();
        Pattern acgt = Pattern.compile("[ACGT]+", 2);
        DNAAlphabetContainer con = DNAAlphabetContainer.SINGLETON;
        int size = 0;
        while ((str = read.readLine()) != null || line.length() > 0) {
            if (str != null) {
                str = str.trim();
            }
            if (str == null || str.startsWith(">")) {
                String header = lastHeader.toString();
                if (str != null) {
                    lastHeader.delete(0, lastHeader.length());
                    lastHeader.append(str.substring(1).trim());
                }
                if (line.length() <= 0) continue;
                String seqStr = line.toString();
                line.delete(0, line.length());
                Matcher match = acgt.matcher(seqStr);
                while (match.find()) {
                    int start = match.start();
                    int end = match.end();
                    SequenceAnnotation annotation = new SequenceAnnotation("id", header, (Result[][])new Result[0][]);
                    Sequence seq = Sequence.create(DNAAlphabetContainer.SINGLETON, seqStr.substring(start, end));
                    seq = seq.annotate(false, annotation);
                    seqs.add(seq);
                    size += end - start;
                    starts.add(start);
                }
                if (!((double)size > 1.0E7) && str != null) continue;
                boolean s = false;
                return new Pair<int[][], DataSet>(new int[][]{starts.toArray()}, new DataSet("", seqs));
            }
            line.append(str);
        }
        return null;
    }
}

