/*
 * Decompiled with CFR 0.152.
 */
package projects.dream2016;

import de.jstacs.data.DataSet;
import de.jstacs.data.alphabets.DNAAlphabetContainer;
import de.jstacs.data.sequences.Sequence;
import de.jstacs.data.sequences.annotation.SequenceAnnotation;
import de.jstacs.results.Result;
import de.jstacs.utils.IntList;
import de.jstacs.utils.Pair;
import de.jstacs.utils.ToolBox;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.PrintWriter;
import java.util.LinkedList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PrintRegions {
    public static void main(String[] args) throws Exception {
        Pair<int[][], DataSet> seqs = null;
        StringBuffer lastHeader = new StringBuffer();
        BufferedReader read = new BufferedReader(new FileReader(args[0]));
        PrintWriter wr = new PrintWriter(String.valueOf(args[0]) + "_regions.txt");
        int sl = 50;
        int currIdx = 0;
        int lastOff = 0;
        String lastId = null;
        while ((seqs = PrintRegions.readNextSequences(read, lastHeader)) != null) {
            DataSet ds = seqs.getSecondElement();
            int[][] idxs = seqs.getFirstElement();
            int i = 0;
            while (i < ds.getNumberOfElements()) {
                Sequence seq = ds.getElementAt(i);
                String id = seq.getSequenceAnnotationByType("id", 0).getIdentifier();
                if (!id.equals(lastId)) {
                    currIdx = 0;
                    lastOff = 0;
                    wr.println("[" + id + "]");
                }
                int off = idxs[0][i];
                int j = lastOff;
                while (j < off) {
                    if (++currIdx == sl) {
                        PrintRegions.print(wr, id, lastOff, j, currIdx);
                        currIdx = 0;
                    }
                    ++j;
                }
                j = 0;
                while (j < seq.getLength()) {
                    if (++currIdx == sl) {
                        PrintRegions.print(wr, id, off, j, currIdx);
                        currIdx = 0;
                    }
                    lastOff = off + j + 1;
                    ++j;
                }
                lastId = id;
                ++i;
            }
        }
        read.close();
        wr.close();
    }

    private static void print(PrintWriter wr, String id, int off, int j, int end) {
        wr.println(String.valueOf(id) + "\t" + (off + j - 50 + 1) + "\t" + (off + j + 1));
    }

    public static double getConsensusScore(double[][] pwm) {
        double score = 0.0;
        int i = 0;
        while (i < pwm.length) {
            score += ToolBox.max(pwm[i]);
            ++i;
        }
        return score;
    }

    public static Pair<int[][], DataSet> readNextSequences(BufferedReader read, StringBuffer lastHeader) throws Exception {
        String str = null;
        StringBuffer line = new StringBuffer();
        IntList starts = new IntList();
        LinkedList<Sequence> seqs = new LinkedList<Sequence>();
        Pattern acgt = Pattern.compile("[ACGT]+", 2);
        DNAAlphabetContainer con = DNAAlphabetContainer.SINGLETON;
        int size = 0;
        while ((str = read.readLine()) != null || line.length() > 0) {
            if (str != null) {
                str = str.trim();
            }
            if (str == null || str.startsWith(">")) {
                String header = lastHeader.toString();
                if (str != null) {
                    lastHeader.delete(0, lastHeader.length());
                    lastHeader.append(str.substring(1).trim());
                }
                if (line.length() <= 0) continue;
                String seqStr = line.toString();
                line.delete(0, line.length());
                Matcher match = acgt.matcher(seqStr);
                while (match.find()) {
                    int start = match.start();
                    int end = match.end();
                    SequenceAnnotation annotation = new SequenceAnnotation("id", header, (Result[][])new Result[0][]);
                    Sequence seq = Sequence.create(DNAAlphabetContainer.SINGLETON, seqStr.substring(start, end));
                    seq = seq.annotate(false, annotation);
                    seqs.add(seq);
                    size += end - start;
                    starts.add(start);
                }
                if (!((double)size > 1.0E7) && str != null) continue;
                boolean s = false;
                return new Pair<int[][], DataSet>(new int[][]{starts.toArray()}, new DataSet("", seqs));
            }
            line.append(str);
        }
        return null;
    }
}

